/***********************************************************************/
/* MOUSE.C - THE mouse handling                                        */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1996 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3849 7731
 * Bellara                       http://www.gu.edu.au/gwis/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: mouse.c 2.1 1995/06/24 16:29:25 MH Rel MH $
*/

#include <the.h>
#include <proto.h>

#if defined(OS2) || defined(DOS) || defined(XCURSES)

#ifdef HAVE_PROTO
static void THEMouseButton(CHARTYPE,int,int,int,int,int,int);
static void which_window_is_mouse_in(CHARTYPE *,int *,int *,int *);
#else
static void THEMouseButton();
static void which_window_is_mouse_in();
#endif

/***********************************************************************/
#ifdef HAVE_PROTO
short THEMouse(CHARTYPE *params)
#else
short THEMouse(params)
CHARTYPE *params;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 int w=0,y=0,x=0;
 CHARTYPE scrn=0;
 short rc=RC_OK;
 int curr_button_action=0;
 int curr_button_modifier=0;
 int curr_button=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("mouse.c:  THEMouse");
#endif
/*---------------------------------------------------------------------*/
/* The code below is VERY primitive at the moment :-(                  */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/* First determine in which window the mouse is...                     */
/*---------------------------------------------------------------------*/
 which_window_is_mouse_in(&scrn,&w,&y,&x);
 if (w == (-1)) /* shouldn't happen! */
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
 if (current_screen != scrn)
   {
    (void)Nextwindow((CHARTYPE *)"");
   }
#ifdef MOUSE_DEBUG
 printf("before handling mouse\n");
#endif
 rc = get_mouse_info(&curr_button,&curr_button_action,&curr_button_modifier);
 if (rc != RC_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
 THEMouseButton(scrn,w,curr_button,curr_button_action,curr_button_modifier,y,x);
#ifdef MOUSE_DEBUG
 printf("after handling mouse\n\n");
#endif
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef HAVE_PROTO
static void THEMouseButton(CHARTYPE scrn,int w,int button,int button_action,
            int button_modifier,int winy,int winx)
#else
static void THEMouseButton(scrn,w,button,button_action,button_modifier,winy,winx)
CHARTYPE scrn;
int w,button,button_action,button_modifier,winy,winx;
#endif
/***********************************************************************/
{
#define MOUSE_Y (MOUSE_Y_POS+1-screen[scrn].screen_start_row)
#define MOUSE_X (MOUSE_X_POS+1-screen[scrn].screen_start_col)
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("mouse.c:  THEMouseButton");
#endif
#ifdef MOUSE_DEBUG
 printf("scrn: %d w: %d button: %d button_action: %d button_modifier: %d\n",
        scrn,w,button,button_action,button_modifier);
 printf("MOUSE: Y: %3d X: %3d\n",MOUSE_Y_POS+1,MOUSE_X_POS+1);
 printf("MOUSE: Y: %3d X: %3d\n",MOUSE_Y,MOUSE_X);
#endif
 switch(w)
   {
    case WINDOW_MAIN:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
#ifdef MOUSE_DEBUG
                                 printf("Mark(line)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Reset((CHARTYPE *)"BLOCK");
                                 rc = Mark((CHARTYPE *)"LINE");
                                 break;
                            case BUTTON_CONTROL:
#ifdef MOUSE_DEBUG
                                 printf("Mark(box)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Reset((CHARTYPE *)"BLOCK");
                                 rc = Mark((CHARTYPE *)"BOX");
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("cursor_move()\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
#ifdef MOUSE_DEBUG
                                 printf("Mark(line)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Mark((CHARTYPE *)"LINE");
                                 break;
                            case BUTTON_CONTROL:
#ifdef MOUSE_DEBUG
                                 printf("Mark(box)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Mark((CHARTYPE *)"BOX");
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("cursor_move()\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 break;
                           }
                         break;
                    case BUTTON_RELEASED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 if (CURRENT_FILE->pseudo_file == PSEUDO_DIR)
                                   {
#ifdef MOUSE_DEBUG
                                   printf("sos_edit()\n");
#endif
                                    rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                    rc = Sos_edit((CHARTYPE *)"");
                                   }
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
#ifdef MOUSE_DEBUG
                                 printf("Mark(line)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Mark((CHARTYPE *)"LINE");
                                 break;
                            case BUTTON_CONTROL:
#ifdef MOUSE_DEBUG
                                 printf("Mark(box)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Mark((CHARTYPE *)"BOX");
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("Mark(word)\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 rc = Reset((CHARTYPE *)"BLOCK");
                                 rc = Mark((CHARTYPE *)"WORD");
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    case BUTTON_RELEASED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
    case WINDOW_COMMAND:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("cursor_cmdline()\n");
#endif
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
    case WINDOW_PREFIX:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 rc = cursor_move(TRUE,MOUSE_Y,MOUSE_X);
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_CLICKED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
    case WINDOW_IDLINE:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("Xedit()\n");
#endif
                                 rc = Xedit((CHARTYPE *)"");
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_CLICKED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_CLICKED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
    case WINDOW_FOOTING:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("Status()\n");
#endif
                                 rc = Status((CHARTYPE *)"");
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_CLICKED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_CLICKED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
    case WINDOW_DIVIDER:
         switch(button)
           {
            case 1:  /* button 1 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
#ifdef MOUSE_DEBUG
                                 printf("screen 1\n");
#endif
                                 rc = THEScreen((CHARTYPE *)"1");
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_RELEASED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 2:  /* button 2 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_DOUBLE_CLICKED:
                         break;
                    default:
                         break;
                   }
                 break;
            case 3:  /* button 3 */
                 switch(button_action)
                   {
                    case BUTTON_PRESSED:
                         switch(button_modifier)
                           {
                            case BUTTON_SHIFT:
                                 break;
                            case BUTTON_CONTROL:
                                 break;
                            case BUTTON_ALT:
                                 break;
                            default:
                                 break;
                           }
                         break;
                    case BUTTON_MOVED:
                         break;
                    case BUTTON_RELEASED:
                         break;
                    default:
                         break;
                   }
                 break;
           }
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef HAVE_PROTO
static void which_window_is_mouse_in(CHARTYPE *scrn,int *w,int *winy,int *winx)
#else
static void which_window_is_mouse_in(scrn,w,winy,winx)
CHARTYPE *scrn;
int *w,*winy,*winx;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern CHARTYPE display_screens;
 extern WINDOW *foot,*divider;
 extern bool horizontal;
/*--------------------------- local data ------------------------------*/
 CHARTYPE i=0;
 int j=0;
 int y=0,x=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("mouse.c:  which_window_is_mouse_in");
#endif
 for (i=0;i<display_screens;i++)
   {
    for (j=0;j<VIEW_WINDOWS;j++)
      {
       if (screen[i].win[j] != (WINDOW *)NULL)
         {
          wmouse_position(screen[i].win[j],&y,&x);
          if (y != (-1)
          &&  x != (-1))
            {
             *scrn = i;
             *w = j;
             *winy = y;
             *winx = x;
#ifdef TRACE
             trace_return();
#endif
             return;
            }
         }
      }
   }
/*---------------------------------------------------------------------*/
/* To get here, the mouse is NOT in any of the view windows; is it in  */
/* the status line ?                                                   */
/*---------------------------------------------------------------------*/
 wmouse_position(foot,&y,&x);
 if (y != (-1)
 &&  x != (-1))
   {
    *w = WINDOW_FOOTING;
    *scrn = current_screen;
    *winy = y;
    *winx = x;
#ifdef TRACE
    trace_return();
#endif
    return;
   }
/*---------------------------------------------------------------------*/
/* To get here, the mouse is NOT in any of the view windows; or the    */
/* status line. Is it in the DIVIDER window ?                          */
/*---------------------------------------------------------------------*/
 if (display_screens > 1
 &&  !horizontal)
   {
    wmouse_position(divider,&y,&x);
    if (y != (-1)
    &&  x != (-1))
      {
       *w = WINDOW_DIVIDER;
       *scrn = current_screen;
       *winy = y;
       *winx = x;
#ifdef TRACE
       trace_return();
#endif
       return;
      }
   }
/*---------------------------------------------------------------------*/
/* To get here, the mouse is NOT in ANT window. Return an error.       */
/*---------------------------------------------------------------------*/
 *w = (-1);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef HAVE_PROTO
short get_mouse_info(int *button,int *button_action,int *button_modifier)
#else
short get_mouse_info(button,button_action,button_modifier)
int *button,*button_action,*button_modifier;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("mouse.c:  get_mouse_info");
#endif
 if (A_BUTTON_CHANGED)
   {
#ifdef MOUSE_DEBUG
    printf("a button has changed\n");
#endif
    if (BUTTON_CHANGED(1))
       *button = 1;
    else
       if (BUTTON_CHANGED(2))
          *button = 2;
       else
          if (BUTTON_CHANGED(3))
             *button = 3;
          else
            {
#ifdef TRACE
             trace_return();
#endif
             return(RC_OK);
            }
    if (BUTTON_STATUS(*button) & BUTTON_SHIFT)
       *button_modifier = BUTTON_SHIFT;
    else
       if (BUTTON_STATUS(*button) & BUTTON_CONTROL)
          *button_modifier = BUTTON_CONTROL;
       else
          if (BUTTON_STATUS(*button) & BUTTON_ALT)
             *button_modifier = BUTTON_ALT;
          else
             *button_modifier = 0;
    if (MOUSE_HAS_MOVED)
       *button_action = BUTTON_MOVED;
    else
       *button_action = BUTTON_STATUS(*button) & BUTTON_ACTION_MASK;
   }
 else
   {
    *button = *button_action = *button_modifier = 0;
    rc = RC_INVALID_OPERAND;
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
#endif
