unit generator;
{
This unit written for JugglePro on March 17, 1993
}

Interface

procedure gballs;  {allow user to specify number of balls}
procedure gperiod; {user specifies period for patterns generated}
procedure gmaxthrow;  {user sets a maximum throw-height}
procedure gswitches;  {user selects a set of switches}
function guessmode(s:string):char;
{
guess the mode --returns 'a','s','p', or 'c'
s is the notation of the pattern.  There is one pattern which makes
sense in two different modes.  This is a passing pattern in which
no passes are made.  Thus there are no p's to distinguish it from
custom.
}
procedure generate;
{
generates all patterns conforming to the user specifications
(executes j2.exe)
outputs to screen and/or disk as specified
}
procedure gload;
{
provides the listing of generated patterns from disk -- user
chooses the patterns to be converted for viewing
}

Implementation
uses crt,dos,header,jpfcts,showbuff,demoinput,convert,menus;

procedure gballs;
begin
  window(1,2,79,8);
  clrscr;
  gn:=changeval(gn,'balls',1,50);
  clrscr;
end;

procedure gperiod;
begin
  window(1,2,79,8);
  clrscr;
  gl:=changeval(gl,'period',1,50);
  clrscr;
end;

procedure gmaxthrow;
begin
  window(1,2,79,8);
  clrscr;
  gmaxt:=changeval(gmaxt,'maximum throw height',1,100);
  clrscr;
end;

procedure gswitches;
begin
  window(1,2,79,25);
  clrscr;
  writeln('-s            Activates simultaneous mode');
  writeln('-p            Activates 2 person passing mode');
  writeln('-c <filename> Activates custom definition file');
  writeln('-g            Print only ground state patterns');
  writeln('-ng           Print only excite state patterns');
  writeln('-se           Disable starting/ending sequences');
  writeln('-n            Include the number of patterns');
  writeln('-no           Print only the number of patterns');
  writeln('-noexit       Disables exit procedure');
  writeln('-f            Full generation (includes decomposable patterns)');
  writeln('-lame         Includes "11" in default mode (solo asynch.)');
  writeln('-x <throws>   Excludes listed throw values');
  writeln('-i <throws>   Excludes all but the listed throw values');
  writeln('-xp <throws>  Excludes passing the listed throw values');
  writeln('-m <number>   Turns on multiplexing to allow for <number> balls');
  writeln('              in one hand at one time');
  writeln('-mf           Includes multiplex patterns where different balls');
  writeln('              arrive at one hand at the same time (difficult!)');
  writeln('-d <number>   Delay flag is used for passing patterns as it allows');
  writeln('              a partner some reaction time to tricks made from the');
  writeln('              ground state (-g is activated too).');
  writeln('-l <person>   When delay flag is used, this identifies the leader');
  writeln('Current switches:   ',switches);
  write('Enter new switches: ');
  readlndemo(switches);
  clrscr;
end;

function guessmode(s:string):char;
var
  ccnt,c2cnt,scnt,pcnt:byte;
  mode:char;
                             {AI algorithm to determine mode}
begin
  mode:='a';                 {async mode assumed first}
  scnt:=count('(',s);        {count parantheses for simo mode}
  pcnt:=count('p',s);        {count p's for passing mode}
  ccnt:=count('<',s);        {count <'s for custom mode}
  c2cnt:=count('/',s)+count(':',s);   {count others}
  if scnt>0 then mode:='s';  {simo overrides async}
  if ccnt>0 then mode:='c';  {custom overrides simo}
  if (pcnt>0) and (ccnt>0) and (c2cnt=0) then mode:='p'; {passing}
  if length(s)=0 then mode:='0';
  guessmode:=mode;
end;

procedure generate;
var
  out,mode:char;
  s1,s2,s3,choice,filename,cmdline:string;
begin
  window(1,1,79,25);
  clrscr;
  str(gn,s1);
  str(gmaxt,s2);
  str(gl,s3);
  cmdline:=s1+' '+s2+' '+s3+' '+switches;  {command-line options}
  writeln(cmdline);
  write('Disable screen printing (Y/N)?');
  ch:=readkeydemo;
  writeln(ch);
  if (ch='Y') or (ch='y') then cmdline:=cmdline+' -noprint';
  write('Output to disk (Y/N)?');
  ch:=readkeydemo;
  writeln(ch);
  if (ch='Y') or (ch='y') then
    begin
      write('Filename: ');
      readlndemo(filename);
      if pos('.',filename)=0 then filename:=filename+'.gen';
      cmdline:=cmdline+' -write '+path+filename;
    end;
  exec('j2.exe',cmdline);
  write('Enter pattern choice or type enter to exit: ');
  readlndemo(choice);
  if length(choice)>0 then
    begin
      mode:=guessmode(choice);
      anim(mode,choice);
    end;
  clrscr;
  setupmenu;
end;

procedure gload;
var
  ngen,ox,x:integer;
  ncl,cl:byte;
  ch,mode:char;
  inn:text;
  filename:string[40];
  choice:string;
  gselect,gexitflg:boolean;

begin
  choice:='';
  gselect:=false;
  gexitflg:=false;
  window(1,1,79,25);
  clrscr;
  assign(inn,path+genfile);
  {$i-}
  reset(inn);
  {$i+}
  clrscr;
  if ioresult<>0
   then hitenter('Generation file missing!')
   else
     begin
       x:=1;                 {set counter}
       repeat
         readln(inn);
         x:=x+1;             {count number of lines}
       until eof(inn);
       ngen:=x-1;            {ngen = # of patterns in file}
       x:=1;
       ox:=x;
       cl:=1;
       ncl:=gget(inn,x,x+23);   {ncl = # of lines loaded}
       showbuffer(cl,ncl);      {display these lines}
       repeat
         if x<>ox then
           begin
             ncl:=gget(inn,x,x+23);  {ncl = # of lines read}
             showbuffer(cl,ncl);
           end;
         ox:=x;
         repeat
           ch:=readkeydemo;
         until (ch=chr(0)) or (ch=' ') or (ch=chr(13)) or (ch=chr(27));
         textbackground(colr1);
         gotoxy(1,cl);
         writeln(buffer[cl]);
         if ch=chr(0) then ch:=readkeydemo;
         if ch='P' then cl:=cl+1;
         if ch='H' then cl:=cl-1;
         if ch='I' then x:=x-24;
         if ch='Q' then x:=x+24;
         if cl<1 then cl:=ncl;
         if cl>ncl then cl:=1;
         if x<1 then x:=1;
         if x>ngen then x:=x-24;
         if ch=chr(13) then gselect:=true;  {enter}
         if ch=chr(27) then gexitflg:=true; {esc}
         if ch=' ' then
           begin
             if length(choice)+length(buffer[cl])<255
               then choice:=choice+unspace(buffer[cl]);
           end;
         textbackground(colr3);             {highlight}
         gotoxy(1,cl);
         writeln(buffer[cl]);
       until gselect or gexitflg;
       if gselect then
         begin
           if length(choice)=0 then choice:=buffer[cl];
           mode:=guessmode(choice);
           anim(mode,choice);        {prepare for animation}
         end;
       close(inn);
     end;
  if startup=1 then endup:=l;
  clrscr;
  setupmenu;
end;

begin
  gn:=3;               {initialization defaults}
  gl:=3;
  gmaxt:=5;
  switches:='';
  genfile:='a353.gen';
end.
