/* ---------------------------------------------------------------------- */
/*   Rando.c (C) Copyright Bill Buckels 1990-1999                         */
/*   All Rights Reserved.                                                 */
/*                                                                        */
/*   Licence Agreement                                                    */
/*   -----------------                                                    */
/*                                                                        */
/*   Rando is distributed as ShareWare.                                   */
/*   Suggested Registration is $10.00 per commercial site, free for       */
/*   family users at home. (Rando is free for home use.)                  */
/*                                                                        */
/*   Commercial users are expected to register with the Author if using   */
/*   Rando beyond a 30-day evaluation period. Send registration in the    */
/*   form of cheque, or money order to:                                   */
/*                                                                        */
/*   Bill Buckels                                                         */
/*   589 Oxford Street                                                    */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                   */
/*                                                                        */
/*   Email: bbuckels@escape.ca                                            */
/*   WebSite: http://www.escape.ca/~bbuckels                              */
/*                                                                        */
/*   Registered users of Rando have a royalty-free right to use,          */
/*   modify, reproduce and distribute this source code (and/or any        */
/*   modified version) in any way you find useful, provided you do not    */
/*   compete with Bill Buckels or his agents, and that you agree that     */
/*   Bill Buckels has no warranty obligations or liability whatsoever     */
/*   resulting from any associated loss or damage.                        */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*   -----------                                                          */
/*   Young childrens' letter recognition game                             */
/*                                                                        */
/*   This version of Rando is written in Microsoft C Large Memory Model.  */
/*   It uses the romfont as a template for large letters.                 */
/*   Although this is a complete rewrite, and basic redesign, it was      */
/*   only finished to a point that I consider reasonably functional.      */
/*   Please do not hold this source up as an example of the way we should */
/*   work, because there is much room left to finish this program off,    */
/*   although functionally everything is working as far as I know.        */
/*                                                                        */
/*   The important thing was to get it out there for the kiddies to use.  */
/*                                                                        */
/*   Bill Buckels 1999                                                    */
/* ---------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <time.h>

typedef unsigned char uchar;
typedef unsigned int  uint;
typedef unsigned long ulong;

#define TRUE     1
#define FALSE    0

#define SUCCESS  0
#define VALID    SUCCESS
#define FAILURE  -1
#define INVALID  FAILURE

/* video routines */
#define CGA_COMPAT 4
#define MONOCHROME 99
#define TERMINATOR 1
#define SCREENSIZE 4000

#define BLACK     0
#define BLUE      1
#define GREEN     2
#define CYAN      3
#define RED       4
#define MAGENTA   5
#define BROWN     6
#define WHITE     7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15
#define INTENSE   16

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */
#define HOMEKEY    'G'    /* second character generated by home key        */
#define ENDKEY     'O'    /* second character generated by end key         */

/* second character generated by numerical fkeys */
/* starting at character 59                      */
/* ending at character 68                        */
#define F1         ';'
#define F2         '<'
#define F3         '='
#define F4         '>'
#define F5         '?'
#define F6         '@'
#define F7         'A'
#define F8         'B'
#define F9         'C'
#define F10        'D'

#define CRETURN '\x0d'
#define LFEED   '\x0A'
#define CTRLZ   '\x1a'
#define DELETE  '\x7f'
#define ESCAPE  '\x1b'
#define BACKSPACE   8
#define SPACEBAR    32

#define UPPER_REVIEW  1
#define LOWER_REVIEW  2
#define NUMBER_REVIEW 3

int ADAPTER=CGA_COMPAT;
int bMickeyMouse = FALSE,
    iMousex = 319,
    iMousey = 99;

int background = BLACK, foreground = WHITE;
int background2= WHITE, foreground2= BLACK;
int bordercolor= BLACK;

/* function prototypes */
int UnpackPicture(int, uchar *, uchar *);
int PutPicture(uint, uint, uint, uint, uchar *, uchar *);

uchar *crt =(uchar *)0xB8000000l;
uchar *romfont=(uchar *)0xffa6000el;

uchar *menuscreen = (uchar *)NULL,
         *menuchoice = (uchar *)NULL;

extern uchar RANDSEL[];
extern int RANDSEL_SIZE;

extern uchar RANDMENU[];
extern int RANDMENU_SIZE;

extern uchar STARVE[];
extern int STARVE_SIZE;

/* sound arrays */
extern int HABANERA[],
           danube[],
           dvorak[],
           guonod[],
           mexico[],
           mozart[],
           sam[],
           stars[],
           bug[],
           weasel[];

int Frequency[7][12]={
/* C           D           E     F           G           A           B  */
/* 0     1     2     3     4     5     6     7    8      9     10    11 */
/* W     B     W     B     W     W     B     W    B      W     B     W  */
   65,   69,   73,   78,   82,   87,   93,   98,  104,  110,  117,  123,
  131,  139,  147,  156,  165,  175,  185,  196,  208,  220,  233,  247,
  262,  278,  294,  312,  330,  349,  371,  392,  416,  440,  467,  494,
  523,  555,  587,  623,  659,  698,  741,  784,  832,  880,  934,  988,
 1046, 1111, 1175, 1247, 1318, 1397, 1482, 1568, 1664, 1760, 1868, 1976,
 2093, 2221, 2349, 2493, 2637, 2794, 2965, 3136, 3328, 3520, 3736, 3951,
 4186, 4442, 4699, 4986, 5274, 5588, 5930, 6272, 6656, 7040, 7471, 7902};

int WHITES[26][2]={
    /* 26 of em, one for each letter of the alphabet               */
    /* white keys - octave note indexes into frequency array above */
    0,  9,
    0,  11,
    1,  0,
    1,  2,
    1,  4,
    1,  5,
    1,  7,
    1,  9,
    1,  11,
    2,  0,
    2,  2,
    2,  4,
    2,  5,
    2,  7,
    2,  9,
    2,  11,
    3,  0,
    3,  2,
    3,  4,
    3,  5,
    3,  7,
    3,  9,
    3,  11,
    4,  0,
    4,  2,
    4,  4};

int s1 = 523;          /* some values for the keyclick */
int s2 = 659;
int s3 = 784;

/* ---------------------------------------------------------------------- */
/* initialization and screen and keyboard routines                        */
/* ---------------------------------------------------------------------- */
void initproc(void)
{
     union REGS inregs,outregs;

     menuscreen = malloc(SCREENSIZE);
     if (menuscreen == NULL)
       exit(99);
     menuchoice = malloc(SCREENSIZE);
     if (menuchoice == NULL)
       exit(99);

    int86(0x11,&inregs,&outregs);
    /* get equipment list from the bios */
    /* and isolate videomode info       */
    if(((outregs.x.ax>>4) &3) > 2) {
      ADAPTER=MONOCHROME;
      crt =(uchar *)0xB0000000l;
    }

    if (ADAPTER==CGA_COMPAT){
      background =RED;
      foreground =YELLOW;
      background2=BLUE;
      foreground2=LCYAN;
      bordercolor=BLUE;
    }
    UnpackPicture(RANDSEL_SIZE, RANDSEL, menuchoice);
    UnpackPicture(RANDMENU_SIZE, RANDMENU, menuscreen);
    HiMickey();
}

/* -------------------------------------------------------------------- */
/* low level video routines using bios int 10h                          */
/* -------------------------------------------------------------------- */

/* clear screen */
void cls(int background,int foreground)
{
  union REGS reg;

  reg.h.ah = 6;
  reg.h.al = 0;
  reg.h.ch = 0;
  reg.h.cl = 0;
  reg.h.dh = 24;
  reg.h.dl = 79;
  reg.h.bh = (background << 4) + foreground;
  int86(0x10, &reg, &reg);

}

/* set cursor location */
void locate(uint row, uint column)
{
    union REGS regs;
    regs.h.ah = 0x02;
    regs.h.bh = 0;
    regs.x.dx = (uint)row<<8|column;
    int86(0x10,&regs,&regs);
}

/* ---------------------------------------------------------------------- */
/* SetScreenColor                                                         */
/* Sets the CGA Color and Palette using the standard bios int10h call.    */
/* ---------------------------------------------------------------------- */
int SetScreenColor(uint background, uint palette)
{
    union REGS rin,rout;

    rin.h.ah = 11;
    rin.h.bh = 0;
    rin.h.bl = (uchar)background;
    int86(0x10,&rin,&rout);
    rin.h.bh = 1;
    rin.h.bl = (uchar)palette;
    int86(0x10,&rin,&rout);
    return 0;
}

/* write a string of a single character left justified */
void DMC(int Row, int Column, uint BYTE, int BACK, int FRONT, int QUANT)
{
    uint offset=160 * Row + 2 * Column;
    uint i=0, Attribute = (BACK << 4) + FRONT;

    while(i++ < QUANT){
      crt[offset++]=BYTE;
      crt[offset++]=Attribute;
    }
}

/* write a centre justified string (used for titles etc.) */
void DMM(uchar *String, int Row, int Column, int BACK, int FRONT)
{
    uint Attribute = (BACK << 4) + FRONT;
    uint offset= 160 * Row + 2 * ((Column++) - strlen(String)/2);
    uchar c;

    while ((c=*String++)!=0){
      crt[offset++]=c;
      crt[offset++]=Attribute;
    }
}

/* make a frame around the screen in a single character */
void makeframe(uchar framechar)
{
    int back2=background, front2=foreground,i;

    if(ADAPTER!=MONOCHROME) {
      back2++;
      front2++;
    }
    DMC(0,0,framechar,back2,front2,80);
    for(i=1;i<24;i++){
      DMC(i,0, framechar,back2,front2,1);
      DMC(i,79,framechar,back2,front2,1);
    }
    DMC(24,0,framechar,back2,front2,80);
}

/* clear the screen and hide the cursor */
int ClearHide()
{
    SetScreenColor(bordercolor,0);
    cls(background, foreground);
    locate(26,0);
    return 0;
}

/* ---------------------------------------------------------------------- */
/* clear the keyboard buffer, return keypress values etc.                 */
/* also the mouse status is returned as well...                           */
/* ---------------------------------------------------------------------- */
int EatKeys()
{
  int c = FUNCKEY;

  if(kbhit()) {
    c = getch();
    if (c == FUNCKEY)
      getch();
    if (kbhit()) {
      while (kbhit()) {
        if (getch() == FUNCKEY)
          getch();
      }
    }
  }
  else {
    if (ClickOnly())
      c = ESCKEY;
  }
  return c;
}
     
/* ---------------------------------------------------------------------- */
/* returns a random number in a usable range                              */
/* ---------------------------------------------------------------------- */
uchar random(int seed)
{
  int hold=-1;
  while(hold<0)hold=rand();
  if(hold >seed)hold= hold % seed;
  return hold;
}

/* ---------------------------------------------------------------------- */
/* Sleep for a while                                                      */
/* ---------------------------------------------------------------------- */
int sleep(int seconds)
{
  int x, i;

  for (x=0; x<seconds; x++) {
    for (i = 0; i < 9; i++) {
     if (EatKeys())
        return FAILURE;
      sound(32767, 2);
    }
    if (x%5 == 0)         /* correct for timertick every 5th second */
      sound(32767, 1);
  }
  if (EatKeys())
    return FAILURE;
  return SUCCESS;
}

/* ---------------------------------------------------------------------- */
/* A rather big font.                                                     */
/* ---------------------------------------------------------------------- */
int RatherBigFont(uchar *str)
{
  int target = strlen(str);
  int scanline,row,linebase,byte,nibble;
  int col,col2,att,att2;
  int attr = (background2<< 4) + foreground2;

  uchar character;

  linebase = 5 * 160 + 82 - (target * 16);

  for(scanline=0;scanline!=8;scanline++)
   {
    row = linebase + (scanline * 2 * 160);

    for (byte=0;byte<target;byte++)
     {
      character= romfont[(str[byte]&0x7f)*8+scanline];
      col = row + (byte* 32);
      att = col + 1;
      col2 = col + 160;
      att2 = att + 160;

      for (nibble=0;nibble<8;nibble++)
       {
        if (character & 0x80>>nibble){
          crt[col] =str[byte];crt[att]=attr;
          crt[col2]=str[byte];crt[att2]=attr;
        }
        col+= 2;att+= 2;col2+=2;att2+=2;
        if (character & 0x80>>nibble){
          crt[col] =str[byte];crt[att]=attr;
          crt[col2]=str[byte];crt[att2]=attr;
        }
        col+= 2;att+= 2;col2+=2;att2+=2;
      }
    }
  }
}

/* ---------------------------------------------------------------------- */
/* Sets Up the random colors and makes a sound as required by the caller  */
/* after clearing the screen. Called before displaying a new letter.      */
/* ---------------------------------------------------------------------- */
void ColorUpdate(void)
{
  if(ADAPTER!=MONOCHROME){
     foreground = random(14);
     foreground2= random(13);
     background = random(6);
     background2= random(5);
     bordercolor= random(15);

     if(foreground == background||foreground ==background2)foreground+=7;
     if(foreground2== background||foreground2==background2)foreground2+=7;
     if(bordercolor== background||bordercolor==background2)bordercolor+=7;
  }

  ClearHide();
  ThreeSounds(1,1);
  return;
}

uchar *countdown[10]={"1","2","3","4","5","6","7","8","9","10"};
/* ---------------------------------------------------------------------- */
/* The YAHOO routine (used after every 10 correct guesses during game.    */
/* ---------------------------------------------------------------------- */
int rewardthekid()
{
     uint i, c, status=0;

     RestoreDefaultSounds();
     if (EatKeys())
       return -1;
     if (ThreeSounds(1, 10)!= 0)
       return -1;
     if (Sleep(1))
       return -1;
     /* countdown */
     for(i=0;i<10;i++){
         s1 = s1 + (s1 / 80) * i;
         s2 = s2 + (s2 / 80) * i;
         s3 = s3 + (s3 / 80) * i;
         ColorUpdate();
         if (i==9)
           makeframe(1);
         else
           makeframe(countdown[i][0]);
         RatherBigFont(countdown[i]);
         if(EatKeys() || Sleep(1)) {
           RestoreDefaultSounds();
           return -1;
         }
     }
     if (ThreeSounds(1, 10)) {
       RestoreDefaultSounds();
       return -1;
     }
     if (Sleep(1))
       return -1;
     DisableDefaultSounds();
     ColorUpdate();
     makeframe(2);
     RatherBigFont("YAHOO");
     if (EatKeys()) {
       RestoreDefaultSounds();
       return -1;
     }
     status=PlayRewardSong(random(10));
     RestoreDefaultSounds();
     if(status!=0 || ClickOnly())return -1;
     return 0;
}

uchar *titletext[6]={"This Program Is Distributed As Shareware",
                    "TEACHER'S CHOICE tm Productions Presents",
                    "A Random Letters Recognition Game",
                    "(C)Copyright Bill Buckels 1990-1999",
                    "589 Oxford St., Wpg.,Mb., Canada R3M 3J2",
                    "RANDO"};

int titlecords[5][2]={1,39,3,39,20,39,22,39,23,39};
/* ---------------------------------------------------------------------- */
/* Display the program title... the only dynamic screen besides the game. */
/* The other screens in this program were prepared in advance.            */
/* ---------------------------------------------------------------------- */
void DoTitle()
{
    int i;

    makeframe('R');
    for(i=0;i!=5;i++)
      DMM(titletext[i],titlecords[i][0],
          titlecords[i][1],background,foreground);
    RatherBigFont(titletext[5]);
    srand((uint)time(NULL)); /* seed the random number generator */
    PlayRewardSong(random(10));
    EatKeys();
    return;
}

/* ---------------------------------------------------------------------- */
/* Letters and Numbers Review Routine                                     */
/* ---------------------------------------------------------------------- */
void DoReview(int iReviewType)
{
    int idx, ioctave, inote,
             joctave, jnote,
             koctave, knote;

    uchar ranbuf[2]={0,0};
    uchar c, *pBogus = "xyz";
    ClearHide();

    makeframe('?');
    switch (iReviewType) {
       case UPPER_REVIEW:
         pBogus = (uchar *)"ABC";break;
       case NUMBER_REVIEW:
         pBogus = (uchar *)"123";break;
       case LOWER_REVIEW:
       default:
         pBogus = (uchar *)"xyz";break;
    }
    RatherBigFont(pBogus);

    for(;;){
      if (!kbhit()) {
        while (!kbhit())  {
          c = ClickOnly();
          if (c)
            break;
        }
        if (c)
          break;
      }
      c = tolower(getch());
      if (c == ESCKEY)break;
      if (c == FUNCKEY) {
        getch();
        c = '?';
      }
      else if ((iReviewType == NUMBER_REVIEW && (c < '0' || c > '9')) ||
          (iReviewType != NUMBER_REVIEW && (c < 'a' || c > 'z'))) {
        c = '?';
      }
      else if (iReviewType == UPPER_REVIEW)
        c = toupper(c);

      DisableDefaultSounds();
      ColorUpdate();
      RestoreDefaultSounds();

      makeframe(c);
      if (c != '?') {
        ranbuf[0]=c;
        RatherBigFont(ranbuf);
        c = toupper(c);
        if (c > 'Z')
          idx = c - 'a';
        else if (c < 'A')
          idx = c - '0';
        else
          idx = c - 'A';

        if (idx > -1 && idx < 26) {  /* make sure in array bounds */
          koctave = joctave = ioctave = WHITES[idx][0];
          inote   = WHITES[idx][1];   /* create a major triad chord */
          jnote   = inote + 4;
          knote   = inote + 7;
          if (jnote > 11) {
            jnote-= 12;
            joctave++;
          }
          if (knote > 11) {
            knote-= 12;
            koctave++;
          }
          sound(Frequency[ioctave][inote],1);
          sound(Frequency[joctave][jnote],1);   /* playing tricks with the array */
          sound(Frequency[koctave][knote],1);   /* to make a chord for each key  */
        }
      }
      else {
        RatherBigFont(pBogus);
        bronx();
      }
      EatKeys();
    }
    if(ADAPTER==CGA_COMPAT){
      background =RED;
      foreground =YELLOW;
      bordercolor=BLUE;
    }
    ClearHide();
}

/* ---------------------------------------------------------------------- */
/* Random Letters Game(s) routine                                         */
/* ---------------------------------------------------------------------- */
void PlayTheGame(int pairs)
{
    uchar ranbuf[3]={0,0,0};

    uchar c= 'R';
    int count=1,i;
    uchar rambo;
    uchar num1,num2,num3;
    uchar old1,old2;

    ClearHide();
    while(c!=ESCKEY){
      ColorUpdate();
      srand((uint)time(NULL));     /* seed the random number generator */
      num1  = random(26)+65;   /* ucase */
      num2  = random(26)+97;   /* lcase */
      while(num1==old1)num1=random(26)+65;  /* safety play */
      while(num2==old2)num2=random(26)+97;
      old1=num1;
      old2=num2;
      num3  = num2 - 32;
      rambo = num1;
      if(((num2+num1)%2)==0)rambo=num2;
      else num3=num1+32;
      /* random case selection uses modulus operator to mix em up */
      if (pairs == FALSE) {
        ranbuf[0]=rambo;
      }
      else  {
        ranbuf[0]=toupper(rambo);
        ranbuf[1]=tolower(rambo);
      }

      makeframe(rambo);
      RatherBigFont(ranbuf);
      while(c!=rambo) {
        if (!kbhit()) {
          while (!kbhit()) {
            c = ClickOnly();
            if (c)
              break;
          }
          if (c) {
            c = ESCKEY;
            break;
          }
        }
        c=getch();
        if (c==FUNCKEY)getch();
        EatKeys();
        if(c==ESCKEY)rambo=ESCKEY;
        if(c==num3)c=rambo;
        if (c != rambo)bronx();
      }
      if(count++==10 && c!= ESCKEY) {
        /* don't allow escape to exit when playing tunes */
        rewardthekid();
        count=1;
      }
    }
    if(ADAPTER==CGA_COMPAT){
      background =RED;
      foreground =YELLOW;
      bordercolor=BLUE;
    }
    ClearHide();

}

/* main menu selection zones */
int choices[6][4] = {
    0,  0,  10,  26,
    0, 26,  10,  52,
    0, 52,  10,  79,
   14,  0,  24,  26,
   14, 26,  24,  52,
   14, 52,  24,  79};

/* ---------------------------------------------------------------------- */
/* Main Menu routine                                                      */
/* ---------------------------------------------------------------------- */
int GetMenuChoice(int oldchoice) {

  int choice = oldchoice,
      width,
      height,
      c = 0;

  PutPicture(0, 0, 25, 80, menuscreen, crt);
  height  = (choices[choice][2] - choices[choice][0]) + 1;
  width =   (choices[choice][3] - choices[choice][1]) + 1;
  PutPicture(choices[choice][0], choices[choice][1],
             height, width, menuchoice, crt);

  SetMouseCords(choice);
  ShowMickey();
  for (;;) {
    if (c == ESCKEY || c == ENTERKEY)break;
    if (kbhit()) {
      c = toupper(getch());
      if (c == FUNCKEY) {
        c = getch();
        switch (c) {
          case  UPARROW:
            choice -= 3;
            if (choice < 0) choice+= 6;
            break;
          case  DOWNARROW:
            choice += 3;
            if (choice > 5) choice-= 6;
            break;
          case  LTARROW:
            choice -= 1;
            if (choice < 0) choice= 5;
            break;
          case  RTARROW:
            choice += 1;
            if (choice > 5) choice= 0;
            break;
          case F1:
          case F2:
          case F3:
          case F4:
          case F5:
          case F6:
            choice=c-59;
            c = ENTERKEY;
            break;
          default:
            c = 0;
            break;
        }
      }
      else {
         /* no hotkey for choice 4 because it conflicts with choice 0 */
         switch(c) {
           case '?':
             choice = 0; c = ENTERKEY; break;
           case 'A':
             choice = 1; c = ENTERKEY; break;
           case 'Z':
             choice = 2; c = ENTERKEY; break;
           case '9':
             choice = 3; c = ENTERKEY; break;
           case 'X':
             choice = 5; c = ENTERKEY; break;
         }
      }
      if (choice != oldchoice) {
         SetMouseCords(choice);
      }
    }
    else {
      c = HotClick(c, &choice);
    }
    if (choice != oldchoice) {
        HideMickey();
        height  = (choices[oldchoice][2] - choices[oldchoice][0]) + 1;
        width   = (choices[oldchoice][3] - choices[oldchoice][1]) + 1;
        PutPicture(choices[oldchoice][0], choices[oldchoice][1],
                   height, width, menuscreen, crt);
        height = (choices[choice][2] - choices[choice][0]) + 1;
        width  = (choices[choice][3] - choices[choice][1]) + 1;
        PutPicture(choices[choice][0], choices[choice][1],
                   height, width, menuchoice, crt);
        oldchoice = choice;
        ShowMickey();
    }
  }
  HideMickey();
  return choice;
}

/* ---------------------------------------------------------------------- */
/* Main Program                                                           */
/* ---------------------------------------------------------------------- */
main(int argc, char *argv[])
{

    int choice = 0;
    initproc();
    ClearHide();
    DoTitle();
    for (;;) {
      choice = GetMenuChoice(choice);
      if (choice == 5)
        break;
      switch(choice) {
        case 0:
          PlayTheGame(FALSE);break;
        case UPPER_REVIEW:
        case LOWER_REVIEW:
        case NUMBER_REVIEW:
          DoReview(choice);break;
        case 4:
          PlayTheGame(TRUE);break;
      }
    }
    bordercolor=BLACK;
    background=BLACK;
    foreground=WHITE;
    ClearHide();
    StarvingProgrammer();
    ClearHide();
    locate(0,0);
    puts("Have a Nice Dos!");
    exit(0);
}

/* sound functions */
/* ---------------------------------------------------------------------- */
/* Some Helper functions for sound related setup during the program.      */
/* ---------------------------------------------------------------------- */
int RestoreDefaultSounds()
{
  s1 = 523;
  s2 = 659;
  s3 = 784;
  return 0;
}

int DisableDefaultSounds()
{
  s1 = s2 = s3 = 32767;
}

int ThreeSounds(int delay, int reps)
{
  int i;

  for (i = 0; i < reps; i++) {
    if (EatKeys() == ESCKEY)
      return -1;
    if (s1 != 32767)
      sound(s1,delay);
    if (EatKeys() == ESCKEY)
      return -1;
    if (s2 != 32767)
      sound(s2,delay);
    if (EatKeys() == ESCKEY)
      return -1;
    if (s3 != 32767)
      sound(s3,delay);
    if (EatKeys() == ESCKEY)
      return -1;
   }
   return 0;
}

/* ---------------------------------------------------------------------- */
/* play an array of frequency, duration                                   */
/* ---------------------------------------------------------------------- */
int PlaySong(int *musical_script)
{
  int frequency=0, duration=1, c;

  for(;;)
  {
      if(kbhit()) {
        c = getch();
        if (c == FUNCKEY)
          getch();
        EatKeys();
        return -1;
        break;
      }
      else {
        if (ClickOnly())
         return -1;
      }
      sound(musical_script[frequency],musical_script[duration]);
      frequency+=2;
      duration+=2;
      if (musical_script[frequency] == -1)break;
  }
  return 0;
}

/* ---------------------------------------------------------------------- */
/* play a tune based on selection by index...                             */
/* ---------------------------------------------------------------------- */
int PlayRewardSong(int tuneindex)
{
    switch(tuneindex){
        case 1 : return PlaySong(danube);
        case 2 : return PlaySong(dvorak);
        case 3 : return PlaySong(guonod);
        case 4 : return PlaySong(mexico);
        case 5 : return PlaySong(mozart);
        case 6 : return PlaySong(sam);
        case 7 : return PlaySong(stars);
        case 8 : return PlaySong(bug);
        default: return PlaySong(weasel);
    }
}

/*                                                           */
/*  a sound function in microsoft C                          */
/*                                                           */

#define TIMEOUT 0x2c00

int sound(freq,tlen)
int freq;         /* freq of sound in Hertz                  */
int tlen;         /* duration of sound 18.2 ticks per second */
{
    union REGS inregs,outregs;
    uint frdiv = 1331000L/freq;   /* timer divisor */
    int seed,hiseed,hold=0,setting;
      
    if (freq != 32767 && tlen> 0) {
      outp(0x43,0xB6) ;           /* write timer mode register */
      outp(0x42,frdiv & 0x00FF);  /* write divisor LSB */
      outp(0x42,frdiv >> 8);      /* write divisor MSB */

      setting= inp(0x61);          /* get current port B setting */
      outp(0x61,setting | 0x03);   /* turn speaker on */
    }
    if(tlen>0){
       tlen=((tlen*1000)/182); /* convert from 18.2 ticks to 100ths */
       inregs.x.ax= TIMEOUT;
       int86(0x21,&inregs,&outregs);
       seed=(outregs.x.dx)&0xff;

    while(hold<tlen)
     {
       inregs.x.ax = TIMEOUT;
       int86(0x21,&inregs,&outregs);
       if(seed!=(outregs.x.dx&0xff))
        {
          hiseed= (outregs.x.dx)&0xff;
          if(hiseed<seed)hiseed+=100;
          hold+=(hiseed-seed);
          seed =(outregs.x.dx)&0xff;
          }
          }
          }

    if (freq != 32767 && tlen > 0)
      outp(0x61,setting);
    /* restore port B setting */
    return 0;
}

/* ---------------------------------------------------------------------- */
/* Mouse Functions and Mouse Navigation Helper Functions                  */
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* Set global mouse cordinates                                            */
/* ---------------------------------------------------------------------- */
int SetMouseCords(choice)
{
   int height,
       width,
       xmid,
       ymid;

   height = (choices[choice][2] - choices[choice][0]) + 1;
   width  = (choices[choice][3] - choices[choice][1]) + 1;

   ymid = choices[choice][0] + (height/2);
   xmid = choices[choice][1] + (width/2);

   iMousey = ymid*8;
   iMousex = xmid*8;

   return 0;
}

/* ---------------------------------------------------------------------- */
/* PicMouse - Called by HotClick to return a position in the mainmenu.    */
/* ---------------------------------------------------------------------- */
int PicMouse(int x1, int y1)
{
   int i=-1,
       col,
       row,
       idx;

   col = (x1/8);
   row = (y1/8);

   for (idx = 0; idx < 6; idx++) {
     if (col > choices[idx][1]  && col < choices[idx][3]  &&
         row > choices[idx][0]  && row < choices[idx][2]) {
       i = idx;
       break;
     }
   }

   return i;
}

/* ---------------------------------------------------------------------- */
/* Hotclick is to return mouse status and cursor position.                */
/* position. Mouse status is mapped to equivalent key code returns.       */
/* ---------------------------------------------------------------------- */
int HotClick(int iRetVal, int *position)
{
  union REGS inregs, outregs; /* mouse registers */
  int idx;

  if (bMickeyMouse == TRUE) {

    inregs.x.ax = 3;
    int86(0x33,&inregs,&outregs);
    iMousex=outregs.x.cx;
    iMousey=outregs.x.dx;

    idx = PicMouse(iMousex,iMousey);
    if (idx != -1)
        position[0]=idx;


    if(outregs.x.bx)
     {
        if (outregs.x.bx == 1)
          iRetVal = ENTERKEY;
        else if (outregs.x.bx == 2)
          iRetVal = ESCKEY;

        while(outregs.x.bx)int86(0x33,&inregs,&outregs);
      }
   }
   return (iRetVal);
}

/* ---------------------------------------------------------------------- */
/* Clickonly - returns a left or a right mouse click as a key value       */
/*             if the mouse is installed.                                 */
/* ---------------------------------------------------------------------- */
int ClickOnly()
{
  union REGS inregs, outregs; /* mouse registers */
  int iRetVal = 0;

  if (bMickeyMouse == TRUE) {

    inregs.x.ax = 3;
    int86(0x33,&inregs,&outregs);

    if(outregs.x.bx)
     {
        if (outregs.x.bx == 1)
          iRetVal = ENTERKEY;            /* left button */
        else if (outregs.x.bx == 2)
          iRetVal = ESCKEY;              /* right button */

        while(outregs.x.bx)int86(0x33,&inregs,&outregs);
      }
   }
   return (iRetVal);
}

/* ---------------------------------------------------------------------- */
/* HideMickey                                                             */
/* Hide the mouse cursor.                                                 */
/* ---------------------------------------------------------------------- */
int HideMickey()
{
  union REGS inregs, outregs; /* mouse registers */
  if (bMickeyMouse == TRUE)
    {
      inregs.x.ax = 2;
      int86(0x33,&inregs,&outregs);
    }
  return bMickeyMouse;
}

/* ---------------------------------------------------------------------- */
/* ShowMickey                                                             */
/* Show (Unhide) The Mouse Cursor.                                        */
/* ---------------------------------------------------------------------- */
int ShowMickey()
{

  union REGS inregs, outregs; /* mouse registers */

  if (bMickeyMouse == FALSE)
     return FALSE;

   inregs.x.ax = 4;
   inregs.x.cx = iMousex;
   inregs.x.dx = iMousey;
   int86(0x33,&inregs,&outregs);   /* start */

   inregs.x.ax = 1;
   int86(0x33,&inregs,&outregs);   /* show  cursor*/
   return TRUE;
}

/* ---------------------------------------------------------------------- */
/* HiMickey                                                               */
/* Check for a valid mouse driver and mouse.                              */
/* ---------------------------------------------------------------------- */
int HiMickey()
{
    union REGS inregs, outregs;
    struct SREGS segregs;
    long address;
    uchar first_byte;

    bMickeyMouse = FALSE;

    /* check for microsoft compatible mouse driver */
    inregs.x.ax = 0x3533;
    intdosx ( &inregs, &outregs, &segregs );
    address = (((long) segregs.es) << 16) + (long) outregs.x.bx;
    first_byte = * (long far *) address;
    if ((address == 0) || (first_byte == 0xcf)) return FALSE;

    /* check to see if the mouse is responding */
    inregs.x.ax=0;
    int86(0x33,&inregs,&outregs);
    if(outregs.x.ax!=0)bMickeyMouse = TRUE;

    return (bMickeyMouse);
}

/* ---------------------------------------------------------------------- */
/* A Rude Noise for wrong answers                                         */
/* ---------------------------------------------------------------------- */
int bronx(void)
{
  sound(60,4);
  sound(40,8);
  return (0);
}

/* ---------------------------------------------------------------------- */
/* unpack a PTX array (one of mine) into a buffer or onto screen          */
/* ---------------------------------------------------------------------- */
int UnpackPicture(int argc, uchar *argv, uchar *crtbuf)
{

    uint byteoff=0,secondoff=1,packet;
    uchar byte,bytecount;
    int wordcount,target;

    target = argc-TERMINATOR;
    wordcount=0;
    do {
      bytecount=1;                          /* start with a seed count */
      byte=argv[wordcount];
      wordcount++;
                                            /* check to see if its raw */
      if(0xC0 == (0xC0 &byte)) {            /* if its not, run encoded */
        bytecount= 0x3f &byte;
        byte=argv[wordcount];
        wordcount++;
      }
      for(packet=0;packet<bytecount;packet++){
        if(byteoff<SCREENSIZE){
          crtbuf[byteoff]=byte;
          byteoff+=2;
        }
        else{
          crtbuf[secondoff]=byte;
          secondoff+=2;
        }
      }
    } while(wordcount<target);
    return 0;
}

/* ---------------------------------------------------------------------- */
/* Put a window or all of a text screen from a source to a dest or        */
/* onto the screen. The coordinates are expected to match in both.        */
/* ---------------------------------------------------------------------- */
int PutPicture(uint row, uint col, uint height, uint width,
               uchar *src, uchar *dest)
{
   uint x, y, offset;

   for (y = 0; y < height; y++) {
     offset = ((row + y) * 160) + (col * 2);
     for (x = 0; x < width; x++) {
        dest[offset] = src[offset];
        offset++;
        dest[offset] = src[offset];
        offset++;
     }
   }
   return 0;
}

/* ---------------------------------------------------------------------- */
/* An animation effect for the final routine.                             */
/* ---------------------------------------------------------------------- */
int pull_right(int row,int col)
{
  uchar *crtbuf;
  int x,x2,y,scanlines = 24;
  col=(col*2)-1;

  while(col<159)
    {
      if (EatKeys() == ESCKEY)
        return -1;
      x2=158;
      for(x=159;x>col;x-=2)
      {
        for(y=row;y<scanlines;y++)
        {
          crtbuf = (uchar *)&crt[(y*160)];
          crtbuf[x]= crtbuf[x-2] ;
          crtbuf[x2]=crtbuf[x2-2];
        }
        x2-=2;
      }
      /* dwell cycle */
      /* make noise  */
      sound(20000,(((160-col)/30)+2));
      col+=2;
    }
    return 0;

}

/* ---------------------------------------------------------------------- */
/* Display the beg notice and play the song.                              */
/* ---------------------------------------------------------------------- */
int StarvingProgrammer()
{
    int i;

    /* display the beg notice and play the song */
    UnpackPicture(STARVE_SIZE,STARVE, crt);
    PlaySong(HABANERA);

    /* make noise */
    for(i=2;i!=4;i++)
      {
        if (EatKeys())
          break;
        sound(32767,i);
        if (EatKeys())
          break;
        sound(492,(i*10));
      }

    /* fade right after a key press */
    pull_right(15,1);
    return 0;

}

/* ---------------------------------------------------------------------- */
/* Screen and music arrays (put here for safe keeping).                   */
/* Probably should have been compiled seperately since not really code.   */
/* ---------------------------------------------------------------------- */
/* music arrays */

int danube[]=
{
294,4,371,4,441,4,441,4,32767,4,882,2,32767,2,882,2,
32767,6,742,2,32767,2,742,2,32767,6,294,4,294,4,371,4,
441,4,441,4,32767,4,882,2,32767,2,882,2,32767,6,786,2,
32767,2,786,2,32767,6,278,4,278,4,330,4,495,4,495,4,
32767,4,990,2,32767,2,990,2,32767,6,786,2,32767,2,786,2,
32767,6,278,4,278,4,330,4,495,4,495,4,32767,4,990,2,
32767,2,990,2,32767,6,742,2,32767,2,742,2,32767,6,294,4,
294,4,371,4,441,4,589,4,32767,4,1178,2,32767,2,1178,2,
32767,6,882,2,32767,2,882,2,32767,6,294,4,294,4,371,4,
441,4,589,4,32767,4,1178,2,32767,2,1178,2,32767,6,990,2,
32767,2,990,2,32767,6,330,4,330,4,393,4,495,2,32767,2,
495,14,32767,2,416,4,441,4,742,16,589,4,371,4,371,8,
330,4,495,8,441,4,294,4,32767,2,294,2,294,4,32767,8,
441,2,32767,2,393,2,32767,6,441,2,32767,2,393,2,32767,6,
441,4,742,16,661,4,441,2,32767,2,371,2,32767,6,441,2,
32767,2,371,2,32767,6,441,4,661,16,589,4,441,2,32767,2,
393,2,32767,6,441,2,32767,2,393,2,32767,6,441,4,742,16,
661,4,441,4,589,4,661,4,742,4,882,8,786,4,742,2,
742,2,742,4,661,2,32767,2,589,4,32767,8,-1,-1
/* the blue danube walz -strauss */
};

int dvorak[]=
{
393,3,32767,2,441,1,393,3,32767,2,441,1,495,3,32767,2,
589,1,661,3,32767,2,589,1,786,3,32767,2,742,1,882,3,
32767,2,786,1,742,3,32767,2,882,1,786,3,32767,2,661,1,
589,3,32767,2,589,1,661,3,32767,2,589,1,786,3,32767,2,
661,1,589,3,32767,2,495,1,441,24,393,3,32767,2,441,1,
393,3,32767,2,441,1,495,3,32767,2,589,1,661,3,32767,2,
589,1,661,3,32767,2,742,1,882,3,32767,2,786,1,742,3,
32767,2,882,1,786,3,32767,2,661,1,589,3,32767,2,589,1,
786,3,32767,2,393,1,441,6,589,6,393,18,-1,-1
/* humoresque by dvorak */
};

int guonod[]=
{
221,1,32767,2,147,1,32767,5,294,3,294,3,278,3,248,3,
278,3,32767,3,294,3,330,3,32767,3,221,1,32767,2,147,1,
32767,5,294,3,294,3,278,3,248,3,278,3,32767,3,294,3,
330,3,32767,3,221,3,294,3,32767,3,350,3,441,6,393,3,
350,3,32767,3,441,3,525,6,467,3,441,3,32767,3,556,3,
661,6,589,3,556,3,467,3,441,3,393,3,350,3,330,3,
147,1,32767,5,294,3,294,3,278,3,248,3,278,3,32767,3,
294,3,330,3,32767,3,221,1,32767,2,147,1,32767,5,294,3,
294,3,278,3,248,3,278,3,32767,3,294,3,330,3,32767,3,
221,3,350,3,32767,3,441,3,525,6,467,3,441,3,393,3,
350,3,312,3,393,3,467,3,294,3,278,3,294,3,330,3,
32767,3,350,1,32767,2,330,9,294,1,-1,-1
/* funeral march of a marionette by guonod */
};

int mexico[]=
{
525,2,700,2,32767,2,525,2,700,2,32767,2,525,2,700,6,
32767,4,525,2,700,2,786,2,700,2,661,4,700,2,786,2,
32767,8,525,2,661,2,32767,2,525,2,661,2,32767,2,525,2,
661,6,32767,4,525,2,661,2,700,2,661,2,589,4,661,2,
700,2,32767,6,1049,2,990,2,1049,2,882,2,833,2,882,2,
700,2,661,2,700,2,525,2,32767,4,441,2,467,2,525,2,
589,2,661,2,700,2,786,2,882,2,935,2,786,2,32767,4,
935,2,882,2,935,2,786,2,742,2,786,2,661,2,624,2,
661,2,525,2,32767,4,1049,2,990,2,1049,2,1178,2,1049,2,
935,2,882,2,786,2,700,2,-1,-1
/* mexican hat dance */
};

int mozart[]=
{
624,2,589,2,589,4,624,2,589,2,589,4,624,2,589,2,
589,4,935,4,32767,4,935,2,882,2,786,4,786,2,700,2,
624,4,624,2,589,2,525,4,525,4,32767,4,589,2,525,2,
525,4,589,2,525,2,525,4,589,2,525,2,525,4,882,4,
32767,4,882,2,786,2,742,4,742,2,624,2,589,4,589,2,
525,2,467,4,467,4,32767,4,935,2,882,2,882,4,1049,4,
742,4,882,4,786,4,589,4,32767,4,935,2,882,2,882,4,
1049,4,742,4,882,4,786,4,935,4,882,2,786,2,700,2,
624,2,589,4,371,4,393,4,441,4,467,4,525,2,467,2,
441,4,393,4,589,4,32767,4,1112,8,1178,2,32767,6,1112,8,
1178,2,32767,6,1112,8,1178,4,1112,4,1178,4,1112,4,1178,4,-1,-1
/* symphony #40 by wolfgang mozart */
};

int sam[]=
{
523,3,32767,1,523,3,32767,1,587,3,32767,1,659,3,32767,1,
523,3,32767,1,659,3,32767,1,587,3,32767,1,392,3,32767,1,
523,3,32767,1,523,3,32767,1,587,3,32767,1,659,3,32767,1,
523,6,32767,1,392,6,32767,2,523,3,32767,1,523,3,32767,1,
587,3,32767,1,659,3,32767,1,698,3,32767,1,659,3,32767,1,
587,3,32767,1,523,3,32767,1,493,3,32767,1,493,3,32767,1,
440,3,32767,1,493,3,32767,1,523,6,32767,1,523,6,32767,3,-1,-1
/* yankee doodle */
};

int stars[]=
{
589,6,589,6,525,3,495,3,495,6,467,3,495,3,495,16,32767,2,
467,3,495,3,495,6,467,3,495,3,589,6,495,3,589,3,525,12,
441,6,32767,3,441,3,441,6,416,3,441,3,441,6,416,3,441,3,
525,16,32767,2,495,3,441,3,495,3,589,9,661,9,661,3,441,16,
32767,2,589,6,589,6,525,3,495,3,495,6,467,3,495,3,495,16,
32767,2,467,3,495,3,495,6,467,3,495,3,525,3,495,3,441,5,
371,1,441,12,393,6,32767,3,393,3,393,6,371,3,393,3,467,6,
441,3,393,3,786,15,32767,3,393,3,441,3,495,3,589,1,32767,2,
393,3,441,3,495,3,589,1,32767,2,294,3,330,5,495,1,441,12,393,1,
-1,-1
/* the stars and stripes forever
   john p. sousa  */
};

int bug[]=
{
294,1,32767,1,294,1,32767,1,294,1,32767,1,393,1,32767,5,
495,1,32767,3,294,1,32767,1,294,1,32767,1,294,1,32767,1,
393,1,32767,5,495,1,32767,5,147,1,32767,1,147,1,32767,1,
196,1,32767,3,393,1,32767,1,393,1,32767,1,371,1,32767,1,
371,1,32767,1,330,1,32767,1,330,1,32767,1,294,8,32767,2,
294,1,32767,1,294,1,32767,1,294,1,32767,1,371,1,32767,5,
441,1,32767,3,294,1,32767,1,294,1,32767,1,294,1,32767,1,
371,1,32767,5,441,1,32767,5,221,1,32767,1,221,1,32767,1,
147,1,32767,3,589,2,661,2,589,2,525,2,495,2,441,2,393,8,-1,-1
/* archie and mehitabel's lovesong */
};

int weasel[]=
{
393,2,32767,2,393,2,441,2,32767,2,441,2,495,2,589,2,
495,2,393,2,32767,2,294,2,393,2,32767,2,393,2,441,2,
32767,2,441,2,495,6,393,2,32767,2,294,2,393,2,32767,2,
393,2,441,2,32767,2,441,2,495,2,589,2,495,2,393,2,
32767,4,661,2,32767,4,441,2,32767,2,525,2,495,6,393,2,
32767,4,786,2,32767,2,786,2,661,2,32767,2,786,2,742,2,
882,2,742,2,589,2,32767,4,786,2,32767,2,786,2,661,2,
32767,2,786,2,742,6,589,2,32767,2,495,2,525,2,32767,2,
495,2,525,2,32767,2,589,2,661,2,32767,2,742,2,786,2,
32767,4,661,2,32767,4,441,2,32767,2,525,2,495,6,393,2,-1,-1
/* popgoestheweasel */
};

/* musical array created from file HABANERA.SND */
/* array structure is frequency,duration */
int HABANERA[]={
  147,  6,32767,  0,  220,  2,32767,  0,  349,  2,32767,  2,
  220,  2,32767,  2,  147,  6,32767,  0,  220,  2,32767,  0,
  349,  2,32767,  2,  220,  2,32767,  2,  147,  6,32767,  0,
  220,  2,32767,  0,  349,  2,32767,  2,  220,  2,32767,  2,
  147,  6,32767,  0,  220,  2,32767,  0, 1175,  4,32767,  0,
 1109,  4,32767,  0, 1047,  6,32767,  0, 1047,  2,32767,  0,
  988,  4,32767,  0,  932,  4,32767,  0,  880,  6,32767,  0,
  880,  2,32767,  0,  831,  4,32767,  0,  784,  4,32767,  0,
  698,  1,32767,  0,  784,  1,32767,  0,  698,  1,32767,  0,
  659,  2,32767,  0,  698,  2,32767,  0,  784,  4,32767,  0,
  698,  4,32767,  0,  587,  0,32767,  0,  659,  8,32767,  0,
 1175,  4,32767,  0, 1109,  4,32767,  0, 1047,  6,32767,  0,
 1047,  2,32767,  0,  988,  4,32767,  0,  932,  4,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0,  784,  4,32767,  0,
  698,  4,32767,  0,  659,  1,32767,  0,  698,  1,32767,  0,
  659,  1,32767,  0,  587,  2,32767,  0,  659,  2,32767,  0,
  698,  4,32767,  0,  659,  4,32767,  0,  587,  8,32767,  0,
 1175,  4,32767,  0, 1109,  4,32767,  0, 1047,  6,32767,  0,
 1047,  2,32767,  0,  988,  4,32767,  0,  932,  4,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0,  831,  4,32767,  0,
  784,  4,32767,  0,  698,  1,32767,  0,  784,  1,32767,  0,
  698,  1,32767,  0,  659,  2,32767,  0,  698,  2,32767,  0,
  784,  4,32767,  0,  698,  4,32767,  0,  587,  0,32767,  0,
  659,  8,32767,  0, 1175,  4,32767,  0, 1109,  4,32767,  0,
 1047,  6,32767,  0, 1047,  2,32767,  0,  988,  4,32767,  0,
  932,  4,32767,  0,  880,  6,32767,  0,  880,  2,32767,  0,
  784,  4,32767,  0,  698,  4,32767,  0,  659,  1,32767,  0,
  698,  1,32767,  0,  659,  1,32767,  0,  587,  2,32767,  0,
  659,  2,32767,  0,  698,  4,32767,  0,  659,  4,32767,  0,
  587,  6,32767,  0,  880,  2,32767,  0,  587,  4,32767,  0,
  659,  4,32767,  0,  740,  6,32767,  0,  880,  2,32767,  0,
  740,  4,32767,  0,  659,  4,32767,  0,  587,  6,32767,  0,
  659,  2,32767,  0,  740,  4,32767,  0,  784,  4,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  740,  0,32767,  0,
  880,  2,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  784,  0,32767,  0,
  988,  4,32767,  0,  740,  0,32767,  0,  880,  4,32767,  0,
  659,  0,32767,  0,  784,  6,32767,  0,  988,  2,32767,  0,
  659,  4,32767,  0,  740,  4,32767,  0,  659,  0,32767,  0,
  784,  6,32767,  0,  988,  2,32767,  0,  784,  4,32767,  0,
  740,  4,32767,  0,  659,  6,32767,  0,  740,  2,32767,  0,
  784,  4,32767,  0,  880,  4,32767,  0,  784,  0,32767,  0,
  988,  2,32767,  0,  784,  0,32767,  0,  988,  2,32767,  0,
  784,  0,32767,  0,  988,  2,32767,  0,  784,  0,32767,  0,
  988,  2,32767,  0,  880,  0,32767,  0, 1109,  4,32767,  0,
  784,  0,32767,  0,  988,  4,32767,  0,  740,  0,32767,  0,
  880,  6,32767,  0,  880,  2,32767,  0, 1175,  4,32767,  0,
 1319,  4,32767,  0, 1175,  0,32767,  0, 1480,  6,32767,  0,
  880,  2,32767,  0,  740,  4,32767,  0,  659,  4,32767,  0,
  587,  6,32767,  0,  659,  2,32767,  0,  740,  4,32767,  0,
  784,  4,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  740,  0,32767,  0,  880,  2,32767,  0,  740,  0,32767,  0,
  880,  2,32767,  0,  740,  0,32767,  0,  880,  2,32767,  0,
  988,  0,32767,  0, 1175, 16,32767,  0, 1109,  1,32767,  0,
 1175,  1,32767,  0, 1109,  1,32767,  0,  659,  0,32767,  0,
  784,  6,32767,  0,  988,  2,32767,  0, 1319,  4,32767,  0,
 1480,  4,32767,  0, 1319,  0,32767,  0, 1568,  6,32767,  0,
  988,  2,32767,  0,  784,  4,32767,  0,  740,  4,32767,  0,
  659,  6,32767,  0,  740,  2,32767,  0,  784,  4,32767,  0,
  880,  4,32767,  0, 1109,  2,32767,  0,  988,  2,32767,  0,
  831,  2,32767,  0,  880,  2,32767,  0, 1480, 18,32767,  0,
 1319,  1,32767,  0, 1480,  1,32767,  0, 1319,  1,32767,  0,
 1175,  4,32767,  0,32767,  2, 1760,  2,32767,  0, 2349,  4,
32767,  4,-1,-1};


/* screen arrays */
uchar RANDSEL[]={
255,219,210,219,217, 32,193,219,199, 32,194,220,194,223,193,220,194,223,
194,220,201, 32,193,219,218, 32,194,219,199, 32,194,220,194,223,193,220,
194,223,194,220,201, 32,193,219,198, 32,193,223,193,220,197,223,193,220,
194,223,193,220,200, 32,193,219,218, 32,194,219,198, 32,193,223,193,220,
197,223,193,220,194,223,193,220,200, 32,193,219,198, 32,193,220,194,223,
193,220,195, 32,194,223,193,220,193,223,200, 32,193,219,199, 32,194,220,
194,223,193,220,194,223,193,220,194,223,193,220,200, 32,194,219,203, 32,
194,220,194,223,193,220,193,223,200, 32,193,219,198, 32,194,223,193,220,
194,223,193,220,194,223,193,220,194,223,200, 32,193,219,199, 32,198,223,
193,220,194,223,193,220,193,223,200, 32,194,219,202, 32,193,223,193,220,
195,223,202, 32,193,219,198, 32,193,223,193,220,195,223,193,220,193,223,
193,220,194,223,193,220,200, 32,193,219,200, 32,193,220,194,223,193,220,
194,223,204, 32,194,219,202, 32,195,223,204, 32,193,219,198, 32,196,223,
195, 32,194,223,193,220,193,223,200, 32,193,219,199, 32,193,220,194,223,
193,220,193,223,198,220,200, 32,194,219,202, 32,194,223,193,220,204, 32,
193,219,198, 32,196,223,195, 32,194,223,193,220,193,223,200, 32,193,219,
199, 32,194,223,193,220,194,223,193,220,194,223,193,220,194,223,200, 32,
194,219,217, 32,193,219,198, 32,196,223,195, 32,194,223,193,220,193,223,
200, 32,193,219,218, 32,194,219,196, 32, 77, 73, 88, 69, 68, 32, 76,
 69,194, 84, 69, 82, 32, 77, 65, 84, 67, 72,195, 32,193,219,196, 32,
 66, 73, 71,193,255, 76, 69,194, 84, 69, 82, 32, 82, 69, 86, 73, 69,
 87,196, 32,193,219,196, 32, 83, 77, 65,194, 76,193,255, 76, 69,194, 84,
 69, 82,193,255, 82, 69, 86, 73, 69, 87,195, 32,255,219,211,219,196, 32,
193,196, 16, 32, 61, 32, 82, 73, 71, 72, 84,203, 32,193,219,196, 32,
 31, 32, 61, 32, 68, 79, 87, 78,205, 32,193,219,194, 32, 69, 78, 84,
 69, 82, 32, 61, 32, 83, 69, 76, 69, 67, 84, 73, 79, 78,199, 32,194,219,
217, 32,193,219,217, 32,193,219,218, 32,194,219,196, 32, 17,193,196,
 32, 61, 32, 76, 69, 70, 84,204, 32,193,219,196, 32, 30, 32, 61, 32,
 85, 80,207, 32,193,219,196, 32, 69, 83, 67, 32, 61, 32, 83, 69, 76,
 69, 67, 84, 73, 79, 78,199, 32,255,219,211,219,198, 32, 78, 85, 77,
 66, 69, 82, 32, 82, 69, 86, 73, 69, 87,198, 32,193,219,196, 32, 80,
 65, 73, 82, 69, 68,193,255, 76, 69,194, 84, 69, 82,193,255, 77, 65,
 84, 67, 72,194, 32,193,219,203, 32, 69, 88, 73, 84,203, 32,194,219,
217, 32,193,219,194, 32,194,220,194,223,193,220,194,223,194,220,206, 32,
193,219,218, 32,194,219,200, 32,193,220,193,223,193,220,194,223,193,220,
194,223,193,220,200, 32,193,219, 32,193,223,193,220,197,223,193,220,
194,223,193,220,194, 32,194,220,194,223,193,220,194,223,194,220,194, 32,
193,219,200, 32,194,220,193,223,193,220,195, 32,193,220,194,223,193,220,
199, 32,194,219,199, 32,194,223,193,220,193,223,195, 32,193,223,193,220,
194,223,199, 32,193,219,198, 32,194,220,194,223,193,220,193,223, 32,
193,223,193,220,197,223,193,220,194,223,193,220, 32,193,219,200, 32,
195,223,193,220,193,223,194,220,194,223,193,220,193,223,199, 32,194,219,
199, 32,193,223,193,220,193,223,193,220,195, 32,193,220,194,223,193,220,
199, 32,193,219,197, 32,193,223,193,220,195,223,200, 32,194,220,194,223,
193,220,193,223, 32,193,219,202, 32,195,223,193,220,195,223,201, 32,
194,219,200, 32,194,223,193,220,194,223,193,220,194,223,193,220,193,223,
199, 32,193,219,197, 32,193,223,193,220,194,223,200, 32,193,223,193,220,
195,223,195, 32,193,219,202, 32,193,220,193,223,193,220,194,223,194,220,
201, 32,194,219,205, 32,193,220,193,223,193,220,194,223,199, 32,193,219,
197, 32,193,223,193,220,194,223,200, 32,195,223,197, 32,193,219,200, 32,
193,220,194,223,193,220,194,223,193,220,194,223,194,220,199, 32,194,219,
200, 32,195,223,193,220,194,223,193,220,194,223,200, 32,193,219,197, 32,
195,223,201, 32,194,223,193,220,197, 32,193,219,200, 32,194,223,193,220,
193,223,195, 32,193,223,193,220,194,223,199, 32,194,219,217, 32,193,219,
197, 32,194,223,193,220,209, 32,193,219,218, 32,255,219,210,219,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,194,199,193,244,217, 15,193,244,
199, 15,  7,127,115,194, 59, 54,194,110,  6,201, 15,193,244,218, 15,
193,244,193,199,199, 15,  2, 42, 33,194, 25, 21,194, 93,  5,201, 15,
193,199,198, 15,194, 76, 71,127,  7,  3, 11, 59, 54,194,110,200, 15,
193,199,218, 15,193,199,193,244,198, 15,194,110, 98, 42,  2,  1,  9,
 25, 21,194, 93,200, 15,193,244,198, 15, 93, 84,194, 76,195, 15,115,
194, 59, 54,200, 15,193,244,199, 15,  7,127,115,194, 59, 54,194,110,
 98, 42, 10,200, 15,193,244,193,199,203, 15,  2, 42, 33,194, 25,  5,
200, 15,193,199,198, 15, 21,194, 93, 84,194, 76, 71,194,127,115, 59,
200, 15,193,199,199, 15,  4,  7, 15,  7,  3,194, 59, 54,194,110,  2,
200, 15,193,199,193,244,202, 15,194,110, 98, 42,  2,202, 15,193,244,
198, 15,194, 25, 21, 93,194, 76, 71, 76, 71,194,127,200, 15,193,244,
200, 15, 13, 84,194, 76, 71,205, 15,193,244,193,199,202, 15,  3,  6,
 14,204, 15,193,199,198, 15,  2, 33, 25,  1,195, 15,  4,194, 76,  7,
200, 15,193,199,199, 15, 25, 21,194, 93, 84,  4, 12,  4,  7, 15,  7,
200, 15,193,199,193,244,202, 15,115,194, 59,204, 15,193,244,198, 15,
  2, 33, 25,  1,195, 15,  4,194, 76,  7,200, 15,193,244,199, 15,  1,
194, 25, 21,194, 93, 84,194, 76, 71,201, 15,193,244,193,199,217, 15,
193,199,198, 15,  2, 33, 25,  1,195, 15,  4,194, 76,  7,200, 15,193,199,
218, 15,193,199,193,244,217, 15,193,244,217, 15,193,244,218, 15,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,194,199,193,244,217,112,
193,244,217,112,193,244,218,112,193,244,193,199,217,112,193,199,217,112,
193,199,218,112,193,199,193,244,217,112,193,244,217,112,193,244,218,112,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,194,199,193,244,
217, 15,193,244,217, 15,193,244,218, 15,193,244,193,199,217, 15,193,199,
194, 15,  2, 42, 33,194, 25, 21,194, 93,  5,206, 15,193,199,218, 15,
193,199,193,244,200, 15,  2,194, 25, 21,194, 93, 84, 76, 12,200, 15,
193,244, 15,194,110, 98, 42,  2,  1,  9, 25, 21,194, 93,194, 15,  2,
 42, 33,194, 25, 21,194, 93,  5,194, 15,193,244,200, 15,  4, 76, 71,
  7,195, 15, 11, 54,110, 14,199, 15,193,244,193,199,199, 15, 98,194, 42,
  1,195, 15, 13, 93, 84, 76,199, 15,193,199,198, 15,  2, 42, 33,194, 25,
  5, 15,194,110, 98, 42,  2,  1,  9, 25, 21,194, 93, 15,193,199,200, 15,
  5, 84,194, 76, 71,  7,127,115,194, 59,  6,199, 15,193,199,193,244,
199, 15,194,110, 98,  2,195, 15,  9, 21,194, 93,199, 15,193,244,197, 15,
194,110, 98, 42,  2,200, 15,  2, 42, 33,194, 25,  5, 15,193,244,202, 15,
  5, 84,194, 76, 71,127,  7,201, 15,193,244,193,199,200, 15,  6,194,110,
 98,194, 42, 33,194, 25, 21,199, 15,193,199,197, 15,194,110, 98, 42,
200, 15,194,110, 98, 42,  2,195, 15,193,199,202, 15,  1,194, 93, 84,
194, 76,  4,201, 15,193,199,193,244,205, 15,  6,194, 42, 33, 25,199, 15,
193,244,197, 15,194,110, 98, 42,200, 15,  3,  6, 14,197, 15,193,244,
200, 15, 10, 33,194, 25, 21, 13, 93, 84,194, 76,  4,199, 15,193,244,
193,199,200, 15,  7,115,194, 59, 54,194,110, 98, 10,200, 15,193,199,
197, 15,  3,  6, 14,201, 15,115,194, 59,197, 15,193,199,200, 15,  2,
194, 42,  1,195, 15, 13, 93, 84, 12,199, 15,193,199,193,244,217, 15,
193,244,197, 15,115,194, 59,209, 15,193,244,218, 15,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,
193,199,193,244,193,199,193,244,193,199,193,244,193,199,193,244,193,199,
193,244,193,199,193,244,193,199,193,244,194,199,
0}; /* terminator */

int RANDSEL_SIZE = sizeof(RANDSEL);

uchar RANDMENU[]={
193,218,217,196,193,194,217,196,193,194,218,196,191,179,217, 32,179,
199, 32,194,220,194,223,193,220,194,223,194,220,201, 32,179,218, 32,
194,179,199, 32,194,220,194,223,193,220,194,223,194,220,201, 32,179,
198, 32,193,223,193,220,197,223,193,220,194,223,193,220,200, 32,179,
218, 32,194,179,198, 32,193,223,193,220,197,223,193,220,194,223,193,220,
200, 32,179,198, 32,193,220,194,223,193,220,195, 32,194,223,193,220,
193,223,200, 32,179,199, 32,194,220,194,223,193,220,194,223,193,220,
194,223,193,220,200, 32,194,179,203, 32,194,220,194,223,193,220,193,223,
200, 32,179,198, 32,194,223,193,220,194,223,193,220,194,223,193,220,
194,223,200, 32,179,199, 32,198,223,193,220,194,223,193,220,193,223,
200, 32,194,179,202, 32,193,223,193,220,195,223,202, 32,179,198, 32,
193,223,193,220,195,223,193,220,193,223,193,220,194,223,193,220,200, 32,
179,200, 32,193,220,194,223,193,220,194,223,204, 32,194,179,202, 32,
195,223,204, 32,179,198, 32,196,223,195, 32,194,223,193,220,193,223,
200, 32,179,199, 32,193,220,194,223,193,220,193,223,198,220,200, 32,
194,179,202, 32,194,223,193,220,204, 32,179,198, 32,196,223,195, 32,
194,223,193,220,193,223,200, 32,179,199, 32,194,223,193,220,194,223,
193,220,194,223,193,220,194,223,200, 32,194,179,217, 32,179,198, 32,
196,223,195, 32,194,223,193,220,193,223,200, 32,179,218, 32,194,179,
196, 32, 77, 73, 88, 69, 68, 32, 76, 69,194, 84, 69, 82, 32, 77, 65,
 84, 67, 72,195, 32,179,196, 32, 66, 73, 71,193,255, 76, 69,194, 84,
 69, 82, 32, 82, 69, 86, 73, 69, 87,196, 32,179,196, 32, 83, 77, 65,
194, 76,193,255, 76, 69,194, 84, 69, 82,193,255, 82, 69, 86, 73, 69,
 87,195, 32,179,193,195,217,196,193,193,196,196,193,194,212,196,193,193,
218,196,180,179,196, 32,193,196, 16, 32, 61, 32, 82, 73, 71, 72, 84,
208, 32, 31, 32, 61, 32, 68, 79, 87, 78,208, 32, 69, 78, 84, 69, 82,
 32, 61, 32, 83, 69, 76, 69, 67, 84, 73, 79, 78,199, 32,194,179,255, 32,
207, 32,194,179,196, 32, 17,193,196, 32, 61, 32, 76, 69, 70, 84,209, 32,
 30, 32, 61, 32, 85, 80,212, 32, 69, 83, 67, 32, 61, 32, 83, 69, 76,
 69, 67, 84, 73, 79, 78,199, 32,179,193,195,217,196,193,194,196,196,
193,193,212,196,193,194,218,196,180,179,198, 32, 78, 85, 77, 66, 69,
 82, 32, 82, 69, 86, 73, 69, 87,198, 32,179,196, 32, 80, 65, 73, 82,
 69, 68,193,255, 76, 69,194, 84, 69, 82,193,255, 77, 65, 84, 67, 72,
194, 32,179,203, 32, 69, 88, 73, 84,203, 32,194,179,217, 32,179,194, 32,
194,220,194,223,193,220,194,223,194,220,206, 32,179,218, 32,194,179,
200, 32,193,220,193,223,193,220,194,223,193,220,194,223,193,220,200, 32,
179, 32,193,223,193,220,197,223,193,220,194,223,193,220,194, 32,194,220,
194,223,193,220,194,223,194,220,194, 32,179,200, 32,194,220,193,223,
193,220,195, 32,193,220,194,223,193,220,199, 32,194,179,199, 32,194,223,
193,220,193,223,195, 32,193,223,193,220,194,223,199, 32,179,198, 32,
194,220,194,223,193,220,193,223, 32,193,223,193,220,197,223,193,220,
194,223,193,220, 32,179,200, 32,195,223,193,220,193,223,194,220,194,223,
193,220,193,223,199, 32,194,179,199, 32,193,223,193,220,193,223,193,220,
195, 32,193,220,194,223,193,220,199, 32,179,197, 32,193,223,193,220,
195,223,200, 32,194,220,194,223,193,220,193,223, 32,179,202, 32,195,223,
193,220,195,223,201, 32,194,179,200, 32,194,223,193,220,194,223,193,220,
194,223,193,220,193,223,199, 32,179,197, 32,193,223,193,220,194,223,
200, 32,193,223,193,220,195,223,195, 32,179,202, 32,193,220,193,223,
193,220,194,223,194,220,201, 32,194,179,205, 32,193,220,193,223,193,220,
194,223,199, 32,179,197, 32,193,223,193,220,194,223,200, 32,195,223,
197, 32,179,200, 32,193,220,194,223,193,220,194,223,193,220,194,223,
194,220,199, 32,194,179,200, 32,195,223,193,220,194,223,193,220,194,223,
200, 32,179,197, 32,195,223,201, 32,194,223,193,220,197, 32,179,200, 32,
194,223,193,220,193,223,195, 32,193,223,193,220,194,223,199, 32,194,179,
217, 32,179,197, 32,194,223,193,220,209, 32,179,218, 32,179,193,192,
217,196,193,193,217,196,193,193,218,196,193,217,255, 15,243, 15,  7,
127,115,194, 59, 54,194,110,  6,237, 15,  2, 42, 33,194, 25, 21,194, 93,
  5,208, 15,194, 76, 71,127,  7,  3, 11, 59, 54,194,110,235, 15,194,110,
 98, 42,  2,  1,  9, 25, 21,194, 93,207, 15, 93, 84,194, 76,195, 15,
115,194, 59, 54,208, 15,  7,127,115,194, 59, 54,194,110, 98, 42, 10,
213, 15,  2, 42, 33,194, 25,  5,207, 15, 21,194, 93, 84,194, 76, 71,
194,127,115, 59,208, 15,  4,  7, 15,  7,  3,194, 59, 54,194,110,  2,
212, 15,194,110, 98, 42,  2,209, 15,194, 25, 21, 93,194, 76, 71, 76,
 71,194,127,209, 15, 13, 84,194, 76, 71,217, 15,  3,  6, 14,211, 15,
  2, 33, 25,  1,195, 15,  4,194, 76,  7,208, 15, 25, 21,194, 93, 84,
  4, 12,  4,  7, 15,  7,212, 15,115,194, 59,211, 15,  2, 33, 25,  1,
195, 15,  4,194, 76,  7,208, 15,  1,194, 25, 21,194, 93, 84,194, 76,
 71,235, 15,  2, 33, 25,  1,195, 15,  4,194, 76,  7,255, 15,255, 15,
255, 15,200, 15,255,112,207,112,194, 15,255,112,207,112,194, 15,255,112,
207,112,255, 15,255, 15,255, 15, 15,  2, 42, 33,194, 25, 21,194, 93,
  5,243, 15,  2,194, 25, 21,194, 93, 84, 76, 12,202, 15,194,110, 98,
 42,  2,  1,  9, 25, 21,194, 93,194, 15,  2, 42, 33,194, 25, 21,194, 93,
  5,203, 15,  4, 76, 71,  7,195, 15, 11, 54,110, 14,208, 15, 98,194, 42,
  1,195, 15, 13, 93, 84, 76,206, 15,  2, 42, 33,194, 25,  5, 15,194,110,
 98, 42,  2,  1,  9, 25, 21,194, 93,202, 15,  5, 84,194, 76, 71,  7,
127,115,194, 59,  6,208, 15,194,110, 98,  2,195, 15,  9, 21,194, 93,
205, 15,194,110, 98, 42,  2,200, 15,  2, 42, 33,194, 25,  5,204, 15,
  5, 84,194, 76, 71,127,  7,211, 15,  6,194,110, 98,194, 42, 33,194, 25,
 21,205, 15,194,110, 98, 42,200, 15,194,110, 98, 42,  2,206, 15,  1,
194, 93, 84,194, 76,  4,216, 15,  6,194, 42, 33, 25,205, 15,194,110,
 98, 42,200, 15,  3,  6, 14,206, 15, 10, 33,194, 25, 21, 13, 93, 84,
194, 76,  4,209, 15,  7,115,194, 59, 54,194,110, 98, 10,206, 15,  3,
  6, 14,201, 15,115,194, 59,206, 15,  2,194, 42,  1,195, 15, 13, 93,
 84, 12,232, 15,115,194, 59,255, 15,254, 15,
0}; /* terminator */

int RANDMENU_SIZE = sizeof(RANDMENU);


/* run length encoded array created from BSAVED text screen */
uchar STARVE[]={
255, 32,229, 32, 45, 82,101,115,101, 97,114, 99,104, 32, 70,117,110,
100,115, 32, 97,114,101, 32, 68,101,115,112,101,114, 97,116,101,108,
121, 32, 78,194,101,100,101,100, 32,116,111, 32, 70,105,110,100, 32,
 97, 32, 67,117,114,101,220, 32, 70,111,114, 32, 80,114,111,103,114,
 97,194,109,101,114, 39,115, 32, 73,110,115,111,109,110,105, 97, 46,
231, 32, 47, 92,204, 32, 45, 69,118,101,110, 32,105,102, 32, 73, 32,
 99,111,117,108,100, 32, 97,194,102,111,114,100, 32,110,111,116, 32,
116,111, 32, 73, 32,119,111,117,108,100, 32,112,114,111, 98, 97, 98,
108,121, 32,115,116,105,194,108,204, 32,194, 47,194, 92,204, 32,114,
 97,116,104,101,114, 32,100,111, 32,112,114,111,103,114, 97,194,109,
105,110,103, 32, 97,194,108, 32,110,105,103,104,116, 32,116,104, 97,
110, 32, 67, 97,116, 99,104, 32, 90,194,101,115, 46,207, 32,195, 47,
195, 92,203, 32, 73, 32,119,111,117,108,100, 44, 32,104,111,119,101,
118,101,114, 44, 32, 97,194,112,114,101, 99,105, 97,116,101, 32,116,
104,101, 32,111,194,112,111,114,116,117,110,105,116,121, 32,116,111,
 32,112,114,111,118,101,201, 32,196, 47,196, 92,202, 32,111,114, 32,
100,105,115,112,114,111,118,101, 32,116,104,105,115, 32,116,104,101,
111,114,121, 46, 32, 73,102, 32,121,111,117, 32,119,105,115,104, 32,
116,111, 32,112, 97,114,116,105, 99,105,112, 97,116,101, 32,105,110,
199, 32,197, 47,197, 92,201, 32,116,104,105,115, 32,119,111,114,116,
104,119,104,105,108,101, 32, 83, 99,105,101,110,116,105,102,105, 99,
 32, 69,120,112,101,114,105,109,101,110,116, 32, 97,110,100, 32, 89,
111,117, 32,102,194,101,108, 32,116,104, 97,116,197, 32,195, 47, 67,
 65, 78, 65, 68, 65,195, 92,200, 32, 89,111,117, 32,104, 97,118,101,
 32,114,101, 99,101,105,118,101,100, 32,115,111,109,101, 32,118, 97,
108,117,101, 32,102,114,111,109, 32,109,121, 32, 99,114,101, 97,116,
105,111,110,115, 44, 32, 80,108,101, 97,115,101,197, 32, 47,204,223,
 92,199, 32, 70,194,101,108, 32, 70,114,194,101, 32, 84,111, 32, 67,
111,110,116,114,105, 98,117,116,101, 32, 87,104, 97,116,101,118,101,
114, 32, 89,111,117,114, 32, 67,111,110,115, 99,105,101,110, 99,101,
 32, 87,105,194,108,202, 32,193,221,193,222, 32,193,221,193,222, 32,
193,221,202, 32, 65,194,108,111,119, 46, 32, 40, 80,114,101,102,101,
114, 97, 98,108,121, 32,109,111,110,101,121, 44, 32, 98,117,116, 32,
 97,110,121,116,104,105,110,103, 32,111,102, 32,118, 97,108,117,101,
 32, 97,194, 99,101,112,116,101,100, 46, 41,197, 32,193,221,193,222,
 32,193,221,193,222, 32,193,221,255, 32,202, 32,194, 98,117, 99,107,
101,108,115, 64,101,115, 99, 97,112,101, 46, 99, 97,200, 32, 66,105,
194,108, 32, 66,117, 99,107,101,108,115, 44, 32, 83,116, 97,114,118,
105,110,103, 32, 80,114,111,103,114, 97,194,109,101,114,213, 32,195,119,
 46,101,115, 99, 97,112,101, 46, 99, 97, 47,126,194, 98,117, 99,107,
101,108,115,195, 32, 53, 56, 57, 32, 79,120,102,111,114,100, 32, 83,
116,114,194,101,116,255, 32, 87,105,194,110,105,112,101,103, 44, 32,
 77, 97,110,105,116,111, 98, 97, 44, 32, 67, 97,110, 97,100, 97,194, 32,
 82, 51, 77, 32, 51, 74, 50,255, 32,244, 32, 72,101,114,101, 32, 73,
215, 32,202, 36,233, 32,202,219,211, 32,202,219,196, 32,193,219,195,223,
193,219,197, 32,195,219,216, 32,202,219,211, 32,202,219,196, 32,193,219,
195, 32,193,219,198, 32,193,219,202, 32, 77, 97,110,105,116,111, 98,
 97,194, 32,197, 95,202,219,197, 95, 67,111,109,101,198, 32,196, 95,
202,219,196, 95,205,219,201, 32,202,219,197, 32,202,219,197, 32,202,219,
196, 32,202,219,196, 32,205,219,203, 32, 79,196, 32, 79,201, 32, 79,
196, 32, 79,201, 32, 79,196, 32, 79,200, 32, 79,196, 32, 79,201, 32,
 79,196, 32, 79,196, 32,193,219,255, 32,255, 32,229, 32, 78,111,116,
101, 58, 32, 73,116, 32,105,115, 32,111,107, 32,116,111, 32,109, 97,
105,108, 32, 99, 97,115,104, 44, 32, 98,117,116, 32,100,111, 32,110,
111,116, 32,115,101,110,100, 32, 99, 97,114,115, 32,111,114, 32,108,
105,118,101,115,116,111, 99,107, 32,116,104,114,111,117,103,104, 32,
116,104,101, 32,109, 97,105,108, 46,255, 21,255, 21,255, 21,243, 21,
204, 30,255, 21,197, 21,204, 30,255, 21,197, 21,204, 30,255, 21,197, 21,
206, 30,255, 21,195, 21,208, 30,255, 21, 21,210, 30,254, 21,210, 30,
254, 21,210, 30,254, 21,210, 30,254, 21,255, 47,255, 47,255, 47,255, 47,
255, 47,255, 47,255, 47,255, 47,255, 47,255, 47,255, 47,219, 47,255, 36,
207, 36,194, 37,255, 47,255, 47,255, 47,243, 47,
0}; /* terminator */

int STARVE_SIZE = sizeof(STARVE);

