#include <iostream.h>
#include <string.h>
#include <ctype.h>
#include "tcg.h"

/* ============================================================================
File name:	tcg.cpp
Purpose:	implementation for tcg class define in tcg.h
Author:		Zijian Huang
Date:		9, Feb, 96
==============================================================================*/

tcgClass::tcgClass(ifstream* twdf, ifstream* dicf, ofstream* basketf)
		: dicText()
{
  int i;

  TWDsource=twdf;
  dicSource=dicf;
  basketDestination=basketf;
  for (i=0; i<TWD_MAX; i++)
    basketLen[i]=0;
}

bool tcgClass::defineTWD()
{
  CHAR def[MAX_DEF_LEN+1];		// will store a definition string temperarily
  int len, i=0;

  if (TWDsource==NULL)		// the definition source will not be a file
	 {
    do
      {
      cout<<"Input line "<<i<<" : ";
      cin>>def;
      len=strlen(def);
      if (len>1)
	{		// more than 1 char
	TWDtext.camp[i]=new CHAR[len+1];	// point to a string space
	strcpy(TWDtext.camp[i], def);		// create an item of definition
	}
	else			// only 1 char, then finish input
	  break;

      i=i+1;
      }
    while (i<TWD_MAX);
    }
    else
      {			// read a file
      TWDsource->clear(0);
      TWDsource->seekg(0, ios::beg);
      while(( ! TWDsource->eof()) && (i  < TWD_MAX) && TWDsource->getline(def, MAX_DEF_LEN))
	{
	len=strlen(def);
	if (len>1)
	  {
	  TWDtext.camp[i]=new CHAR[len+1];
	  strcpy(TWDtext.camp[i], def);

	  i=i+1;
	};
      };
    };
  TWDtext.sum=i;		// return the sum of total definiton string

  return true;
}

bool tcgClass::readDic()
{
  int len;	// len of a word
  int j, i;      // counter for analysing a line
  int k=0;	// counter for number of words
  CHAR lineBuf[MAX_LINE_LEN+1];
  CHAR def[80];
  bool wordOK;

  dicSource->clear(0);
  dicSource->seekg(0, ios::beg);
  while (( ! dicSource->eof()) && (k < DIC_MAX) && dicSource->getline(lineBuf, MAX_LINE_LEN))
    {
// extract words from the line and add them to dic
    j=0;  i=0;
    wordOK=false;		// no word can be formed yet
    if (! lineBuf[0])
		continue;			// skip empty line

    do
      {
      if ((unsigned char)lineBuf[i] > 32)	// a character, may also be extended ASCII
	{
	def[j]=lineBuf[i];
	wordOK=true;	// ready to form a word
	j++;		// ready for next char in the word
	}
	else		// un-visuable chars
	  {
	  if (wordOK)	// the first time encounter a space after some chars
	    {
	    def[j]='\0';
	    len=j;

	    // insert the word to the list
	    dicText.insertAtTail( new CHAR[len+1] );	// add a new empty string
	    strcpy(dicText.itemAtTail(), def);			// fill the string

	    j=0;	// ready for next word

	    wordOK=false;		// will be true until next char
	    };   //  if
          if (! lineBuf[i])		// if it is the end of of the line
	    break;			// break the scan of this line
	  };	// else
      i++;		// ready for reading next char in the line
		}
    while (true);		// scan the line

    k++;		// count actuall non-empty lines

   };				// while
   return true;
}

bool tcgClass::writeBasket()
{
// now only for testing other function

  int i, j;

  // scan TWD Text, and write thme to File line by line
  *basketDestination<<"The Definition Strings"<<endl;
  *basketDestination<<"======================"<<endl;
  for (i=0; i<TWDtext.sum; i++)
    *basketDestination<<TWDtext.camp[i]<<endl;

  *basketDestination<<"================"<<endl;
  *basketDestination<<"The Sieved Words"<<endl;
  *basketDestination<<"================"<<endl;

  for (i=0; i<TWDtext.sum; i++)			// basket by basket
    {
    *basketDestination<<"----------------------------------------------------"<<endl;
    *basketDestination<<TWDtext.camp[i]<<" >> Total: "<<basketLen[i]<<endl;
    *basketDestination<<"****************************************************"<<endl;

	 basketText[i].start();		// head of a basket
    j=0;
    while( ! basketText[i].atEnd())
      {
      *basketDestination<<basketText[i].current();	// write down a word in the basket
      j++;

      if (j % 10)		// 10 words per line
	*basketDestination<<' ';
	else
	*basketDestination<<endl;

      basketText[i].next();		// next word in the basket
      };

      *basketDestination<<endl;

	 };
  return true;
}

bool tcgClass::sieve(CHAR*& candi)
{
  static int i, j, k;		// static only improve the speed
  static bool fitALetter;

  for (i=0; i<TWDtext.sum; i++)		// def by def
    {
    j=0;

    while (candi[j])			// letter by letter in the candi
      {
      fitALetter=false;
      for (k=0; TWDtext.camp[i][k]; k++)	// compare the letter with a definition
	{
	if (TWDtext.camp[i][k]==tolower(candi[j]))	// the letter fit the definition
	  {
	  fitALetter=true;
	  break;
	  };
	};

      if (fitALetter==false)		// a letter do not fit the definition
	break;
      j++;				// ready for next letter of the word
      };

	 if (fitALetter)		// all OK
		{
		basketText[i].insertAtTail(new CHAR[j+1]);	// new a grib of basket
		strcpy(basketText[i].itemAtTail(), candi);		// place the word inside

		basketLen[i]++ ;
		return true;
		};
	 };
  return false;
}

void tcgClass::mainExec()
{
  dicText.start();
  while(! dicText.atEnd())
	 {
	 sieve(dicText.current());
    dicText.next();
    };
}

void tcgClass::exec()
{
  if (defineTWD())
    if ( readDic())
      {
      mainExec();
      writeBasket();
		};
}

tcgClass::~tcgClass()
{
  int i;

// delete the TWD strings
  for (i=0; i<TWDtext.sum; i++)
    delete TWDtext.camp[i];

// the dictionary strings will be deleted by List desturctor

// the baskets will be deleted by the List array
}
