/*
  lfn.h: Long filename functions for WRen.

  Jason Hood, 14 June, 2000 & 25 November, 2002.
*/


#ifndef _LFN_H
#define _LFN_H

#include <dir.h>


typedef unsigned long DWORD;	// 32 bits

struct lfn_ffblk
{
  DWORD attrib;
  DWORD cr_time[2];
  DWORD ac_time[2];
  DWORD mo_time[2];
  DWORD size_hi;
  DWORD size;
  char  resv[8];
  char  fname[260];
  char  sname[14];

  int   handle;
};

struct my_ffblk
{
  char* name;
  union
  {
    struct     ffblk df;
    struct lfn_ffblk lf;
  } ff;
};


extern int use_lfn;

int init_lfn( void );
int lfn_findfirst( const char*, struct lfn_ffblk*, int );
int lfn_findnext( struct lfn_ffblk* );
int my_findfirst( const char*, struct my_ffblk*, int );
int my_findnext( struct my_ffblk* );
int my_rename( const char*, const char* );
int file_exists( const char* );

#endif
