;
; Copyright (C) 1987 Solar Wind Computing,  ALL RIGHTS RESERVED
;
;
;  Equates for IBM BIOS interrupt calls
;
BiosVideo equ   10h
BiosDisk  equ   13h
BiosComm  equ   14h
BiosKeybd equ   16h
BiosLpt   equ   17h
BiosBoot  equ   19h
BiosClk   equ   1ah
BiosBreak equ   1bh
;
;  Equates for Tandy BIOS interrupt calls
;
TBiosBoot  equ  49h
TBiosKeybd equ  51h
TBiosVideo equ  52h
TBiosComm  equ  53h
TBiosLpt   equ  54h
TBiosClk   equ  55h
TBiosDisk  equ  56h
;
;  Equates for BIOS keyboard functions
;
KeybdRead  equ  00h
KeybdScan  equ  01h
KeybdStat  equ  02h
KeybdFlush equ  03h
KeybdReset equ  04h
;
;  Equates for BIOS video functions
;
VideoSetMode   equ      00h
VideoSetCurTyp equ      01h
VideoSetCurPos equ      02h
VideoGetCurPos equ      03h
VideoSelPage   equ      05h
VideoScrlUp    equ      06h
VideoScrlDn    equ      07h
VideoRdAtrCh   equ      08h
VideoWrAtrCh   equ      09h
VideoWrCh      equ      0ah
VideoSetPal    equ      0bh
VideoWrDot     equ      0ch
VideoRdDot     equ      0dh
VideoWrTty     equ      0eh
VideoGetMode   equ      0fh
VideoFont      equ      10h
VideoWrAtr     equ      11h
VideoAdvScrl   equ      12h
;
;  Equates for BIOS communications functions
;
CommReset equ   00h
CommXmit  equ   01h
CommRecv  equ   02h
CommStat  equ   03h
CommFlush equ   04h
;
;  Record definition for parms used to set port with CommReset
;
CRParm	record	CRRate:3,CRParity:2,CRStopBit:1,CRWordLen:2
;
;  Equates for BIOS line printer functions
;
LptPrCh  equ    00h
LptReset equ    01h
LptStat  equ    02h
;
;  Equates for BIOS clock functions
;
ClkGetTod  equ  00h
ClkSetTod  equ  01h
ClkGetDate equ  02h
ClkSetDate equ  03h
