/*
	gtc - graphics driver using Turbo C graphics functions
*/
#define INCLUDING

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <graphics.h>			/* Turbo C header file */
#include "g.h"					/* portable CORE device driver header file */


/* LOCAL DEFINITIONS */


/* Constants */

/*	pointers to optional functions (NULL if not implemented)	*/

int	(*new_linewidth)(int)=0;		/* (*new_linewidth)(width) int width; */
int	(*new_linestyle)(int)=0;		/* (*new_linestyle)(style) int style; */
int	(*new_charsize)(int, int)=0;	/* (*new_charsize)(w,h) int w,h; */
int	(*draw_marker)(int)=0;			/* (*draw_marker)(n) int n; */

/*	exported graphics variables	*/

char *machine		=	"BGI";
char *interface_version	=	".91";
char *config_file	=	NULL;
int plotting_device	=	0;
int erasing			=	1;
int flipping		=	1;
int max_color		=	1;
int current_color	=	0;
int current_background_color = 0;
int pen_diameter	=	1;
					/* height/width parameters of screen */
int pixels_wide		=	720;
int pixels_high		=	348;
double best_width	=	1.;
double best_height	=	.652;
					/* text parameters */
int char_height		=	12;	/* includes blank scans */
static font_height	=	9;	/* no blank scans */
int char_width		=	8;
int char_rows		=	38;
int char_columns	=	90;
int x_offset		=	0;
int y_offset		=	8;
int	char_v_adjusted	=	1;
int	char_h_adjusted	=	0;
struct textsettingstype ts;		/* Borland's text info structure */

					/* cursor key codes */
int	up_arrow	=	0x48;
int	down_arrow	=	0x50;
int	left_arrow	=	0x4b;
int	right_arrow	=	0x4d;
int	escaped_arrows	=	1;	/* cursor keys are preceded by 0 */
int	escape_char	=	0;

struct PRIM_ATTR prim_attr;

static int cursor_x=0, cursor_y=0;	/* pixel loc. of cursor
				 (lower left corner of char) */
static char active_page=0;		/* 0 for page at b000,
									1 for page at b800  */
static char graph_status;		/* value saved from 40:0049 */

/*	set_color - set color to be used for subsequent primitives
	0 -> white     prim_attr.color_count-1 -> black  */
set_color(color) int color;
{
	color = max_color - color&max_color;
	setcolor(color);
	current_color=color; 
}	
set_background_color(color) int color; 
	{current_background_color = max_color - color&max_color;
	}
set_intensity(intensity) double intensity;
{	int i;			/* 0->black  1->white */
	if(intensity > 1.) intensity = 1.;
	i=(int)(intensity*prim_attr.color_count);
	if(i<0) i=0;
	if(i > max_color) i = max_color;
	set_color(max_color - i);
}
set_background_intensity(intensity) double intensity;
{	int i;
	if(intensity > 1.) intensity = 1.;
	i=(int)(intensity*prim_attr.color_count);
	if(i<0) i=0;
	if(i > max_color) i = max_color;
	set_background_color(max_color - i);
}

inquire_color() {return current_color;}
double inquire_intensity() {return current_color/(double)max_color;}


/*	clear_graphics - clear screen  */
clear_graphics()
{	clearviewport();
}

/*	gotoxy - direct cursor positioning
		(set x and y pixel position of lower left corner of char,
		can be off the screen)     */
gotoxy(x,y) int x,y;
{	cursor_x=x; cursor_y=y;
	moveto(x,y);
}


/*	Draw a straight line  */

static draw2(x1,y1, x2,y2)
int	x1,y1;		/* Coordinates of first point */
int	x2,y2;		/* Coordinates of last point */
{
	line(x1,y1, x2,y2);
}

/*  flip bits along a line */

static flip2(x1,y1, x2,y2)
int	x1,y1;		/* Coordinates of first point */
int	x2,y2;		/* Coordinates of last point */
{
	setwritemode(1);	/* XOR mode */
	line(x1,y1, x2,y2);
	setwritemode(0);	/* MOV mode */
}


/*     Erase line    */

static erase2(x1,y1, x2,y2)
int	x1,y1;		/* Coordinates of first point */
int	x2,y2;		/* Coordinates of last point */
{
	setcolor(0);
	line(x1,y1, x2,y2);
	setcolor(current_color);
}

static puts2(s) char *s;
{	char far *sp;
	if(strchr(s, '\n') == NULL)
		{sp = s;
		cursor_x = getx();
		cursor_y = gety();
#ifdef INCLUDING
		if(cursor_y<font_height) cursor_y=font_height;
		else if(cursor_y>=pixels_high) cursor_y=pixels_high-1;
		if(cursor_x<0) cursor_x=0;
		else if(cursor_x+char_width>=pixels_wide)
			cursor_x=pixels_wide-char_width;
#endif
		setfillstyle(SOLID_FILL, current_background_color);
		bar(cursor_x, cursor_y, cursor_x + textwidth(sp), 
													cursor_y - char_height);
/*
*/
		outtext(sp);
		}
	else
		while(*s) 
			putchar2(*s++);
}
	
static putchar2(c) int c;
{
	static char s[2] = "x";
	static char far *sp = s;

	if(c=='\n') 
		gotoxy(0, gety() + char_height);
	else
		{s[0] = c;
		cursor_x = getx();
		cursor_y = gety();
#ifdef INCLUDING
		if(cursor_y<font_height) cursor_y=font_height;
		else if(cursor_y>=pixels_high) cursor_y=pixels_high-1;
		if(cursor_x<0) cursor_x=0;
		else if(cursor_x+char_width>=pixels_wide)
			cursor_x=pixels_wide-char_width;
		moveto(cursor_x, cursor_y);
#endif
		setfillstyle(SOLID_FILL, current_background_color);
		bar(cursor_x, cursor_y, cursor_x + textwidth(sp), 
													cursor_y - char_height);
/*
*/
		outtext(sp);
		}
}

static int huge Always_One( void )
{
  return( 1 );
}

/*	init_graphics - initialize hardware for graphics */
init_graphics()
{	int usermode, graphmode, graphdriver, xasp, yasp, lomode, himode;
	static int vga_scan_lines[] = {200, 350, 480};
	char *bgi_path, *s, *t, *u, buf[40];
	extern char **_argv;		/* global variable supplied by Turbo C */

	s = getenv("BGIDRIVER");
	if(s == NULL) graphdriver = DETECT;
	else graphdriver = installuserdriver( s, Always_One );

	usermode = -7;
	s = getenv("GRAPHMODE");
	if(s != NULL) usermode = atoi(s);

	s = getenv("BGIDIR");
	if(s==NULL || *s == 0) s = getenv("PATH");
	bgi_path = strncpy(buf, _argv[0], 39);
	if(bgi_path != NULL)
		{		/* delete program name to yield path to program (with '\') */
		for (u = t = bgi_path; *u; u++)
			if(*u == '\\')
				t = u;
		if(t > bgi_path) t[1] = 0;
		}

	while(1)
		{
/*		printf("bgi_path=%s\n", (bgi_path==NULL)?"NULL":bgi_path); getchar(); */
		initgraph(&graphdriver, &graphmode, bgi_path);
		if(graphdriver > 0) break;
/*		printf("%s\n", grapherrormsg(graphresult())); */
		if((s != NULL) && *s) bgi_path = s;
		else 
			{fprintf(stderr, grapherrormsg(graphresult())); 
			exit(1);
			}
		if(s = strchr(bgi_path, ';')) {*s++ = 0;}
		graphdriver = DETECT;
		}

	getmoderange(graphdriver, &lomode, &himode);
	if(usermode >= lomode && usermode <= himode && usermode != graphmode)
		setgraphmode(usermode);
	graphmode = getgraphmode();

	pixels_wide = getmaxx() + 1;
	pixels_high = getmaxy() + 1;
	if(graphdriver == 9)
		pixels_high = vga_scan_lines[graphmode];

	max_color = getmaxcolor();
	set_color(0);							/* white */
	set_background_color(max_color);		/* black */

	settextjustify(LEFT_TEXT, BOTTOM_TEXT);
	gettextsettings(&ts);
/*	if(ts.font) */
		{char_width = textwidth("M");
		font_height = textheight("Mj");
		}
/*	else */
		{char_width = font_height = 8;
		}
	char_height = (font_height*3)/2;		/* allow for space between lines */

	char_rows = pixels_high/char_height;
	char_columns = pixels_wide/char_width;

	y_offset = font_height;

	prim_attr.color_count = getmaxcolor() + 1;
	prim_attr.intensity_count = 1;
	prim_attr.intensities_in_hardware = 0;
	prim_attr.hardware_linestyles = 0;       /* # linestyles in hardware          */
	prim_attr.software_linestyles = 0;       /* # linestyles in software          */
	prim_attr.linewidth_count = 0;           /* # linewidths                      */
	prim_attr.linewidths_in_hardware = 0;    /* nonzero if supported in hardware  */
	prim_attr.linewidth_minimum = 1;         /*                                   */
	prim_attr.linewidth_maximum = 1;         /*                                   */
	prim_attr.hardware_pens = 1;             /*                                   */
	prim_attr.software_pens = 1;             /*                                   */
	prim_attr.charfont_count = 1;            /* # fonts                           */
	prim_attr.charsize_count = 1;            /* # character sizes                 */
	prim_attr.charsize_in_hardware = 0;      /* nonzero if supported in hardware  */
	prim_attr.charsize_minimum = font_height;          /*                                   */
	prim_attr.charsize_maximum = font_height;          /*                                   */
	prim_attr.hardware_markers = 0;          /* # markers in hardware             */
	prim_attr.software_markers = 0;          /* # markers in software             */
	prim_attr.pick_id_count = 0;             /* # pick IDs in hardware            */

}


/*	finish_graphics - clean up after graphics */
finish_graphics()
{	closegraph();
}


/*	exported function pointers (declared & initialized here) */

int (*draw_line)()=draw2;
int (*erase_line)()=erase2;
int (*draw_char)()=putchar2;
int (*draw_text)()=puts2;
int (*flip_line)()=flip2;

