{Ŀ
  Font Editor 1.0 / VGA 256 Colors   
 ĳ
  Written by Jou-Nan Chen  May,1992  
  Copyright (C) 1992 by Jou Nan Chen 
 }

uses Crt,Misc,Show,VGA256a;

type MenuType=record
       X,X2,LenX,LenY,N,P:integer;
       Name:string[7];
     end;
const
  SubNum=5;
  Sub:array[1..SubNum] of MenuType=(
    (X: 16;X2: 16;LenX:98;LenY: 46;N: 3;P:1;Name:'File'),
    (X: 48;X2: 48;LenX:92;LenY: 73;N: 6;P:1;Name:'Edit'),
    (X: 80;X2: 80;LenX:92;LenY:118;N:11;P:1;Name:'Tools'),
    (X:120;X2:120;LenX:92;LenY: 46;N: 3;P:1;Name:'Block'),
    (X:160;X2:160;LenX:98;LenY: 55;N: 4;P:1;Name:'Special'));
  SubName:array[1..27] of string[12]=(
    'Load','Save a char','Quit',
    'Edit a char','Merge','Scroll '#0,'Scroll '#3,'Scroll '#2,'Scroll '#1,
    'Line','Circle','Fill','Clear','Reverse','Mirror '#0#1,'Mirror '#2#3,
    'Move '#0,'Move '#3,'Move '#2,'Move '#1,
    'Begin/end','Copy to','Move to',
    'Animate','Cut...','Show block','Full block');
  SubKey:array[1..27] of string[2]=(
    '^L','G','^Q', 'E','M','W','A','D','X',
    'L','C','F','^C','R','H','V','^W','^A','^D','^X', '@B','@C','@M',
    'T','^T','F2','F3');
  MenuP:integer=1;
  Color:array[0..1] of byte=(1,14);
  Xi=8; Yi=16; XX:integer=0; YY:integer=0;
  Xp:integer=0; Yp:integer=0; Mode:integer=2; Page:integer=0;
var K,I,J,WinX,WinY,WinLenX,WinLenY,Xsize,Ysize,FontSize,Xcell,Ycell,
      Fsize,FontNo,PageSize:integer;
    File1:file;
    Font:array[0..5600] of byte;
    St:string;
    Back:pointer;

{--------------Sub Menu--------------}
procedure SubMenu;
var N,P,X:integer;
    Buf:pointer;
begin
  N:=1; for K:=1 to MenuP-1 do Inc(N,Sub[K].N);
  P:=Sub[MenuP].P;
  X:=Sub[MenuP].X2-4; I:=Sub[MenuP].LenX; J:=Sub[MenuP].LenY;
  GetMem(Buf,20000); Get(X,9,I,J,Buf^);
  Bar(X,9,I-4,J-4,3); Box(X+2,11,I-8,J-8,1);
  Bar(X+I-4,13,4,J-4,0); Bar(X+4,J+5,I-4,4,0);  { Shadow }
  for K:=1 to Sub[MenuP].N do begin
    Print(X+8,K*9+8,14,0,SubName[N+K-1]);
    Print2(X+I-12,K*9+8,10,0,SubKey[N+K-1]);
  end;
  repeat
    Bar(X+4,P*9+8,Sub[MenuP].LenX-12,9,5);
    Print(X+8,P*9+8,15,0,SubName[N+P-1]);
    Print2(X+I-12,P*9+8,10,0,SubKey[N+P-1]);
    K:=Key;
    Bar(X+4,P*9+8,Sub[MenuP].LenX-12,9,3);
    Print(X+8,P*9+8,14,0,SubName[N+P-1]);
    Print2(X+I-12,P*9+8,10,0,SubKey[N+P-1]);
    case K of
      328:Dec(P); 336:Inc(P);
    end;
    if P<1 then P:=Sub[MenuP].N; if P>Sub[MenuP].N then P:=1;
  until (K=331) or (K=333) or (K=13) or (K=27);
  Sub[MenuP].P:=P;
  Put(X,9,I,J,Buf^); FreeMem(Buf,20000);
end;
{--------------Main Menu---------------}
function MainMenu:integer;
var Start:integer;
begin
  Start:=0;
  repeat
    Bar(Sub[MenuP].X-4,0,FontWidth(Sub[MenuP].Name)+7,9,5);
    Print(Sub[MenuP].X,0,15,0,Sub[MenuP].Name);
    if Start=1 then SubMenu else begin
      K:=Key;
      if (K=13) or (K=336) then begin SubMenu; Start:=1; end;
    end;
    Bar(Sub[MenuP].X-4,0,FontWidth(Sub[MenuP].Name)+7,9,3);
    Print(Sub[MenuP].X,0,14,0,Sub[MenuP].Name);
    case K of
      331:Dec(MenuP); 333:Inc(MenuP);
    end;
    if MenuP<1 then MenuP:=SubNum; if MenuP>SubNum then MenuP:=1;
  until K in [13,27];
  MainMenu:=0;
  if K=13 then begin
    Start:=0; for K:=1 to MenuP-1 do Inc(Start,Sub[K].N);
    MainMenu:=Start+Sub[MenuP].P;
  end;
end;
{--------------Line_---------------}
procedure Line_(X,Y:integer);
begin
  I:=X; J:=Y;
  repeat
    repeat
      Line(X,Y,I,J,-1);
      K:=Key;
      Line(X,Y,I,J,-1);
      case K of
	331:Dec(I); 333:Inc(I); 328:Dec(J); 336:Inc(J);
      end;
      if I<Xi then I:=Xi; if I>Xi+Xsize-1 then I:=Xi+Xsize-1;
      if J<Yi then J:=Yi; if J>Yi+Ysize-1 then J:=Yi+Ysize-1;
    until K in [13,27];
    if K=13 then Line(X,Y,I,J,Color[1]); X:=I; Y:=J;
  until K=27;
end;
{--------------Circle_---------------}
procedure Circle_(X,Y:integer);
begin
  MinX:=Xi; MinY:=Yi; MaxX:=Xi+Xsize-1; MaxY:=Yi+Ysize-1;
  I:=3; J:=3;
  repeat
    Circle(X,Y,I,J,-1);
    K:=Key;
    Circle(X,Y,I,J,-1);
    case K of
      331:Dec(I); 333:Inc(I); 328:Dec(J); 336:Inc(J);
    end;
    if I<3 then I:=3; if I>Xsize then I:=Xsize;
    if J<3 then J:=3; if J>Ysize then J:=Ysize;
  until K in [13,27];
  if K=13 then Circle(X,Y,I,J,Color[1]);
  MinX:=0; MinY:=0; MaxX:=319; MaxY:=199;
end;
{--------------Block---------------}
procedure Block(X,Y:integer);  { Min:2x2 }
begin
  WinX:=X; WinY:=Y; WinLenX:=2; WinLenY:=2;
  repeat
    Box(WinX,WinY,WinLenX,WinLenY,-1);
    I:=WinLenX; J:=WinLenY;
    if I>56-Xp then I:=56-Xp; if J>56-Yp then J:=56-Yp;
    Box(3*Xp+144,3*Yp+16,3*I,3*J,-1);
    K:=Key;
    Box(WinX,WinY,WinLenX,WinLenY,-1);
    Box(3*Xp+144,3*Yp+16,3*I,3*J,-1);
    case K of
      328:Dec(WinLenY); 331:Dec(WinLenX); 333:Inc(WinLenX); 336:Inc(WinLenY);
      327:begin Dec(WinLenX); Dec(WinLenY); end;
      329:begin Inc(WinLenX); Dec(WinLenY); end;
      335:begin Dec(WinLenX); Inc(WinLenY); end;
      337:begin Inc(WinLenX); Inc(WinLenY); end;
    end;
    if WinLenX<2 then WinLenX:=2; if WinLenY<2 then WinLenY:=2;
    if WinLenX>Xsize-Xp-XX then WinLenX:=Xsize-Xp-XX;
    if WinLenY>Ysize-Yp-YY then WinLenY:=Ysize-Yp-YY;
  until K in [13,27];
end;
{--------------Help--------------}
procedure Help(X,Y:integer);     { 200x100 }
const                            { 160x71 }
  St:array[0..7] of string[27]=(
    'Copyright (C) May,1992',
    'by Jou-Nan Chen',
    'Written by Jou-Nan Chen',
    #0#1#2#3#4#5#6#7' - Move cursor',
    #12' '#0#1#2#3#4#5#6#7' - Quick cursor',
    '+,-,'#31' - Change mode',
    'Space - Put/erase a dot',
    '^PgUp,PgDn - Prev/next page');
var Buf,Back:pointer;
begin
  GetMem(Back,20000); Get(X,Y,200,100,Back^);
  Window(X,Y,200,100,3,29,1,0,15,0,'Font Editor version 1.0');
  GetMem(Buf,11360); FillChar(Buf^,11360,3);
  Width:=160; MemV:=Buf; for K:=0 to 7 do Print(0,9*K,64+K,0,St[K]);
  Width:=320; MemV:=Ptr($A000,0); Show7(2,X+12,Y+18,160,71,5,Buf^);
  K:=Key; K:=0; FreeMem(Buf,11360);
  Put(X,Y,200,100,Back^); FreeMem(Back,20000);
end;
{--------------Main Window--------------}
procedure MainWindow;
begin
  Bar(0,0,320,9,3); Bar(0,9,320,182,1); Bar(0,191,320,9,3);
  for K:=1 to 5 do Print(Sub[K].X,0,14,0,Sub[K].Name);
  Print(16,191,14,0,'F1-Help   Esc-Menu');
  Box(7,15,130,130,29); Box(143,15,170,170,29);  { 56x56 cells }
  Bar(7,150,130,35,3);
  Print(16,154,14,0,'X:        Y:');
  Print(28,154,13,0,'  0'); Print(70,154,13,0,'  0');
  Print(16,164,14,0,'Mode:'); Print(48,164,13,0,'Move');
end;
{======================================================================}
{--------------Show Font---------------}
procedure ShowFont(P:integer);  { 290x156 }
var Buf:pointer;
begin
  case P of
    1:begin
	GetMem(Back,50000); Get(15,22,290,156,Back^);
	Box(15,22,290,156,29);
      end;
    2:begin
	Bar(16,23,288,154,1); GetMem(Buf,2048);
	if Page>Fsize-PageSize then J:=Fsize mod PageSize else J:=PageSize;
	for I:=0 to J-1 do begin
	  Conv1to8(Font[FontSize*I],Buf^,FontSize,10,1);
	  Put(16+Xsize*(I mod Xcell),23+Ysize*(I div Xcell),Xsize,Ysize,Buf^);
	end;
        FreeMem(Buf,2048);
      end;
    3:begin Put(15,22,290,156,Back^); FreeMem(Back,50000); end;
  end;
end;
{--------------Choose Font---------------}
procedure ChooseFont;
begin
  repeat
    Str(FontNo+Page:5,St); Bar(280,0,40,9,3); Print(280,0,10,0,St);
    PutCursor(1,17+Xsize*(FontNo mod Xcell),24+Ysize*(FontNo div Xcell));
    K:=Key;
    PutCursor(2,17+Xsize*(FontNo mod Xcell),24+Ysize*(FontNo div Xcell));
    case K of
      328:Dec(FontNo,Xcell);   331:Dec(FontNo);
      333:Inc(FontNo);         336:Inc(FontNo,Xcell);
      327:Dec(FontNo,Xcell+1); 329:Dec(FontNo,Xcell-1);
      335:Inc(FontNo,Xcell-1); 337:Inc(FontNo,Xcell+1);
      388:begin
	    Dec(Page,PageSize);
	    if Page>=0 then begin
	      Seek(File1,Page); BlockRead(File1,Font,PageSize); ShowFont(2);
	    end else
	      begin Page:=0; Sounds(2); end;
	  end;
      374:begin
	    Inc(Page,PageSize);
	    if Page<Fsize then begin
	      if Page>Fsize-PageSize then I:=Fsize mod PageSize
		else I:=PageSize;
	      Seek(File1,Page); BlockRead(File1,Font,I); ShowFont(2);
	    end else
	      begin Dec(Page,PageSize); Sounds(2); end;
	  end;
    end;
    if FontNo<0 then Inc(FontNo,Xcell*Ycell);
    if FontNo>Xcell*Ycell-1 then Dec(FontNo,Xcell*Ycell);
  until K in [13,27];
end;
{--------------Load---------------}
procedure Load(X,Y:integer);  { 200x100 }
var Buf:pointer;
begin
  GetMem(Buf,20000); Get(X,Y,200,100,Buf^);
  Window(X,Y,200,100,3,29,1,0,15,0,'Load a new font file');
  Print(X+8,Y+30,14,0,'X=8-128, Y=4-128');
  Print(X+8,Y+42,14,0,'X size:');
  Print(X+8,Y+54,14,0,'Y size:');
  Print(X+8,Y+66,14,0,'Filename:');
  repeat
    Bar(X+48,Y+42,36,9,3);
    Input(X+48,Y+42,10,3,0,3,St);
    Val(St,Xsize,I);
  until (Xsize in [8..128]) and (Xsize and 7=0);
  repeat
    Bar(X+48,Y+54,36,9,3);
    Input(X+48,Y+54,10,3,0,3,St);
    Val(St,Ysize,I);
  until Ysize in [4..128];
{$I-}
  repeat
    Bar(X+8,Y+78,180,9,3);
    Input(X+8,Y+78,10,3,0,20,St);
    FontSize:=Xsize*Ysize shr 3;
    Assign(File1,St);  Reset(File1,FontSize);
    Fsize:=FileSize(File1); Xcell:=288 div Xsize; Ycell:=154 div Ysize;
    PageSize:=Xcell*Ycell; if Fsize>PageSize then I:=PageSize else I:=Fsize;
    BlockRead(File1,Font,I);
  until IOResult=0;
{$I+}
  Put(X,Y,200,100,Buf^); FreeMem(Buf,20000);
  ShowFont(1); ShowFont(2); K:=Key; K:=0; ShowFont(3); FontNo:=0;
  Page:=0; Bar(280,0,40,9,3); Print(280,0,10,0,'    0');
  I:=Xsize; J:=Ysize; if I>56 then I:=56; if J>56 then J:=56;
  Bar(16,174,101,9,3); Print(16,174,13,0,St);
  Bar(264,191,64,9,3);
  Str(Xsize:3,St); Print(264,192,10,0,St+'x');
  Str(Ysize:3,St); Print(288,192,10,0,St);
  Bar(8,16,128,128,Color[0]); Bar(144,16,168,168,Color[0]);
  Box(143,15,3*I+2,3*J+2,29); Box(Xi-1,Yi-1,Xsize+2,Ysize+2,29);
  WinX:=8; WinY:=16; WinLenX:=Xsize; WinLenY:=Ysize;
end;
{--------------Animate---------------}
procedure Animate(X,Y:integer);  { 140x152 }
const TestNo:array[1..4] of integer=(0,0,0,0);
var Buf:pointer;
begin
  ShowFont(1); ShowFont(2);
  for I:=1 to 4 do begin ChooseFont; TestNo[I]:=FontNo; end; ShowFont(3);
  GetMem(Back,22000); Get(X,Y,140,152,Back^);
  Window(X,Y,140,24+Ysize,3,29,1,0,15,0,'Animate / 4 cells');
  GetMem(Buf,2048);
  repeat
    for I:=1 to 4 do begin
      Conv1to8(Font[FontSize*TestNo[I]],Buf^,FontSize,11,1);
      Put(X+4,Y+16,Xsize,Ysize,Buf^);
      Delay(60);
    end;
  until KeyPressed;
  K:=Key; K:=0; FreeMem(Buf,2048);
  Put(X,Y,140,24+Ysize,Back^); FreeMem(Back,22000);
end;
{===============Fuctions===============}
procedure Functions(No:integer);
var Buf:pointer;
begin
  GetMem(Buf,16384);
  case No of
     1:Load(60,45);
     2:begin   { Save a char }
	 Get(Xi,Yi,Xsize,Ysize,Buf^);
	 ShowFont(1); ShowFont(2); ChooseFont;
	 Conv8to1(Buf^,Font[FontSize*FontNo],FontSize,Color[1]);
	 Put(16+Xsize*(FontNo mod Xcell),23+Ysize*(FontNo div Xcell),
	   Xsize,Ysize,Buf^);
	 Seek(File1,FontNo+Page); BlockWrite(File1,Font[FontSize*FontNo],1);
	 ShowFont(3);
	 if Fsize<=FontNo+Page then Fsize:=FontNo+1;  { Append Fsize }
       end;
     3:begin
	 VideoMode(LastMode);
         Writeln('ķ');
         Writeln(' Font Editor version 1.0            ');
         Writeln(' Copyright (C) 1992 by Jou-Nan Chen ');
         Writeln(' ķ    ķ    ķ    ķ ');
         Writeln(' зĽ   зĽ  ');
         Writeln(' Ľ    Ľ    Ľ    Ľ ');
         Writeln('Ľ');
         Halt(1);
       end;
     4:begin   { Edit }
	 ShowFont(1); ShowFont(2); ChooseFont; ShowFont(3);
	 Conv1to8(Font[FontSize*FontNo],Buf^,FontSize,Color[1],Color[0]);
	 Put(Xi,Yi,Xsize,Ysize,Buf^);
	 XX:=0; YY:=0;
       end;
     5:begin   { Merge }
	 ShowFont(1); ShowFont(2); ChooseFont; ShowFont(3);
	 Conv1to8(Font[FontSize*FontNo],Buf^,FontSize,Color[1],Color[0]);
	 K:=0;
	 for J:=Yi to Yi+Ysize-1 do for I:=Xi to Xi+Xsize-1 do begin
	   if Mem[Seg(Buf^):Ofs(Buf^)+K]<>Color[0] then PutDot(I,J,Color[1]);
	   Inc(K);
	 end;
       end;    { Scroll up,left,right,down }
     6:begin Dec(YY,8); if YY<0 then begin YY:=0; Sounds(2); end; end;
     7:begin Dec(XX,8); if XX<0 then begin XX:=0; Sounds(2); end; end;
     8:begin
	 Inc(XX,8); if XX>=Xsize-48 then begin Dec(XX,8); Sounds(2); end;
       end;
     9:begin
	 Inc(YY,8); if YY>=Ysize-48 then begin Dec(YY,8); Sounds(2); end;
       end;
    10:Line_(Xi+Xp+XX,Yi+Yp+YY);
    11:Circle_(Xi+Xp+XX,Yi+Yp+YY);
    12:begin
	 I:=Xi+Xp+XX; J:=Yi+Yp+YY;
	 if GetDot(I,J)=Color[0] then Fill(I,J,Color[1])
	   else Fill(I,J,Color[0]);
       end;
    13:Bar(WinX,WinY,WinLenX,WinLenY,Color[0]);
    14:for J:=WinY to WinY+WinLenY-1 do for I:=WinX to WinX+WinLenX-1 do
	 if GetDot(I,J)=Color[0] then PutDot(I,J,Color[1])
	   else PutDot(I,J,Color[0]);
    15:MirrorX(WinX,WinY,WinLenX,WinLenY);
    16:MirrorY(WinX,WinY,WinLenX,WinLenY);
    17:Scroll(1,WinX,WinY,WinLenX,WinLenY,1);
    18:Scroll(2,WinX,WinY,WinLenX,WinLenY,1);
    19:Scroll(3,WinX,WinY,WinLenX,WinLenY,1);
    20:Scroll(4,WinX,WinY,WinLenX,WinLenY,1);
    21:Block(Xi+Xp+XX,Yi+Yp+YY);
    22:begin   { Block copy }
	 Get(WinX,WinY,WinLenX,WinLenY,Buf^);
	 Put(Xi+Xp+XX,Yi+Yp+YY,WinLenX,WinLenY,Buf^);
	 WinX:=Xi+Xp+XX; WinY:=Yi+Yp+YY;
       end;
    23:begin   { Block move }
	 Get(WinX,WinY,WinLenX,WinLenY,Buf^);
	 Bar(WinX,WinY,WinLenX,WinLenY,Color[0]);
	 Put(Xi+Xp+XX,Yi+Yp+YY,WinLenX,WinLenY,Buf^);
	 WinX:=Xi+Xp+XX; WinY:=Yi+Yp+YY;
       end;
    24:Animate(92,84-Ysize shr 1);
    25:begin   { Cut... }
	 ShowFont(1); ShowFont(2); ChooseFont; ShowFont(3);
	 Seek(File1,FontNo); Truncate(File1); Fsize:=FontNo;
       end;
    26:begin   { Show block }
	 Box(WinX,WinY,WinLenX,WinLenY,-1);
	 K:=Key; K:=0;
	 Box(WinX,WinY,WinLenX,WinLenY,-1);
       end;    { Full block }
    27:begin WinX:=Xi; WinY:=Yi; WinLenX:=Xsize; WinLenY:=Ysize; end;
  end;
  I:=Xsize; J:=Ysize; if I>56 then I:=56; if J>56 then J:=56;
  Get(Xi+XX,Yi+YY,I,J,Buf^); Zoom(3,3,144,16,I,J,Buf^);
  Mode:=2; Bar(48,164,40,9,3); Print(48,164,13,0,'Move');
  FreeMem(Buf,16384);
end;
{======================================================================}
{--------------Main Program---------------}
begin
  VideoMode($13); MainWindow; Load(60,45);
  repeat
    if Mode<2 then begin
      Bar(144+3*Xp,16+3*Yp,3,3,Color[Mode]);
      PutDot(Xi+Xp+XX,Yi+Yp+YY,Color[Mode]);
    end;
    PutCursor(1,145+3*Xp,17+3*Yp);
    K:=Key;
    PutCursor(2,145+3*Xp,17+3*Yp);
    case K of
      328:Dec(Yp);    331:Dec(Xp);     333:Inc(Xp);    336:Inc(Yp);
      327:begin Dec(Xp); Dec(Yp); end; 329:begin Inc(Xp); Dec(Yp); end;
      335:begin Dec(Xp); Inc(Yp); end; 337:begin Inc(Xp); Inc(Yp); end;
       45:begin Mode:=0; Bar(48,164,40,9,3); Print(48,164,13,0,'Erase'); end;
       43:begin Mode:=1; Bar(48,164,40,9,3); Print(48,164,13,0,'Draw'); end;
       13:begin Mode:=2; Bar(48,164,40,9,3); Print(48,164,13,0,'Move'); end;
       32:begin
	    Mode:=2; Bar(48,164,40,9,3); Print(48,164,13,0,'Move');
	    I:=Xi+Xp+XX; J:=Yi+Yp+YY;
	    if GetDot(I,J)=1 then begin
	      Bar(144+3*Xp,16+3*Yp,3,3,Color[1]); PutDot(I,J,Color[1]);
	    end else begin
	      Bar(144+3*Xp,16+3*Yp,3,3,Color[0]); PutDot(I,J,Color[0]);
	    end;
	  end;
       27:Functions(MainMenu); { Esc } 315:Help(60,45);      { F1 }
       12:Functions(1);        { ^L }  71,103:Functions(2);  { G }
      69,101:Functions(4);     { E }   77,109:Functions(5);  { M }
      87,119:Functions(6);     { W }   65,97:Functions(7);   { A }
      68,100:Functions(8);     { D }   88,120:Functions(9);  { X }
      76,108:Functions(10);    { L }   67,99:Functions(11);  { C }
      70,102:Functions(12);    { F }   3:Functions(13);      { ^C }
      82,114:Functions(14);    { R }   72,104:Functions(15); { H }
      86,118:Functions(16);    { V }   23:Functions(17);     { ^W }
	1:Functions(18);       { ^A }  4:Functions(19);      { ^D }
       24:Functions(20);       { ^X }  304:Functions(21);    { a-B }
      302:Functions(22);       { a-C } 306:Functions(23);    { a-M }
      84,116:Functions(24);    { T }   20:Functions(25);     { ^T }
      316:Functions(26);       { F2 }  317:Functions(27);    { F3 }
    end;
    I:=Xsize-1; J:=Ysize-1; if I>55 then I:=55; if J>55 then J:=55;
    if Xp>I then Xp:=0; if Xp<0 then Xp:=I;
    if Yp>J then Yp:=0; if Yp<0 then Yp:=J;
    Str(Xp+XX:3,St); Bar(28,154,27,9,3); Print(28,154,13,0,St);
    Str(Yp+YY:3,St); Bar(70,154,27,9,3); Print(70,154,13,0,St);
  until K=17;                  { ^Q }
  Functions(3);
end.
