{ͻ
                                    
    Pattern Recognition #1          
    Feature Extraction  Moments   
                                    
    Written by Jou-Nan Chen  1995   
                                    
 ͼ}

uses SVGA256,Txt;

var F:file;
    A:array[0..29999] of byte;
    B:array[0..149,0..132] of byte;
    C:array[1..6,1..6,1..7] of real;
    Font:array[0..4000] of byte;

{  Show Start Screen  }

procedure ShowScreen;
var I:integer;
    Pal:array[0..767] of byte;
begin
  SetMode(3);
  GetPalette(0,256,Pal);
  Move(Pal,Pal[64*3],128*3);
  for I:=1 to 63 do begin
    Pal[3*I]:=  I;
    Pal[3*I+1]:=0;
    Pal[3*I+2]:=63;
  end;
  SetPalette(0,256,Pal);
  for I:=0 to 59 do Bar(0,8*I,640,8,I+4);
  FileRead('1616spc2.fnt',0,96,32,Font);
  InstallFont(2,16,16,32,96,1,Font);
  Print3A(1,40,30,64+64,2,2,'Pattern  Recognition');
  FileRead('1616sim#.fnt',0,96,32,Font);
  InstallFont(2,16,16,32,96,1,Font);
  Print2A(40,55,62+64,2,'Written by Jou-Nan Chen  1995');
end;

{  Compute Features  }

procedure ComputeFeatures;
var I,J,K,N:integer;
    St:string;
    X0,Y0,X1,Y1,X2,Y2,M00,M10,M01,U00,
    U20,U02,U11,U21,U12,U30,U03,
    N20,N02,N11,N21,N12,N30,N03:real;
begin
  { ****** Process 6 Pictures ****** }
  for N:=1 to 6 do begin
    Str(N-1,St);
    { ****** Binary Picture ****** }
    Assign(F,St+'.raw'); Reset(F,30000);
    for I:=0 to 3 do begin
      BlockRead(F,A,1);
      for J:=0 to 29999 do if A[J]>50 then A[J]:=63 else A[J]:=0;
      Put(120,110+75*I,400,75,A);
    end;
    Close(F);
    { ****** Start Processing, Every Char=133x150 ****** }
    for K:=1 to 6 do begin
      Get(120+133*((K-1) mod 3),110+150*((K-1) div 3),133,150,B);
      { ****** Get Area ****** }
      M00:=0;
      for I:=0 to 149 do for J:=0 to 132 do if B[I][J]>0 then M00:=M00+1;
      { ****** Get Features ****** }
      M10:=0; M01:=0;
      for I:=0 to 149 do for J:=0 to 132 do if B[I,J]>0 then begin
	M10:=M10+J;
	M01:=M01+I;
      end;
      X0:=M10/M00; Y0:=M01/M00;
      U00:=M00;
      U20:=0; U02:=0; U11:=0; U21:=0; U12:=0; U30:=0; U03:=0;
      for I:=0 to 149 do begin
	Y1:=I-Y0; Y2:=Y1*Y1;
	for J:=0 to 132 do if B[I,J]>0 then begin
	  X1:=J-X0; X2:=X1*X1;
	  U20:=U20+X2;
	  U02:=U02+Y2;
	  U11:=U11+X1*Y1;
	  U21:=U21+X2*Y1;
	  U12:=U12+X1*Y2;
	  U30:=U30+X2*X1;
	  U03:=U03+Y2*Y1;
	end;
      end;
      U00:=U00*U00;
      N20:=U20/U00;
      N02:=U02/U00;
      N11:=U11/U00;
      N21:=U21/U00;
      N12:=U12/U00;
      N30:=U30/U00;
      N03:=U03/U00;
      C[N,K,1]:=N20+N02;
      C[N,K,2]:=(N20-N02)*(N20-N02)+4*N11*N11;
      C[N,K,3]:=(N30-3*N12)*(N30-3*N12)+(3*N21-N03)*(3*N21-N03);
      C[N,K,4]:=(N30+N12)*(N30+N12)+(N21+N03)*(N21+N03);
      C[N,K,5]:=(N30-3*N12)*(N30+N12)
		*((N30+N12)*(N30+N12)-3*(N21+N03)*(N21+N03))
		+(3*N21-N03)*(N21+N03)
		*(3*(N30+N12)*(N30+N12)-(N21+N03)*(N21+N03));
      C[N,K,6]:=(N20-N02)*((N30+N12)*(N30+N12)-(N21+N03)*(N21+N03))
		+4*N11*(N30+N12)*(N21+N03);
      C[N,K,7]:=(3*N21-N03)*(N30+N12)
		*((N30+N12)*(N30+N12)-3*(N21+N03)*(N21+N03))
		-(N30-3*N12)*(N21+N03)
		*(3*(N30+N12)*(N30+N12)-(N21+N03)*(N21+N03));
      { ****** Show Result ****** }
      Str(C[N,K,1]:10,St);
      Print2A(140+133*((K-1) mod 3),150+150*((K-1) div 3),64+64,2,'Feature 1');
      Print2A(140+133*((K-1) mod 3),175+150*((K-1) div 3),64+64,2,St);
    end;
  end;
  Print3(1,180,230,24+64,2,'Press any key to continue . . .');
end;

{  Show Features  }

procedure ShowFeatures;
var I,J,K:integer;
    St:string;
begin
  K:=Key;
  SetMode(0);
  for I:=1 to 6 do begin
    if I mod 2=1 then TextBar(1,1,80,25,$1F,' ');
    PrintText(2,3+11*((I-1) mod 2),$1F,'Picture '+Chr(I+48));
    for J:=1 to 6 do
      PrintText(5+11*J,3+11*((I-1) mod 2),$1F,'Char '+Chr(J+48));
    TextBar(2,4+11*((I-1) mod 2),78,1,$13,'');
    TextBar(12,3+11*((I-1) mod 2),1,9,$13,'');
    PrintText(12,4+11*((I-1) mod 2),$13,'');
    for J:=1 to 7 do begin
      PrintText(2,4+J+11*((I-1) mod 2),$1A,'Feature '+Chr(J+48));
      for K:=1 to 6 do begin
	Str(C[I,K,J]:10,St);
	PrintText(3+11*K,4+J+11*((I-1) mod 2),$1E,St);
      end;
    end;
    if I mod 2=0 then K:=Key;
  end;
end;

{  Show Results  }

procedure ShowResults;
var I,J,K,N,Z:integer;
    R,E:array[1..6,1..7] of real;
    Count:array[1..6,1..6,1..6] of integer;
begin
  TextBar(1,1,80,25,$1F,' ');
  { ****** Recognition 1..6 of Every Feature ****** }
  for N:=1 to 7 do for I:=1 to 6 do begin
    R[I,N]:=0;
    for J:=1 to 6 do R[I,N]:=R[I,N]+C[J,I,N];
    R[I,N]:=R[I,N]/6;
  end;
  for I:=1 to 6 do for J:=1 to 6 do for K:=1 to 6 do Count[I,J,K]:=0;
  for N:=1 to 7 do begin
    PrintText(5+25*((N-1) mod 3),2+8*((N-1) div 3),$1F,'Feature '+Chr(N+48));
    for K:=1 to 6 do begin
      PrintText(5+25*((N-1) mod 3),2+K+8*((N-1) div 3),$1A,'Pic '+Chr(K+48)+' >');
      for I:=1 to 6 do begin
	{ ****** Compute Errors ****** }
	for J:=1 to 6 do E[J,N]:=Abs(C[K,J,N]-R[I,N]);
	{ ****** Min of Errors ****** }
	Z:=1;
	for J:=2 to 6 do if E[Z,N]>E[J,N] then Z:=J;
	{ ****** Sum ****** }
	PrintText(12+2*I+25*((N-1) mod 3),2+K+8*((N-1) div 3),$1E,Chr(Z+48));
	Count[K,I,Z]:=Count[K,I,Z]+1;
      end;
    end;
  end;
  { ****** Recognition 1..6 ****** }
  K:=Key;
  TextBar(1,1,80,25,$1F,' ');
  { ****** Show Frequences ****** }
  PrintText(10,4,$1F,'Frequence');
  for I:=1 to 6 do PrintText(14+8*I,4,$1F,'Char '+Chr(I+48));
  for I:=1 to 6 do PrintText(10,5+I,$1A,'Picture '+Chr(I+48));
  TextBar(10,5,60,1,$13,'');
  TextBar(20,4,1,8,$13,'');
  PrintText(20,5,$13,'');
  for I:=1 to 6 do for J:=1 to 6 do for K:=1 to 6 do
    PrintText(13+8*J+K,5+I,$1E,Chr(Count[I,J,K]+48));
  { ****** Show Recognition Result ****** }
  PrintText(10,14,$1F,'Recognition Result');
  TextBar(10,15,30,1,$13,'');
  for I:=1 to 6 do begin
    PrintText(10,I+15,$1A,'Picture '+Chr(I+48)+' >');
    for J:=1 to 6 do for K:=7 downto 1 do
      for N:=1 to 6 do if Count[I,J,N]=K then begin
	PrintText(21+2*J,I+15,$1E,Chr(N+48));
	N:=6; K:=1;
      end;
  end;
  { ****** End ****** }
  K:=Key;
  TextBar(1,25,80,1,$07,' ');
  SetCurPos(1,25);
end;

{  Main Program  }

begin
  ShowScreen;
  ComputeFeatures;
  ShowFeatures;
  ShowResults;
end.
