/*

	Init File (ini) processor
	- special thanks to the Fractint people, 'cause that's were we nicked it from
	Command-line / Command-File Parser Routines

	03Mar92 moles  : major conversion hack
	04Mar92 zaph   : Cleaning
	11Mar92 zaph   : Testing Hex Input
						: Bummer - didn't work  :-(
	16Apr92 zaph   : Added 'debug=yes' flag that will enable the printfs!!

 * 29May92 zaph  + Making things Static, thanks to Global Lint
	08Oct92 zaph  - Removed lots of unreferenced vars

	26Oct94 zaph  : Converted to be used by Cthugha
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <float.h>
#include <ctype.h>
// #include <extras.h>
#include <direct.h>
#include <dos.h>
#include <conio.h>

#include "cthugha.h"
#include "cmdfiles.h"
#include "audio.h"
#include "options.h"

#define KEYWORD_LEN	20

char *debug_str="\n---  Entering Debug Mode ---\nSection == [%s]\n";
/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Proto */
int  cmdfiles(char *fname);
int  load_commands(FILE *);

static int  cmdfile(FILE *,int);
static int  next_command(char *,int,FILE *,char *,int *,int);
static int  next_line(FILE *,char *,int);
static int  cmdarg(char *,int);
static void argerror(char *);
void findpath(char *filename, char *fullpathname);
int file_gets(char *buf,int maxlen,FILE *infile);


/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ local vars */
int first_init=1;		/* first time into cmdfiles? */

int thisversion=530;

static char initcorners,initparams;

static char CommandComment1[57];	/* comments for command set */
static char CommandComment2[57];

/* --------------------------------------------------------- */

typedef struct {
	char *area_str;  /* Name of area, inc [] */
	char str_len;  /* to speed code up, strlen not performed every iteration */
	void (*area_func)(char *var, char *val, int yesno); /* job function */
} Area_entry;


extern void general_prep(char *var, char *val, int yesno);
extern void startup_prep(char *var, char *val, int yesno);
extern void waves_prep(char *var, char *val, int yesno);
extern void flames_prep(char *var, char *val, int yesno);
extern void displays_prep(char *var, char *val, int yesno);
extern void oldini_prep(char *var, char *val, int yesno);


Area_entry joblist[] = {
	{ "[general]", 9, general_prep },
	{ "[startup]", 9, startup_prep },
	{ "[waves]", 7, waves_prep },
	{ "[flames]", 8, flames_prep },
	{ "[displays]", 10, displays_prep },
	{ "[oldini]", 8, oldini_prep },
	{ NULL, 0, NULL }
};

int L_cur_area = -1;  /* 06Mar92 zaph  : Was Char - but that was bad for -1 stuff */

/* --------------------------------------------------------- */


int cmdfiles(char *fname)
{
	char tempstring[101];
	FILE *initfile;

	findpath(fname, tempstring);
	if (tempstring[0] != 0)	{	/* found it! */
		if ((initfile = fopen(tempstring,"r")) != NULL)
		 cmdfile(initfile,1);		/* process it */
	} else
		return TRUE;

	return FALSE;
}


int load_commands(FILE *infile)
{
	/* when called, file is open in binary mode, positioned at the */
	/* '(' or '{' following the desired parameter set's name		 */
	int ret;
	initcorners = initparams = 0; /* reset flags for type= */
	ret = cmdfile(infile,2);
	return ret;
}

static int cmdfile(FILE *handle,int mode)
	/* mode = 0 command line @filename			*/
	/*		  1 sstools.ini				*/
	/*		  2 <@> command after startup		*/
	/*		  3 command line @filename/setname */
{
	/* note that cmdfile could be open as text OR as binary */
	/* binary is used in @ command processing for reasonable speed note/point */
	int i;
	int lineoffset = 0;
	int changeflag = 0; /* &1 fractal stuff chgd, &2 3d stuff chgd */
	char linebuf[513],cmdbuf[1001];

	if (mode == 2 || mode == 3) {
		while ((i = getc(handle)) != '{' && i != EOF) { }
		CommandComment1[0] = CommandComment2[0] = 0;
	}

	linebuf[0] = 0;
	while (next_command(cmdbuf,1000,handle,linebuf,&lineoffset,mode) > 0) {
		if ((mode == 2 || mode == 3) && strcmp(cmdbuf,"}") == 0)
			break;
		if ((i = cmdarg(cmdbuf,mode)) < 0)
			break;
		changeflag |= i;
	}
	fclose(handle);
	return changeflag;
}

static int next_command(char *cmdbuf,int maxlen,
				FILE *handle,char *linebuf,int *lineoffset,int mode)
{
	int cmdlen = 0;
	char *lineptr;
	lineptr = linebuf + *lineoffset;
	while(1) {
		while (*lineptr <= ' ' || *lineptr == ';') {
			if (cmdlen) {			/* space or ; marks end of command */
				cmdbuf[cmdlen] = 0;
				*lineoffset = lineptr - linebuf;
				return cmdlen;
			}
			while (*lineptr && *lineptr <= ' ')
				++lineptr;			/* skip spaces and tabs */
			if (*lineptr == ';' || *lineptr == 0) {
				if (*lineptr == ';' && (mode == 2 || mode == 3)
					&& (CommandComment1[0] == 0 || CommandComment2[0] == 0)) {
					/* save comment */
					while (*(++lineptr) && (*lineptr == ' ' || *lineptr == '\t'))
						{ }
					if (*lineptr) {
						if (strlen(lineptr) > 56)
							*(lineptr+56) = 0;
						if (CommandComment1[0] == 0)
							strcpy(CommandComment1,lineptr);
						else
							strcpy(CommandComment2,lineptr);
					}
				}
				if (next_line(handle,linebuf,mode) != 0)
					return(-1); /* eof */
				lineptr = linebuf; /* start new line */
			}
		}
		if (*lineptr == '\\'				  /* continuation onto next line? */
			&& *(lineptr+1) == 0) {
				if (next_line(handle,linebuf,mode) != 0) {
					argerror(cmdbuf);		/* missing continuation */
					return(-1);
				}

		lineptr = linebuf;
		while (*lineptr && *lineptr <= ' ')
			++lineptr;			/* skip white space @ start next line */
		continue;			/* loop to check end of line again */
		}

		cmdbuf[cmdlen] = *(lineptr++);	/* copy character to command buffer */
		if (++cmdlen >= maxlen) { 	/* command too long? */
			argerror(cmdbuf);
			return(-1);
		}
	}
}

static int next_line(FILE *handle,char *linebuf,int mode)
{
	int toolssection;
/* 	char tmpbuf[10]; */
/* 	char *end; */
	int i;  /* ,len */

	toolssection = 0;

	while (file_gets(linebuf,512,handle) >= 0) {
		if (mode == 1 && linebuf[0] == '[') {	  /* check for [fractint] */
			L_cur_area=-1;
			for (i=0; joblist[i].area_str != NULL ; i++) {
				toolssection = _strnicmp(linebuf,joblist[i].area_str,joblist[i].str_len);
				if (toolssection==0) {
					if (debug_mode)
						printf("Section == %s\n",joblist[i].area_str);
					L_cur_area=i;
					break;
				}
			}
			if (toolssection!=0) {
				printf("Unknown section: %s\n",linebuf);
			}
		} else {
			if (toolssection == 0)
				return(0);
		}
	}
	return(-1);
}


/*
  cmdarg(string,mode) processes a single command-line/command-file argument
	 return:
	-1 FAILED
*/

static int cmdarg(char *curarg,int mode) /* process a single argument */
{
	char	 variable[21];		/* variable name goes here	*/
	char	 *value;			/* pointer to variable value */
	int		valuelen;			/* length of value		  */
	int		numval;			/* numeric value of arg		*/
#define NONNUMERIC -32767
	char	 charval;			/* first character of arg	 */
	int		yesnoval;			/* 0 if 'n', 1 if 'y', -1 if not */
	double  ftemp;
	int		i, j;
	char	 *argptr,*argptr2;
	int		totparms;			/* # of / delimited parms	 */
	int		intparms;			/* # of / delimited ints	  */
	int		floatparms;			/* # of / delimited floats	*/
	int		intval[64];			/* pre-parsed integer parms  */
	double  floatval[16];		/* pre-parsed floating parms */
	char	 tmpc;
	int		lastarg;

	argptr = curarg;

	while (*argptr) {			/* convert to lower case */
		if (*argptr >= 'A' && *argptr <= 'Z')
	 *argptr += 'a' - 'A';
#if 0
		if (*argptr == '=' && strncmp(curarg,"colors=",7) == 0)
	 break; 			/* don't convert colors=value */
#endif
		++argptr;
	}

	if ((value = strchr(&curarg[1],'='))) {
		if ((j = (value++) - curarg) > 1 && curarg[j-1] == ':')
			--j;				/* treat := same as =	  */
	} else
		value = curarg + (j = strlen(curarg));

	if (j > KEYWORD_LEN)
		goto badarg;		/* keyword too long */

	strncpy(variable,curarg,j);		/* get the variable name  */
	variable[j] = 0;			/* truncate variable name */
	valuelen = strlen(value);		/* note value's length	 */
	charval = value[0];			/* first letter of value  */

	yesnoval = -1;			/* note yes|no value	  */
	if (charval == 'n')
		yesnoval = 0;
	if (strcmp(value,"off")==0)
		yesnoval = 0;
	if (charval == 'y')
		yesnoval = 1;
	if (strcmp(value,"on")==0)
		yesnoval = 1;

	argptr = value;
	numval = totparms = intparms = floatparms = 0;
	while (*argptr) {			/* count and pre-parse parms */
		lastarg = 0;
		if ((argptr2 = strchr(argptr,'/')) == NULL) {	  /* find next '/' */
			argptr2 = argptr + strlen(argptr);
			*argptr2 = '/';
			lastarg = 1;
		}
		if (totparms == 0)
			numval = NONNUMERIC;
		i = -1;

		if (sscanf(argptr,"%d%c",&j,&tmpc) > 0				/* got an integer */
		  && tmpc == '/') {
			++floatparms; ++intparms;
			if (totparms < 16)
				floatval[totparms] = j;
			if (totparms < 64)
				intval[totparms] = j;
			if (totparms == 0)
				numval = j;
		} else {
			if (sscanf(argptr,"%lg%c",&ftemp,&tmpc) > 0  /* got a float */
			  && tmpc == '/') {
				++floatparms;
				if (totparms < 16)
					floatval[totparms] = ftemp;
			}
		}
		++totparms;
		argptr = argptr2; 				/* on to the next */
		if (lastarg)
			*argptr = 0;
		else
			++argptr;
	}

	/* ACTUAL environment stuff gets set here !!!! */

/* See sample ARG proc at below (near EOF) */


	if (L_cur_area >= 0) {

		if (debug_mode)
			if (yesnoval>=0)
		 		printf("  %s turned %s\n",variable,yesnoval?"On":"Off");
			else
		 		printf("  %s set to '%s'\n",variable,value);

		(joblist[L_cur_area].area_func)(variable,value,yesnoval);

	} else
		printf("Bad Config Area\n");

	return 0;

badarg:
	argerror(curarg);
	return(-1);
}


static void argerror(char *badarg)	/* oops. couldn't decode this */
{
	printf("ERROR - BADARG %s",badarg);
}


void findpath(char *filename, char *fullpathname) /* return full pathnames */
{
	if (filename[0] == '\\'
	  || (filename[0] && filename[1] == ':')) {
		strcpy(fullpathname,filename);
		return;
	}
	fullpathname[0] = 0;								 /* indicate none found */
	_searchenv(filename,"PATH",fullpathname);
	if (fullpathname[0] != 0)						  /* found it! */
		if (strncmp(&fullpathname[2],"\\\\",2) == 0) /* stupid klooge! */
			strcpy(&fullpathname[3],filename);
}


int file_gets(char *buf,int maxlen,FILE *infile)
{
	int len,c;
	/* similar to 'fgets', but file may be in either text or binary mode */
	/* returns -1 at eof, length of string otherwise */
	if (feof(infile)) return -1;
	len = 0;
	while (len < maxlen) {
		if ((c = getc(infile)) == EOF || c == '\x1a') {
			if (len) break;
			return -1;
			}
		if (c == '\n') break;				 /* linefeed is end of line */
		if (c != '\r') buf[len++] = c;	 /* ignore c/r */
		}
	buf[len] = 0;
	return len;
}



/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Proto */
void varval_err(char *area, char *var, char *val)
{
	printf("ERROR - BAD data in INI file:\n");
	printf("[%s]\n%s = %s\n",area, var, val);
	printf("press any key to continue\n");
	_getch();
}



/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Funcs */
void general_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */
	int temp,i;


	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"general");
		}
		return;
	}


	if (strcmp(var,"refresh") == 0 ) {
		if (yesno < 0)
			goto badarg;
		norefresh = (yesno)?FALSE:TRUE;  // Reverse of what was entered
		return;
	}

	if (strcmp(var,"audio_irq") == 0 ) {
		audio_irq=atoi(val);
		return;
	}
	if (strcmp(var,"audio_dma") == 0 ) {
		audio_dma=atoi(val);
		return;
	}
	if (strcmp(var,"audio_dma16") == 0 ) {
		audio_dma16=atoi(val);
		return;
	}
	if (strcmp(var,"audio_port") == 0 ) {
		audio_port=0;
		temp=1;
		for (i=strlen(val)-1; i>=0; i--) {
			audio_port += temp*(val[i]-'0');
			temp=temp*16;
		}

		return;
	}

	if (strcmp(var,"version") == 0 ) {
		temp=atoi(val);
		if (temp!=thisversion) {
			printf("WARNING\nINI file is version:%d ",temp);
			printf(" Cthugha is version:%d\n",thisversion);
			printf(" Press a key to continue  ");
			_getch();
		}
		return;
	}

	if (strcmp(var,"myname") == 0 ) {
		memcpy(myname,val,16);
		myname[15]=0;
		if (strlen(val)<15) {
			for (i=strlen(val); i<16; i++)
				myname[i]=0;
		}
		for (i=0; i<15; i++) {
			if (myname[i]=='_')
				myname[i]=' ';
		}

		return;
	}

	if (strcmp(var,"soundcard") == 0 ) {
		if (strcmp(val,"sbpro")==0) {
			sound_card=SBPRO;
			return;
		}
		if (strcmp(val,"oldsb")==0) {
			sound_card=OLDSB;
			return;
		}
		if (strcmp(val,"gus")==0) {
			sound_card=GUS;
			return;
		}
		if (strcmp(val,"pas")==0) {
			sound_card=PAS;
			return;
		}
		goto badarg;
	}

	if (strcmp(var,"source") == 0 ) {
		if (strcmp(val,"line")==0) {
			device=LineInput;
			return;
		}
		if (strcmp(val,"cd")==0) {
			device=CDInput;
			return;
		}
		if (strcmp(val,"mic")==0) {
			device=MicInput;
			return;
		}
		if (strcmp(val,"mike")==0) {
			device=MicInput;
			return;
		}
		goto badarg;
	}

	if (strcmp(var,"personal") == 0 ) {
		if (strcmp(val,"always")==0) {
			usepersonal=1;
			return;
		}
		if (strcmp(val,"never")==0) {
			usepersonal=0;
			return;
		}
		if (strcmp(val,"random")==0) {
			usepersonal=2;
			return;
		}
		goto badarg;
	}

	if (strcmp(var,"audiowait") == 0 ) {
		if (yesno < 0)
			goto badarg;
		audioWait = (yesno)?TRUE:FALSE;
		return;
		goto badarg;
	}

	if (strcmp(var,"stereo") == 0 ) {
		if (yesno < 0)
			goto badarg;
		sample_stereo = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"vesa") == 0 ) {
		if (yesno < 0)
			goto badarg;
		useVesa = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"pcx") == 0 ) {
		if (yesno < 0)
			goto badarg;
		use_pcx_files = (yesno)?TRUE:FALSE;
		return;
	}
	if (strcmp(var,"pause") == 0 ) {
		if (yesno < 0)
			goto badarg;
		pause = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"locked") == 0 ) {
		if (yesno < 0)
			goto badarg;
		locked = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"string_file") == 0 ) {
		strcpy(stringfile,val);
		return;
	}
	if (strcmp(var,"table_file") == 0 ) {
		strcpy(maptabfile,val);
		return;
	}
	if (strcmp(var,"stop_cd") == 0 ) {
		if (yesno < 0)
			goto badarg;
		stop_cd = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"fft") == 0 ) {
		if (yesno < 0)
			goto badarg;
		allow_fft = (yesno)?TRUE:FALSE;
		return;
	}


	if (strcmp(var,"translate") == 0 ) {
		if (yesno < 0)
			goto badarg;
		translate = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"cpu_check") == 0 ) {
		if (yesno < 0)
			goto badarg;
		checkcpu = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"internal_pal") == 0 ) {
		if (yesno < 0)
			goto badarg;
		use_internal_palettes = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"external_pal") == 0 ) {
		if (yesno < 0)
			goto badarg;
		use_external_palettes = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"input_vol") == 0 ) {
		in_vol = atoi(val);
		return;
	}

	if (strcmp(var,"vu_rate") == 0 ) {
		vu_rate = atoi(val);
		return;
	}




badarg:
	varval_err("general",var, val);
}


void startup_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"startup");
		}
		return;
	}

	if (strcmp(var,"wave") == 0 ) {
		newwave = val[0]-'a';
		if (newwave<0)
			newwave=0;
		return;
	}

	if (strcmp(var,"palette") == 0 ) {
		curpal = atoi(val);
		if (curpal<0)
			curpal=0;
		return;
	}

	if (strcmp(var,"flame") == 0 ) {
		curflame = val[0]-'a';
		if (curflame<0)
			curflame=0;
		return;
	}

	if (strcmp(var,"display") == 0 ) {
		curdisplay = val[0]-'a';
		if (curdisplay<0)
			curdisplay=0;
		return;
	}

	if (strcmp(var,"randtime") == 0 ) {
		rand_time = atoi(val);
		rand_time = min(rand_time,32000);
		rand_time = max(rand_time,1);
		return;
	}

	if (strcmp(var,"mintime") == 0 ) {
		min_time = atoi(val);
		min_time = min(min_time,32000);
		min_time = max(min_time,1);
		return;
	}

	if (strcmp(var,"cdtrack") == 0 ) {
		starttrack = atoi(val);
		if (starttrack<1)
			starttrack=1;
		return;
	}

	if (strcmp(var,"quiet") == 0 ) {
		quiet_change = atoi(val);
		if (quiet_change<0)
			quiet_change=0;
		return;
	}

	if (strcmp(var,"beatframes") == 0 ) {
		peakframes = atoi(val);
		if (peakframes<0)
			peakframes=0;
		return;
	}

	if (strcmp(var,"beatlevel") == 0 ) {
		peaklevel = atoi(val);
		if (peaklevel<0)
			peaklevel=0;
		return;
	}


badarg:
	varval_err("startup",var, val);
}



void waves_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */

	int wavenum=0;

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"waves");
		}
		return;
	}

	if (strncmp(var,"wave-",5)==0) {
		if (yesno < 0)
			goto badarg;
		wavenum=var[5]-'a';
		if ((wavenum<numwaves) && (wavenum>=0)) {
			if (yesno)
				wavearray[wavenum].flag_when=WHEN_ALWAYS;
			else
				wavearray[wavenum].flag_when=WHEN_NEVER;
		} else {
			printf("Bad Wave Code\n");
			goto badarg;
		}
		return;
	}
badarg:
	varval_err("waves",var, val);
}

void flames_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */
	int flamenum;

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"flames");
		}
		return;
	}


	if (strncmp(var,"flame-",6)==0) {
		if (yesno < 0)
			goto badarg;
		flamenum=var[6]-'a';
		if ((flamenum<numflames) && (flamenum>=0)) {
			if (yesno)
				flamearray[flamenum].flag_when=WHEN_ALWAYS;
			else
				flamearray[flamenum].flag_when=WHEN_NEVER;
		} else {
			printf("Bad Flame Number\n");
			goto badarg;
		}
		return;
	}


badarg:
	varval_err("flames",var, val);
}


void displays_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */

	int temp;

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"displays");
		}
		return;
	}


	if (strncmp(var,"disp-",5)==0) {
		if (yesno < 0)
			goto badarg;
		temp=var[5]-'a';
		if ((temp<numdisplays) && (temp>=0)) {
			if (yesno)
				disparray[temp].flag_when=WHEN_ALWAYS;
			else
				disparray[temp].flag_when=WHEN_NEVER;
		} else {
			printf("Bad Display mode Number\n");
			goto badarg;
		}
		return;
	}


badarg:
	varval_err("displays",var, val);
}



extern int iniline;

void oldini_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */

	int temp,n;
	char *string;

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		debug_mode = (yesno)?TRUE:FALSE;
		if (debug_mode) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf(debug_str,"oldini");
		}
		return;
	}


	if (strcmp(var,"oldini")==0) {
		n=sscanf(val,"%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%u_%d_%d",
			&personalINI[iniline].min_time,
			&personalINI[iniline].rand_time,
			&personalINI[iniline].quiet_change,
			&personalINI[iniline].curtable,
			&personalINI[iniline].curflame,
			&personalINI[iniline].curdisplay,
			&personalINI[iniline].locked,
			&personalINI[iniline].minnoise,
			&personalINI[iniline].massageStyle,
			&personalINI[iniline].allow_fft,
			&personalINI[iniline].use_fft,
			&personalINI[iniline].peaklevel,
			&personalINI[iniline].peakframes,
			&personalINI[iniline].newwave,
			&personalINI[iniline].usewave,
			&personalINI[iniline].extra,
			&personalINI[iniline].curpal,
			&personalINI[iniline].sample_rate,
			&personalINI[iniline].sample_stereo,
			&personalINI[iniline].translate);


		if (n==20) {
			sprintf(personalINI[iniline].name,"OldIni-%d",iniline);
			iniline++;
		} else
			printf("Bad INI line: %s",val);

		return;
	}


badarg:
	varval_err("oldini",var, val);
}
