/*
Written by: Robert C. Pendleton

Placed in the public domain by the author.

*/

#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include "ptypes.h"
#include "vesa.h"

#define FALSE 0
#define TRUE  1

//---------------------------------------------------
/*
    Static Variables
*/

static union _REGS reg;
static struct _SREGS sreg;

//---------------------------------------------------
/*
*/

void
setVGAColor(int16 index, int16 r, int16 g, int16 b)
{
   reg.x.ax =0x1010;

   reg.x.bx =index;
   reg.h.dh =r;
   reg.h.ch =g;
   reg.h.cl =b;

   _int86(0x10, &reg, &reg);
}

//---------------------------------------------------
/*
*/

void
setVGAPalette(palette *p)
{
   reg.x.ax =0x1012;
   reg.x.bx =0;
   reg.x.cx =256;

   sreg.es = _FP_SEG(p);
   reg.x.dx = _FP_OFF(p);


   _int86x(0x10, &reg, &reg, &sreg);
}

//---------------------------------------------------
/*
*/

char getVesaInfo(vesaInfo *infoPtr)
{
  	reg.x.ax = 0x4f00;

	sreg.es = _FP_SEG(infoPtr);
	reg.x.di = _FP_OFF(infoPtr);

    	_int86x(0x10, &reg, &reg, &sreg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

void
printVesaInfo(FILE *file, vesaInfo *info)
{
	int16 *mode;

	fprintf(file, "name=%c%c%c%c\n", info->vesa[0],
					   info->vesa[1],
					   info->vesa[2],
					   info->vesa[3]);

	fprintf(file, "Version %d.%d\n", info->majorMode, info->minorMode);
	fprintf(file, "Vendor %s\n", info->vendorName);
	fprintf(file, "Capabilities %lX\n", info->capabilities);

	mode = info->modes;
	while((*mode) != 0xffff)
	{
		fprintf(file, "mode=%x\n", *mode);
		mode++;
	}
	fflush(file);
}

//---------------------------------------------------
/*
*/

char getVesaModeInfo(int16 mode, vesaModeInfo *infoPtr)
{
  	reg.x.ax = 0x4f01;
  	reg.x.cx = mode;

	sreg.es = _FP_SEG(infoPtr);
	reg.x.di = _FP_OFF(infoPtr);

    	_int86x(0x10, &reg, &reg, &sreg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

void
printVesaModeInfo(FILE *file, vesaModeInfo *info)
{
	char optionalInfo = FALSE;

/* mode attributes */

	if(info->modeAttr & (1<<0))
	{
		fprintf(file, "supported\n");
	}
	else
	{
		fprintf(file, "not supported\n");
	}

	if(info->modeAttr & (1<<1))
	{
		fprintf(file, "optional info\n");
		optionalInfo = TRUE;
	}
	else
	{
		fprintf(file, "no optional info\n");
		optionalInfo = FALSE;
	}

	if(info->modeAttr & (1<<2))
	{
		fprintf(file, "BIOS output\n");
	}
	else
	{
		fprintf(file, "no BIOS output\n");
	}

	if(info->modeAttr & (1<<3))
	{
		fprintf(file, "color\n");
	}
	else
	{
		fprintf(file, "monochrome\n");
	}

	if(info->modeAttr & (1<<4))
	{
		fprintf(file, "graphics\n");
	}
	else
	{
		fprintf(file, "text\n");
	}

/* window A attributes */

	if(info->windowAAttr & (1<<0))
	{
		fprintf(file, "window A exists\n");
	}
	else
	{
		fprintf(file, "window A does not exist\n");
	}

	if(info->windowAAttr & (1<<1))
	{
		fprintf(file, "window A readable\n");
	}
	else
	{
		fprintf(file, "window A not readable\n");
	}

	if(info->windowAAttr & (1<<2))
	{
		fprintf(file, "window A writable\n");
	}
	else
	{
		fprintf(file, "window A not writable\n");
	}

/* window B attributes */

	if(info->windowBAttr & (1<<0))
	{
		fprintf(file, "window B exists\n");
	}
	else
	{
		fprintf(file, "window B does not exist\n");
	}

	if(info->windowBAttr & (1<<1))
	{
		fprintf(file, "window B readable\n");
	}
	else
	{
		fprintf(file, "window B not readable\n");
	}

	if(info->windowBAttr & (1<<2))
	{
		fprintf(file, "window B writable\n");
	}
	else
	{
		fprintf(file, "window B not writable\n");
	}

/* window attributes */

	fprintf(file, "window granularity=%d\n", info->windowGranularity);
	fprintf(file, "window size=%d\n", info->windowSize);
	fprintf(file, "window A start seg=%x\n", info->windowAStartSeg);
	fprintf(file, "window B start seg=%x\n", info->windowBStartSeg);

	fprintf(file, "positioning function=%p\n", info->posFuncPtr);

	fprintf(file, "bytes/scanline=%d\n", info->bytesPerScanLine);

	if(optionalInfo)
	{
		fprintf(file, "width =%d\n", info->width);
		fprintf(file, "height=%d\n", info->height);

		fprintf(file, "char width =%d\n", (int16)(info->charWidth));
		fprintf(file, "char height=%d\n", (int16)(info->charHeight));

		fprintf(file, "number of planes=%d\n", (int16)(info->numberOfPlanes));
		fprintf(file, "bits/pixel=%d\n", (int16)(info->bitsPerPixel));
		fprintf(file, "number of banks=%d\n", (int16)(info->numberOfBanks));

		fprintf(file, "memory model=%d\n", (int16)(info->memoryModel));
		fprintf(file, "size of bank=%d\n", (int16)(info->sizeOfBank));
	}

	fflush(file);
}

//---------------------------------------------------
/*
*/

char setVesaMode(int16 mode)
{
  	reg.x.ax = 0x4f02;
  	reg.x.bx = mode;

    	_int86x(0x10, &reg, &reg, &sreg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaMode(int16 *mode)
{
  	reg.x.ax = 0x4f03;

    	_int86x(0x10, &reg, &reg, &sreg);

  	*mode = reg.x.bx;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaStateSize(uint8 flags, int32 *size)
{
  	reg.x.ax = 0x4f04;
	reg.h.dl = 0x00;
	reg.x.cx = flags;

    	_int86x(0x10, &reg, &reg, &sreg);

  	*size = ((int32)reg.x.bx) * 64;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaState(uint8 flags, uint8 *buffer)
{
  	reg.x.ax = 0x4f04;
	reg.h.dl = 0x01;
	reg.x.cx = flags;

	sreg.es = _FP_SEG(buffer);
	reg.x.bx = _FP_OFF(buffer);

    	_int86x(0x10, &reg, &reg, &sreg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char setVesaState(uint8 flags, uint8 *buffer)
{
  	reg.x.ax = 0x4f04;
	reg.h.dl = 0x02;
	reg.x.cx = flags;

	sreg.es = _FP_SEG(buffer);
	reg.x.bx = _FP_OFF(buffer);

    	_int86x(0x10, &reg, &reg, &sreg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char setVesaWinAAddr(uint16 addr)
{
  	reg.x.ax = 0x4f05;
	reg.h.bh = 0x00;
	reg.h.bl = 0x00;
	reg.x.dx = addr;

    	_int86(0x10, &reg, &reg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char setVesaWinBAddr(uint16 addr)
{
  	reg.x.ax = 0x4f05;
	reg.h.bh = 0x00;
	reg.h.bl = 0x01;
	reg.x.dx = addr;

    	_int86(0x10, &reg, &reg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaWinAAddr(uint16 *addr)
{
  	reg.x.ax = 0x4f05;
	reg.h.bh = 0x01;
	reg.h.bl = 0x00;

    	_int86(0x10, &reg, &reg);

	*addr = reg.x.dx;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaWinBAddr(uint16 *addr)
{
  	reg.x.ax = 0x4f05;
	reg.h.bh = 0x01;
	reg.h.bl = 0x01;

    	_int86(0x10, &reg, &reg);

	*addr = reg.x.dx;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char setVesaScanLineLength(uint16 length)
{
  	reg.x.ax = 0x4f06;
	reg.h.bl = 0x00;
	reg.x.cx = length;

    	_int86(0x10, &reg, &reg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaScanLineLength(uint16 *bytesPerScanLine, 
		      uint16 *pixelsPerScanLine, 
		      uint16 *maxScanLines)
{
  	reg.x.ax = 0x4f06;
	reg.h.bl = 0x01;

    	_int86(0x10, &reg, &reg);

	*bytesPerScanLine = reg.x.bx;
	*pixelsPerScanLine = reg.x.cx;
	*maxScanLines = reg.x.dx;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char setVesaDisplayStart(uint16 pixel, uint16 line)
{
  	reg.x.ax = 0x4f07;
	reg.h.bh = 0x00;
	reg.h.bl = 0x00;

	reg.x.cx = pixel;
	reg.x.dx = line;

    	_int86(0x10, &reg, &reg);

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------
/*
*/

char getVesaDisplayStart(uint16 *pixel, uint16 *line) 
{
  	reg.x.ax = 0x4f07;
	reg.h.bh = 0x00;
	reg.h.bl = 0x01;

    	_int86(0x10, &reg, &reg);

	*pixel = reg.x.cx;
	*line = reg.x.dx;

	if(reg.x.ax != 0x004f)
	{
		return FALSE;
	}

	return TRUE;
}

//---------------------------------------------------

