/*
 This is a simple test of the SVGA graphics routines
 by Piotr Ulaszewski
*/

#ifdef __CCDL__
#define cdecl			/* if LADsoft 32bit DPMI compiler */
#include "headers/scans.h"
#include "headers/flip2.h"
#include "headers/dpmi.h"
#include "headers/extra.h"	/* do not use with your 32bit compiler */
#else
#include "headers\scans.h"
#include "headers\flip2.h"
#include "headers\dpmi.h"
#include "headers\extra.h"	/* do not use with your 32bit compiler */
#endif

int color = 9;
int x1 = 0;
int y1 = 0;
int x2 = 590;
int y2 = 200;
int x3 = 10;
int y3 = 470;
char tekst1[] = "Hi-res SVGA graphics\0"
	 "uses\0"
	 "\0"
	 "VESA 2.0\0"
	 "\0"
	 "written in assembler\0"
	 "\0"
	 "by\0"
	 "Piotr Ulaszewski\0"
	 "\0"
	 "\0"
	 "\0"
	 "special thanks\0"
	 "to\0"
	 "\0"
	 "Michael Tippach\0"
	 "for the\0"
	 "DOS Extender\0"
	 "\0"
	 "\0"
	 "\0"
	 "Babyloon Revelations\0"
	 "for the\0"
	 "basic vesa functions\0"
	 "released in 1997\0"
	 "\0"
	 "that was a\0"
	 "good\0"
	 "piece of code\0"
	 "\0"
	 "\0"
	 "\0"
	 "In the demo\0"
	 "I use the modified\0"
	 "version of their\0"
	 "two main procedures\0"
	 "\0"
	 "\0"
	 "\0"
	 "This code\0"
	 "is too primitive\0"
	 "to call it a demo\0"
	 "\0"
	 "\0"
	 "it is just\0"
	 "a coding example\0"
	 "with all the\0"
	 "sources\0"
	 "\0"
	 "\0"
	 "\0"
	 "This release\0"
	 "is\0"
	 "for\0"
	 "32 bit protected mode\0"
	 "\0"
	 "\0"
	 "\0"
	 "I started to write the code\0"
	 "in\0"
	 "March 1998\0"
	 "\0"
	 "but\0"
	 "I was too lazy\0"
	 "to keep it going\0"
	 "\0"
	 "\0"
	 "so this is only\0"
	 "one part of\0"
	 "the project\0"
	 "\0"
	 "\0"
	 "\0"
	 "No 3D animation yet\0"
	 "may be next time?\0"
	 "\0"
	 "\0"
	 "\0"
	 "But it is\0"
	 "a DOS program\0"
	 "and DOS belongs\0"
	 "to\0"
	 "the past!!!\0"
	 "\0"
	 "\0"
	 "\0"
	 "SVGA graphics\0"
	 "in\0"
	 "DOS\0"
	 "\0"
	 "\0"
	 "with high framerates\0"
	 "\0"
	 "even on 486 PCI\0"
	 "\0"
	 "requires\0"
	 "double\0"
	 "or even\0"
	 "triple\0"
	 "buffering\0"
	 "\0"
	 "\0"
	 "\0"
	 "You can do this\0"
	 "by accesing\0"
	 "the linear framebuffer\0"
	 "directly\0"
	 "\0"
	 "\0"
	 "\0"
	 "I ony used\0"
	 "double buffering\0"
	 "with\0"
	 "page fliping\0"
	 "and\0"
	 "vertical refresh sync\0"
	 "\0"
	 "\0"
	 "\0"
	 "that means\0"
	 "a back buffer\0"
	 "in video memory\0"
	 "that you can write to\0"
	 "and simply flip pages\0"
	 "to show it\0"
	 "\0"
	 "\0"
	 "\0"
	 "\0"
	 "my address:\0"
	 "Piotr Ulaszewski\0"
	 "Suchy Dwor 18a\0"
	 "Wroclaw - POLAND\0";
static byte text_end = 0xff;		   /* always at the end [,0ffh,0] */
static byte always_zero = 0;

int text_colorize = 0;                     /* var of scrolled text */
int text_color = 13;
int text_y0 = 0;
int text_scroll_length = 0;                /* do not fill (internal) */

char *fps_string = "Actual fps : ";        /* var of fps string */
int fps_colorize = 0;
int fps_color = 13;
int fps_color_hicolor = 0xffff ;           /* only for hicolor modes (white) */
int fps_x0 = 0;
int fps_y0 = 0;
int fps_counter = 0;
int actual_fps = 0;
int seconds = 0;

char *res_string = "SVGA mode : ";
int res_colorize = 0;
int res_color = 13;
int res_x0 = 0;
int res_y0 = 16;

int color_count = 0;

int XCenter = 0;
int YCenter = 0;

int line_x1 = 0;                                  /* values for moving line */
int line_y1 = 0;                                  /* in scene 3 */
int line_x2 = 0;
int line_y2 = 0;
int line_dinc_x = 1;
int line_dinc_y = 1;

byte line_r_color = 0;
byte line_g_color = 0;
byte line_b_color = 0;

/***************************************************************************/

char *FileName = "TEST.PCX";
byte *PictureAddress = 0;                   /* uncompressed PCX address */
dword PictureHandle = 0;                    /* uncompressed PCX memory handle */
dword FileHandle = 0;


/*  */ 
/*  */
void main (void)                            /* MAIN STARTING POINT */
{
	REGS regs;
	byte *ptr1;
	register temp1;
	register temp2;

	text_scroll_length = CheckScrollTextLength(tekst1);
	GetROMFont();

	PictureAddress = (byte *)DPMI_malloc((640*480)+769,PictureHandle);

	if (temp1 = CheckVESA()) {
		print (*(VBE_Msg_Table+(temp1<<2)));
		exit(-1);
	}

	if (temp1 = InitVESAMode(640, 480, 8)) {
		print (*(VBE_Msg_Table+(temp1<<2)));
		exit(-1);
	}

	if (!PcxUnpack(FileName, PictureAddress)) {
		print ("There was an error while loading the PCX image.$");
		exit(-1);
	}

	key_init();

	SetVBEMode();
	ActivePcxPal(PictureAddress);
	PutVESAScreen(PictureAddress);

	while(!*(key_table + scan_Space)){};
	while(*(key_table + scan_Space)){};

	CloseVBEMode();
	if (InitVESAMode(800, 600, 8)) exit_program();

	SetVBEMode();

/* -----------------------------SECOND-SCENE-------------------------------- */

	text_y0 = VBE_YResolution + 10;		/* scroll resolution start */
	XCenter = VBE_XResolution >> 1;
	YCenter = VBE_YResolution >> 1;

	while (!*(key_table + scan_Space)) {

	regs.h.ah = 2	;
	int386(0x1a, &regs, &regs);
	if (regs.h.dh != seconds) {
		actual_fps = fps_counter;
		fps_counter = 0;
		seconds = regs.h.dh;
	}

	fps_counter++;
	FTriangle(x1, y1, x2, y2, x3, y3, color);
	Circle (XCenter, YCenter, y3, 15);
	ptr1 = PutText (fps_x0, fps_y0, fps_color, fps_colorize, fps_string);
	WriteWordSVGA (actual_fps, 0x3f, ptr1);
	ScrollText (text_y0, text_color, text_colorize, tekst1);
	ptr1 = PutText (res_x0, res_y0, fps_color, res_colorize, res_string);
	ptr1 = WriteWordSVGA (VBE_XResolution, 0x3f, ptr1);
	ptr1 = WriteCharSVGA ('x', 0x3f, ptr1);
	ptr1 = WriteWordSVGA (VBE_YResolution, 0x3f, ptr1);
	ptr1 = WriteCharSVGA('x', 0x3f, ptr1);
	ptr1 = WriteWordSVGA(VBE_BitsPerPixel, 0x3f, ptr1);
	ptr1 = WriteCharSVGA('b', 0x3f, ptr1);
	ptr1 = WriteCharSVGA('i', 0x3f, ptr1);
	WriteCharSVGA('t', 0x3f, ptr1);

	Flip();

	if (*(key_table + scan_Plus)) IncreaseResolution();
	if (*(key_table + scan_Minus)) DecreaseResolution(); 

	temp1 = VBE_XResolution - 1;
	temp2 = VBE_YResolution - 1;

	if (!--x2) x2 = temp1;
	if (++x3 >= temp1) x3 = 0;
	if ((x1+=2) >= temp1) x1 = 0;
	if (++y1 >= temp2) y1 = 0;
	if (!--y3) y3 = temp2;

	if (--text_y0 <= -text_scroll_length) text_y0 = temp2 + 10;
	}

/* -------------------------------THIRD-SCENE------------------------------- */

	CloseVBEMode();
	DPMI_free(PictureHandle);
	if (InitVESAMode(640,400,15))
		if (InitVESAMode(320,200,15)) exit_program();
	SetVBEMode();

	while (!*(key_table + scan_Space)) {

	regs.h.ah = 2	;
	int386(0x1a, &regs, &regs);
	if (regs.h.dh != seconds) {
		actual_fps = fps_counter;
		fps_counter = 0;
		seconds = regs.h.dh;
	}

	fps_counter++;

	temp1 = color_count;
	ptr1 = VBE_VirtualScreenAddress;
hicolor_fill:
	do {
	*(word *)ptr1 = temp1;
	ptr1 += 2;
	if (ptr1 > VBE_FirstByteBeyondVirtualScreen) goto exit_hicolor_fill;
	temp1++;
	 } while (temp1 < 32);

	temp1 = color_count;
	do {
	temp1 = temp1 << 5;
	*(word *)ptr1 = temp1;
	temp1 = temp1 >> 5;
	ptr1 += 2;
	if (ptr1 > VBE_FirstByteBeyondVirtualScreen) goto exit_hicolor_fill;
	temp1++;
	} while (temp1 < 64);

	temp1 = color_count;
	do {
	temp1 = temp1 << 10;
	*(word *)ptr1 = temp1;
	temp1 = temp1 >> 10;
	ptr1 += 2;
	if (ptr1 > VBE_FirstByteBeyondVirtualScreen) goto exit_hicolor_fill;
	temp1++;
	} while (temp1 < 32);

	temp1 = color_count;
	goto hicolor_fill;

exit_hicolor_fill:
	line_x2 += line_dinc_x;
	line_y2 += line_dinc_y;
	if (line_y2 >= (VBE_YResolution -1)) line_dinc_y = -line_dinc_y;
	if (line_y2 <= 0) line_dinc_y = -line_dinc_y;
	if (line_x2 >= (VBE_XResolution -1)) line_dinc_x = -line_dinc_x;
	if (line_x2 <= 0) line_dinc_x = -line_dinc_x;
	line_r_color += 1;
	line_g_color += 2;
	line_b_color += 3;
	if (line_r_color >= 255) line_r_color = 0;
	if (line_g_color >= 254) line_g_color = 0;
	if (line_b_color >= 255) line_b_color = 0;
	Line ( line_x1, line_y1, line_x2, line_y2,
	CreateColor (line_r_color, line_g_color, line_b_color));

	ptr1 = PutText(fps_x0, fps_y0, -1, fps_colorize, fps_string);
	WriteWordSVGA(actual_fps, -1,ptr1);
	ptr1 = PutText(res_x0, res_y0, -1, res_colorize, res_string);
	ptr1 = WriteWordSVGA(VBE_XResolution, -1, ptr1);
	ptr1 = WriteCharSVGA('x', -1, ptr1);
	ptr1 = WriteWordSVGA(VBE_YResolution, -1, ptr1);
	ptr1 = WriteCharSVGA('x', -1, ptr1);
	ptr1 = WriteWordSVGA(VBE_BitsPerPixel, -1, ptr1);
	ptr1 = WriteCharSVGA('b', -1, ptr1);
	ptr1 = WriteCharSVGA('i', -1, ptr1);
	WriteCharSVGA('t', -1, ptr1);

	Flip();
	}


/* ------------------------------------------------------------------------- */

	key_deinit();
	CloseVBEMode();
	SetVGAMode(3);
	exit(0);
}

