/*********************************************************************/
/*								     */
/* RTTY ART UTILITY PROGRAM FOR THE IBM PERSONAL COMPUTER	     */
/*   Companion program to the RTTY program for the IBM PC	     */
/*								     */
/* BY	GLENN E. WELMAN  -  KF4NB				     */
/*	3301 PASTERN CT.					     */
/*	LEXINGTON, KY 40513					     */
/*								     */
/*  (C) COPYRIGHT WELMAN SOFTWARE 1986				     */
/*********************************************************************/
/*								     */
/* Rules for distribution of this program:			     */
/*								     */
/*  FEEL FREE TO GIVE COPIES OF THIS PROGRAM TO YOUR FRIENDS.	     */
/*								     */
/*  PLEASE, DON'T SELL OR BARTER THE PROGRAM TO OTHERS.              */
/*								     */
/*  IF YOU FIND BUGS IN THE PROGRAM, FEEL FREE TO		     */
/*  CORRESPOND DIRECTLY WITH ME. (SASE REQUESTED)		     */
/*								     */
/*  WHEN YOU PASS ALONG THE PROGRAM, INCLUDE ONLY THE		     */
/*  ORIGINAL UNMODIFIED VERSION.				     */
/*								     */
/*  DO NOT REMOVE THESE GUIDELINES FROM THE PROGRAM		     */
/*  OR DOCUMENT.						     */
/*								     */
/*								     */
/*			 73's                                        */
/*			 Glenn - KF4NB				     */
/*								     */
/*********************************************************************/


#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#undef toupper
#undef tolower

    int in,out,rcnt,first;
    int prt,newfile,comp;

main()
{
    char infile[60];
    char outfile[60];
    char temp[10];
    int cnt,tcnt;
    unsigned char ch,lch,tmp;

/* Print the program header */

    setmode (fileno(stdout),O_BINARY);
    cls ();
    printf("\nThe RTTY Art Utility Program");
    printf("\r\nby Glenn Welman, KF4NB");
    printf("\r\n(C) Copyright Welman Software 1986");
    temp[0] = '\0';

do
{
    if (toupper(temp[0]) == 'Y')
	cls ();
    rcnt=0;
    first=0;

/* Get the input file and make sure it is good */

    printf("\r\n\nEnter the name of the file to process? ");
    gets(infile);

    if (infile[0] == '\0')
	break;

    in=open(infile,O_RDONLY | O_BINARY);
    if(in == -1)
	{
	perror("\nCannot open ");
	printf("filename is %s",infile);
	abort ();
	}

/* Check to see if they want the data saved in a file */

    printf("\nWould you like to save the results (y/n)? ");
    gets(temp);

    if (toupper(temp[0]) == 'Y')
	{

/* Get the name of the file where they want the data saved */

	printf("\nEnter the name of the new file? ");
	gets(outfile);

	if (outfile[0] != '\0')
	    {
	    newfile=-1;

	    out=open(outfile,O_WRONLY | O_TRUNC | O_CREAT | O_BINARY,S_IWRITE);
	    if(out == -1)
		{
		perror("\nCannot open ");
		printf("filename is %s",outfile);
		abort ();
		}


/* See if they want the data compressed */

	    printf("\nWould you like to compress the file (y/n)? ");
	    gets(temp);

	    if (toupper(temp[0]) == 'Y')
		comp=-1;
	    else
		comp=0;
	    }
	}

    else
	newfile=0;

/* Check to see if they want the data printed */

    printf("\nWould you like to print the file (y/n)? ");
    gets(temp);

    if (toupper(temp[0]) == 'Y')
	{
	prt=-1;
	setmode (fileno(stdprn),O_BINARY);
	fflush(stdprn);
	setbuf(stdprn,NULL);

/* Check to see if they want small or regular size printing */

	printf("\nWould you like small or full size print (default=small) (s/f)? ");
	gets(temp);

	if (toupper(temp[0]) == 'F')
	    fputs("\x12\x1b\x32",stdprn);
	else
	    fputs("\x0f\x1b\x31",stdprn);

	}
    else
	prt=0;


/* Read the input file in it's entirety */

    cls ();
    lch = 0;
    while(!eof(in))
    {
	read(in,&ch,1);
	switch (ch)
	{
	case 255:
	    read(in,&ch,1);
	    tcnt = ch;
	    read(in,&ch,1);
	    for (cnt=0;cnt < tcnt;cnt++)
		process(ch);
	    break;
	case '\x14':
	case '\x17':
	    process(ch-10);
	    break;
	case '\x0a':
	case '\x0d':
	    if ((lch != 20) && (lch != 23))
		process(ch);
	    else
		ch = lch;
	    break;
	case '\x1a':
	    ch = lch;
	    break;
	default:
	    process(ch);
	    break;
	}
	lch = ch;
    }
    if (newfile && ((lch == 10) || (lch == 13) || (lch == 20) || (lch == 23)))
	{
	tmp = 0x0d;
	write(out,&tmp,1);
	tmp = 0x0a;
	write(out,&tmp,1);
	}

    tmp = 0x1a; 	/* write end of file for BASIC compatibility */
    write(out,&tmp,1);

    close(in);
    if (newfile) close(out);

    printf("\nWould you like to process another file (y/n)? ");
    gets(temp);

} while(toupper(temp[0]) == 'Y');

}

/* Process the characters, send to file and/or printer as requested */

process (ch)

    unsigned char ch;

/* put the character on the screen */
{
    static unsigned char last,lastin=0;
    unsigned char tmp,spc=255;

    if (ch != '\7') putchar(ch);

/* send the character to the printer, if requested */

    if ((prt) && (ch != '\7')) putc(ch,stdprn);

/* send the character to the file, if requested */

    if (newfile)
	{
	if ((first != 0) && (ch != 10) && (ch != 13) && ((lastin == 10) || (lastin == 13)))
	    {
	    tmp = 0x0d;
	    write(out,&tmp,1);
	    tmp = 0x0a;
	    write(out,&tmp,1);
	    }
	if (comp)
	    {
	    if (ch == lastin)
		rcnt++;
	    else
		{
		if ((lastin != 10) && (lastin != 13))
		    switch (rcnt)
		    {
		    case 0:
			break;
		    case 1:
			write(out,&last,1);
			break;
		    case 2:
			write(out,&last,1);
			write(out,&last,1);
			break;
		    case 26:
			write(out,&last,1);
			rcnt--;
		    default:
			write(out,&spc,1);
			write(out,&rcnt,1);
			write(out,&last,1);
			break;
		    }
		last = ch;
		rcnt = 1;
		}
	    }
	else if ((ch != 10) && (ch != 13))
	    write(out,&ch,1);

	if ((ch == 10) || (ch == 13))
	    {
	    tmp = ch+10;
	    write(out,&tmp,1);
	    }
	lastin = ch;
	}
    first = 1;
    return;
}

cls ()
{
#define CRT_BIOS 0x10
union REGS inregs, outregs;
unsigned int page;
unsigned int cols;

inregs.h.ah = 15;    /* get active page and screen size */

int86(CRT_BIOS, &inregs, &outregs);

page = outregs.h.bh;
cols = outregs.h.ah;

inregs.h.al = 0;
inregs.h.ch = 0;
inregs.h.cl = 0;
inregs.h.dh = 24;
inregs.h.dl = cols;
inregs.h.bh = 7;
inregs.h.ah = 6;    /* scroll up command */

int86(CRT_BIOS, &inregs, &outregs);

inregs.h.bh = page;
inregs.h.dh = 0;
inregs.h.dl = 0;
inregs.h.ah = 2;    /* locate cursor at upper left corner */

int86(CRT_BIOS, &inregs, &outregs);
}
