/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* Definitions, visible to others, of the dynamic allocator module.	     *
*****************************************************************************/

#ifndef	ALLOCATE_GH
#define	ALLOCATE_GH

typedef enum {
    ALLOC_OTHER,
    ALLOC_VERTEX,
    ALLOC_SURFACE,
    ALLOC_CURVE,
    ALLOC_POLYGON,
    ALLOC_OBJECT
} AllocateStructType;

char *MyMalloc(unsigned int Size, AllocateStructType Type);
void MyFree(char *p, AllocateStructType Type);

VertexStruct *AllocVertex(ByteType Count, ByteType Tags,
				PolygonStruct * PAdj, VertexStruct * Pnext);
PolygonStruct *AllocPolygon(ByteType Count, ByteType Tags,
				VertexStruct * V, PolygonStruct * Pnext);
ObjectStruct *AllocObject(char *Name, IritObjectType ObjType,
						 ObjectStruct * Pnext);

#endif	/* ALLOCATE_GH */
