/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* General, Visible to others, definitions for the Input Parser module.	     *
*****************************************************************************/

#ifndef	INPT_PRSR_GH
#define	INPT_PRSR_GH

/*****************************************************************************
* Error	numbers	as located during the parsing process:			     *
*****************************************************************************/
typedef enum {
    IPE_NO_ERR = 0,

    IP_ERR_WRONG_SYNTAX,
    IP_ERR_PARAM_EXPECT,
    IP_ERR_ONE_OPERAND,
    IP_ERR_TWO_OPERAND,
    IP_ERR_STACK_OV,
    IP_ERR_PARAM_MATCH,
    IP_ERR_UNDEF_TOKEN,
    IP_ERR_UNDEF_FUNC,
    IP_ERR_NAME_TOO_LONG,
    IP_ERR_PARAM_FUNC,
    IP_ERR_NO_PARAM_FUNC,

/*****************************************************************************
* Error	as located during the evaluation process:			     *
*****************************************************************************/

    IE_ERR_FATAL_ERROR,
    IE_ERR_DIV_BY_ZERO,
    IE_ERR_NO_OBJ_METHOD,
    IE_ERR_TYPE_MISMATCH,
    IE_ERR_ASSIGN_LEFT_OP,
    IE_ERR_MIXED_OBJ,
    IE_ERR_UNDEF_OBJECT,
    IE_ERR_NO_ASSIGNMENT,
    IE_ERR_FP_ERROR,
    IE_ERR_NUM_PRM_MISMATCH,
    IE_ERR_MAT_POWER,
    IE_ERR_FREE_SIMPLE,
    IE_ERR_MODIF_ITER_VAR,
    IE_ERR_BOOLEAN_ERR,
    IE_ERR_LIST_TOO_LONG,
    IE_ERR_DATA_PRSR_ERROR
} InptPrsrEvalErrType;

/*****************************************************************************
* The global (visible to others) function prototypes:			     *
*****************************************************************************/
int InputParser(void);
/* If the above returns NULL object the following might be called to find    */
/* What went wrong (In the parsing stage, or in the evaluation stage.	     */
InptPrsrEvalErrType InptPrsrParseError(char **Message);
InptPrsrEvalErrType InptPrsrEvalError(char **Message);

void FileInclude(char *FileName);  /* Used to insert files on include stack. */

void AliasReset(void);				/* Reset the aliases buffer. */

#endif	/* INPT_PRSR_GH */
