SLASH-IF.FOR
Some properties of the use of a slash within a FOR or IF statement.

Introduction.

Within batch files replaceable batch file parameters (%0..%9) and other batch
variables (%%A..%%Z in FOR commands) are always processed as is, i.e.
literally, except for the wildcard characters ? and * within a FOR command,
ment to be replaced by a list of existing corresponding file names.
Furthermore there are characters that DOS interprets as delimiters and that
can never be processed by themselves or as "part" of a parameter (the parameter
gets split in such a case). These are: space TAB , ; =

There is, however, a character that DOS appears to treat in a special way,
which is not documented anywhere (at least I have not seen it anywhere, but
I have experienced the special treatment). That character is the slash. It
will not be treated specially if it only is being compared in a comparative
IF command (IF 'text'=='some other text' ...), whether or not it is a part
of a replaceable parameter or not, but it gets treated specially if it
is part of a text that refers to file names with the IF or FOR command, as in
IF EXIST filename ...
FOR %%F IN (filename_set) DO ...

Slash processing.

Generally a filename (text that refers to a file name) or set of one or more
filenames within an IF or a FOR, that involves a slash is separated into more
filenames, the first one consisting of all (eventually occurring) characters
up to the slash, the second one consisting of the one literal character (not
being a delimiter) following the slash, while removing the slash (the one
character may be another slash or a * or ?, interpreted as a wildcard character
within an IF, but NOT within a FOR) and the third one consisting of the
(eventually) remaining characters. Thus for example the text 'abc/defg' is
being processed into three separate texts: 'abc', 'd' and 'efg', the texts
'abc/?efg' or 'abc/*efg' evaluate into 'abc', literal '?' or '*' and 'efg,
while 'abc//efg' is split into 'abc', '/' and 'efg'.

In an IF EXIST command only the first evaluated part is processed and the rest
gets ignored, while in a FOR command all parts are contained in the set to be
processed. If specifying 'FOR %%B IN (%1) DO .....' if the first character of
%1 is a '/': it is being removed (within the set-part of the FOR) and the first
(or only) part of the set will be the second character of %1 (and the next part
the eventually remaining characters). If %1 does not have a second character
(it only consists of the slash) then it will be removed, evaluating into
nothing. (If there would be a non-empty following set specification (%1 %2)
then that one would be processed as if being directly preceed by the only
slash, thus disregarding the delimiter between %1 and %2). If %1 has more
embedded slashes these delimit sub-parts and determine a one-character and
remaining-characters next parts. So for example the set specification
'/abc/,def/g' evaluates into 'a', 'bc', 'd', 'ef' and 'g'.

This feature (?) can be used to investigate explicitely only the first
character of a replaceable parameter by preceeding it with a slash in a FOR
command. Consider the following DOS batch commands:
  IF "%1"=="" GOTO EMPTY
  FOR %%B IN (/%1) DO IF %%B==/ GOTO SLASH
  FOR %%B IN (/%1) DO IF %%B==~ GOTO TILDE
  REM If %1 itself starts with a slash (followed by zero or more characters)
  REM then the IF test on the first part of %1, being a slash, evaluates
  REM positive and the jump actually is being made before the second remaining
  REM part could be investigated.
Within the FOR the initial (literal) '/' is removed and the rest (%1) is
processed as follows:
- if %1 is only one character long it is the only remaining part of the set
  (and may be checked further, see 1. below).
- if %1 is longer then one character it is split into 2 separate parts of a set:
   1. the first or only character: if it is a '*' or '?' it is _NOT_
      treated as a wildcard specification, but literally left as it is;
   2. the remaining characters (if not including a '/' themselves), which
      may have wildcard characters among them, substituting to file names;
      if these include a '/' the '/' acts as a part delimiter _AND_
      influences the processing of the characters thereafter similarly;
So when calling bath files with arguments one could discriminate between
replaceable parameters starting with a slash (or any specific first character)
and those not starting with a slash (or character specified).

Even if 'IF EXIST /%1 ...' is specified not the whole filename (or wildcard)
is used for evaluation, but only the filename consisting of the first
character. If that one is a '*' or '?' it will be treated as a wildcard.
If the slash is within the filename (not the first character) then only the
characters up to the slash as regarded as the filename (eventually including
processed wildcard characters), the rest being ignored. But this seems a
useless application.

This also implies that the batch commands of for instance the form
  FOR %%A IN (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z) DO
                                                 IF "%1"=="%%A:\" GOTO ROOTDIR
  FOR %%A IN (a b c d e f g h i j k l m n o p q r s t u v w x y z) DO
                                                 IF "%1"=="%%A:\" GOTO ROOTDIR
may be replaced by the much shorter
  FOR %%A IN (/%1) DO IF "%%A:\"=="%1" GOTO ROOTDIR
assuming only letters are specified as the first character of %1.

This is as far as I know undocumented DOS, but has been tested successfully on
many systems and many DOS versions (3.1, 3.2, 3.3, 5.0). One may check these
properties oneself with the command 'FOR %A IN (test-set) DO ECHO %A'.

This is only valid for real batch files, not for compiled ones (BAT2EXEC 1.5);
compiled programs pass the slash (as well as the =char.) as any other character.

Centrum voor Medische Informatica TNO       <Email>              |  |  |\/|
TNO Center for Medical Informatics | GROENEVELD@CMI.TNO.NL  |  \_/  |  |  |
( CMI-TNO )    | Y. Groeneveld     | GROENEVELD@CMIHP1.UUCP | Jim Groeneveld
P.O.Box 124    | Wassenaarseweg 56 | GROENEVELD@TNO.NL      | Schoolweg 14
2300 AC Leiden | 2333 AL Leiden    | (21 December 1992)     | 8071 BC Nunspeet
Nederland.     | (+31|0)71-181810  | Fax (+31|0)71-176382   | 03412-60413
