{$V-,I-,R-,S-,X+}
Unit Netware;

{
  (C) Copyright 1991 Terje Mathisen, Norsk Hydro, Hydro Data.

  This unit is made available as is, i.e. no warranties of any kind.
  You are granted the use of it, as long as this (C) msg is not removed.

  Unit to provide interface with Novell 2.10's Queue Management,
  Also added other Novell calls.
  Documentation to be found in:
  Advanced Netware V2.1 Preliminary Function Calls.
  Also added later V3.0, 3.1 calls.

  Modified, 6 Feb 1995, by Peter Summers to support up to 16 attachments.
}

INTERFACE

USES
  Dos, MyDos;

CONST
  MAXSERVERS   = 8;

  WILD = $FFFF;
  UNKNOWN_TYPE = 0;
  NET_USER = 1;
  USER_GROUP = 2;
  PRINT_QUEUE = 3;
  FILE_SERVER = 4;
  PRINT_SERVER = 7;
  SQL_SERVER   = $F503;     { MS SQL? }

{ Bindery security bitmap }
  B_ANYONE     = 0;
  B_LOGGED_IN  = 1;
  B_OBJECT     = 2;
  B_SUPERVISOR = 3;
  B_BINDERY    = 4;

{ Trustee access bits}
  T_READ       =  1;
  T_WRITE      =  2;
  T_OPEN       =  4;
  T_CREATE     =  8;
  T_DELETE     =$10;
  T_PARENTAL   =$20;
  T_SEARCH     =$40;
  T_MODIFY     =$80;

{ Job Control Flags }
  OperatorHoldFlag    = $80;
  UserHoldFlag        = $40;
  EntryOpenFlag       = $20;
  ServiceRestartFlag  = $10;
  ServiceAutoStartFlag= $08;

{ Print Flags }
  SuppressFF          = $08;
  NotifyUser          = $10;
  TextFile            = $40;
  BannerPage          = $80;

  DriveHandleTable = 0;
  DriveFlagTable   = 1;
  DriveServerTable = 2;
  ServerMapTable   = 3;
  ServerNameTable  = 4;

TYPE
  DriveTable    = ARRAY ['A'..Chr(96)] OF BYTE;
  DriveTablePtr = ^DriveTable;

  Long       = LongInt;
  FlagsType  = (STATIC, DYNAMIC, STATIC_SET, DYNAMIC_SET);

  NetWorkAddress = RECORD
    InterNet : ARRAY [1..4] OF BYTE;
    CardNr : ARRAY [1..6] OF BYTE;
    Socket : WORD;
  END;

  NetTime    = ARRAY [1..6] OF BYTE;
  DescType   = ARRAY [1..50] OF CHAR;
  JobType    = (PrintJob, General); { Variants to Client's Record }
  JobList    = ARRAY [1..250] OF WORD;
  NetStr = STRING[47];

  ClientType = RECORD
    CASE JobType OF
      PrintJob : (
        Fill1      : BYTE;
        TabSize    : BYTE;
        Fill2      : BYTE;
        Copies     : BYTE;
        Fill3      : BYTE;
        PrintFlags : BYTE;
        Fill4      : Long;
        FormName   : ARRAY [1..22] OF CHAR;
        BannerName : ARRAY [1..13] OF CHAR;
        BannerFile : ARRAY [1..13] OF CHAR;
        FileName   : ARRAY [1..14] OF CHAR;
        FilePath   : ARRAY [1..80] OF CHAR;);
      General : (GeneralFill : ARRAY [1..152] OF CHAR;)
    END;

  Job = RECORD
    ClientStation  : BYTE;
    ClientTask     : BYTE;
    ClientIDNumber : Long;

    TargetServerID      : Long;
    TargetExecutionTime : NetTime;

    JobEntryTime    : NetTime;
    JobNumber       : WORD;
    JobType         : WORD;
    JobOrder        : BYTE;
    JobControlFlags : BYTE;

    JobFileName     : ARRAY [1..14] OF CHAR;
    JobFileHandle   : ARRAY [1..6] OF BYTE;

    ServerStation   : BYTE;
    ServerTask      : BYTE;
    ServerIDNumber  : Long;

    JobDescription  : DescType;
    ClientArea      : ClientType;
  END;

  ConnectionInfo = RECORD
    plen : WORD;
    ID : LongInt;
    oType : WORD;
    name : ARRAY [1..48] OF CHAR;
    LogTime : ARRAY [1..8] OF BYTE;
  END;

  FileServerInfo = RECORD
    plen                : WORD;
    ServerName          : ARRAY [1..48] OF CHAR;
    NetWareVersion      : WORD;
    MaxConnections      : WORD;
    CurrConnections     : WORD;
    MaxConnectedVolumes : WORD;

    RevisionLevel       : BYTE;
    SFTLevel            : BYTE;
    TTSLevel            : BYTE;
    MaxConnectionsUsed  : WORD;

    Undefined : ARRAY [1..67] OF BYTE;
  END;

  ScanBinderyInfo = RECORD
    plen : WORD;
    objID : Long;
    otype : WORD;
    name : ARRAY [1..48] OF CHAR;
    ObjectFlags : BYTE;
    ObjectSecurity : BYTE;
    PropertiesExist : BYTE;
  END;

  ServerName = ARRAY[1..MAXSERVERS] OF ARRAY [1..48] OF CHAR;
  ServerNamePtr = ^ServerName;

  ServerMappingEntry = RECORD
    SlotInUse      : BYTE;
    OrderNumber    : BYTE;
    ServerNet      : ARRAY [1..10] OF CHAR;
    ServerSocket   : WORD;  {Swap}
    ReceiveTimeout : WORD;  {Swap}
    RoutingNode    : ARRAY [1..6] OF CHAR;
    SequenceNr     : BYTE;
    ConnectionNr   : BYTE;
    ConnStatus     : BYTE;
    MaxTimeout     : WORD;  {Swap}
    wConnectionNr  : WORD;  {Swap}
    Server3pluss   : BYTE;
    ServerVersion  : WORD;
  END;

  ServerMappingTable = ARRAY [1..MAXSERVERS] OF ServerMappingEntry;
  ServerMappingPtr = ^ServerMappingTable;

  ASCIIZ = ARRAY [0..MaxInt] OF CHAR;
  pASCIIZ = ^ASCIIZ;
  CAPTURE_FLAGS = RECORD
    status              : BYTE;
    flags               : BYTE;
    tabsize             : BYTE;
    serverPrinter       : BYTE;
    numberOfCopies      : BYTE;
    formType            : BYTE;
    reserved            : BYTE;
    bannerText          : ARRAY [0..12] OF CHAR;
    reserved1           : BYTE;
    localLPTDevice      : BYTE;
    flushCaptureOnTimeoutCount  : WORD;
    flushCaptureOnDeviceClose   : BYTE;
    maxLines            : WORD;
    maxChars            : WORD;
    formName            : ARRAY [0..12] OF CHAR;
    LPTCaptureFlag      : BYTE;
    fileCaptureFlag     : BYTE;
    timingOutFlag       : BYTE;
    printerSetupBufPtr  : pASCIIZ;
    printerResetBufPtr  : pASCIIZ;
    connectionIDQueuePrintJob   : BYTE;
    captureInProgress   : BYTE;
    printQueueFlag      : BYTE;
    printJobValid       : BYTE;
    printQueueID        : long;
    printJobNumber      : WORD;
  END;

TYPE
  tlist = ARRAY [0..4] OF LongInt;

TYPE
  BinderyAccessReply = RECORD
    plen : WORD;
    access : BYTE;
    MyObjectID : LongInt;
  END;

FUNCTION SystemLogout : BYTE;
InLine($B4/$D7        {mov ah,$D7}
      /$CD/$21);      {int $21}

FUNCTION GetVolumeStat386(sname, vname : NetStr; VAR secPrBlock,
                          totalBlocks : Word): BYTE;
FUNCTION OpenBindery : BYTE;
FUNCTION CloseBindery : BYTE;
FUNCTION GetConnectionNr : WORD;
FUNCTION GetDirectoryRights(path : STRING;VAR rights : WORD): BYTE;
FUNCTION GetDirectoryHandle(drive : CHAR) : BYTE;
FUNCTION GetDriveFlag(drive : CHAR) : BYTE;
FUNCTION GetDirectoryPath(handle : BYTE; VAR path : STRING): BYTE;
FUNCTION GetNetDrivePath(drive : CHAR; VAR path : STRING): BYTE;
FUNCTION NetExpand(dp : PathStr): STRING;
FUNCTION MapFakeRoot(drive : CHAR; path : STRING): BYTE;
PROCEDURE DelFakeRoot(drive : CHAR);
FUNCTION GetRelativeDriveDepth(drive : CHAR): BYTE;
FUNCTION SetShowDots(on : BOOLEAN): BYTE;
FUNCTION ConnectToServer(server : NetStr): BYTE;
FUNCTION GetFileServerInfo(VAR fsi : FileServerInfo): BYTE;
FUNCTION HexStr(VAR l; len : INTEGER): STRING;
PROCEDURE HexBuf(VAR buf, data; len : INTEGER);
PROCEDURE Str2Az(st : STRING; VAR az; size : INTEGER);
FUNCTION Az2Str(VAR az): STRING;
FUNCTION GetString(VAR s):STRING;

FUNCTION CreateQueue(QueueType : BYTE; QueueName : NetStr;
                     VAR QueueID : Long): BYTE;
FUNCTION DestroyQueue(QueueID : Long): BYTE;
FUNCTION ReadQueueStatus(QueueID : Long;
         VAR QueueStatus, CurrentEntries, CurrentServers : BYTE): BYTE;
FUNCTION CreateQueueJob(QueueID : Long; VAR JobRec : Job): BYTE;
FUNCTION StartQueueJob(QueueID : Long; JobNumber : WORD): BYTE;
FUNCTION RemoveJobFromQueue(QueueID : Long; JobNumber : WORD) : BYTE;
FUNCTION GetListOfJobs(QueueID : Long;
                       VAR NrofJobs : WORD; VAR Jobs : JobList ) : BYTE;
FUNCTION ReadJobQueueEntry(QueueID : Long; JobNumber : WORD;
                           VAR JobReturn : Job): BYTE;
FUNCTION ChangeJobQueueEntry(QueueID : Long; J : Job): BYTE;
FUNCTION ChangeJobQueuePosition(QueueID : Long; JobNumber : WORD;
                            NewPosition : BYTE) : BYTE;
FUNCTION AttachServerToQueue(QueueID : Long): BYTE;
FUNCTION DetachServerFromQueue(QueueID : Long): BYTE;
FUNCTION ServiceQueueJob(QueueID : Long; TargetServiceType : BYTE;
                        VAR JobReturn : Job): BYTE;
FUNCTION FinishServicingJob(QueueID : Long; JobNumber : WORD;
                           Charge : Long ): BYTE;
FUNCTION AbortServicingJob(QueueID : Long; JobNumber : WORD): BYTE;
FUNCTION GetClientRights(QueueID : Long; JobNumber : WORD): BYTE;
FUNCTION RestoreServerRights: BYTE;
FUNCTION GetJobQueueEntryFileSize(QueueID : Long; JobNumber : WORD;
                                 VAR FileSize : Long): BYTE;

FUNCTION MapObjectToConnectionSet(ObjectType : WORD;ObjectName : NetStr;
                         VAR ConnSet : STRING): BYTE;
FUNCTION MapNameToNumber(ObjectType : WORD;ObjectName : NetStr;
                         VAR ObjectID : Long): BYTE;
Function GetBinderyObjectId(ObjectType : WORD;ObjectName : NetStr;
                         VAR ObjectID : Long): BYTE;
FUNCTION MapNumberToName(ID : Long; VAR Name; VAR Otype : WORD):BYTE;

FUNCTION CreateBinderyObject(flags : FlagsType; security : BYTE;
                            OType : WORD;
                            Name:NetStr): BYTE;
FUNCTION ScanBinderyObjects(Search : NetStr;
                            VAR ObjectID : Long;
                            VAR Name:NetStr;
                            VAR OType:WORD): BYTE;
FUNCTION ScanBinderyObject(Search : NetStr; oid : Long; ot : WORD;
                VAR sbi : ScanBinderyInfo): BYTE;
FUNCTION AddMembertoProperty(ObjectType : WORD;ObjectName : NetStr;
                             Property : NetStr; MemberType : WORD;
                             Member : NetStr ): BYTE;
FUNCTION AddPropertytoObject(ObjectType : WORD; ObjectName : NetStr;
                             PropertyFlags : FlagsType;
                             PropertySecurity : BYTE;
                             Property : NetStr ): BYTE;
FUNCTION ChangePropertySecurity(ObjectType : WORD; ObjectName : NetStr;
                             PropertySecurity : BYTE;
                             Property : NetStr ): BYTE;
FUNCTION ChangeObjectSecurity(ObjectType : WORD; ObjectName : NetStr;
                             Security : BYTE): BYTE;
FUNCTION GetServerNumber(s:NetStr):BYTE;
FUNCTION GetServerUtilization(VAR util : BYTE):BYTE;
FUNCTION GetServerName(n : BYTE):NetStr;
FUNCTION SetPreferredServer(sno:BYTE) : BYTE;
FUNCTION GetPreferredServer:BYTE;
FUNCTION GetEffectiveServer:BYTE;
PROCEDURE SetPrimaryServer(sno:BYTE);
FUNCTION GetPrimaryServer:BYTE;
FUNCTION GetCurrentServer: BYTE;

FUNCTION LoginAnObject( Name:NetStr; Otype:WORD; Passw: NetStr):BYTE;
FUNCTION LoginUser(Name, Passw: NetStr):BYTE;
FUNCTION LoginToFileServer(server: Byte; name: NetStr; otype: WORD; passw: STRING): BYTE;
FUNCTION VerifyBinderyObjectPassword(otype : WORD;name : NetStr;
                                     passw : STRING): BYTE;
FUNCTION Login(Sname,OName:NetStr; OType:WORD; Passw:NetStr):BYTE;
FUNCTION ScanProperties(ObjectType : WORD; ObjectName, Pattern : NetStr;
                        VAR Property : NetStr; VAR PropertyID : Long): BYTE;
FUNCTION GetTrusteePath(volnr : BYTE; ObjID : LONG; VAR NextSequence : WORD;
                        VAR access : BYTE; VAR path : STRING): BYTE;
FUNCTION GetPathTrustees(path : String; setnr : BYTE; VAR tl : tlist): BYTE;
FUNCTION AddTrusteeToDir(base : BYTE; path : STRING; ObjectID : Long;
                         mask : BYTE): BYTE;
FUNCTION ReadPropertyValue(ObjectType : WORD; ObjectName : NetStr;
                        Segnr : BYTE; Property : NetStr;
                        VAR item): BYTE;
FUNCTION WritePropertyValue(ObjectType : WORD; ObjectName : NetStr;
                        Segnr : BYTE; More : BOOLEAN; Property : NetStr;
                        VAR item): BYTE;
{ PROCEDURE GetShellTableAddresses(f:BYTE;VAR rep:Pointer);}
FUNCTION InsertServer(Name : NetStr; VAR sn : BYTE):BYTE;
{FUNCTION InsertServer(Name : NetStr):BYTE;}
FUNCTION AttachServer(func : BYTE; name : NetStr) : BYTE;
FUNCTION AttachServerNumber(func : BYTE; sn : BYTE) : BYTE;
FUNCTION LogOut(ServerName:NetStr):BYTE;
FUNCTION GetBinderyAccessLevel(VAR BinAcc : BinderyAccessReply): BYTE;
FUNCTION GetMyBinderyAccessLevel(VAR access : BYTE): BYTE;
FUNCTION AllocPermBase(drive : CHAR; base : BYTE; path : NetStr): BYTE;
FUNCTION AllocTempBase(drive : CHAR; base : BYTE; path : NetStr): BYTE;
FUNCTION DeAllocBase(base : BYTE): BYTE;
FUNCTION GetUserName(c : Long; VAR UserName : NetStr): BYTE;
FUNCTION GetConnectionName(VAR name : NetStr): BYTE;
FUNCTION MapNumberToVolume(nr : BYTE; VAR volume : NetStr): BYTE;
PROCEDURE UpcaseStr(VAR s:STRING);
FUNCTION CopyFile(Fra,Til:STRING):BYTE;
FUNCTION SystemStr(sysid : Long): STRING;
PROCEDURE SetErrorMode(mode : BYTE);
FUNCTION MapConnToNetworkNr(conn : LongInt; VAR addr): BYTE;
FUNCTION GetSerialNr(VAR snr, appl : STRING): BYTE;
FUNCTION OpenSem(name : NetStr; initial : ShortInt;
                 VAR h : LongInt; VAR users : BYTE): BYTE;
FUNCTION TestSem(h : LongInt; VAR value : INTEGER;
                 VAR users : BYTE): BYTE;
FUNCTION CloseSem(h : LongInt): BYTE;
FUNCTION ShellVersion : WORD;

FUNCTION SendPersonalMessage(msg, list : STRING;VAR result : STRING): BYTE;
FUNCTION SendBroadcastMessage(msg, list : STRING;VAR result : STRING): BYTE;
FUNCTION LoginEnabled(VAR enable : BOOLEAN): BYTE;
FUNCTION ChangeLoginStatus(enable : BOOLEAN): BYTE;

FUNCTION StrUpr(s:STRING): STRING;
FUNCTION StrLwr(s:STRING): STRING;

FUNCTION GetSpecificCaptureFlags(localLPT : BYTE; VAR cf : CAPTURE_FLAGS): BYTE;

{$IFDEF StonyBrook}

FUNCTION GetDriveHandlePtr : DriveTablePtr [ALTERS(AX), RETURNS ES:SI];
Inline(
  $B8/$EF00              {mov ax,$ef00}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
);

FUNCTION GetDriveFlagPtr : DriveTablePtr [ALTERS(AX), RETURNS ES:SI];
Inline(
  $B8/$EF01              {mov ax,$ef01}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
);

FUNCTION GetDriveServerPtr : DriveTablePtr [ALTERS(AX), RETURNS ES:SI];
Inline(
  $B8/$EF02              {mov ax,$ef02}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
);

FUNCTION GetServerMappingPtr : ServerMappingPtr [ALTERS(AX), RETURNS ES:SI];
Inline(
  $B8/$EF03              {mov ax,$ef03}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
);

FUNCTION GetServerNamePtr : ServerNamePtr [ALTERS(AX), RETURNS ES:SI];
Inline(
  $B8/$EF04              {mov ax,$ef04}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
);

FUNCTION FileServiceRequest(func : WORD; VAR q; qlen : WORD; VAR reply; 
    rlen : WORD): BYTE [ALTERS(AX), PASS(AX,BX:SI,CX,ES:DI,DX)];
Inline(
  $1E                    {push ds}
  /$8E/$DB               {mov ds,bx}
  /$CD/$21               {int $21}
  /$1F                   {pop ds}
);

FUNCTION CallNetware(RegAX : WORD; VAR request, reply): BYTE
[ALTERS(AX), PASS(AX,BX:SI,ES:DI)] ;
Inline(
  $1E                    {push ds}
  /$8E/$DB               {mov ds,bx}
  /$CD/$21               {int $21}
  /$1F                   {pop ds}
);

FUNCTION SwapLong(l : Long): Long [ALTERS(AX,DX), PASS(AX:DX)];
Inline(
  $86/$F2                {  xchg dl,dh}
  /$86/$E0               {  xchg al,ah}
);

{$ELSE}

FUNCTION GetDriveHandlePtr : DriveTablePtr;
Inline(
  $B8/$EF00              {mov ax,$ef00}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
  /$8C/$C2               {mov dx,es}
  /$89/$F0               {mov ax,si}
);

FUNCTION GetDriveFlagPtr : DriveTablePtr;
Inline(
  $B8/$EF01              {mov ax,$ef01}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
  /$8C/$C2               {mov dx,es}
  /$89/$F0               {mov ax,si}
);

FUNCTION GetDriveServerPtr : DriveTablePtr;
Inline(
  $B8/$EF02              {mov ax,$ef02}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
  /$8C/$C2               {mov dx,es}
  /$89/$F0               {mov ax,si}
);

FUNCTION GetServerMappingPtr : ServerMappingPtr;
Inline(
  $B8/$EF03              {mov ax,$ef03}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
  /$8C/$C2               {mov dx,es}
  /$89/$F0               {mov ax,si}
);

FUNCTION GetServerNamePtr : ServerNamePtr;
Inline(
  $B8/$EF04              {mov ax,$ef04}
  /$BE/$FF/$FF           {mov si,$ffff}
  /$CD/$21               {int $21}
  /$8C/$C2               {mov dx,es}
  /$89/$F0               {mov ax,si}
);

FUNCTION FileServiceRequest(func : WORD; VAR q; qlen : WORD;
                            VAR reply; rlen : WORD): BYTE;

FUNCTION CallNetware(RegAX : WORD; VAR request, reply): BYTE;

FUNCTION SwapLong(l : Long): Long;
Inline(
  $5A                    {  pop dx}
  /$58                   {  pop ax}
  /$86/$F2               {  xchg dl,dh}
  /$86/$E0               {  xchg al,ah}
);

{$ENDIF}

CONST
  NormalBroadcast  = 0;
  ConsoleBroadcast = 1;
  NoBroadcast      = 2;
  StoreBroadcast   = 3;
  GetBroadcast     = 4;
  StopBroadcastTimer = 5;
  StartBroadcastTimer = 6;

FUNCTION SetBroadcastMode(mode : BYTE): BYTE;
Inline(
  $5A                    {  pop dx}
  /$B4/$DE               {  mov ah,0DEh}
  /$CD/$21               {  int 21h}
);

TYPE
  JobReqType = RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
    JobNumber : WORD;
  END;

  JobRepType = RECORD
    plen : WORD;
  END;

  ShellPathBuf = ARRAY [0..16] OF BYTE;

PROCEDURE GetShellPath(VAR pbuf : ShellPathBuf);
PROCEDURE SetShellPath(VAR pbuf : ShellPathBuf);

function GetVolumeName(nr : Integer; var vname : NetStr): byte;

FUNCTION GetVolumeNumber(const volume : NetStr; var nr : Integer): BYTE;

function GetEffectiveDirectoryRights(const path: String;var r: byte): byte;

IMPLEMENTATION

CONST
  NoReply : WORD = 0;

FUNCTION GetVolumeStat386(sname, vname : NetStr; VAR secPrBlock,
                          totalBlocks : Word): BYTE;
var
  res, curr, save : BYTE;
  sm : ServerMappingPtr;
  q : record
    plen : word;
    func : byte;
    vname: NetStr;
  end;
  a : record
    plen : word;
    voln : BYTE;
    dummy: BYTE;
  end;
  GetVolInfo : record
    secPrBlock : Word;
    dummy : ARRAY [1..28] OF BYTE;
    secPrBlock386 : Word;
    d2 : ARRAY [1..72] OF BYTE;
  END;
begin
  save := GetPreferredServer;
  curr := GetServerNumber(sname);
  if (curr < 1) or (curr > MAXSERVERS) then begin
    GetVolumeStat386 := 255;
    Exit;
  end;
  SetPreferredServer(curr);

  q.plen := Length(vname) + 2;
  q.func := 5;
  q.vname := vname;
  a.plen := SizeOf(a)-2;
  res := CallNetware($E200,q,a);
  if res = 0 then begin
    GetVolInfo.secPrBlock := 100;
    sm := GetServerMappingPtr;
    if sm^[curr].Server3pluss <> 0 then begin
      q.plen := 2;
      q.func := 44;
      q.vname[0] := Chr(a.voln);
      res := CallNetware($E200,q,GetVolInfo);
      if res = 0 then
        secPrBlock := Lo(GetVolInfo.secPrBlock386);
    end
    else begin
      ASM
        mov ah,0DAh
        mov dl,[a.voln]
        lea di,[GetVolInfo]
        push ds
        mov bx,ss
        mov ds,bx
        mov es,bx
        int 21h
        pop ds
        mov [res],al
      END;
      if res = 0 then
        secPrBlock := Lo(GetVolInfo.secPrBlock);
    end;
  end;
  SetPreferredServer(save);
  GetVolumeStat386 := res;
end;

FUNCTION CloseBindery : BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  req.plen := 1;
  req.func := 68;
  CloseBindery := CallNetware($E300,req,NoReply);
END;

FUNCTION OpenBindery : BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  req.plen := 1;
  req.func := 69;
  OpenBindery := CallNetware($E300,req,NoReply);
END;

PROCEDURE GetShellPath(VAR pbuf : ShellPathBuf);
Assembler;
ASM
  push ds
  lds dx,[pbuf]
  mov ax,0E901h { Get a copy of shell NPATH table }
  int 21h
  pop ds
END;

PROCEDURE SetShellPath(VAR pbuf : ShellPathBuf);
Assembler;
ASM
  push ds
  lds dx,[pbuf]
  mov ax,0E902h { Update shell NPATH table }
  int 21h
  pop ds
END;

FUNCTION ServerVersion : WORD;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
  fsi : FileServerInfo;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 17;
  fsi.plen := SizeOf(fsi)-2;
  ServerVersion := 0;
  IF CallNetWare($E300,req,fsi) <> 0 THEN Exit;
  ServerVersion := Swap(fsi.NetwareVersion);
END;

{$IFNDEF StonyBrook}

FUNCTION FileServiceRequest(func : WORD; VAR q; qlen : WORD;
                            VAR reply; rlen : WORD): BYTE; Assembler;
ASM
  push ds
  mov ax,[func]
  lds si,[q]
  mov cx,[qlen]
  les di,[reply]
  mov dx,[rlen]
  int $21
  pop ds
END;

FUNCTION CallNetware(RegAX : WORD; VAR request, reply): BYTE;
Assembler;
ASM
  push ds
  mov ah,byte ptr [RegAX+1]
  lds si,[request]
  les di,[reply]
  int $21
  pop ds
END;

{$ENDIF}

FUNCTION MapFakeRoot(drive : CHAR; path : STRING): BYTE;
VAR
  azpath : String;
BEGIN
  azpath := path;
  ASM
    cld
    push ds
    push ss
    pop ds
    lea si,[azpath]
    lodsb
    xor bx,bx
    mov bl,al
    mov [bx+si],bh
    mov bl,[drive]
    and bl,31
    mov dx,si
    mov ax,$E905
    int $21
    pop ds
    mov [@Result],al
  END;
END;

PROCEDURE DelFakeRoot(drive : CHAR); Assembler;
ASM
  mov ax,$E906
  mov bl,[drive]
  and bl,31
  int $21
END;

FUNCTION GetRelativeDriveDepth(drive : CHAR): BYTE;
Assembler;
{ Drive 0 = Current, 1 = A etc. }
{ Returns FF for no fake root }
ASM
  mov ax,$E907
  mov bl,[drive]
  and bl,31
  int $21
END;

FUNCTION SetShowDots(on : BOOLEAN): BYTE; Assembler;
ASM
  mov ax,$E908
  mov bl,[on]
  int $21
END;

FUNCTION ConnectToServer(server : NetStr): BYTE;
VAR
  sn, curr, res, access : BYTE;
  df, ds : DriveTablePtr;
  smap       : ServerMappingPtr;
  sname      : ServerNamePtr;
  drive      : CHAR;
  data       : ARRAY [1..130] OF BYTE;
  snm : NetStr;
BEGIN
  snm := server;
  UpCaseStr(snm);

  df := GetDriveFlagPtr;
  drive := 'A';
  WHILE (drive <= 'Z') AND (df^[drive] <> 1) DO Inc(drive);
  IF drive > 'Z' THEN BEGIN
    ConnectToServer := 2;
    Exit;
  END;

  SetCurDisk(drive);                    { Keep the lowest network disk }

  res := SystemLogout;

  ds := GetDriveServerPtr;
  curr := ds^[drive];

  sname := GetServerNamePtr;
  IF GetString(sname^[curr]) = snm THEN BEGIN
    ConnectToServer := 0;
    Exit;
  END;

  sn := 1;
  IF curr = 1 THEN sn := 2;         { This is the first free slot! }

  smap := GetServerMappingPtr;
  WITH smap^[sn] DO BEGIN
    IF SlotInUse = $FF THEN BEGIN
      ConnectToServer := 3;
      Exit;
    END;

    res := ReadPropertyValue(FILE_SERVER,snm,1,'NET_ADDRESS',data);
    IF res <> 0 THEN BEGIN
      ConnectToServer := res;
      Exit;
    END;
    Move(data,ServerNet,12);

    OrderNumber := 2;
    IF ServerNet < smap^[curr].ServerNet THEN BEGIN
      OrderNumber := 1;
      smap^[curr].OrderNumber := 2;
    END;
    SlotInUse := $FF;
  END;

  Str2AZ(snm,sname^[sn],SizeOf(sname^[sn]));

  res := AttachServerNumber(0,sn);
  IF res <> 0 THEN BEGIN
    ConnectToServer := res;
    Exit;
  END;

{********************************************************************

  Here is a VERY dirty cludge: To persuade the shell to connect to a
  new server, we make believe this is the server for the current drive!
}

  ds^[drive] := sn;               { This drive is served by SERVER }

{*********************************************************************}

  IF SetPreferredServer(sn) <> sn THEN BEGIN
    ConnectToServer := 4;
    Exit;
  END;
  SetPrimaryServer(sn);
  ConnectToServer := SystemLogout;
END;                                    {ConnectToServer}

FUNCTION GetDirectoryRights(path : STRING;VAR rights : WORD): BYTE;
VAR
  q : RECORD
    plen : WORD;
    func : BYTE;
    base : BYTE;
    path : STRING;
  END;
  a : RECORD
    plen : WORD;
    EffRights : BYTE;
  END;
BEGIN
  q.plen := 3 + Length(path);
  q.func := 3;
  q.base := 0;
  q.path := path;
  a.plen := SizeOf(a)-2;
  GetDirectoryRights := CallNetware($E200,q,a);
  rights := a.EffRights;
END;

FUNCTION LoginEnabled(VAR enable : BOOLEAN): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
  rep : RECORD
    plen : WORD;
    eFlag : BOOLEAN;
  END;
BEGIN
  req.plen := 1;
  req.func := $CD;
  rep.plen := 1;
  LoginEnabled := CallNetware($E300,req,rep);
  enable := rep.eFlag;
END;

FUNCTION ChangeLoginStatus(enable : BOOLEAN): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  req.plen := 1;
  req.func := $CB + Ord(enable);
  ChangeLoginStatus := CallNetware($E300,req,NoReply);
END;

FUNCTION GetServerUtilization(VAR util : BYTE):BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
  rep : RECORD
    plen : WORD;
    systicks : Long;
    CpuType : BYTE;
    Fill1 : BYTE;
    ServProcs : BYTE;
    Utilization : BYTE;
    MaxBindery : WORD;
    UsedMaxBindery : WORD;
    UsedBindery : WORD;
    TotalRAM : WORD;
    WasteRAM : WORD;
    Records : WORD;
    DynRAM : ARRAY [1..3] OF RECORD
      Total : LongInt;
      MaxUsed : LongInt;
      CurrUsed : LongInt;
    END;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := $E8;
  rep.plen := SizeOf(rep)-2;
{
  IF rep.plen <> 56 THEN BEGIN
    WriteLn('Reply len = ',rep.plen);
    Halt;
  END;
}
  GetServerUtilization := CallNetware($E300,req,rep);
  util := rep.Utilization
END;

FUNCTION GetFileServerInfo(VAR fsi : FileServerInfo): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 17;
  fsi.plen := SizeOf(fsi)-2;
  GetFileServerInfo := CallNetWare($E300,req,fsi);
END;
(*
FUNCTION Hex2Ch(b : BYTE): WORD;
Inline(
  $58                    { pop ax}
  /$88/$C4               { mov ah,al}
  /$24/$0F               { and al,$F}
  /$27                   { daa}
  /$04/$F0               { add al,$F0}
  /$14/$40               { adc al,$40}
  /$86/$E0               { xchg al,ah}
  /$B1/$04               { mov cl,4}
  /$D2/$E8               { shr al,cl}
  /$24/$0F               { and al,$F}
  /$27                   { daa}
  /$04/$F0               { add al,$F0}
  /$14/$40               { adc al,$40}
);

FUNCTION HexStr(VAR l; len : INTEGER): STRING;
CONST
  MaxLen = 12;
{  HexCh : ARRAY [0..15] OF CHAR = '0123456789ABCDEF'; }
VAR
  b : ARRAY [1..MaxLen] OF BYTE ABSOLUTE l;
  i, p, step : INTEGER;
  st : STRING[MaxLen*2];
  stw : RECORD
    slen : BYTE;
    w : ARRAY [1..MaxLen] OF WORD;
  END ABSOLUTE st;
BEGIN
  IF len > 0 THEN BEGIN
    IF len > MaxLen THEN len := MaxLen;
    p := 1; step := 1;
  END
  ELSE IF len < 0 THEN BEGIN
    len := -len;
    IF len > MaxLen THEN len := MaxLen;
    p := len; step := -1;
  END;

  stw.slen := len * 2;
  FOR i := 1 TO len DO BEGIN
    stw.w[p] := Hex2Ch(b[i]);
    Inc(p,step);
  END;

  HexStr := st;
END;
*)

FUNCTION HexStr(VAR l; len : INTEGER): STRING;
Assembler;
CONST
  MaxLen = 127;
ASM
  push ds
  cld
  mov bx,[len]
  lds si,[l]
  mov dx,1
  or bx,bx
   jz @done
   jg @positive
  neg bx
  neg dx
  lea si,[si+bx-1]
@positive:
  les di,[@result]
  mov byte ptr [es:di],0
  cmp bx,MaxLen
   ja @done
  mov ax,bx
  shl ax,1
  stosb
  mov cl,4
@HexLoop:
  mov al,[si]
  add si,dx
  mov ah,al
  and al,$F
  daa
  add al,$F0
  adc al,$40
  xchg al,ah
  shr al,cl
  and al,$F
  daa
  add al,$F0
  adc al,$40

  stosw

  dec bx
   jnz @HexLoop

@done:
  pop ds
END;

PROCEDURE HexBuf(VAR buf, data; len : INTEGER);
CONST
  MAX = 32;
  HexCh : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
VAR
  b : ARRAY [0..MAX+MAX-1] OF CHAR Absolute buf;
  d : ARRAY [0..MAX-1] OF BYTE Absolute data;
  i, step, ipos, upos : Integer;
BEGIN
  IF len = 0 THEN Exit;
  ipos := 0; upos := 0; step := 1;
  IF len < 0 THEN BEGIN
    len := -len;
    ipos := len-1;
    step := -1;
  END;
  REPEAT
    i := d[ipos];
    Inc(ipos,step);
    b[upos] := HexCh[i Shr 4];
    Inc(upos);
    b[upos] := HexCh[i AND 15];
    Inc(upos);
    Dec(len);
  UNTIL len = 0;
END;

FUNCTION SystemStr(sysid : Long): STRING;
VAR
  id : ARRAY [0..3] OF BYTE ABSOLUTE sysid;
  i : INTEGER;
BEGIN
  i := 0;
  WHILE (i < 3) AND (id[i] = 0) DO Inc(i);
  SystemStr := HexStr(id[i],4-i);
END;

PROCEDURE Str2Az(st : STRING; VAR az; size : INTEGER); Assembler;
ASM
  cld
  push ds
  lds si,[&st]
  les di,[az]
  mov dx,[size]
  xor ax,ax
  lodsb
  mov cx,ax
  cmp cx,dx
   jb @ok
  mov cx,dx
  dec cx
@ok:
  sub dx,cx
  rep movsb
  mov cx,dx
  mov al,0
  rep stosb
  pop ds
END;

FUNCTION Az2Str(VAR az): STRING; Assembler;
ASM
  cld
  push ds
  lds si,[az]
  les di,[@Result]
  mov bx,di
  mov cx,256
@store:
  stosb
  lodsb
  or al,al
   loopnz @store

  mov ch,255
  sub ch,cl
  mov [es:bx],ch
  pop ds
END;

FUNCTION GetString(VAR s):STRING; Assembler;
ASM
  cld
  push ds
  lds si,[s]
  les di,[@Result]
  mov bx,di
  mov cx,256
@store:
  stosb
  lodsb
  or al,al
   loopnz @store

  mov ch,255
  sub ch,cl
  mov [es:bx],ch
  pop ds
END;

PROCEDURE UpcaseStr(VAR s:STRING);
BEGIN
  ASM
    cld
    push ds
    lds si,[s]
    xor ax,ax
    lodsb
    mov cx,ax
     jcxz @done
    mov bx,-1
  @load:
    lodsb
    cmp al,'a'
     jb @next
    cmp al,'z'
     ja @next
    sub al,'a'-'A'
    mov [si+bx],al
  @next:
     loop @load
  @done:
    pop ds
  END;
END;

FUNCTION StrUpr(s:STRING): STRING; Assembler;
ASM
  cld
  push ds
  lds si,[s]
  les di,[@Result]
  xor ax,ax
  lodsb
  stosb
  mov cx,ax
   jcxz @done
@load:
  lodsb
  cmp al,'a'
   jb @next
  cmp al,'z'
   ja @next
  sub al,'a'-'A'
@next:
  stosb
   loop @load
@done:
  pop ds
END;

FUNCTION StrLwr(s:STRING): STRING; Assembler;
ASM
  cld
  push ds
  lds si,[s]
  les di,[@Result]
  xor ax,ax
  lodsb
  stosb
  mov cx,ax
   jcxz @done
@load:
  lodsb
  cmp al,'A'
   jb @next
  cmp al,'Z'
   ja @next
  add al,'a'-'A'
@next:
  stosb
   loop @load
@done:
  pop ds
END;

FUNCTION CreateQueue(QueueType : BYTE; QueueName : NetStr;
                     VAR QueueID : Long): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueType : WORD;
    QueueName : NetStr;
  END;
  Rep : RECORD
    plen : WORD;
    QueueID : Long;
  END;
BEGIN
  Req.plen := 16 + Length(QueueName);
  Req.func := 100;
  Req.QueueType := Swap(QueueType);
  Req.QueueName := QueueName + #0#10'SYS:SYSTEM';
  Req.QueueName[0] := QueueName[0];
  Rep.plen := 4;
  CreateQueue := CallNetWare($E300,Req,Rep);
  QueueID := Rep.QueueID;
END;

FUNCTION DestroyQueue(QueueID : Long): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
  END;
  Rep : RECORD
    plen : WORD;
  END;
BEGIN
  Req.plen := SizeOf(Req)-2;
  Req.func := 101;
  Req.QueueID := QueueID;
  Rep.plen := 0;
  DestroyQueue := CallNetWare($E300,Req,Rep);
END;

FUNCTION ReadQueueStatus(QueueID : Long;
         VAR QueueStatus, CurrentEntries, CurrentServers : BYTE): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
  END;
  Rep : RECORD
    plen : WORD;
    QueueID : Long;
    QueueStatus : BYTE;
    CurrentEntries : BYTE;
    CurrentServers : BYTE;
    CASE BOOLEAN OF
      FALSE : (ServerIDList : ARRAY [0..25] OF Long);
      TRUE  : (ServerStationList : ARRAY [0..129] OF BYTE);
  END;
BEGIN
  Req.plen := SizeOf(Req)-2;
  Req.func := 102;
  Req.QueueID := QueueID;
  Rep.plen := 132;
  ReadQueueStatus := CallNetWare($E300,Req,Rep);
  QueueStatus := Rep.QueueStatus;
  CurrentEntries := Rep.CurrentEntries;
  CurrentServers := Rep.CurrentServers;
END;

FUNCTION CreateQueueJob(QueueID : Long; VAR JobRec : Job): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
    j : Job;
  END;
  Rep : RECORD
    plen : WORD;
    j : Job;
  END;
BEGIN
  Req.plen := SizeOf(Req)-2;
  Req.func := 104;
  Req.QueueID := QueueID;
  Req.j := JobRec;
  Rep.plen := SizeOf(Rep)-2;
  CreateQueueJob := CallNetWare($E300,Req,Rep);
  JobRec := Rep.j;
END;

FUNCTION StartQueueJob(QueueID : Long; JobNumber : WORD): BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 7;
  Req.func := 105;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := 0;
  StartQueueJob := CallNetware($E300,Req,Rep);
END;


FUNCTION RemoveJobFromQueue(QueueID : Long; JobNumber : WORD) : BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 7;
  Req.func := 106;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := SizeOf(Rep) - 2;
  RemoveJobFromQueue := CallNetware($E300,Req,Rep);
END;

FUNCTION GetListOfJobs(QueueID : Long;
                       VAR NrofJobs : WORD; VAR Jobs : JobList ) : BYTE;
VAR
  Req : JobReqType;
  Rep : RECORD
    plen : WORD;
    JobCount : WORD;
    JobNumber : JobList;
  END;
BEGIN
  Req.plen := 5;
  Req.func := 107;
  Req.QueueID := QueueID;
  Rep.plen := SizeOf(Rep) - 2;
  GetListOfJobs := CallNetware($E300,Req,Rep);
  NrOfJobs := Rep.JobCount;
  Jobs := Rep.JobNumber;
END;

FUNCTION ReadJobQueueEntry(QueueID : Long; JobNumber : WORD;
                           VAR JobReturn : Job): BYTE;
VAR
  Req : JobReqType;
  Rep : RECORD
    plen : WORD;
    j : Job;
  END;
BEGIN
  Req.plen := 7;
  Req.func := 108;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := SizeOf(Rep) - 2;
  ReadJobQueueEntry := CallNetware($E300,Req,Rep);
  JobReturn := Rep.j;
END;

FUNCTION ChangeJobQueueEntry(QueueID : Long; J : Job): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
    j : Job;
  END;
  Rep : JobRepType;
BEGIN
  Req.plen := SizeOf(Req)-2;
  Req.func := 109;
  Req.QueueID := QueueID;
  Rep.plen := 0;
  ChangeJobQueueEntry := CallNetware($E300,Req,Rep);
END;

FUNCTION ChangeJobQueuePosition(QueueID : Long; JobNumber : WORD;
                            NewPosition : BYTE) : BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : Long;
    JobNumber : WORD;
    NewPosition : BYTE;
  END;
  Rep : JobRepType;
BEGIN
  Req.plen := SizeOf(Req) - 2;
  Req.func := 110;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Req.NewPosition := NewPosition;
  Rep.plen := 0;
  ChangeJobQueuePosition := CallNetware($E300,Req,Rep);
END;

FUNCTION AttachServerToQueue(QueueID : Long): BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 5;
  Req.func := 111;
  Req.QueueID := QueueID;
  Rep.plen := 0;
  AttachServerToQueue := CallNetware($E300,Req,Rep);
END;

FUNCTION DetachServerFromQueue(QueueID : Long): BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 5;
  Req.func := 112;
  Req.QueueID := QueueID;
  Rep.plen := 0;
  DetachServerFromQueue := CallNetware($E300,Req,Rep);
END;

FUNCTION ServiceQueueJob(QueueID : Long; TargetServiceType : BYTE;
                         VAR JobReturn : Job): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : LONG;
    TargetServiceType : WORD;
  END;
  Rep : RECORD
    plen : WORD;
    j    : Job;
  END;
BEGIN
  Req.plen := 7;
  Req.func := 113;
  Req.QueueID := QueueID;
  Req.TargetServiceType := TargetServiceType;
  Rep.plen := 54;
  ServiceQueueJob := CallNetware($E300,Req,Rep);
  JobReturn := Rep.j;
END;

FUNCTION FinishServicingJob(QueueID : Long; JobNumber : WORD;
                            Charge : Long ): BYTE;
VAR
  Req : RECORD
    plen : WORD;
    func : BYTE;
    QueueID : LONG;
    JobNumber : WORD;
    Charge : Long;
  END;
  Rep : JobRepType;
BEGIN
  Req.plen := 11;
  Req.func := 114;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Req.Charge := Charge;
  Rep.plen := 0;
  FinishServicingJob := CallNetware($E300,Req,Rep);
END;

FUNCTION AbortServicingJob(QueueID : Long; JobNumber : WORD): BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 7;
  Req.func := 115;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := 0;
  AbortServicingJob := CallNetware($E300,Req,Rep);
END;

FUNCTION GetClientRights(QueueID : Long; JobNumber : WORD): BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 7;
  Req.func := 116;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := 0;
  GetClientRights := CallNetware($E300,Req,Rep);
END;

FUNCTION RestoreServerRights: BYTE;
VAR
  Req : JobReqType;
  Rep : JobRepType;
BEGIN
  Req.plen := 1;
  Req.func := 117;
  Rep.plen := 0;

  RestoreServerRights := CallNetware($E300,Req,Rep);
END;

FUNCTION GetJobQueueEntryFileSize(QueueID : Long; JobNumber : WORD;
                                  VAR FileSize : Long): BYTE;
VAR
  Req : JobReqType;
  Rep : RECORD
    plen : WORD;
    QueueID : Long;
    JobNumber : WORD;
    FileSize : Long;
  END;
BEGIN
  Req.plen := 7;
  Req.func := 120;
  Req.QueueID := QueueID;
  Req.JobNumber := JobNumber;
  Rep.plen := 10;
  GetJobQueueEntryFileSize := CallNetware($E300,Req,Rep);
  FileSize := Rep.FileSize;
END;

FUNCTION MapObjectToConnectionSet(ObjectType : WORD;ObjectName : NetStr;
                         VAR ConnSet : STRING): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    name : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    cset : STRING;
  END;
BEGIN
  req.func := 21;      {Get an object's connection set}
  req.otype := Swap(ObjectType);
  req.name := ObjectName;
  req.plen := Length(ObjectName) + 4;
  rep.plen := SizeOf(rep) - 2;
  MapObjectToConnectionSet := CallNetware($E300,req,rep);
  ConnSet := rep.cset;
END;

FUNCTION MapNameToNumber(ObjectType : WORD;ObjectName : NetStr;
                         VAR ObjectID : Long): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    name : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    objID : Long;
    otype : WORD;
    name : ARRAY [1..48] OF CHAR;
  END;
BEGIN
  req.func := 53;      {Get an object's number}
  req.otype := Swap(ObjectType);
  req.name := ObjectName;
  req.plen := Length(ObjectName) + 4;
  rep.plen := SizeOf(rep) - 2;
  MapNameToNumber := CallNetware($E300,req,rep);
  ObjectID := rep.objID;
END;

Function GetBinderyObjectId(ObjectType : WORD;ObjectName : NetStr;
                         VAR ObjectID : Long): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    name : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    objID : Long;
    otype : WORD;
    name : ARRAY [1..48] OF CHAR;
  END;
BEGIN
  req.func := 53;      {Get an object's number}
  req.otype := Swap(ObjectType);
  req.name := ObjectName;
  req.plen := Length(ObjectName) + 4;
  rep.plen := SizeOf(rep) - 2;
  GetBinderyObjectId := CallNetware($E300,req,rep);
  ObjectID := rep.objID;
END;


FUNCTION MapNumberToName(ID : Long; VAR Name; VAR Otype : WORD):BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    OID  : Long;
  END;
  rep : RECORD
    plen : WORD;
    OID  : Long;
    otyp : WORD;
    Oname : ARRAY [1..48] OF CHAR;
  END;
  nam : NetStr ABSOLUTE Name;
BEGIN
  req.func := 54;      {Get an object's name}
  req.OID := ID;
  req.plen := SizeOf(req) - 2;
  rep.plen := SizeOf(rep) - 2;
  MapNumberToName := CallNetware($E300,req,rep);
  Nam := GetString(rep.OName);
  Otype:= Swap(rep.Otyp);
END;

FUNCTION CreateBinderyObject(flags: FlagsType; security : BYTE;
                            OType : WORD;
                            Name:NetStr): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    flags: BYTE;
    security : BYTE;
    OType : WORD;
    name : NetStr;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.plen := Length(name) + 6;
  req.func := 50;
  req.flags := Ord(flags);
  req.security := security;
  req.OType := Swap(OType);
  req.name := name;
  rep.plen := SizeOf(rep) - 2;
  CreateBinderyObject := CallNetware($E300,req,rep);
END;

FUNCTION ScanBinderyObjects(Search : NetStr;
                            VAR ObjectID : Long;
                            VAR Name:NetStr;
                            VAR OType:WORD): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    LastObjSeen : Long;
    PatternType : INTEGER;
    Scan : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    objID : Long;
    otype : WORD;
    name : ARRAY [1..48] OF CHAR;
    ObjectFlags : BYTE;
    ObjectSecurity : BYTE;
    PropertiesExist : BYTE;
  END;
BEGIN
  req.func := 55;
  req.LastObjSeen := ObjectID;
  req.PatternType := Swap(OType);
  req.Scan := Search;
  req.plen := Length(Search)+8;
  rep.plen := SizeOf(rep) - 2;
  ScanBinderyObjects := CallNetware($E300,req,rep);
  ObjectID := rep.objID;
  Name := GetString(rep.name);
  Otype := Swap(rep.otype);
END;

FUNCTION ScanBinderyObject(Search : NetStr; oid : Long; ot : WORD;
                VAR sbi : ScanBinderyInfo): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    LastObjSeen : Long;
    PatternType : INTEGER;
    Scan : NetStr;
  END;
BEGIN
  req.func := 55;
  req.LastObjSeen := oid;
  req.PatternType := Swap(ot);
  req.Scan := Search;
  req.plen := Length(Search)+8;
  sbi.plen := SizeOf(sbi) - 2;
  ScanBinderyObject := CallNetware($E300,req,sbi);
  sbi.OType := Swap(sbi.OType);
END;

FUNCTION ScanProperties(ObjectType : WORD; ObjectName, Pattern : NetStr;
                        VAR Property : NetStr; VAR PropertyID : Long): BYTE;
VAR
  IDStr : ARRAY [1..4] OF CHAR ABSOLUTE PropertyID;

  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
    PropName : ARRAY [1..16] OF CHAR;
    PropFlags : BYTE;
    PropSecurity : BYTE;
    PropID : Long;
    ValueAvail : BYTE;
    MoreProp : BYTE;
  END;

BEGIN
  req.func := 60;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Pattern) + 9;
  req.filler := ObjectName + IDStr +
                Char(Length(Pattern)) +
                Pattern;
  req.filler[0] := Char(Length(ObjectName));
  rep.plen := SizeOf(rep) - 2;
  ScanProperties := CallNetware($E300,req,rep);
  Property := GetString(rep.PropName);
  PropertyID := rep.PropID;
END;

FUNCTION ReadPropertyValue(ObjectType : WORD; ObjectName : NetStr;
                        Segnr : BYTE; Property : NetStr;
                        VAR item): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
    Data : ARRAY [1..128] OF BYTE;
    More : BYTE;
    PropFlags : BYTE;
  END;

BEGIN
  req.func := 61;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Property) + 6;
  req.filler := ObjectName + Char(Segnr) +
                Char(Length(Property)) +
                Property;
  req.filler[0] := Char(Length(ObjectName));
  rep.plen := SizeOf(rep) - 2;
  ReadPropertyValue := CallNetware($E300,req,rep);
  Move(rep.data,item,SizeOf(rep.data)+2);
END;

FUNCTION WritePropertyValue(ObjectType : WORD; ObjectName : NetStr;
                        Segnr : BYTE; More : BOOLEAN; Property : NetStr;
                        VAR item): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
  END;
  m, l : BYTE;
BEGIN
  req.func := $3E;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Property) + 7 + 128;
  m := 0; IF More THEN m := $FF;
  req.filler := ObjectName;
  l := Length(ObjectName)+1;
  req.filler[l] := CHAR(SegNr); Inc(l);
  req.filler[l] := CHAR(m); Inc(l);
  Move(property,req.filler[l],Length(Property)+1);
  Inc(l,Length(Property)+1);
  Move(item,req.filler[l],128);

  rep.plen := SizeOf(rep) - 2;
  WritePropertyValue := CallNetware($E300,req,rep);
END;

FUNCTION GetTrusteePath(volnr : BYTE; ObjID : LONG; VAR NextSequence : WORD;
                        VAR access : BYTE; VAR path : STRING): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    vol : BYTE;
    LastSeq : WORD;
    ID : Long;
  END;
  rep : RECORD
    plen : WORD;
    NextSeq : WORD;
    ID : Long;
    access : BYTE;
    path : STRING;
  END;

BEGIN
  req.func := 71;
  req.vol := volnr;
  req.plen := SizeOf(req)-2;
  req.LastSeq := NextSequence;
  req.ID := ObjID;
  rep.plen := SizeOf(rep) - 2;
  GetTrusteePath := CallNetware($E300,req,rep);
  access := rep.access;
  path := rep.path;
  NextSequence := rep.nextSeq;
END;

FUNCTION AddMembertoProperty(ObjectType : WORD; ObjectName : NetStr;
                             Property : NetStr; MemberType : WORD;
                             Member : NetStr ): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.func := 65;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Property) +
              Length(Member) + 8 ;
  req.filler := ObjectName +
                Char(Length(Property)) +
                Property +
                Char(Hi(MemberType)) + Char(Lo(MemberType)) +
                Char(Length(Member)) + Member;
  req.filler[0] := Char(Length(ObjectName));
  rep.plen := SizeOf(rep) - 2;
  AddMembertoProperty := CallNetware($E300,req,rep);
END;

FUNCTION AddPropertytoObject(ObjectType : WORD; ObjectName : NetStr;
                             PropertyFlags : FlagsType;
                             PropertySecurity : BYTE;
                             Property : NetStr ): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.func := 57;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Property) + 7;
  req.filler := ObjectName +
                Char(PropertyFlags) + Char(PropertySecurity) +
                Char(Length(Property)) +
                Property ;
  req.filler[0] := Char(Length(ObjectName));
  rep.plen := SizeOf(rep) - 2;
  AddPropertytoObject:= CallNetware($E300,req,rep);
END;

FUNCTION ChangePropertySecurity(ObjectType : WORD; ObjectName : NetStr;
                             PropertySecurity : BYTE;
                             Property : NetStr ): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    Filler : STRING;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.func := 59;
  req.otype := Swap(ObjectType);
  req.plen := Length(ObjectName) +
              Length(Property) + 6;
  req.filler := ObjectName +
                Char(PropertySecurity) +
                Char(Length(Property)) +
                Property ;
  req.filler[0] := Char(Length(ObjectName));
  rep.plen := SizeOf(rep) - 2;
  ChangePropertySecurity := CallNetware($E300,req,rep);
END;

FUNCTION ChangeObjectSecurity(ObjectType : WORD; ObjectName : NetStr;
                             Security : BYTE): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    security : BYTE;
    otype : WORD;
    name : STRING;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.func := $38;
  req.otype := Swap(ObjectType);
  req.security := security;
  req.plen := Length(ObjectName) + 5;
  req.name := ObjectName;

  rep.plen := SizeOf(rep) - 2;
  ChangeObjectSecurity := CallNetware($E300,req,rep);
END;

{
PROCEDURE GetShellTableAddresses(f:BYTE;VAR rep:Pointer);
BEGIN
  ASM
    mov ah,$EF
    mov al,[f]
    int $21
    mov dx,es
    les di,[rep]
    mov [es:di],si
    mov [es:di+2],dx
  END;
END;
}

FUNCTION GetServerName(n : BYTE):NetStr;
VAR
  t : ServerNamePtr;
  m : ServerMappingPtr;
  i : INTEGER;
BEGIN
  GetServerName := '';
  m := GetServerMappingPtr;
  IF (n >= 1) AND (n <= MAXSERVERS) AND (m^[n].SlotInUse = $FF) THEN BEGIN
    t := GetServerNamePtr;
    GetServerName := GetString(t^[n]);
  END;
END;

FUNCTION GetServerNumber(s:NetStr):BYTE;
VAR
  t : ServerNamePtr;
  m : ServerMappingPtr;
  i : INTEGER;
  sname : NetStr;
BEGIN
  sname := s;
  m := GetServerMappingPtr;
  t := GetServerNamePtr;
  UpCaseStr(sname);
  FOR i:=1 TO MAXSERVERS DO BEGIN
    IF (m^[i].SlotInUse=$FF) AND (GetString(t^[i])=sname) THEN BEGIN
      GetServerNumber:=i;
      Exit;
    END;
  END;
  GetServerNumber:=0;
END;

PROCEDURE SetErrorMode(mode:BYTE); Assembler;
ASM
  mov ax,$DD00
  mov dl,[mode]
  int $21
END;

FUNCTION GetPreferredServer:BYTE; Assembler;
ASM
  mov ax,$F001
  int $21
END;

FUNCTION SetPreferredServer(sno:BYTE): BYTE; Assembler;
ASM
  mov ax,$f000
  mov dl,[sno]
  int $21           { Set preferred}
  mov ax,$f001
  int $21           { Get preferred to check}
END;

FUNCTION GetEffectiveServer:BYTE; Assembler;
ASM
  mov ax,$f002
  int $21
END;

PROCEDURE SetPrimaryServer(sno:BYTE); Assembler;
ASM
  mov ax,$F004
  mov dl,[sno]
  int $21
END;

FUNCTION GetPrimaryServer:BYTE; Assembler;
ASM
  mov ax,$f005
  int $21
END;

FUNCTION GetCurrentServer: BYTE; Assembler;
ASM
  mov ax,$F001
  int 21h               { Get Preferred server}
  or al,al
   jnz @done            { Use it if set }
  mov ax,$ef02
  int 21h               { Get Drive server ptr in ES:SI}
  mov bx,si
  mov ah,19h
  int 21h               { Get current disk (in AL) }
  seges xlat            { Convert to server # }
  or al,al
   jnz @done            { Use if a NetWare server }
  mov ax,$F005
  int 21h               { Get Primary Server}
@done:
END;

FUNCTION LoginAnObject( Name:NetStr; Otype:WORD; Passw: NetStr):BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    NamePass : STRING[96];
  END;
  rep : RECORD
    plen : WORD;
  END;
  pw : NetStr;
BEGIN
  pw := passw;
  req.plen := 5 + Length(Name) + Length(Passw);
  req.func := 20;
  UpCaseStr(pw);
  req.otype := Swap(otype);
  req.NamePass:=Name;
  UpCaseStr(req.NamePass);
  Move(pw,req.NamePass[Length(Name)+1],Length(Passw)+1);
  rep.plen := 0;
  LoginAnObject := CallNetware($E300,req,rep);
END;

FUNCTION VerifyAnObject( Name:NetStr; Otype:WORD; Passw: NetStr):BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    otype : WORD;
    NamePass : STRING[96];
  END;
  rep : RECORD
    plen : WORD;
  END;
  pw : NetStr;
BEGIN
  pw := Passw;
  req.plen := 5 + Length(Name) + Length(Passw);
  req.func := $3F;
  UpCaseStr(pw);
  req.otype := Swap(otype);
  req.NamePass:=Name;
  UpcaseStr(req.NamePass);
  Move(pw,req.NamePass[Length(Name)+1],Length(Passw)+1);
  rep.plen := 0;
  VerifyAnObject := CallNetware($E300,req,rep);
END;

FUNCTION LoginUser(Name, Passw: NetStr):BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    NamePass : STRING[96];
  END;
  rep : RECORD
    plen : WORD;
  END;
  pw : NetStr;
BEGIN
  pw := passw;
  req.plen := 3 + Length(Name) + Length(pw);
  req.func := 0;
  UpCaseStr(pw);
  req.NamePass:=Name;
  UpcaseStr(req.NamePass);
  Move(pw,req.NamePass[Length(Name)+1],Length(pw)+1);
  rep.plen := 0;
  LoginUser := CallNetware($E300,req,rep);
END;

FUNCTION GetBinderyAccessLevel(VAR BinAcc : BinderyAccessReply): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 70;
  BinAcc.plen := SizeOf(BinAcc)-2;
  GetBinderyAccessLevel := CallNetware($E300,req,BinAcc);
END;

FUNCTION GetMyBinderyAccessLevel(VAR access : BYTE): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
  rep : RECORD
    plen : WORD;
    access : BYTE;
    MyObjectID : LongInt;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 70;
  rep.plen := SizeOf(rep)-2;
  GetMyBinderyAccessLevel := CallNetware($E300,req,rep);
  access := rep.access;
END;

FUNCTION InsertServer(Name : NetStr; VAR sn : BYTE):BYTE;
VAR
  MapPtr : ServerMappingPtr;
  NamePtr : ServerNamePtr;
  res : BYTE;
  free, i : INTEGER;
  data : ARRAY [1..130] OF BYTE;
  sname : NetStr;

  FUNCTION LowerAddr(VAR a, b): BOOLEAN;
  TYPE
    Net_Address = ARRAY [1..10] OF CHAR;
  VAR
    a_addr : Net_Address ABSOLUTE a;
    b_addr : Net_Address ABSOLUTE b;
  BEGIN
    LowerAddr := a_addr < b_addr;
  END;

BEGIN
  sname := name;
  UpCaseStr(sname);
  res := GetServerNumber(sname);
  IF res <> 0 THEN BEGIN
    InsertServer:=0;
    sn := res;
    Exit;
  END;

  res := ReadPropertyValue(FILE_SERVER,sname,1,'NET_ADDRESS',data);
  IF res <> 0 THEN BEGIN
    InsertServer := res;
    Exit;
  END;

  MapPtr := GetServerMappingPtr;
  free := 1;
  WHILE (MapPtr^[free].SlotInUse = $FF) DO BEGIN
    Inc(free);
    IF free > MAXSERVERS THEN BEGIN
      InsertServer := $7C;
      Exit;
    END;
  END;

  NamePtr := GetServerNamePtr;
  WITH MapPtr^[free] DO BEGIN
    Move(data,ServerNet,12);

    Str2Az(sname,NamePtr^[free],SizeOf(NamePtr^[free]));

    OrderNumber := 1;
    FOR i := 1 TO MAXSERVERS DO BEGIN
      IF MapPtr^[i].SlotInUse = $FF THEN BEGIN
        IF LowerAddr(MapPtr^[i].ServerNet,ServerNet) THEN
          Inc(OrderNumber)
        ELSE
          Inc(MapPtr^[i].OrderNumber);
      END;
    END;
    SlotInUse := $FF;
  END;
  InsertServer := 0;
  sn := free;
END;

FUNCTION AttachServerNumber(func : BYTE; sn : BYTE) : BYTE; ASSEMBLER;
ASM
  mov ah,$F1
  mov al,[func]
  mov dl,[sn]
  int $21
END;

FUNCTION AttachServer(func : BYTE; name : NetStr) : BYTE;
VAR
  sn : BYTE;
BEGIN
  sn := GetServerNumber(name);
  IF sn = 0 THEN BEGIN
    AttachServer := $7B;
    Exit;
  END;
  AttachServer := AttachServerNumber(func,sn);
END;

TYPE
  Buf32 = ARRAY [0..31] OF BYTE;
  Buf16 = ARRAY [0..15] OF BYTE;
  Buf8  = ARRAY [0..7]  OF BYTE;
  Buf4  = ARRAY [0..3]  OF BYTE;

FUNCTION GetEncryptionKey(VAR key : Buf8): BYTE;
VAR
  q : RECORD
    plen : WORD;
    func : BYTE;
  END;
BEGIN
  q.plen := 1;
  q.func := $17;
  GetEncryptionKey := FileServiceRequest($F217,q,SizeOf(q),key,SizeOf(key));
END;

FUNCTION LoginEncrypted(name : NetStr; otype : WORD; VAR key : Buf8): BYTE;
VAR
  a : RECORD
    plen : WORD;
    func : BYTE;
    key  : Buf8;
    otyp : WORD;
    name : NetStr;
  END;
BEGIN
  a.plen := Length(name) + 12;
  a.func := $18;
  a.key  := key;
  a.otyp := Swap(otype);
  a.name := name;
  LoginEncrypted := FileServiceRequest($F217,a,a.plen+2,Mem[0:0],0);
END;

FUNCTION VerifyEncrypted(name : NetStr; otype : WORD; VAR key : Buf8): BYTE;
VAR
  a : RECORD
    plen : WORD;
    func : BYTE;
    key  : Buf8;
    otyp : WORD;
    name : NetStr;
  END;
BEGIN
  a.plen := Length(name) + 12;
  a.func := 74;
  a.key  := key;
  a.otyp := Swap(otype);
  a.name := name;
  VerifyEncrypted := FileServiceRequest($F217,a,a.plen+2,Mem[0:0],0);
END;

{
CONST
  SubstTable : ARRAY [BYTE] OF BYTE =
($7,$8,$0,$8,$6,$4,$E,$4,$5,$C,$1,$7,$B,$F,$A,$8,
 $F,$8,$C,$C,$9,$4,$1,$E,$4,$6,$2,$4,$0,$A,$B,$9,
 $2,$F,$B,$1,$D,$2,$1,$9,$5,$E,$7,$0,$0,$2,$6,$6,
 $0,$7,$3,$8,$2,$9,$3,$F,$7,$F,$C,$F,$6,$4,$A,$0,
 $2,$3,$A,$B,$D,$8,$3,$A,$1,$7,$C,$F,$1,$8,$9,$D,
 $9,$1,$9,$4,$E,$4,$C,$5,$5,$C,$8,$B,$2,$3,$9,$E,
 $7,$7,$6,$9,$E,$F,$C,$8,$D,$1,$A,$6,$E,$D,$0,$7,
 $7,$A,$0,$1,$F,$5,$4,$B,$7,$B,$E,$C,$9,$5,$D,$1,
 $B,$D,$1,$3,$5,$D,$E,$6,$3,$0,$B,$B,$F,$3,$6,$4,
 $9,$D,$A,$3,$1,$4,$9,$4,$8,$3,$B,$E,$5,$0,$5,$2,
 $C,$B,$D,$5,$D,$5,$D,$2,$D,$9,$A,$C,$A,$0,$B,$3,
 $5,$3,$6,$9,$5,$1,$E,$E,$0,$E,$8,$2,$D,$2,$2,$0,
 $4,$F,$8,$5,$9,$6,$8,$6,$B,$A,$B,$F,$0,$7,$2,$8,
 $C,$7,$3,$A,$1,$4,$2,$5,$F,$7,$A,$C,$E,$5,$9,$3,
 $E,$7,$1,$2,$E,$1,$F,$4,$A,$6,$C,$6,$F,$4,$3,$0,
 $C,$0,$3,$6,$F,$8,$7,$B,$2,$D,$C,$6,$A,$A,$8,$D);
}

CONST
  SubstByte : ARRAY [0..127] OF BYTE = (
  $87,$80,$46,$4E,$C5,$71,$FB,$8A,$8F,$CC,$49,$E1,$64,$42,$A0,$9B,
  $F2,$1B,$2D,$91,$E5,$07,$20,$66,$70,$83,$92,$F3,$F7,$FC,$46,$0A,
  $32,$BA,$8D,$A3,$71,$FC,$81,$D9,$19,$49,$4E,$5C,$C5,$B8,$32,$E9,
  $77,$96,$FE,$8C,$1D,$6A,$DE,$70,$A7,$10,$5F,$B4,$B7,$CE,$59,$1D,
  $DB,$31,$D5,$6E,$03,$BB,$3F,$46,$D9,$3A,$41,$49,$38,$EB,$05,$25,
  $BC,$5D,$5D,$2D,$9D,$CA,$0A,$3B,$35,$96,$15,$EE,$E0,$28,$2D,$02,
  $F4,$58,$69,$68,$AB,$FB,$70,$82,$7C,$A3,$41,$52,$7F,$CA,$5E,$39,
  $7E,$21,$1E,$4F,$6A,$6C,$4F,$03,$0C,$63,$8F,$B7,$D2,$6C,$AA,$D8);

CONST
  data_9e : Buf32 =
($48,$93,$46,$67,$98,$3D,$E6,$8D,$B7,$10,$7A,$26,$5A,$B9,$B1,$35,
 $6B,$0F,$D5,$70,$AE,$FB,$AD,$11,$F4,$47,$DC,$A7,$EC,$CF,$50,$C0);

PROCEDURE Shuffle1(VAR temp : Buf32; VAR target : Buf16);
VAR
  t : Buf16;
{
  b4, b3 : BYTE;
  s, d, b2, i : WORD;
}
CONST
  T_SIZE = SizeOf(t);
BEGIN
{
  b4 := 0;
  FOR b2 := 0 TO 1 DO BEGIN
    FOR s := 0 TO 31 DO BEGIN
      b3 := Lo(Lo(temp[s] + b4) XOR
            Lo(temp[(s + b4) AND 31] - data_9e[s]));
      Inc(b4,b3);
      temp[s] := b3;
    END;
  END;
}
  ASM
    cld
    les di,[temp]
    mov dx,200h         { b2 = 2, b4 = 0 }
  @l1:
    xor cx,cx
  @l2:
    mov bx,cx; add bl,dl; and bl,31;
    mov al,[es:di+bx]                   { temp[(s + b4) AND 31] }
    mov bx,cx; sub al,byte ptr data_9e[bx]
    mov ah,[es:di+bx]; add ah,dl        { temp[s] + b4 }
    xor al,ah; add dl,al                { Inc(b4,b3) }
    mov [es:di+bx],al

    inc cx
    cmp cl,32
     jb @l2

    dec dh
     jnz @l1
  END;

{
  FOR i := 0 TO 15 DO
    t[i] := SubstTable[temp[i Shl 1]] OR
           (SubstTable[temp[i Shl 1 +1]] Shl 4);
  Move(t,target,SizeOf(t));
}

  ASM
   push bp
    les si,[temp]; lea bx,[SubstByte]; lea bp,[t]; mov cx,1004h; cld
  @l1:
    seges lodsw; shr al,1; xlat
     jnc @ok1
    shr al,cl
  @ok1:
    xchg al,ah; shr al,1; xlat
     jc @ok2
    shl al,cl
  @ok2:
    and ax,0FF0h; or al,ah; mov [bp],al; inc bp
    dec ch
     jnz @l1
   pop bp

   push ds
    push ss; pop ds; lea si,[t]; les di,[target]; mov cx,T_SIZE Shr 1
    rep movsw
   pop ds
  END;
END;

PROCEDURE Shuffle(tl : Long; VAR buf; buflen : WORD; VAR target : Buf16);
VAR
  b : ARRAY [0..127] OF BYTE ABSOLUTE buf;
  save : WORD;
  temp : Buf32;
  templ: ARRAY [0..7] OF Long ABSOLUTE temp;
  s, d : WORD;
  tb : BYTE;
BEGIN
{$IFNDEF USEASM}
  FillChar(temp,SizeOf(temp),#0);

  WHILE (buflen > 0) AND (b[buflen-1] = 0) DO
    Dec(buflen);

  d := 0;
  WHILE buflen - d >= 32 DO BEGIN
    FOR s := 0 TO 31 DO BEGIN
      temp[s] := temp[s] XOR b[d];
      Inc(d);
    END;
  END;

  IF buflen > d THEN BEGIN
    save := d;
    FOR s := 0 TO 31 DO BEGIN
      tb := b[d];
      Inc(d);
      IF d > buflen THEN BEGIN
        d := save;
        tb := data_9e[s];
      END;
      temp[s] := temp[s] XOR tb;
    END;
  END;

  FOR s := 0 TO 7 DO
    templ[s] := templ[s] XOR tl;

{$ELSE}
  ASM
    cld; push ss; pop es; lea di,[temp]; mov cx,16; xor ax,ax; rep stosw

    les si,[buf]; mov bx,[buflen]
  @b1:
    or bx,bx
     jz @b2
    dec bx
    cmp [es:si+bx],al
     jz @b1
    inc bx
  @b2:
    mov dx,bx

     jmp @trysub

  @c1:
    mov cx,16
  @c2:
    seges lodsw; xor [ss:di],ax; add di,2; loop @c2
  @trysub:
    lea di,[temp]; sub dx,32
     jae @c1

    add dx,32
     jz @d3

    add dx,si
    mov cx,si
  @d1:
    seges lodsb
    cmp si,dx
     jbe @d2
    mov bx,di
    sub bx,offset temp
    mov al,byte ptr data_9e[bx]
    mov si,cx
  @d2:
    xor [ss:di],al
    inc di
    cmp di, offset temp + 32
     jb @d1
  @d3:
    lea di,[temp]
    mov ax,word ptr [tl]
    mov dx,word ptr [tl+2]
    mov cx,8
  @l1:
    xor [es:di],ax
    xor [es:di+2],dx
    add di,4
     loop @l1
  END;
{$ENDIF}
  Shuffle1(temp, target);
END;

PROCEDURE Encrypt(VAR fra : Buf8; VAR buf : Buf16; VAR til : Buf8);
VAR
  f : ARRAY [0..1] OF Long ABSOLUTE fra;
  k : Buf32;
  k16 : ARRAY [0..1] OF Buf16 ABSOLUTE k;
{
  s : WORD;
}
BEGIN
  Shuffle(f[0], buf, 16, k16[0]);
  Shuffle(f[1], buf, 16, k16[1]);
{
  FOR s := 0 TO 15 DO
    k[s] := k[s] XOR k[31-s];
}
  ASM
   push ds
    push ss; pop ds; lea bx,[k]; lea si,[bx+31]; mov cx,16; std
  @l1:
    lodsb; xor [bx],al; inc bx; loop @l1
{
  FOR s := 0 TO 7 DO
    til[s] := k[s] XOR k[15-s];
}
    cld; lea si,[k]; lea bx,[si+15]; les di,[til]; mov cl,8
  @l2:
    lodsb; xor al,[bx]; dec bx; stosb; loop @l2
   pop ds
  END;
END;

Function GetSignMode(var mode : Long): byte;
assembler;
asm
  mov ax,0b301h
  push bp
  int 21h
  pop bp
  or al,al
   jnz @done
  les di,[mode]
  mov es:[di],cx
  mov es:[di+2],bx
@done:
end;

Function SetSignMode(mode : Long): byte;
assembler;
asm
  mov cx,word ptr [mode]
  mov bx,word ptr [mode+2]
  mov ax,0b304h
  int 21h
end;

Type
  SignCode = array [0..24] of byte;

Function SetSignCode(server : Word; var sc : SignCode): Byte;
assembler;
asm
  mov cx,[server]
  push ds
  lds si,[sc]
  mov ax,0b302h
  int 21h
  pop ds
end;

FUNCTION LoginToFileServer(server: Byte; name: NetStr; otype: WORD; passw: STRING): BYTE;
VAR
  key : Buf8;
  id  : LongInt;
  buf : Buf16;
  res : BYTE;
  sc  : SignCode;
  mode, newmode: Long;

BEGIN
  UpCaseStr(passw);
  res := GetEncryptionKey(key);
  IF res = 0 THEN BEGIN
    Move(key,sc[16],8);
    res := MapNameToNumber(otype, name, id);
    IF res = 0 THEN BEGIN
      Shuffle(id, passw[1], Length(passw), buf);
      Move(buf,sc,16);
      Encrypt(key, buf, key);
      GetSignMode(mode);
      res := LoginEncrypted(name, otype, key);
      if res <> 0 then begin
        newmode := 0;
        case res of
          $BD : newmode := $80008;
          $BB : newmode := $40004;
          $BC : newmode := $20002;
        end;
        if newmode <> 0 then begin
          SetSignMode(newmode);

          res := GetEncryptionKey(key);
          if res = 0 then begin
            Move(key,sc[16],8);
            Encrypt(key, buf, key);
            res := LoginEncrypted(name, otype, key);
          end;
          SetSignMode(mode);
        end;
      end;
      if res = 0 then
        SetSignCode(server,sc);
    END;
  END
  ELSE
    res := LoginAnObject(name, otype, passw);

  LoginToFileServer := res;
END;

{
FUNCTION LoginToFileServer(server: Byte; name: NetStr; otype: WORD; passw: STRING): BYTE;
VAR
  key : Buf8;
  id  : Long;
  buf : Buf16;
  res : BYTE;
  pw  : String;
BEGIN
  pw := passw;
  UpCaseStr(pw);
  res := GetEncryptionKey(key);
  IF res = 0 THEN BEGIN
    res := MapNameToNumber(otype, name, id);
    IF res = 0 THEN BEGIN
      Shuffle(id, pw[1], Length(pw), buf);
      Encrypt(key, buf, key);
      res := LoginEncrypted(name, otype, key);
    END;
  END
  ELSE
    res := LoginAnObject(name, otype, passw);

  LoginToFileServer := res;
END;
}

FUNCTION VerifyBinderyObjectPassword(otype : WORD;name : NetStr;
                                     passw : STRING): BYTE;
VAR
  key : Buf8;
  id  : Long;
  buf : Buf16;
  res : BYTE;
  pw  : String;
BEGIN
  pw := passw; 
  UpCaseStr(pw);
  res := GetEncryptionKey(key);
  IF res = 0 THEN BEGIN
    res := MapNameToNumber(otype, name, id);
    IF res = 0 THEN BEGIN
      Shuffle(id, pw[1], Length(pw), buf);
      Encrypt(key, buf, key);
      res := VerifyEncrypted(name, otype, key);
    END;
  END
  ELSE
    res := VerifyAnObject(name, otype, pw);

  VerifyBinderyObjectPassword := res;
END;

FUNCTION Login(Sname, OName : NetStr; OType : WORD; Passw : NetStr) : BYTE;
VAR
  sn,
  res : BYTE;
  Curr_Server : BYTE;
  snm : NetStr;
BEGIN
  snm := SName;
  UpCaseStr(snm);
  sn := GetServerNumber(snm);
  IF sn = 0 THEN BEGIN
    res := InsertServer(snm,sn);
    IF res<>0 THEN BEGIN
      Login := res;
      Exit;
    END;
    res := AttachServerNumber(0,sn);
    IF res <> 0 THEN BEGIN
      Login := res;
      Exit;
    end;
  END;
  Curr_Server := GetPreferredServer;
  IF SetPreferredServer(sn) = sn THEN
    Login := LoginToFileServer(sn,OName, Otype, Passw)
  ELSE
    Login := $7A;
  SetPreferredServer(Curr_Server);
END;

FUNCTION Logout(ServerName : NetStr): BYTE;
VAR
  s, server : BYTE;
  firstdisk : CHAR;
  DriveServer,
  DriveFlag : DriveTablePtr;
BEGIN
  server := GetEffectiveServer;
  s := server;

  IF ServerName <> '' THEN BEGIN
    s := GetServerNumber(ServerName);
    IF (s<1) OR (s>MAXSERVERS) THEN BEGIN
      Logout := 2;
      Exit;
    END;
  END;

  IF server = s THEN BEGIN
    DriveServer := GetDriveServerPtr;
    DriveFlag := GetDriveFlagPtr;

    firstdisk := 'A';
    WHILE (firstdisk <= 'Z') AND (DriveFlag^[firstdisk] AND $80 <> 0) DO
      Inc(firstdisk);
    IF firstdisk > 'Z' THEN BEGIN
      Logout := 3;
      Exit;
    END;

    SetCurDisk(firstdisk);
    DriveServer^[firstdisk] := s;

    LogOut := SystemLogout;
  END
  ELSE
    LogOut := AttachServer(1,ServerName);
END;

FUNCTION AllocTempBase(drive : CHAR; base : BYTE; path : NetStr): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    source : BYTE;
    drive : CHAR;
    path : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    newbase : BYTE;
    access : BYTE;
  END;
BEGIN
  req.plen := Length(path) + 4;
  req.func := 19;
  req.source := base;
  req.drive := drive;
  req.path := path;
  UpcaseStr(req.path);
  rep.plen := SizeOf(rep)-2;
  AllocTempBase := CallNetware($E200,req,rep);
END;

FUNCTION DeAllocBase(base : BYTE): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    base : BYTE;
  END;
  rep : RECORD
    plen : WORD;
  END;
BEGIN
  req.plen := SizeOf(req) - 2;
  req.func := 20;
  req.base := base;
  rep.plen := SizeOf(rep)-2;
  DeAllocBase := CallNetware($E200,req,rep);
END;


FUNCTION AllocPermBase(drive : CHAR; base : BYTE; path : NetStr): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    source : BYTE;
    drive : CHAR;
    path : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    newbase : BYTE;
    access : BYTE;
  END;
BEGIN
  req.plen := Length(path) + 4;
  req.func := 18;
  req.source := base;
  req.drive := drive;
  req.path := path;
  UpcaseStr(req.path);
  rep.plen := SizeOf(rep)-2;
  AllocPermBase := CallNetware($E200,req,rep);
END;

FUNCTION GetDirectoryHandle(drive : CHAR) : BYTE;
Assembler;
ASM
  mov ax,$E900
  mov dl,[drive]
  dec dx
  and dx,31
  int 21h
END;

FUNCTION GetDriveFlag(drive : CHAR) : BYTE;
Assembler;
ASM
  mov ax,$E900
  mov dl,[drive]
  dec dx
  and dx,31
  int 21h
  mov al,ah
END;

FUNCTION GetDirectoryPath(handle : BYTE; VAR path : STRING): BYTE;
VAR
  q : RECORD
    plen : WORD;
    func : BYTE;
    hndl : BYTE;
  END;
  r : RECORD
    plen : WORD;
    path : STRING;
  END;
BEGIN
  q.plen := SizeOf(q)-2;
  q.func := 1;
  q.hndl := handle;
  r.plen := SizeOf(r)+1;
  GetDirectoryPath := CallNetware($E200,q,r);
  path := r.path;
END;

FUNCTION GetNetDrivePath(drive : CHAR; VAR path : STRING): BYTE;
VAR
  serv, pref, res : BYTE;
  ds : DriveTablePtr;
  sn : ServerNamePtr;
  i : WORD;
BEGIN
  ds := GetDriveServerPtr;
  serv := ds^[drive];
  pref := GetPreferredServer;
  IF serv <> pref THEN
    SetPreferredServer(serv);
  res := GetDirectoryPath(GetDirectoryHandle(drive),path);
  IF serv <> pref THEN
    SetPreferredServer(pref);
  IF res <> 0 THEN BEGIN
    GetNetDrivePath := res;
    Exit;
  END;
  FOR i := 1 TO Length(path) DO
    IF path[i] = '/' THEN
      path[i] := '\';

  sn := GetServerNamePtr;
  path := GetString(sn^[serv]) + '\' + path;
  GetNetDrivePath := 0;
END;

FUNCTION NetExpand(dp : PathStr): STRING;
VAR
  res, depth : BYTE;
  drive : CHAR;
  CurDir : DirStr;
  path : STRING;
  sv, colon, backslash : WORD;
  sn : ServerNamePtr;
  DosPath : PathStr;
BEGIN
  DosPath := dp;
  UpcaseStr(DosPath);
  FOR sv := 1 TO Length(DosPath) DO
    IF DosPath[sv] = '/' THEN
      DosPath[sv] := '\';

  colon := Pos(':',DosPath);
  IF colon <= 2 THEN BEGIN              { NetWare or DOS path? SYS: / C: }
    IF DosPath[1] > 'Z' THEN BEGIN
      NetExpand := DosPath;
      Exit;
    END;

    DosPath := FExpand(DosPath);

    drive := DosPath[1];

    sv := ShellVersion;
    IF (sv < $200) OR
       (GetDriveFlag(drive) AND $3 = 0) THEN
      NetExpand := DosPath
    ELSE BEGIN
      res := GetNetDrivePath(drive,path);
      IF res <> 0 THEN BEGIN
        NetExpand := '';
        Exit;
      END;
      colon := Pos(':',path);
      IF (sv >= $300) THEN BEGIN
         depth := GetRelativeDriveDepth(drive);
        IF depth <> $FF THEN BEGIN
          colon := Length(path);
          IF depth > 0 THEN BEGIN
            GetDir(Ord(drive) AND 31, CurDir);
            REPEAT
              REPEAT
                Dec(colon);
              UNTIL (path[colon] = '\');
              Dec(depth);
            UNTIL depth = 0;
            Dec(colon);
          END;
        END;
      END;
      path[0] := Chr(colon);

      res := 4;
      IF path[Length(path)] <> ':' THEN
        res := 3;
      DosPath := path + Copy(DosPath,res,255);
    END;
  END
  ELSE BEGIN
    backslash := Pos('\',DosPath);
    IF (backslash = 0) OR (backslash > colon) THEN BEGIN
      res := GetCurrentServer;
      sn := GetServerNamePtr;
      Insert(GetString(sn^[res])+'\',DosPath,1);
    END;
  END;
  IF (DosPath[Length(DosPath)] <> '\') AND
     (DosPath[Length(DosPath)] <> ':') AND
     IsDir(DosPath) THEN
    Insert('\',DosPath,Length(DosPath)+1);
  NetExpand := DosPath;
END;

FUNCTION AddTrusteeToDir(base : BYTE; path : STRING; ObjectID : Long;
                         mask : BYTE): BYTE;
VAR
  AddTrust : RECORD
    plen : word;
    func,
    source : BYTE;
    trustee : Long;
    trmask : byte;
    path : STRING;
  end;
  NoReply : WORD;
BEGIN
  AddTrust.plen := Length(path) + 8;
  AddTrust.func := 13;
  AddTrust.source := base;
  AddTrust.trustee := ObjectID;
  AddTrust.trmask := mask;
  AddTrust.path := path;
  NoReply := 0;
  AddTrusteeToDir := CallNetware($E200,AddTrust,NoReply);
END;

FUNCTION GetUserName(c : Long; VAR UserName : NetStr): BYTE;
VAR
  res : BYTE;
  CReq : RECORD
    plen : WORD;
    func : BYTE;
    conn : Long;
  END;
  CRep : RECORD
    plen : WORD;
    ID : LongInt;
    IDtype : WORD;
    name : ARRAY [1..48] OF CHAR;
    LogTime : ARRAY [1..8] OF BYTE;
  END;
BEGIN
  CReq.plen := SizeOf(CReq)-2;
  CReq.func := 22;  {Get Station Info}
  CReq.conn := c;
  IF c >= 256 THEN
    CReq.func := $1C;
  CRep.plen := SizeOf(CRep)-2;
  res := CallNetWare($E300,Creq,CRep);
  GetUserName := res;
  UserName := '';
  IF (res = 0) AND (CRep.ID <> 0) THEN
    UserName := GetString(CRep.name);
END;

FUNCTION GetConnectionNr : WORD;
Assembler;
ASM
  mov ah,$DC
  int $21
  cmp cl,'X'
   je @OK
  xor ah,ah
@OK:
END;

FUNCTION GetConnectionName(VAR name : NetStr): BYTE;
VAR
  ba : BinderyAccessReply;
  res : BYTE;
  otype : Word;
BEGIN
  res := GetBinderyAccessLevel(ba);
  IF res = 0 THEN
    res := MapNumberToName(ba.MyObjectId,name,otype);
  GetConnectionName := res; 
END;

FUNCTION MapNumberToVolume(nr : BYTE; VAR volume : NetStr): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    vol : BYTE;
  END;
  rep : RECORD
    plen : WORD;
    volume : NetStr;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 6;
  req.vol := nr;
  rep.plen := SizeOf(rep)-2;
  MapNumberToVolume := CallNetware($E200,req,rep);
  volume := rep.volume;
END;

function GetVolumeName(nr : Integer; var vname : NetStr): byte;
begin
  GetVolumeName := MapNumberToVolume(nr,vname);
end;

function GetEffectiveDirectoryRights(const path: String;var r: byte): byte;
var
  s, c : Integer;
  q : record
    plen : word;
    func : byte;
    dirhandle : byte;
    dir : String;
  end;
  a : record
    plen : word;
    rights : byte;
  end;
begin
  q.plen := Length(path) + 3;
  q.func := 3;
  q.dirhandle := 0;
  q.dir := path;
  if (Length(q.dir) <> 0) and (q.dir[Length(q.dir)] = '\') then
    Dec(q.dir[0]);
  a.plen := SizeOf(a)-2;
  GetEffectiveDirectoryRights := CallNetware($E200,q,a);
  r := a.rights;
end;

FUNCTION GetVolumeNumber(const volume : NetStr; var nr : Integer): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    vol  : NetStr;
  END;
  rep : RECORD
    plen : WORD;
    nr   : byte;
  END;
BEGIN
  req.plen := 2 + Length(volume);
  req.func := 5;
  req.vol := volume;
  rep.plen := SizeOf(rep)-2;
  GetVolumeNumber := CallNetware($E200,req,rep);
  nr := rep.nr;
END;

FUNCTION CopyFile(Fra,Til:STRING):BYTE;
VAR
  f,t : FILE;
  fh  : WORD ABSOLUTE f;
  th  : WORD ABSOLUTE t;
  req : RECORD
    from,
    tof   : WORD;
    dstart,
    ddest,
    dbytes : Long;
  END;
  res : INTEGER;
  tattr, attr : WORD;
  time : LongInt;
BEGIN
  FileMode:=$20;
  Assign(f,Fra);
  GetFAttr(f,attr);
  Reset(f);
  res := IOResult;
  IF res<>0 THEN BEGIN
    CopyFIle:=res;
    Exit;
  END;
  GetFTime(f,time);

  Assign(t,Til);
  GetFAttr(t,tattr);
  IF (DosError = 0) THEN BEGIN
    FileMode := $82;
    Reset(t);
  END
  ELSE
    ReWrite(t);
  res := IOResult;
  IF res<>0 THEN BEGIN
    CopyFile:=res;
    Exit;
  END;
  req.from := fh;
  req.tof  := th;
  req.dstart   := 0;
  req.ddest    := 0;
  req.dbytes   := $77777777;
  CopyFile:=CallNetWare($F300,req,req);
  Close(f);
  SetFTime(t,time);
  Close(t);
  SetFAttr(t,attr);
END;

FUNCTION MapConnToNetworkNr(conn : LongInt; VAR addr): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    conn : LongInt;
  END;
  rep : RECORD
    plen : WORD;
    InterNet : ARRAY [1..4] OF BYTE;
    CardNr : ARRAY [1..6] OF BYTE;
    Socket : WORD;
    extra  : BYTE;
  END;
BEGIN
  req.plen := SizeOf(req)-2;
  req.func := 19;
  IF conn > 255 THEN
    req.func := 26;
  req.conn := conn;
  rep.plen := SizeOf(rep)-2;

  MapConnToNetworkNr := CallNetware($E300,req,rep);
  Move(rep.InterNet,addr,12);
END;

FUNCTION GetSerialNr(VAR snr, appl : STRING): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
  END;
  rep : RECORD
    plen : WORD;
    data : ARRAY [1..6] OF BYTE;
  END;
BEGIN
  req.plen := 1;
  req.func := $12;
  rep.plen := 6;
  GetSerialNr := CallNetWare($E300,req,rep);
  snr := HexStr(rep.data,4);
  appl := HexStr(rep.data[5],2);
END;

FUNCTION OpenSem(name : NetStr; initial : ShortInt;
                 VAR h : LongInt; VAR users : BYTE): BYTE;
Assembler;
ASM
  push ds
  mov ax,$C500
  mov cl,[initial]
  lds dx,[name]
  int $21
  or al,al
   jnz @done
  lds di,[h]
  mov [di],cx
  mov [di+2],dx
  lds di,[users]
  mov [di],bl
@done:
  pop ds
END;

FUNCTION TestSem(h : LongInt; VAR value : INTEGER;
                 VAR users : BYTE): BYTE;
Assembler;
ASM
  mov ax,$C501
  les cx,[h]
  mov dx,es
  int $21
  les di,[value]
  mov [es:di],cx
  les di,[users]
  mov [es:di],dl
END;

FUNCTION CloseSem(h : LongInt): BYTE;
Assembler;
ASM
  mov ax,$C504
  les cx,[h]
  mov dx,es
  int $21
END;

FUNCTION ShellVersion : WORD;
Assembler;
ASM
  mov ax,$EF01
  mov si,$FFFF
  int $21               { Get shell table in ES:SI }
  xor ax,ax
  cmp si,$FFFF          { SI = FFFF is impossible }
   je @done
  mov ax,$EA00
  xor bx,bx
  int $21
  mov ax,$200           { Assume at least V2.00 }
  cmp bx,ax
   jbe @done
  mov ax,bx
@done:
END;

FUNCTION SendPersonalMessage(msg, list : STRING;VAR result : STRING): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    buf : ARRAY [0..227] OF CHAR;
  END;
  reply : RECORD
    plen : WORD;
    res : STRING[126];
  END;
  mlen, llen : Word;
BEGIN
  mlen := Length(msg);
  IF mlen > 55 THEN mlen := 55;
  llen := Length(list);
  IF llen > 100 THEN llen := 100;
  req.plen := mlen + llen + 3;
  req.func := 4;
  Move(msg,req.buf,mlen+1);
  Move(list,req.buf[mlen+1],llen+1);
  reply.plen := SizeOf(reply)-2;
  SendPersonalMessage := CallNetware($E100,req,reply);
  result := reply.res;
END;

FUNCTION SendBroadcastMessage(msg, list : STRING;VAR result : STRING): BYTE;
VAR
  req : RECORD
    plen : WORD;
    func : BYTE;
    buf : ARRAY [0..227] OF CHAR;
  END;
  reply : RECORD
    plen : WORD;
    res : STRING[100];
  END;
  mlen, llen : Word;
BEGIN
  mlen := Length(msg);
  IF mlen > 55 THEN mlen := 55;
  llen := Length(list);
  IF llen > 100 THEN llen := 100;
  req.plen := mlen + llen + 3;
  req.func := $00;
  Move(list,req.buf,llen+1);
  Move(msg,req.buf[llen+1],mlen+1);
  reply.plen := SizeOf(reply)-2;
  SendBroadcastMessage := CallNetware($E100,req,reply);
  result := reply.res;
END;

FUNCTION GetSpecificCaptureFlags(localLPT : BYTE; VAR cf : CAPTURE_FLAGS): BYTE;
Assembler;
CONST
  Rep_Size = SizeOf(CAPTURE_FLAGS);
ASM
  mov ax,0B802h
  mov cx, Rep_Size
  les bx,[cf]
  mov dh,[localLPT]
  int 21h
END;

FUNCTION GetPathTrustees(path : String; setnr : BYTE;
           VAR tl : tlist): BYTE;
var
  res : byte;

  q : record
    plen : word;
    func : byte;
    base : byte;
    setnr : byte;
    path : String;
  end;

  a : record
    plen : word;
    dirn : array [0..15] of char;
    create : long;
    owner : Long;
    tl : tlist;
    tm : array [0..4] of byte;
  end;

begin
  q.plen := Length(path)+4;
  q.func := 12;
  q.base := 0;
  q.setnr := setnr;
  q.path := path;

  a.plen := SizeOf(a)-2;

  res := CallNetWare($E200,q,a);
  if res = 0 then
    tl := a.tl;
  GetPathTrustees := res;
end;

END.
______________________________________________________________________
Terje W Mathisen, Hydro Data, Norsk Hydro. FAX: +47-22-433606
Internet: terjem@hda.hydro.com, BIX: terjem@Bix.com

