{*********************************************************************
Last Update 3/17/94 by Sid Nash

**********************************************************************}

Unit SNetware;
{$I-,V-,S+,R+}

interface

uses DOS;

const LocationDotSortPath='g:\pcinfo\location.srt';
      MaxConnections=255;
const
  { error return codes for AttachToServer }
  ALREADY_ATTACHED = $F8;  { already attached to server }
  NO_FREE_SLOTS    = $F9;  { No free connection slots at server }
  NO_SERVER        = $FF;  { No response from server }
  _SHAREABLE       = $80;

  { Effective Rights constants represent bit in Mask }
  _READ            = $01;
  _WRITE           = $02;
  _OPEN            = $04;
  _CREATE          = $08;
  _DELETE          = $10;
  _PARENTAL        = $20;
  _SEARCH          = $40;
  _MODIFY          = $80;

  { status byte }
  _PERMENANT       = $01;
  _TEMPORARY       = $02;
  _LOCAL           = $80;

  { general error codes }
  _SUCCESS         = $00;

  OpenSocket       = $00;
  CloseSocket      = $01;

  { Brodcast Messages Constants for use with function BroadcastMode}
  CastOn   = 0;{ - Recieve console and workstation broadcasts.     }
  CastOff  = 1;{ - Receive console broadcasts only.                }
              {     Broadcasts sent by other workstations are       }
              {     discarded and are not retrievable.              }
  CastOffAll=2;{ - Disable receipt of all broadcasts.              }
              {     All broadcasts, including those sent by the     }
              {     console, are discarded and are not retrievable. }
  HoldCalls= 3;{ - Store any broadcasts for possible retrieval.    }
              {     The server accepts all broadcasts.  However,    }
              {     the shell of the station will not issue a       }
              {     request for the message.                        }
  GetBMode = 4;{ - Return current broadcast mode.                  }
  SaveBMode= 7;{ - Save Broadcast Mode in global variable BMode     }
  RestoreBMode=8;{-Restore Broadcast Mode from contents of var BMode}


type
  String8          = String[8];
  Str9             = String[9];
  Str10            = String[10];
  Str20            = String[20];
  Str80            = String[80];
  string2  = string[2];
  string12 = string[12];
  string16 = string[16];
  string20 = string[20];
  string40 = string[40];
  string47 = string[47];
  string48 = string[48];
  string79 = string[79];
  PhysicalNodeAddress
                   = array[1..6] of Byte;
  PrinterDevice    = (LPT_1,LPT_2,LPT_3); { enum type to hold LPT number }
  First_Next_Type  = (First,Next);
  DayOfTheWeek     = byte;{(Sunday,Monday,Tuesday,Wednesday,Thursday,
                      Friday,Saturday);}
  GenericPacket = array[0..255] of byte; { For Novell ftn calls }
  UserRec = RECORD
                Name: STRing[15];              { user name         }
                Number : BYTE;     { Work Station used }
                ConnectionNo: BYTE;       { Connection number }
                NetworkAddr: STRing[12];       { Ethernet address  }
                Location: STRING[21];      { building/room     }
                uid : LONGINT;
                utype : BYTE;
                Fname : STRING [40];
            END;
  UserList = ARRAY [1..150] OF UserRec;

  { Used for GetProperty }

var
  NovRegs          : Registers; { register type for DOS/Novell calls }
  SemHandleHi, SemHandleLo : WORD;


function UpcaseStr(Str: string): string;  { by Sid Nash }

function LeadingZero(w : Word) : String;

function Byte2Hex(B:byte):string2;

function Int2Str(L : LongInt) : string;

Function Day_of_week_String( Month, Day, Year: integer): string;

function GetObjectIDFor(UserName:str20):string12;
{ returns UserName's Object ID # }

function GetUserNameAt(ConnNum:word; var LoginTime:string40):string48;

function GetLocationDotSortInfo(Address: string):string;

function GetConnectionNumberOfAddress(var Address:string; First_Next:First_Next_Type):byte;

function GetConnectionNumber:byte;

function GetNetworkNumber:string8;

function GetNetworkNumberOfConnection(ConnectionNum:integer; var Address:string12):string8;

function GetStationAddress:string12;{Programmer's Guide to Netware Pg.276}

function NumLocalDrives:byte;
{ returns the number of local drives on requesting ws }

function GetDirHandle(Drive : Char; var StatusFlags : Byte) : Byte;
{ returns directory handle and status flags for a drive }
{ return byte:
  00   - Invalid Drive Number
  otherwise returned directory handle

  Status Byte
  7  6  5  4  3  2  1  0
  |                 |  +-Permenant Directory Handle
  |                 +----Temporary Directory Handle
  +----------------------Mapped to a local drive
}

function  GetFileOwnerID(FileName: string): longint;


function GetDirPath(DirHandle : Byte; var DirPath : String) : Byte;
{ returns directory path of a directory handle }
{ return byte
  00h  - Success
  9Bh  - Bad Directory Handle
}


function GetVolumeWithHandle(DirHandle:byte; Success:boolean):string;{E2h 15h}
{ returns Volume Name given a directory handle }
{ Programers guide to Netware Pages 73-74. }

function GetDirHandleWithVolume(VolName:string16; Success:boolean):byte;{E2h 05h}
{ returns a directory handle given Volume Name }
{ Programers guide to Netware Page 73. }

function GetDefaultPathForDrive(Drive:char; var StatusFlags : Byte) : string;
{ returns Volume+Drive+Default directory of given drive
  Status Byte
  9  8  7  6  5  4  3  2  1  0
  |     |                 |  +-Permenant Directory Handle
  |     |                 +----Temporary Directory Handle
  |     +----------------------Mapped to a local drive
  +----------------------------Invalid Drive
}

function GetObjectName(ObjectID : longint;
                       var ObjectName : string47;
                       var ObjectType : integer):byte;

function NetworkDrive(Drive: char): boolean;

function GetExtFAttr(var Path : String; var Attributes : Byte) : Byte;
{
  Meaning of Attributes:
  7   6   5   4   3   2   1   0
  |   |   |   |       |   |   |
  |   |   |   |       +---+---+------Search mode  [210]
  |   |   |   +----------------------transactional bit [4]
  |   |   +--------------------------Indexing bit [5]
  |   +------------------------------Read Audit bit [6]
  +----------------------------------Write Audit bit [7]
  Function returns error code:
    0  - Success
    2  - File not found
    18 - No more files (requesting workstation does not have search
                        rights)
}

function SetExtFAttr(var PathName : Str80; Attr : Byte) : Byte;
{
  See GetExtFAttr for meaning of Attr the Attribute
  Function returns error code:
    0  - Success
    2  - File not found
    5  - Access denied
}


function FileIsSharable(Path : String; var FAttr : Word; var ErrCode : Word)
                       : Boolean;
{ Return TRUE if ifle is flagged as shareable, return file attrib in FAttr }

function MakeFileSharable(Path : String) : Word;

function ConsolePriv : Boolean;

function ServerConnNo: Byte;
{ returns connection number of default file server (1..8) }

procedure EndOfJob(All : Boolean);
{
  forces an end of job
  If All is TRUE, then ends all jobs, otherwise ends a single job.
  Ending a job unlocks and clears all locked or logged files and records.
  It close all open network and local files and resets error and lock modes
}

function GetDirRights(DirHandle : Byte; PathName : String;
                      var Rights : Byte) : Byte;
{ returns the requesting workstation's effective directory rights }
{ return byte
  00h  - Success
  98h  - Volume Does Not Exist
  9Bh  - Bad Directory Handle

  Rights
  7  6  5  4  3  2  1  0
  |  |  |  |  |  |  |  +--Read bit (file reads allowed)
  |  |  |  |  |  |  +-----Write bit (file writes allowed)
  |  |  |  |  |  +--------Open bit (files can be opened)
  |  |  |  |  +-----------Create bit (files can be created)
  |  |  |  +--------------Delete bit (files may be deleted)
  |  |  +-----------------Parental bit (subdirs may be created/deleted
  |  |                                  and trustee rights granted/revoked)
  |  +--------------------Search bit (directory may be searched)
  +-----------------------Modify bit (file status bits can be modified)
}

function IsLockModeExtended : Boolean;
{
  returns TRUE if using Advanced NetWare Extended Lock Mode, if FALSE,
  then in compatability mode (for compat with NetWare 4.61 and prior).
}

function AllocPermDirHandle(DirHandle : Byte; DriveLetter : Char;
                            DirPath : String;
                            var NewHandle,Rights : Byte) : Byte;
{ Allocates a permament directory handle, not deleted automatically by EOJ.

return byte:
  00h  - Success
  98h  - Volume does not exist
  9Ch  - Invalid Path
}

function AllocTempDirHandle(DirHandle : Byte; DriveLetter : Char;
                            DirPath : String;
                            var NewHandle,Rights : Byte) : Byte;
{ Allocates a temporary directory handle, deleted automatically by EOJ.

return byte:
  00h  - Success
  98h  - Volume does not exist
  9Ch  - Invalid Path
}

function DeallocDirHandle(DirHandle : Byte) : Byte;
{ This function deletes a directory handle }
{ return byte:
  00h  - Success
  9Bh  - Bad directory handle
}

function ClearConnectionNumber(ConnNo : Byte) : Byte;
{ Clears a logical connection from the file server }

function HiLong(Long : LongInt) : Word;
{ This inline directive is similar to Turbo's Hi() function, except }
{ it returns the high word of a LongInt                             }
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58);      {pop      ax    ; hi word of long}

function LowLong(Long : LongInt) : Word;
{ This inline directive is similar to Turbo's Lo() function, except }
{ it returns the Low word of a LongInt                              }
Inline(
  $5A/       {pop      dx    ; low word of long}
  $58/       {pop      ax    ; hi word of long}
  $89/$D0);  {mov      ax,dx ; return lo word as function result in Ax}


function CancelLPTCapture : Word;
{ abort capture of default LPT device }

function EndLPTCapture : Word;
{ end the capture of default LPT device (like ENDSPOOL) }

function FlushLPTCapture : Word;
{ Flush capture of default LPT device (like running SPOOL again while
  spooling
}

function GetDefaultLocalPrinter : PrinterDevice;
{ Get LPT device currently used as default by network for capture }

procedure SetDefaultLocalPrinter(LPTNo : PrinterDevice);
{ Sets LPT device used as default by network for capture }

function StartLPTCapture : Word;
{ Start Capture of default LPT device (Like running SPOOL) }

function LPTCaptureActive(var QueServer : Byte) : Boolean;
{ Is spooling occurring now for specified QueServer? }

procedure GetPrinterStatus(var PrinterNo,FormType : Byte;
          var OffLine,Stopped : Boolean);
{ return assorted information about the default network printer }

function GetBannerUser : String;
{ returns the user name that is printed on the banner page }

procedure GetServerDateTime(var Year,Month,Day,Hour,Minute,Second : Word;
                            var WeekDay : DayOfTheWeek);

function GetServerDateTimeString:string;

function DisableServerLogin : Boolean;
{ returns true if file server login is successfully disabled }
{ THIS FUNCTION DISABLES ALL LOGINS TO A SERVER FROM ANY WORKSTATION }
{ Use EnableServerLogin to enable (must be called from same WS) }

function EnableServerLogin : Boolean;
{ returns true if file server login is successfully enabled }
{ Use DisableServerLogin to disable (must be called from same WS }

function DownFileServer(ForceItDown : Boolean) : Byte;
{
  DOWNS the server!!!
  Warning, this function will really down your file server kiddo!
  If ForceItDown is TRUE, it will down the server EVEN IF FILES ARE OPEN!!!
}

function ServerCopy(Source,Dest : Word; SOff,DOff,NoBytes : LongInt;
                    var NoBytesCopied : LongInt) : Byte;

function GetLoginStatus(var LoginEnabled : Boolean) : Byte;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ return byte
  00h  - Success
  C6h No Console Rights
}

procedure PurgeAllErased;
{ actually delete all deleted files from server }

procedure PurgeErased;
{ delete only files deleted by requesting WS from server }

function AttachToServer(ServerConnID : Byte) : Byte;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }

function DetachFromServer(ServerConnID : Byte) : Byte;
{ this functions logs the object out, and detaches the workstation from }
{ the file server. }

function TTSAbort : Byte;
{ Return code:
  00h  - success
  FDh  - TTS Disabled
  FEh  - Transaction ends records locked (trans aborted, but recs left locked)
  FFh  - no explicit transaction active
}

function TTSBegin : Byte;
{ return code:
  00h  - Success
  96h  - Out of Dynamic Workspace
  FEh  - Implicit transaction active (active implicit turned into explicit)
  FFh  - Explicit Transaction active
}

function TTSEnd(var ID : LongInt)  : Byte;
{ return code:
  00h  - Success
  FDh  - TTS Disabled
  FEh  - Tranaction ends records locked
  FFh  - No Explicit transaction active
}

function TTSStatus(ID : LongInt) : Boolean;
{ returns TRUE if referenced transaction has been committed to disk }

function TTSGetAppThresh(var Logical,Physical : Byte) : Boolean;

function TTSGetWSThresh(var Logical,Physical : Byte) : Boolean;

function TTSAvailable : Boolean;

function TTSDisable : Boolean;

function TTSEnable : Boolean;

function UsersFullName(UserName:string12): string;

function UsersGroups(UserName:string12): pointer;{GroupArrayPtr;}

function GetDriveHandleTable:pointer;
  {Programmer's Guide to NetWare Page 279. EFh 00h}

function GetDriveFlagTable:pointer;
  {Programmer's Guide to NetWare Page 280. EFh 01h}

function GetDriveConnectionIDTable:pointer;
  {Programmer's Guide to NetWare Page 280. EFh 02h}

function GetFileServerNameTable:pointer;
  {Programmer's Guide to NetWare Page 280-281. EFh 04h}

function GetServerOfDrive(Drive:char):string48;

function GetConnectionIDofServer(ServerName:string48):word;

function GetDefaultServerName:string48;

function GetDefaultServerConnection:byte;
  {Programmer's Guide to NetWare Page 277. F0h 02h}

function GetPrimaryServerConnection:byte;
  {Programmer's Guide to NetWare Page 278-279. F0h 05h}
procedure SetPrimaryServerConnection(Conn:byte);
  {Programmer's Guide to NetWare Page 278. F0h 04h}

function GetPreferedServerConnection:byte;
  {Programmer's Guide to NetWare Page 278. F0h 01h}
procedure SetPreferedServerConnection(Conn:byte);
  {Programmer's Guide to NetWare Page 278. F0h 00h}
procedure SetPreferedServer(ServerName:string48);


{***************** The following routines stolen from *********************}
{***************** Scott Harwood's and Paul Darrow's  *********************}
{***************** SNetwork.pas 3/7/94. Sid.          *********************}

function GetInternetWorkNetworkAddress(ConnectionNum: word): string20;
{
   Uses Netware funtion $E3, $13 to map a connection number
   Programmer's guide to NetWare Page 275
   Returns <Network Number + Physical Node Address>
}
function GetNetworkAddress(ConnectionNo: word): string12;
{
   Uses Netware funtion $E3, $13 to map a connection number
   Programmer's guide to NetWare Page 275
   Returns <Physical Node Address> of station at ConnectionNo
}
PROCEDURE Cast_Off;
              { Disable broadcast messages to be sent to your machine. }
PROCEDURE Cast_On;
              { Enable broadcast messages to be sent to your machine.  }
FUNCTION SendBroadcastMessage (station : BYTE; Msg : STRING) : BOOLEAN;
              { Send a broadcast message (Msg) to someone.  The logical    }
              { station number being passed into (station).                }
PROCEDURE GetBroadcastMessage (VAR mess : STRING);
              { Returns a broadcast message if one has been sent.   }

FUNCTION BroadcastMode (mode : BYTE): WORD;
              { Sets the broadcast mode to :                        }
    {CastOn   = 0 - Recieve console and workstation broadcasts.     }
    {CastOff  = 1 - Receive console broadcasts only.                }
              {     Broadcasts sent by other workstations are       }
              {     discarded and are not retrievable.              }
    {CastOffAll=2 - Disable receipt of all broadcasts.              }
              {     All broadcasts, including those sent by the     }
              {     console, are discarded and are not retrievable. }
    {HoldCalls= 3 - Store any broadcasts for possible retrieval.    }
              {     The server accepts all broadcasts.  However,    }
              {     the shell of the station will not issue a       }
              {     request for the message.                        }
    {GetBMode = 4 - Return current broadcast mode.                  }
              { 5 - Shell timer interrupt checks are disabled.      }
              { 6 - Shell timer interrupt checks are enabled.       }
    {SaveBMode= 7 - Save Broadcast Mode in global variable BMode     }
    {RestoreBMode=8-Restore Broadcast Mode from contents of var BMode}

FUNCTION GetMyName : STRING;
              { Get my username. }
PROCEDURE get_logged_users (VAR users : Userlist; VAR c : BYTE);
              { Get a list of usernames and logical station numbers of
                the users currently logged in. }
Function GetProperty(ObjectName, PropertyName : string40): string40;
              { Returns the property - usually the fullname of the
                ObjectName.  Written by C. Michael Bell, used by permission
                by Paul Darrow }
FUNCTION UserStationNum( UserName : STRING; FirstConnectionNoToCheck:word ) : WORD;
              { This function returns the virtual station number of }
              { the user with user name UserName. }
              { set FirstConnectionNoToCheck:=1 for first search
                Returns 0 if not found }
FUNCTION CheckPipe (stat1, stat2 : BYTE): BOOLEAN;
                  { Check the status of the pipes of the two stations. }
PROCEDURE OpenPipe (stat1, stat2 : BYTE);
                  { Open a pipe between the two stations. }
PROCEDURE ClosePipe (stat1, stat2 : BYTE);
                  { Close the pipe between the two stations. }
PROCEDURE SendPipeMessage (stat2 : BYTE; msg : STRING);
                  { Send a message through the pipe to the user specified. }
PROCEDURE GetPipeMessage (VAR msg : STRING);
                  { Get a pipe message that has been sent to you.
                    If no message has been sent to you msg will be null. }
FUNCTION OpenSemaphore (str : STRING) : BYTE;
                  { Opens a semaphore STR and returns the number
                    of users who have opened the semaphore.
                    At present the user is limmited to one open semaphore at
                    a time. }
FUNCTION ExamineSemaphore : BYTE;
                  { Returns the number of users who have opened the semaphore
                    that you have opened. }
PROCEDURE WaitSemaphore;
                  {  ??????  }
PROCEDURE SignalSemaphore;
                  {  ??????  }
PROCEDURE CloseSemaphore;
                  { Close the semaphore you opened earlier. }
function IPX_Installed:boolean;

function Netbios_Installed:Boolean;

function NetShell_Installed:Boolean;

{*************************** End Stolen Routines ****************************}

function Socket(OpenClose:byte):word;
  {Programmer's Guide to NetWare Page 442. }
  {If Successfull Returns Assigned Socket}
  {If failure returns $FE if Socket Table is full
                      $FF if Socket is already open}

implementation


function UpcaseStr(Str: string): string;  { by Sid Nash }
  { General purpose function to convert each character in Str to uppercase }
  { Str remains unchanged. Uppercase string returned in UpcaseStr }
  var i,j: byte;
      S: string;
  begin
     j:=length(Str);
     S:='';
     for i:=1 to j do S:= S + ' ';          { init Str }
     for i:=1 to j do S[i]:=upcase(Str[i]); { convert Str }
     UpcaseStr:=S;
  end;  (* func *)


function LeadingZero(w : Word) : String;
  var s : String;

  begin
     Str(w:0,s);
     if Length(s) = 1 then
     s := '0' + s;
     LeadingZero := s;
  end;


Function Byte2Hex(b: byte): string2;
{   Written by Michael Bell }
const h : ARRAY [0..15] of CHAR = '0123456789ABCDEF';
begin
   Byte2Hex := h[ b div 16] + h[b mod 16];
end;


function OpenR(var F:text; FName:string):boolean;
  begin
    {$I-}
    assign(F,FName);
    reset(F);
    {$I+}
    OpenR:= (IOResult = 0) {and (FName <> '')};
  end;  (* func *)


function GetLocationDotSortInfo(Address: string):string;
  var f:text;
      Line:string;
  begin
    Line:='';
    if OpenR(f,LocationDotSortPath) and (Address<>'') then begin
      while (not (eof(f))) and (Address>copy(Line,1,12)) do readln(f,Line);
      if pos(Address,Line)=1
        then GetLocationDotSortInfo:=copy(Line,14,length(Line)-13)
        else GetLocationDotSortInfo:='';
      close(f);
    end else GetLocationDotSortInfo:='';
  end;   (* func *)


function Int2Str(L : LongInt) : string;
      { Converts an integer to a string for use with OutText, OutTextXY }
var
  S : string;
begin
  Str(L, S);
  Int2Str := S;
end; { Int2Str }


Function Day_of_week_String( Month, Day, Year: integer): string;
{
   Computes the Day of the week given
   any date in the Gregorian calendar.
   From Dr. Dobb's Journal, #169
   October 1990, page 139.  Uses
   Zeller's Congruence Algorithm.

Inputs:
   Month.....month in numeric form (1..12)
   Day.......day in numeric form (1..31)
   Year......year (>= 1752)

      The earliest date in the Gregorian
      calendar is September 14, 1752.

   Returns:
      Numerical day of the week (1=Sunday...7=Saturday)

   Limitations:
      No checking is done to ensure the date is valid.

}
CONST days : array [1..7] of String[9] = ('Sunday','Monday','Tuesday',
                               'Wednesday','Thursday','Friday','Saturday');
var J : integer;   { Century (e.g., 19) }
    K : integer;   { Year (e.g., 90) }
    q : integer;   { Day of month     }
    m : integer;   { Month, 3=March, 4=April, ..., 12=December, 13=Jan, 14=Feb }
    r : integer;   { result }
begin
   q := Day;
   m := Month;
   if m < 3 then begin
      m := m + 12;
      dec(Year);
   end;
   J := Year div 100;
   K := Year mod 100;
   r := (q + ((m+1)*26) div 10 + K + K div 4 + J div 4 - 2*J);
   while r < 0 do inc(r,7);
   r := r mod 7;
   if r=0 then r:=7;   { convert Sat=0 to Sat=7 }
   Day_of_week_String := Days[r];
end;


function GetConnectionNumberOfAddress(var Address:string; First_Next:First_Next_Type):byte;
  const Next:word=1;
  var i:word;
      temp:string;
  begin
    if First_Next=First then Next:=1;
    GetConnectionNumberOfAddress:=0;
    for i:=Next to MaxConnections do begin
      temp:=GetNetworkAddress(i);
      if pos(Address,temp)>0 then begin
        GetConnectionNumberOfAddress:=i;
        Address:=temp;
        Next:=i+1;
        break;
      end;
    end; (* for i *)
  end;  (* func *)


function GetConnectionNumber:byte;
  {Programmer's Guide to NetWare Page 274. DCh }
  begin
    asm
      mov AH, 0DCh;
      INT 21h
      mov @result, al
    end;
  end;  (* func *)


function GetStationAddress:string12;{Programmer's Guide to Netware Pg.276}
  var Regs: Registers;
  begin
    with Regs do begin
      AH:=$EE;
      msdos(Regs);
      GetStationAddress:= Byte2Hex(CH)+Byte2Hex(CL)+Byte2Hex(BH)+
                          Byte2Hex(BL)+Byte2Hex(AH)+Byte2Hex(AL);
    end;
  end;  (* func *)


function GetObjectIDFor(UserName:str20):string12;
{ returns UserName's Object ID # }
{ Programmer's Guide to Netware pgs.152 }
  var
      Request:record
        Leng :word;
        Func :byte;
        ObjType:word;
        NameLen:byte;
        Name:array[1..48] of char;
      end; (* Request *)
      Reply  :record
        Leng :word;
        ObjId:array[1..4] of byte;
        ObjType:word;
        Name:array[1..48] of char;
      end; (* Reply *)
      Regs:Registers;
      i:byte;
  begin
    with Request do begin
      Leng:=sizeof(Request)-2;
      Func:=$35;
      ObjType:=$0100;
      NameLen:=length(UserName);
      for i:=1 to NameLen do Name[i]:=upcase(UserName[i]);
    end;
    Reply.Leng:=sizeof(Reply)-2;
    with Regs do begin
      AX:=$E300;
      DS:=seg(Request);
      SI:=ofs(Request);
      ES:=seg(Reply);
      DI:=ofs(Reply);
      msdos(Regs);
    end;
    if Regs.AL<>0 then GetObjectIDFor:='' else with Reply do begin
      GetObjectIDFor:= Byte2Hex(ObjID[1])+Byte2Hex(ObjID[2])+
                       Byte2Hex(ObjID[3])+Byte2Hex(ObjID[4]);
    end;
  end;  (* func *)


FUNCTION TruncName (name : STRING) : STRING;

VAR
  i : BYTE;
  st : STRING;

BEGIN
  i := 1;
  st := '';
  WHILE (name[i] <> #0) AND (i <= LENGTH(name)) DO
  BEGIN
    st := st + name[i];
    INC (i);
  END;
  TruncName := st + #0;
END;


function GetUserNameAt(ConnNum:word; var LoginTime:string40):string48;
  {Programmer's Guide to NetWare page 272 ($E3,$16}
  var
      Request:record
        Leng :word;
        Func :byte;
        Conn :byte;
      end; (* Request *)
      Reply  :record
        Leng :word;
        ObjId:longint;
        ObjType:word;
        Name :array[1..48] of char;
        LTime:array[1..07] of byte;
      end; (* Reply *)
      Regs:Registers;
      UName:String48;
      i:byte;
  begin
    if ConnNum>MaxConnections then begin
      GetUserNameAt:='';
      EXIT;
    end;
    with Request do begin
      Leng:=sizeof(Request)-2;
      Func:=$16;
      Conn:=ConnNum;
    end;
    Reply.Leng:=sizeof(Reply)-2;
    with Regs do begin
      AH:=$E3;
      DS:=seg(Request);
      SI:=ofs(Request);
      ES:=seg(Reply);
      DI:=ofs(Reply);
      msdos(Regs);
    end;
    if Regs.AL=0 then with Reply do begin
      i:=1; UName:='';
      if ObjId=0 then UName:='NOT-LOGGED-IN' else
      while Name[i]<>#0 do begin
        UName:=UName+Name[i];
        inc(i);
      end;
      GetUserNameAt:=UName;
      LoginTime:= Day_of_week_String(LTime[2],LTime[3],LTime[1])+' '+
                  LeadingZero(LTime[2])+'/'+LeadingZero(LTime[3])+'/'+LeadingZero(LTime[1])+
                  '  '+LeadingZero(LTime[4])+':'+LeadingZero(LTime[5])+':'+
                  LeadingZero(LTime[6])+'.'+LeadingZero(LTime[7]);
    end else begin
      GetUserNameAt:='';
    end;
  end;   (* func *)


function NumLocalDrives:byte;
{ returns the number of local drives on requesting ws }
  var NovRegs          : Registers; { register type for DOS/Novell calls }
  begin
    with NovRegs do begin
      AL := $DB;
      MsDos(NovRegs);
      NumLocalDrives := AL;
    end
  end;  (* func *)


function GetDirHandle(Drive : Char; var StatusFlags : Byte) : Byte;
{ returns directory handle and status flags for a drive }
{ return byte:
  00   - Invalid Drive Number
  otherwise returned directory handle

  Status Byte
  7  6  5  4  3  2  1  0
  |                 |  +-Permenant Directory Handle
  |                 +----Temporary Directory Handle
  +----------------------Mapped to a local drive
}

var
  NovRegs          : Registers; { register type for DOS/Novell calls }

begin
  with NovRegs do begin
    AX := $E900;
    DX := Ord(UpCase(Drive)) - Ord('A');
    MsDos(NovRegs);
    GetDirHandle := AL;
    StatusFlags := AH;
  end
end;

function  GetFileOwnerID(FileName: string): longint;

Var
    Req_Packet : Record
                     BufLength : Word;
                     Number1   : Byte;
                     SeqNumber : Word;   {Switch}
                     Directory : Byte;   {Zero if Path}
                     SearchAttr: Byte;
                     PathLength: Byte;
                     Path      : Array[1..255] of char;
                 End;
    Rep_Packet : Record
                     BufLength : Integer;
                     SeqNumber : Word;   {Switch}
                     FileName  : array[1..15] of char;
                     Stuff     : array[1..13] of byte;
                     OwnerID   : longint;
                     MoreStuff : array[1..60] of byte;
                 End;
    IDStr1,IDStr2: string[8];
    i,err : integer;
    error : boolean;
    flags : byte;
    REGS : Registers;

Begin
    With Req_Packet do begin
        BufLength := SizeOf(Req_Packet) - 2;
        Number1 := $0F;
        SeqNumber := $ffff;
        flags := 0;
        Directory := 0;
        SearchAttr := 6;
        For i := 1 to Length(FileName) do begin
            Path[i] := UPCASE(FileName[i]);
        end;
        PathLength := Length(FileName);
    end;
    Rep_Packet.BufLength := sizeof(Rep_Packet)-2;
    Regs.ES := seg(Rep_Packet);
    Regs.DS := seg(Req_Packet);
    Regs.SI := ofs(Req_Packet);
    Regs.DI := ofs(Rep_Packet);
    Regs.AX := $e300;
    MsDos(Regs);
    GetFileOwnerID:=Rep_Packet.OwnerID;
End;


function GetDirPath(DirHandle : Byte; var DirPath : String) : Byte;
{ returns directory path of a directory handle }
{ return byte
  00h  - Success
  9Bh  - Bad Directory Handle
}

var
  Reply : record
    Len : Word;
    Name: String;
  end;
  Request : record
    Len   : Word;
    SubF  : Byte;
    Handle: Byte;
  end;
  var NovRegs: Registers; { register type for DOS/Novell calls }

  begin
    Reply.Len := 256;
    with Request do begin
      Len     := 2;
      SubF    := $01;
      Handle  := DirHandle;
    end;
    with NovRegs do begin
      AX := $E200;
      DS := Seg(Request);
      SI := Ofs(Request);
      ES := Seg(Reply);
      DI := Ofs(Reply);
      MsDos(NovRegs);
      GetDirPath := AL;
    end;
    with Reply do
      DirPath := Name;
  end;

function GetVolumeWithHandle(DirHandle:byte; Success:boolean):string;{E2h 15h}
{ returns Volume Name given a directory handle }
{ Programers guide to Netware Page 73-74}
  var
    Reply  : record
      Len  : Word;
      Stuff: array[1..05] of word;
      Name : array[1..16] of char;
      Remov: word;
    end;
    Request : record
      Len   : Word;
      SubF  : Byte;
      Handle: Byte;
    end;
  var NovRegs: Registers; { register type for DOS/Novell calls }

  begin
    Reply.Len := sizeof(Reply)-2;
    with Request do begin
      Len     := 2;
      SubF    := $15;
      Handle  := DirHandle;
    end;
    with NovRegs do begin
      AX := $E200;
      DS := Seg(Request);
      SI := Ofs(Request);
      ES := Seg(Reply);
      DI := Ofs(Reply);
      MsDos(NovRegs);
      Success := AL=0;
    end;
    GetVolumeWithHandle := copy(Reply.Name,1,16);
  end;  (* func *)


function GetDirHandleWithVolume(VolName:string16; Success:boolean):byte;{E2h 05h}
{ returns a directory handle given Volume Name }
{ Programers guide to Netware Page 73. }
  var
    Request  : record
      Len    : Word;
      SubF   : Byte;
      NameLen: byte;
      Name   : array[1..16] of char;
    end;
    Reply   : record
      Len   : Word;
      Handle: Byte;
    end;
  var NovRegs: Registers; { register type for DOS/Novell calls }
      i:byte;

  begin
    Reply.Len := sizeof(Reply)-2;
    with Request do begin
      Len     := sizeof(Request)-2;
      SubF    := $05;
      NameLen := length(VolName);
      for i:=1 to NameLen do Name[i]:=VolName[i];
    end;
    with NovRegs do begin
      AX := $E200;
      DS := Seg(Request);
      SI := Ofs(Request);
      ES := Seg(Reply);
      DI := Ofs(Reply);
      MsDos(NovRegs);
      Success := AL=0;
    end;
    GetDirHandleWithVolume := Reply.Handle;
  end;  (* func *)


function GetDefaultPathForDrive(Drive:char; var StatusFlags : Byte) : string;
{
  Status Byte
  9  8  7  6  5  4  3  2  1  0
  |     |                 |  +-Permenant Directory Handle
  |     |                 +----Temporary Directory Handle
  |     +----------------------Mapped to a local drive
  +----------------------------Invalid Drive
}
  var DirPath : String;
      DirHandle: byte;
      Success: boolean;
  begin
    DirHandle:=GetDirHandle(Drive,StatusFlags);
    if DirHandle=0 then StatusFlags:=9 else begin
      GetDirPath(DirHandle,DirPath);
      DirPath:=GetVolumeWithHandle(DirHandle,Success)+Drive+DirPath;
    end;
    GetDefaultPathForDrive:=DirPath;
  end;  (* func *)


function GetObjectName(ObjectID : longint;
                       var ObjectName : string47;
                       var ObjectType : integer):byte;
var
  Request   : record
    Len     : Word;
    Funct   : Byte;
    ObjID   : longint;
  end;
  Reply     : record
    Len     : Word;
    ObjID   : longint;
    ObjType : integer;
    ObjName : array[1..48] of char;
            end;
var NovRegs : Registers; { register type for DOS/Novell calls }
    i: byte;

  begin
    with Request do begin
      Len:=sizeof(Request)-2;
      Funct:=$36;
      ObjID:=ObjectID;
    end; (* with Request *)
    Reply.Len:=sizeof(Reply)-2;
    with NovRegs do begin
      AH := $E3;
      DS := Seg(Request);
      SI := Ofs(Request);
      ES := seg(Reply);
      DI := Ofs(Reply);
      MsDos(NovRegs);
      GetObjectName := AL;
    end;
    with Reply do begin
      ObjectName[0] := #0;
      for i:=1 to 47 do begin
        if ObjName[i]=#0 then break;
        ObjectName[i]:=ObjName[i];
        inc(ObjectName[0]);
      end;
      ObjectType:=ObjType;
    end; (* with Reply *)
  end;   (* func *)


function NetworkDrive(Drive: char): boolean;
  var NovRegs : Registers; { register type for DOS/Novell calls }
      Table: ^byte;
  begin
    with NovRegs do begin
      AX:=$EF01;
      msdos(NovRegs);
      Table := Ptr(ES,SI);
      Inc(Table, Ord(UPCASE(Drive)) - 65);
      If Table^ in [1,2,$81,$82] then NetworkDrive := TRUE else NetworkDrive := False;
    end;
  end;  (* func *)


function MakeLong(HiWord,LoWord : Word) : LongInt;
{takes hi and lo words and makes a longint }
Inline(
  $58/    { pop ax ; pop low word into AX }
  $5A);   { pop dx ; pop high word into DX }

function FileIsSharable(Path : String; var FAttr : Word; var ErrCode : Word)
                       : Boolean;
{ Return TRUE if ifle is flagged as shareable, return file attrib in FAttr }

var
  F                : File;

begin
  Assign(F,Path);
  GetFAttr(F,FAttr);
  ErrCode := DOSError;
  FileIsSharable := (FAttr and _SHAREABLE) <> 0   { see if SHARE }
                                                  { bit set.     }
end;

function MakeFileSharable(Path : String) : Word;

var
  F                : File;
  Attr             : Word;
  ErrCode          : Word;
  Share            : Boolean;

begin
  Share := FileIsSharable(Path,Attr,ErrCode);  { is it sharable? }
  if (ErrCode = 0) and (not Share) then begin
    Assign(F,Path);
    SetFAttr(F,Attr or _SHAREABLE); { OR existing at with SHARE bit }
    ErrCode := DOSError;
  end;
  MakeFileSharable := ErrCode;
end;

function SetExtFAttr(var PathName : Str80; Attr : Byte) : Byte;
{
  See GetExtFAttr for meaning of Attr the Attribute
  Function returns error code:
    0  - Success
    2  - File not found
    5  - Access denied
}

begin
  with NovRegs do begin
    AX := $B601;
    PathName := PathName + #0;
    DS := Seg(PathName[1]);
    DX := Ofs(PathName[1]);
    CL := Attr;
    MsDos(NovRegs);
    if Flags and FCarry <> 0 then
      SetExtFAttr := AL
    else
      SetExtFAttr := 0;
  end;
end;

function GetExtFAttr(var Path : String; var Attributes : Byte) : Byte;
{
  Meaning of Attributes:
  7   6   5   4   3   2   1   0
  |   |   |   |       |   |   |
  |   |   |   |       +---+---+------Search mode  [210]
  |   |   |   +----------------------transactional bit [4]
  |   |   +--------------------------Indexing bit [5]
  |   +------------------------------Read Audit bit [6]
  +----------------------------------Write Audit bit [7]
  Function returns error code:
    0  - Success
    2  - File not found
    18 - No more files (requesting workstation does not have search
                        rights)
}
begin
  with NovRegs do begin
    AX := $B600;
    Path[Succ(Length(Path))] := #0; { null terminate string }
    DS := Seg(Path[1]);             { skip length byte for AsciiZ string }
    DX := Ofs(Path[1]);
    MsDos(NovRegs);
    GetExtFAttr := AL;
    Attributes := CL;
  end;
end;

procedure EndOfJob(All : Boolean);
{
  forces an end of job
  If All is TRUE, then ends all jobs, otherwise ends a single job.
  Ending a job unlocks and clears all locked or logged files and records.
  It close all open network and local files and resets error and lock modes
}
begin
  with NovRegs do begin
    AX := $D600;
    if All then
      BX := $FFFF
    else
      BX := $00;
  end;
  MsDos(NovRegs);
end;

function ServerConnNo : Byte;
{ returns connection number of default file server (1..8) }

begin
  with NovRegs do
    AX := $F005;
  MsDos(NovRegs);
  ServerConnNo := NovRegs.AL
end;

function ConsolePriv : Boolean;

var
  Reply            : Word;
  Request          : record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $C8;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    ConsolePriv := AL <> $C6;
  end;
end;

function GetDirRights(DirHandle : Byte; PathName : String;
                      var Rights : Byte) : Byte;
{ returns the requesting workstation's effective directory rights }
{ return byte
  00h  - Success
  98h  - Volume Does Not Exist
  9Bh  - Bad Directory Handle

  Rights

  7  6  5  4  3  2  1  0
  |  |  |  |  |  |  |  +--Read bit (file reads allowed)
  |  |  |  |  |  |  +-----Write bit (file writes allowed)
  |  |  |  |  |  +--------Open bit (files can be opened)
  |  |  |  |  +-----------Create bit (files can be created)
  |  |  |  +--------------Delete bit (files may be deleted)
  |  |  +-----------------Parental bit (subdirs may be created/deleted
  |  |                                  and trustee rights granted/revoked)
  |  +--------------------Search bit (directory may be searched)
  +-----------------------Modify bit (file status bits can be modified)
}

var
  Reply            : record
                       Len     : Word;
                       Mask    : Byte;
                     end;
  Request          : record
                       Len     : Word;
                       SubF    : Byte;
                       Handle  : Byte;
                       Name    : String;
                     end;

begin
  Reply.Len := 1;
  with Request do begin
    Len     := 3 + Length(PathName);
    SubF    := $03;
    Handle  := DirHandle;
    Name    := PathName;
  end;
  with NovRegs do begin
    AX := $E200;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    GetDirRights := AL;
  end;
  with Reply do
    Rights := Mask;
end;

function IsLockModeExtended : Boolean;
{
  returns TRUE if using Advanced NetWare Extended Lock Mode, if FALSE,
  then in compatability mode (for compat with NetWare 4.61 and prior).
}
begin
  with NovRegs do begin
    AX := $C602;
    MsDos(NovRegs);
    IsLockModeExtended := AL = 1;
  end;
end;

function AllocPermDirHandle(DirHandle : Byte; DriveLetter : Char;
                            DirPath : String;
                            var NewHandle,Rights : Byte) : Byte;
{ Allocates a permament directory handle, not deleted automatically by EOJ.

return byte:
  00h  - Success
  98h  - Volume does not exist
  9Ch  - Invalid Path
}
var
  Req              : record
                       Len     : Word;
                       SubF    : Byte;
                       Handle  : Byte;
                       Letter  : Char;
                       PName   : String;
                     end;
  Reply            : record
                       Len     : Word;
                       NewH    : Byte;
                       Mask    : Byte;
                     end;

begin
  Reply.Len := 2;
  with Req do begin
    Len     := 4 + Length(DirPath);
    SubF    := $12;
    Handle  := DirHandle;
    Letter  := UpCase(DriveLetter);
    PName   := DirPath;
  end;
  with NovRegs do begin
    AX := $E200;
    DS := Seg(Req);
    SI := Ofs(Req);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    AllocPermDirHandle := AL;
  end;
  with Reply do begin
    NewHandle := NewH;
    Rights    := Mask;
  end;
end;

function AllocTempDirHandle(DirHandle : Byte; DriveLetter : Char;
                            DirPath : String;
                            var NewHandle,Rights : Byte) : Byte;
{ Allocates a temporary directory handle, deleted automatically by EOJ.

return byte:
  00h  - Success
  98h  - Volume does not exist
  9Ch  - Invalid Path
}
var
  Req              : record
                       Len     : Word;
                       SubF    : Byte;
                       Handle  : Byte;
                       Letter  : Char;
                       PName   : String;
                     end;
  Reply            : record
                       Len     : Word;
                       NewH    : Byte;
                       Mask    : Byte;
                     end;

begin
  Reply.Len := 2;
  with Req do begin
    Len     := 4 + Length(DirPath);
    SubF    := $13;
    Handle  := DirHandle;
    Letter  := UpCase(DriveLetter);
    PName   := DirPath;
  end;
  with NovRegs do begin
    AX := $E200;
    DS := Seg(Req);
    SI := Ofs(Req);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    AllocTempDirHandle := AL;
  end;
  with Reply do begin
    NewHandle := NewH;
    Rights    := Mask;
  end;
end;

function DeallocDirHandle(DirHandle : Byte) : Byte;
{ This function deletes a directory handle }
{ return byte:
  00h  - Success
  9Bh  - Bad directory handle
}
var
  Reply            : Word;
  Req              : record
                       Len    : Word;
                       SubF   : Byte;
                       DH     : Byte;
                     end;

begin
  Reply := 0;
  with Req do begin
    Len   := 2;
    SubF  := $14;
    DH    := DirHandle;
  end;
  with NovRegs do begin
    MsDos(NovRegs);
    DeallocDirHandle := AL;
  end;
end;

function ClearConnectionNumber(ConnNo : Byte) : Byte;
{ Clears a logical connection from the file server }
{ must have supervisor equivelent security rights  }

var
  Reply            : Word;
  Req              : Record
                       Len   : Word;
                       SubF  : Byte;
                       Conn  : Byte;
                     end;

begin
  Reply := 0;
  with Req do begin
    Len   := 2;
    SubF  := $D2;
    Conn  := ConnNo;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Req);
    SI := Ofs(Req);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    ClearConnectionNumber := AL;
  end;
end;

function CancelLPTCapture : Word;
begin
  with NovRegs do begin
    AX := $DF00;
    DX := $02;
    MsDos(NovRegs);
    CancelLPTCapture := AL
  end;
end;

function EndLPTCapture : Word;
begin
  with NovRegs do begin
    AX := $DF00;
    DX := $01;
    MsDos(NovRegs);
    EndLPTCapture := AL;
  end
end;

function FlushLPTCapture : Word;

begin
  with NovRegs do begin
    AX := $DF00;
    DX := $03;
    MsDos(NovRegs);
    FlushLPTCapture := AL
  end
end;

function GetDefaultLocalPrinter : PrinterDevice;

begin
  with NovRegs do begin
    AX := $B800;
    DX := $04;
    MsDos(NovRegs);
    GetDefaultLocalPrinter := PrinterDevice(DH MOD 3) { force in range 0..2 }
  end
end;

function StartLPTCapture : Word;

begin
  with NovRegs do begin
    AX := $DF00;
    DX := $00;
    MsDos(NovRegs);
    StartLPTCapture := AL
  end
end;

function LPTCaptureActive(var QueServer : Byte) : Boolean;

begin
  with NovRegs do begin
    AH:= $F0;
    AL := $03;
    MsDos(NovRegs);
    LPTCaptureActive := $FF = AH;
    QueServer := AL;
  end;
end;

procedure GetPrinterStatus(var PrinterNo,FormType : Byte;
          var OffLine,Stopped : Boolean);

var
  Request          : record
                       BufLen : Word; { 2 }
                       SubF,          { $06 }
                       Num    : Byte;
                     end;
  Reply            : record
                       BufLen : Word; { 4 }
                       Bytes  : Array[1..4] of Byte;
                     end;

begin
  with Request do begin
    BufLen := 2;
    SubF   := $06;
    Num    := PrinterNo;
  end;
  Reply.BufLen := 4;
  with NovRegs do begin
    AX := $E000;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
  end;
  MsDos(NovRegs);
  with Reply do begin
    Stopped   := Bytes[1] = $FF;
    OffLine   := Bytes[2] = $01;
    FormType  := Bytes[3];
    PrinterNo := Bytes[4];
  end;
end;

procedure SetDefaultLocalPrinter(LPTNo : PrinterDevice);

begin
  with NovRegs do begin
    AX := $DF00;
    DL := $05;
    DH := Ord(LPTNo);
  end;
  MsDos(NovRegs);
end;

function GetBannerUser : String;
{ returns the user name that is printed on the banner page }

var
  Buf              : String;

begin
  with NovRegs do begin
    AX := $B808;
    ES := Seg(Buf);
    BX := Ofs(Buf);
    MsDos(NovRegs)
  end;
  { process buf }
  GetBannerUser := Buf;
end;

procedure GetServerDateTime(var Year,Month,Day,Hour,Minute,Second : Word;
                            var WeekDay : DayOfTheWeek);
type
  ReplyBuffer      = array[1..10] of Byte;

var
  Reply            : ReplyBuffer;

begin
  with NovRegs do begin
    AX := $E700;
    DS := Seg(Reply);
    DX := Ofs(Reply);
  end; {with}
  MsDos(NovRegs);
  Year    := Word(Reply[1]) + 1900;
  Month   := Word(Reply[2]);
  Day     := Word(Reply[3]);
  Hour    := Word(Reply[4]);
  Minute  := Word(Reply[5]);
  Second  := Word(Reply[6]);
  WeekDay := DayOfTheWeek(Reply[7]);
end;

function GetServerDateTimeString:string;
  var  Year,Month,Day,Hour,Minute,Second : Word;
       WeekDay : DayOfTheWeek;
  begin
    GetServerDateTime(Year,Month,Day,Hour,Minute,Second,WeekDay);
    GetServerDateTimeString:=Day_of_week_String(Month,Day,Year)+' '+
       LeadingZero(Month)+'/'+LeadingZero(Day)+'/'+LeadingZero(Year)+
       '  '+LeadingZero(Hour)+':'+LeadingZero(Minute)+':'+LeadingZero(Second);

  end;  (* func *)


function DisableServerLogin : Boolean;
{ returns true if file server login is successfully disabled }
{ THIS FUNCTION DISABLES ALL LOGINS TO A SERVER FROM ANY WORKSTATION }
{ Use EnableServerLogin to enable (must be called from same WS) }
var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $CB;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    DisableServerLogin := AL = 0;
  end
end;


function EnableServerLogin : Boolean;
{ returns true if file server login is successfully enabled }
{ Use DisableServerLogin to disable (must be called from same WS }

var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $CC;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    EnableServerLogin := AL = 0;
  end
end;

function DownFileServer(ForceItDown : Boolean) : Byte;
{
  DOWNS the server!!!
  Warning, this function will really down your file server kiddo!
  If ForceItDown is TRUE, it will down the server EVEN IF FILES ARE OPEN!!!
}

var
  Reply            : Word;
  Request          : Record
                       Len   : Word;
                       SubF  : Byte;
                       Force : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 2;
    SubF := $D3;
    Force := Ord(ForceItDown);
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    DownFileServer := AL;
  end
end;

function GetLoginStatus(var LoginEnabled : Boolean) : Byte;
{ if Login is enabled then returns TRUE in LoginEnabled }
{ return byte
  00h  - Success
  C6h No Console Rights
}
var
  Reply            : record
                       Len     : Word;
                       Flag    : Byte;
                     end;
  Request          : record
                       Len     : Word;
                       SubF    : Byte;
                     end;

begin
  Reply.Len := 1;
  with Request do begin
    Len     := 1;
    SubF    := $CD;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    GetLoginStatus := AL;
  end;
  with Reply do
    LoginEnabled := Boolean(Flag);
end;

function ServerCopy(Source,Dest : Word; SOff,DOff,NoBytes : LongInt;
                    var NoBytesCopied : LongInt) : Byte;

var
  Request          : Record
                       S,
                       D   : Word;
                       S_O,
                       D_O,
                       NB  : LongInt;
                     end;

begin
  with Request do begin
    S  := Source;
    D  := Dest;
    S_O := Soff;
    D_O := DOff;
    NB := NoBytes;
  end;
  with NovRegs do begin
    AX := $F300;
    ES := Seg(Request);
    DI := Ofs(Request);
    MsDos(NovRegs);
    NoBytesCopied := MakeLong(CX,DX);
    ServerCopy    := AL;
  end;
end;

procedure PurgeAllErased;
{ actually delete all deleted files from server }

var
  Request          : record
                       Len   : Word;
                       SubF  : Byte;
                     end;
  Reply            : Word;

begin
  Reply := 0;
  with Request do begin
    Len := 1;
    SubF := $CE;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
  end;
end;

procedure PurgeErased;
{ delete only files deleted by requesting WS from server }

var
  Request          : record
                       Len   : Word;
                       SubF  : Byte;
                     end;
  Reply            : Word;

begin
  Reply := 0;
  with Request do begin
    Len := 1;
    SubF := $10;
  end;
  with NovRegs do begin
    AX := $E200;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
  end;
end;

function AttachToServer(ServerConnID : Byte) : Byte;
{ Create an attachment between a server and a workstation }
{ Does not Login the workstation }

begin
  with NovRegs do begin
    AX := $F100;
    DL := ServerConnID;
    MsDos(NovRegs);
    AttachToServer := AL;
  end;
end;

function DetachFromServer(ServerConnID : Byte) : Byte;
{ this functions logs the object out, and detaches the workstation from }
{ the file server. }
begin
  with NovRegs do begin
    AX := $F101;
    DL := ServerConnID;
    MsDos(NovRegs);
    DetachFromServer := AL;
  end;
end;

function TTSAbort : Byte;
{ Return code:
  00h  - success
  FDh  - TTS Disabled
  FEh  - Transaction ends records locked (trans aborted, but recs left locked
  FFh  - no explicit transaction active
}
begin
  with NovRegs do begin
    AX := $C703;
    MsDos(NovRegs);
    if Flags and FCarry <> 0 then
      TTSAbort := AL
    else
      TTSAbort := 0;
  end;
end;

function TTSBegin : Byte;
{ return code:
  00h  - Success
  96h  - Out of Dynamic Workspace
  FEh  - Implicit transaction active (active implicit turned into explicit)
  FFh  - Explicit Transaction active
}

begin
  with NovRegs do begin
    AX := $C700;
    MsDos(NovRegs);
    if Flags and FCarry <> 0 then
      TTSBegin := AL
    else
      TTSBegin := 0;
  end
end;

function TTSEnd(var ID : LongInt)  : Byte;
{ return code:
  00h  - Success
  FDh  - TTS Disabled
  FEh  - Tranaction ends records locked
  FFh  - No Explicit transaction active
}

begin
  with NovRegs do begin
    AX := $C701;
    MsDos(NovRegs);
    ID := MakeLong(CX,DX);
    if Flags and FCarry <> 0 then
      TTSEnd := AL
    else
      TTSEnd := 0;
  end
end;

function TTSGetAppThresh(var Logical,Physical : Byte) : Boolean;

begin
  with NovRegs do begin
    AX := $C705;
    MsDos(NovRegs);
    TTSGetAppThresh := AL = 0;
    Logical  := CL;
    Physical := CH;
  end;
end;

function TTSGetWSThresh(var Logical,Physical : Byte) : Boolean;

begin
  with NovRegs do begin
    AX := $C707;
    MsDos(NovRegs);
    TTSGetWSThresh := AL = 0;
    Logical  := CL;
    Physical := CH;
  end;
end;

function TTSAvailable : Boolean;

begin
  with NovRegs do begin
    AX := $C702;
    MsDos(NovRegs);
    TTSAvailable := AL = 1;
  end
end;

function TTSSetAppThresh(Logical,Physical : Byte) : Byte;

begin
  with NovRegs do begin
    AX := $C706;
    CL := Logical;
    CH := Physical;
    MsDos(NovRegs);
    TTSSetAppThresh := AL;
  end;
end;

function TTSSetWSThresh(Logical,Physical : Byte) : Byte;

begin
  with NovRegs do begin
    AX := $C708;
    CL := Logical;
    CH := Physical;
    MsDos(NovRegs);
    TTSSetWSThresh := AL;
  end;
end;

function TTSStatus(ID : LongInt) : Boolean;
{ returns TRUE if referenced transaction has been committed to disk }

begin
  with NovRegs do begin
    AH := $C7;
    AL := $04;
    CX := HiLong(ID);
    DX := LowLong(ID);
    MsDos(NovRegs);
    TTSStatus := AL = 0;
  end
end;

function TTSDisable : Boolean;

var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $CF;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    TTSDisable := AL = 0;
  end
end;

function TTSEnable : Boolean;

var
  Reply            : Word;
  Request          : Record
                       Len  : Word;
                       SubF : Byte;
                     end;

begin
  Reply := 0;
  with Request do begin
    Len  := 1;
    SubF := $D0;
  end;
  with NovRegs do begin
    AX := $E300;
    DS := Seg(Request);
    SI := Ofs(Request);
    ES := Seg(Reply);
    DI := Ofs(Reply);
    MsDos(NovRegs);
    TTSEnable := AL = 0;
  end
end;

function UsersFullName(UserName:string12): string;
  var Regs: Registers; { register type for DOS/Novell calls }
      User: string;
      i,j,k: byte;
      Request: record
        Length  : word;
        Funct   : byte;
        ObjType : word;
        NameLeng: byte;
        Stuff   : array[1..30] of char;
        {
        ObjName : array[1..14] of char;
        Segment : byte;
        FNameLen: byte;
        Property: array[1..14] of char;
        }
      end;
      Reply: record
        Length  : word;
        FullName: array[1..128] of char;
        MoreSeg : byte;
        flags   : byte;
      end;
  var temp: string;
  begin
    while UserName[length(UserName)]=' ' do dec(UserName[0]);
    if UserName='' then begin
      UsersFullName:='';
      EXIT;
    end;
    with Request do begin
      Funct   :=$3D;
      ObjType :=$0100;
      NameLeng:=system.length(UserName);
      for i:=1 to NameLeng do Stuff[i]:=UserName[i];
      inc(i); Stuff[i]:=chr($1); {Segment :=$1;}
      inc(i); Stuff[i]:=chr(14); {FNameLen:=14;}
      Temp:='IDENTIFICATION';
      k:=1;
      for j:=i+1 to i+15 do begin
        Stuff[j]:=Temp[k]; inc(k);{Property}
      end;
      Length:=sizeof(Request)-(14-NameLeng)-2;
    end;
    Reply.Length:=sizeof(Reply)-2;
    with Regs do begin
      AH:=$E3;
      DS:=seg(Request);
      SI:=ofs(Request);
      ES:=seg(Reply);
      DI:=ofs(Reply);
      msdos(Regs);
      {case AL of
        000: success
        150: server out of mem
        241: Invalid Bindery Security
        251: No such property
        252: No such object
        254: Server bindery locked
        255: Bindery failure
      end;}
    end;
    if Regs.AL=0 then with Reply do begin
      User:='';
      i:=1;
      while FullName[i]<>#0 do begin
        User:=User+' ';
        User[i]:=FullName[i];
        inc(i);
        if i>128 then break;
      end;
    end else User:='';
    UsersFullName:=User;
  end;   (* func *)


function Digit2Char(D : byte) : char;
      { Converts a digit to a char }
var
  S : string;
begin
  Str(D, S);
  Digit2Char := S[1];
end; { Int2Str }


function UsersGroups(UserName:string12): pointer;{GroupArrayPtr;}
  var Regs: Registers; { register type for DOS/Novell calls }
      AddressStr: string;
      i,j,k: byte;
      Request: record
        Length  : word;
        Funct   : byte;
        ObjType : word;
        NameLeng: byte;
        Stuff   : array[1..30] of char;
        {
        ObjName : array[1..15] of char;
        Segment : byte;
        FNameLen: byte;
        Property: array[1..13] of char;
        }
      end;
      Reply: record
        Length  : word;
        Groups: array[1..128] of byte;
        MoreSeg : byte;
        flags   : byte;
      end;
  var temp: string;
  begin
    with Request do begin
      Funct   :=$3D;
      ObjType :=$0100;
      NameLeng:=system.length(UserName);
      for i:=1 to NameLeng do Stuff[i]:=UserName[i];
      i:=NameLeng+1;
      Stuff[i]:=chr($1); {Segment :=$1;}
      inc(i);
      Stuff[i]:=chr(14); {FNameLen:=14;}
      Temp:='GROUPS_I''M_IN';
      k:=1;
      for j:=i+1 to i+14 do begin
        Stuff[j]:=Temp[k]; inc(k);{Property}
      end;
      Length:=sizeof(Request)-(15-NameLeng)-2;
    end;
    Reply.Length:=sizeof(Reply)-2;
    with Regs do begin
      AH:=$E3;
      DS:=seg(Request);
      SI:=ofs(Request);
      ES:=seg(Reply);
      DI:=ofs(Reply);
      msdos(Regs);
      {case AL of
        000: success
        150: server out of mem
        241: Invalid Bindery Security
        251: No such property
        252: No such object
        254: Server bindery locked
        255: Bindery failure
      end;}
    end;
    if Regs.AL=0 then with Reply do begin
      AddressStr:='';
      i:=1;
      for i:=1 to 128 do begin
        AddressStr:=AddressStr+' ';
        AddressStr[i]:=Digit2Char(Groups[i]);
      end;
      UsersGroups:=@Groups;
    end else UsersGroups:=Nil;
  end;   (* func *)


function GetDriveHandleTable:pointer;
  {Programmer's Guide to NetWare Page 279. EFh 00h}
  var NovRegs:registers;
  begin
    with NovRegs do begin
      AH:=$EF;
      AL:=$00;
      MsDos(NovRegs);
      GetDriveHandleTable:=@mem[ES:SI];
    end;
  end;  (* func *)


function GetDriveFlagTable:pointer;
  {Programmer's Guide to NetWare Page 280. EFh 01h}
  var NovRegs:registers;
  begin
    with NovRegs do begin
      AH:=$EF;
      AL:=$01;
      MsDos(NovRegs);
      GetDriveFlagTable:=@mem[ES:SI];
    end;
  end;  (* func *)


function GetDriveConnectionIDTable:pointer;
  {Programmer's Guide to NetWare Page 280. EFh 02h}
  var NovRegs:registers;
  begin
    with NovRegs do begin
      AH:=$EF;
      AL:=$02;
      MsDos(NovRegs);
      GetDriveConnectionIDTable:=@mem[ES:SI];
    end;
  end;  (* func *)


function GetFileServerNameTable:pointer;
  {Programmer's Guide to NetWare Page 280-281. EFh 04h}
  var NovRegs:registers;
  begin
    with NovRegs do begin
      AH:=$EF;
      AL:=$04;
      MsDos(NovRegs);
      GetFileServerNameTable:=@mem[ES:SI];
    end;
  end;  (* func *)


function GetServerOfDrive(Drive:char):string48;
  type
      PChar=array[1..48] of char;
  var
      i:byte;
      p:^byte;
      q:^PChar;
      ConnNum:byte;
      SName:string48; {Server Name}
  begin
    p:=GetDriveConnectionIDTable;
    inc(p,Ord(UpCase(Drive)) - Ord('A'));
    ConnNum:=p^;
    q:=GetFileServerNameTable;
    inc(q,ConnNum-1);
    i:=1;
    SName:='';
    while q^[i]<>#0 do begin
      SName:=SName+q^[i];
      inc(i);
    end;
    GetServerOfDrive:=SName;
  end;  (* func *)


function GetConnectionIDofServer(ServerName:string48):word;
  type Aarray=array[1..48] of char;

  function AtoS(A:Aarray):string;
    var i:byte;
        S:string;
    begin
      S:=A[1];
      for i:=2 to 48 do if A[i]=#0 then break else S:=S+A[i];
      AtoS:=S;
    end;  (* func *)

  type ServerTable=array[1..8] of Aarray;
  var ServerPtr:^ServerTable;
      i:byte;
  begin
    ServerName:=UpcaseStr(ServerName);
    GetConnectionIDofServer:=0;
    ServerPtr:=GetFileServerNameTable;
    for i:=1 to 8 do if AtoS(ServerPtr^[i])=ServerName then begin
      GetConnectionIDofServer:=i;
      break;
    end;
  end;  (* func *)


function GetDefaultServerName:string48;
  type ServerTable=array[1..8,1..48] of char;
  var ServerPtr:^ServerTable;
      i,Conn:byte;
      Server:string48;
  begin
    ServerPtr:=GetFileServerNameTable;
    Conn:=GetDefaultServerConnection;
    Server:=ServerPtr^[Conn,1];
    for i:=2 to 48 do if ServerPtr^[Conn,i]=#0
      then break
      else Server:=Server+ServerPtr^[Conn,i];
    GetDefaultServerName:=Server;
  end;  (* func *)


function GetDefaultServerConnection:byte;
  {Programmer's Guide to NetWare Page 277. F0h 02h}
  begin
    asm
      mov ax, 0F002h
      INT 21h
      mov @result, al
    end;
  end;  (* func *)


function GetPrimaryServerConnection:byte;
  {Programmer's Guide to NetWare Page 278-279. F0h 05h}
  begin
    asm
      mov ax, 0F005h
      INT 21h
      mov @result, al
    end;
  end;  (* func *)


procedure SetPrimaryServerConnection(Conn:byte); assembler;
  {Programmer's Guide to NetWare Page 279. F0h 04h}
  asm
    mov ax, 0F004h
    mov dl, Conn
    INT 21h
  end;  (* proc *)


function GetPreferedServerConnection:byte;
  {Programmer's Guide to NetWare Page 278. F0h 01h}
  begin
    asm
      mov ax, 0F001h
      INT 21h
      mov @result, al
    end;
  end;  (* func *)


procedure SetPreferedServerConnection(Conn:byte); assembler;
  {Programmer's Guide to NetWare Page 278. F0h 00h}
  asm
    mov ax, 0F000h
    mov dl, Conn
    INT 21h
  end;  (* proc *)


procedure SetPreferedServer(ServerName:string48);
  begin
    SetPreferedServerConnection(GetConnectionIDofServer(ServerName));
  end;   (* proc *)

{***************** The following routines stolen from *********************}
{***************** Scott Harwood's and Paul Darrow's  *********************}
{***************** SNetwork.pas 3/7/94. Sid.          *********************}

Function OldGetInternetWorkNetworkAddress(ConnectionNo: word): string20;
{
   Uses Netware funtion $E3, $13 to map a connection number
   Programmer's guide to NetWare Page 275
   Returns <Network Number + Physical Node Address>
}
var i : integer;
    regs : registers;
    netaddr : string20;
    request, return : GenericPacket;

begin

   if ConnectionNo>MaxConnections then begin
     OldGetInternetWorkNetworkAddress:='';
     exit;
   end;
   { *********** Set up the request packet ************ }

   request[0] := 4;  {  request packet length: low }
   request[1] := 0;   { request packet length: high }
   request[2] := 19; { Function: Map a connection to an Internetwork address }
   request[3] := ConnectionNo;

   {************** Set up the return packet **************}

   return[0] := 254; return[1] := 0;

   { *********** Set up the pointers to the packets **********}

   with regs do begin
         ah := $e3;
         ds := seg(Request);
         si := ofs(Request);
         es := seg(Return);
         di := ofs(Return);
   end;

   { *********** DO IT ********************  }

   msdos(regs);

   { ************ Check for results ************* }
    if regs.al <> 0 then begin
      OldGetInternetWorkNetworkAddress := ''; { call not successful}
      Exit;            {<------------------------------------- Error exit }
    end;

    NetAddr := '';
    for i := 2 to 11 do begin
       NetAddr := NetAddr + Byte2Hex(Return[i]);
    end;


    OldGetInternetWorkNetworkAddress := NetAddr;

end; { OldGetInternetWorkNetworkAddress }


function GetInternetWorkNetworkAddress(ConnectionNum:word):string20;
  var Regs: Registers;   (* $E3 $13  Programmer's Guide to Netware Pg.275 *)
      Request: record
        Leng: word;
        Func: byte;
        Conn: byte;
      end; (* Request *)
      Reply : record
        Leng: word;
        NetN: array[1..4] of byte;  (* Network Number *)
        Addr: array[1..6] of byte;  (* Physical Node Address *)
        Sock: array[1..2] of byte;  (* Socket Number *)
      end; (* Reply *)
  begin
    with Request do begin
      Leng:=sizeof(Request)-2;
      Func:=$13;
      if ConnectionNum>MaxConnections then begin
        GetInternetWorkNetworkAddress:='';
        exit;
      end;
      Conn:=ConnectionNum;
    end; (* Request *)
    Reply.Leng:=sizeof(Reply)-2;
    with Regs do begin
      AH:=$E3;
      DS:=seg(Request);
      SI:=ofs(Request);
      ES:=seg(Reply);
      DI:=ofs(Reply);
      msdos(Regs);
      if AL=0 then with Reply do begin
        GetInternetWorkNetworkAddress:= Byte2Hex(NetN[1])+Byte2Hex(NetN[2])+
                  Byte2Hex(NetN[3])+Byte2Hex(NetN[4])+
                  Byte2Hex(Addr[1])+Byte2Hex(Addr[2])+Byte2Hex(Addr[3])+
                  Byte2Hex(Addr[4])+Byte2Hex(Addr[5])+Byte2Hex(Addr[6]);
      end else GetInternetWorkNetworkAddress:='';
    end; (* Regs *)
  end;  (* func *)


Function GetNetworkAddress(ConnectionNo: word): string12;
{
   Uses Netware funtion $E3, $13 to map a connection number
   Programmer's guide to NetWare Page 275
   Returns <Physical Node Address> of station at ConnectionNo
}
var i : byte;
    addr,netaddr : string20;

begin
  addr:=GetInternetWorkNetworkAddress(ConnectionNo);
  if addr='' then GetNetworkAddress:='' else begin
    netaddr:=addr[9];
    for i:=10 to 20 do netaddr:=netaddr+addr[i];
    GetNetworkAddress:=netaddr;
  end;
end; { GetNetworkAddress }


function GetNetworkNumberOfConnection(ConnectionNum:integer; var Address:string12):string8;
  var i : byte;
      addr,netnum : string20;
  begin
    addr:=GetInternetWorkNetworkAddress(ConnectionNum);
    if addr='' then begin
      GetNetworkNumberOfConnection:='';
      Address:='';
    end else begin
      netnum:=addr[1];
      for i:=2 to 8 do netnum:=netnum+addr[i];
      GetNetworkNumberOfConnection:=netnum;
      Address:=addr[9];
      for i:=10 to 20 do Address:=Address+addr[i];
    end;
  end;  (* func *)


function GetNetworkNumber:string8;
  var i : byte;
      addr,netnum : string20;
  begin
    addr:=GetInternetWorkNetworkAddress(GetConnectionNumber);
    if addr='' then GetNetworkNumber:='' else begin
      netnum:=addr[1];
      for i:=2 to 8 do netnum:=netnum+addr[i];
      GetNetworkNumber:=netnum;
    end;
  end;  (* func *)


PROCEDURE Cast_Off;

TYPE
  String60 = STRING[ 60 ];
  Packet   = ARRAY[ 0..79 ] OF BYTE;

VAR
  RequestBuffer, ReplyBuffer : Packet;
  regs : REGISTERS;

BEGIN
  regs.ah := $E1;
  regs.ds := seg(requestbuffer);
  regs.si := ofs(requestbuffer);
  regs.es := seg(replybuffer);
  regs.di := ofs(replybuffer);
  requestbuffer[0] := 0;          { Packet    }
  requestbuffer[1] := 3;          {    Length }
  requestbuffer[2] := 2;          { 2 = stop broadcasts }
  replybuffer[0] := 0;            { Packet    }
  replybuffer[1] := 2;            {    Length }

  INTR($21, regs);
  IF regs.al = 0 THEN
    writeln ('Station Broadcasts Disabled')
  ELSE IF regs.al = $FE THEN
    writeln ('I/O falure or lack of dynamic workspace.')
  ELSE IF regs.al = $FC THEN
    writeln ('Message queue is full.');
END;

PROCEDURE Cast_On;

TYPE
  String60 = STRING[ 60 ];
  Packet   = ARRAY[ 0..79 ] OF BYTE;

VAR
  RequestBuffer, ReplyBuffer : Packet;
  regs : REGISTERS;

BEGIN
  regs.ah := $E1;
  regs.ds := seg(requestbuffer);
  regs.si := ofs(requestbuffer);
  regs.es := seg(replybuffer);
  regs.di := ofs(replybuffer);
  requestbuffer[0] := 0;          { Packet    }
  requestbuffer[1] := 3;          {    Length }
  requestbuffer[2] := 3;          { 3 = accept broadcasts }
  replybuffer[0] := 0;            { Packet    }
  replybuffer[1] := 2;            {    Length }

  INTR($21, regs);
  IF regs.al = 0 THEN
    writeln ('Station Broadcasts Are Enabled.')
  ELSE IF regs.al = $FE THEN
    writeln ('I/O failure or lack of dynamic workspace.');
END;

FUNCTION SendBroadcastMessage;

VAR
  RequestBuffer : RECORD
                    plength : WORD;
                    func    : BYTE;
                    numstat : BYTE;
                    list    : BYTE;
                    message : STRING [59];
                  END;

  ReplyBuffer : RECORD
                  plength : WORD;
                  numstat : BYTE;
                  list    : BYTE;
                END;

  regs : REGISTERS;

  loop : BYTE;

BEGIN
  regs.ah := $E1;

  regs.ds := seg(requestbuffer);
  regs.si := ofs(requestbuffer);
  regs.es := seg(replybuffer);
  regs.di := ofs(replybuffer);

  requestbuffer.plength := 4 + LENGTH (msg);
  requestbuffer.func    := $00;
  requestbuffer.numstat := 1;
  requestbuffer.list    := station;
  requestbuffer.message := msg;
  replybuffer.plength := sizeof (replybuffer);

  INTR($21, regs);

  IF replybuffer.list <> 00 THEN
    SendBroadcastMessage := FALSE
  ELSE
    SendBroadcastMessage := TRUE;
END;

PROCEDURE GetBroadcastMessage;

VAR
  RequestBuffer : RECORD
                    plength : WORD;
                    func    : BYTE;
                  END;

  ReplyBuffer : RECORD
                  rlength : WORD;
                  msg     : STRING;
                END;
  regs : REGISTERS;

BEGIN
  regs.ah := $E1;
  regs.ds := seg(requestbuffer);
  regs.si := ofs(requestbuffer);
  regs.es := seg(replybuffer);
  regs.di := ofs(replybuffer);

  requestbuffer.plength := 3;
  requestbuffer.func    := $01;
  replybuffer.rlength := sizeof (replybuffer);

  INTR($21, regs);
  mess := ReplyBuffer.msg;
END;


FUNCTION GetMyName;

VAR
  packet : RECORD
             plength : WORD;
             func    : BYTE;
             connect : BYTE;
           END;

  return : RECORD
             rlength : WORD;
             uid     : LONGINT;
             tpe     : BYTE;
             oname   : STRING [48];
             ltime   : ARRAY [1..8] OF CHAR;
           END;

  regs   : REGISTERS;

BEGIN
  packet.plength := SIZEOF (packet);
  return.rlength := SIZEOF (return);

  packet.func    := 22;

  packet.connect := GetConnectionNumber;

  regs.AH := $E3;
  regs.ds := SEG (packet);
  regs.SI := OFS (packet);
  regs.ES := SEG (return);
  regs.DI := OFS (return);

  INTR ($21,regs);

  IF return.uid <> 0 THEN
    BEGIN
      return.oname[0] := CHR(48);
      While ((length(return.oname))>0) AND (return.oname[length(return.oname)] = #0) do
         dec( return.oname[0] );
      GetMyName := COPY (return.oname, 1, length(return.oname));
    END
END;


PROCEDURE get_logged_users;

{ UserList is defined as ARRAY [1..150] OF RECORD
                                             Name   : STRING[48];
                                             Number : BYTE;
                                             uid    : LONGINT;
                                             utype  : BYTE;
                                           END;
}
VAR
  packet : RECORD
             plength : WORD;
             func    : BYTE;
             connect : BYTE;
           END;

  return : RECORD
             rlength : WORD;
             ruid    : LONGINT;
             rtype   : BYTE;
             oname   : STRING [48];
             ltime   : ARRAY [1..8] OF CHAR;
           END;

  regs   : REGISTERS;
  loop   : word;

BEGIN
  packet.plength := SIZEOF (packet);
  return.rlength := SIZEOF (return);

  packet.func    := 22;

  c := 0;
  FOR loop := 1 TO MaxConnections DO
  BEGIN
    packet.connect := loop;

    regs.AH := $E3;
    regs.ds := SEG (packet);
    regs.SI := OFS (packet);
    regs.ES := SEG (return);
    regs.DI := OFS (return);

    INTR ($21,regs);

    IF return.ruid <> 0 THEN
    BEGIN
      INC (c);
      users[c].number := loop;
      users[c].uid := return.ruid;
      users[c].utype := return.rtype;
      return.oname[0] := CHR(48);
      users[c].name := TruncName(return.oname);
    END
  END;
END;

Function GetProperty(ObjectName, PropertyName : string40): string40;
{  Written by C. Michael Bell, 1992
   Used with permission by Paul Darrow, 1993

   Scans the bindery for object ObjectName, returns
   value of Property for that object.
}
var i : integer;
    regs : registers;
    id : string40;
    request, return : GenericPacket;

begin
   request[2] := 61; { Function: Read a Property Value }
   request[3] := 0;  request[4] := 1; { ObjectType := Net_User }

   { ObjectName := LastName }
   request[5] := Length(ObjectName);
   for i:= 6 to 6 + Length(Objectname) -1 do
       request[i] := ord( Objectname[i-5]);

   request[7 + Length(Objectname)-1 ] := 1;  {segment #1 }

   request[8 + Length(Objectname) -1] := length(PropertyName);
   for i := 1 To length(PropertyName) Do Begin
      request[9 + Length(Objectname)-1 + i-1] := ord(PropertyName[i]);
   End;

   { Request.PacketLength := 9 + length of ObjectName +
     length of SearchPropName }
   request[0] := 8 + length(Objectname) + Length(PropertyName);
   request[1] := 0;

    with regs do begin
         ah := $e3;
         ds := seg(Request);
         si := ofs(Request);
         es := seg(Return);
         di := ofs(Return);
    end;

    return[0] := 254; return[1] := 0;

    msdos(regs);
    if regs.al <> 0 then
      GetProperty := '' { call not successful}
    else
    begin
       { Get return.data. The first string contains the id }
       i := 2;
       WHILE Return[i] <> 0 Do Begin
             id[i-1] := chr(Return[i]);
             i := i + 1;
       End;
       id[0] := chr(i - 2);
       GetProperty := id;
    end;
end; { GetProperty }

FUNCTION UserStationNum( UserName : STRING; FirstConnectionNoToCheck:word ) : WORD;

VAR
  packet : RECORD
             plength : WORD;
             func    : BYTE;
             connect : BYTE;
           END;

  return : RECORD
             rlength : WORD;
             ruid    : LONGINT;
             rtype   : BYTE;
             oname   : STRING [48];
             ltime   : ARRAY [1..8] OF CHAR;
           END;

  regs   : REGISTERS;
  loop   : word;
  quit   : BOOLEAN;
  name   : STRING[ 50 ];

BEGIN
  packet.plength := SIZEOF (packet);
  return.rlength := SIZEOF (return);

  packet.func    := 22;

  quit := false;
  loop := FirstConnectionNoToCheck;
  if loop<=MaxConnections then REPEAT
    packet.connect := loop;

    regs.AH := $E3;
    regs.ds := SEG (packet);
    regs.SI := OFS (packet);
    regs.ES := SEG (return);
    regs.DI := OFS (return);

    INTR ($21,regs);

    IF return.ruid <> 0 THEN
    BEGIN
      return.oname[0] := CHR(48);
      name := TruncName(return.oname);
      delete( name, length(name), 1 );
    END;
    IF name = UserName THEN
       quit := TRUE;
    inc( loop );
  UNTIL (loop >= MaxConnections) OR quit;
  IF loop < MaxConnections THEN
    UserStationNum := loop-1
  ELSE
    UserStationNum := 0;  { send code for user not found. }
END;


FUNCTION CheckPipe;

VAR
  request : RECORD
              plength   : WORD;
              pfunc     : BYTE;
              pnumstats : BYTE;
              statfrom  : BYTE;
              statto    : BYTE;
            END;
  reply : RECORD
            length    : WORD;
            numstats  : BYTE;
            pipestat1 : BYTE;
            pipestat2 : BYTE;
          END;
  reg : REGISTERS;

BEGIN
  checkpipe := FALSE;
  WITH reg DO BEGIN
    ah := $E1;
    ds := SEG (request);
    si := OFS (request);
    es := SEG (reply);
    di := OFS (reply);
  END;
  WITH request DO BEGIN
    plength := 6;
    pfunc := 8;
    pnumstats := 2;
    statfrom := stat1;
    statto := stat2;
  END;
  reply.length := 5;
  reply.numstats := 2;

  INTR ($21, reg);

  IF (reply.pipestat1 = 0) AND (reply.pipestat2 = 0) THEN
    checkpipe := TRUE;
END;

PROCEDURE OpenPipe;

VAR
  request : RECORD
              plength   : WORD;
              pfunc     : BYTE;
              pnumstats : BYTE;
              statfrom  : BYTE;
              statto    : BYTE;
            END;
  reply : RECORD
            length    : WORD;
            numstats  : BYTE;
            pipestat1 : BYTE;
            pipestat2 : BYTE;
          END;
  reg : REGISTERS;
  st,st2 : STRING[10];

BEGIN
  WITH reg DO BEGIN
    ah := $E1;
    ds := SEG (request);
    si := OFS (request);
    es := SEG (reply);
    di := OFS (reply);
  END;
  WITH request DO BEGIN
    plength := 6;
    pfunc := 6;
    pnumstats := 2;
    statfrom := stat1;
    statto := stat2;
  END;
  reply.length := 5;
  reply.numstats := 2;

  INTR ($21, reg);
END;

PROCEDURE ClosePipe (stat1, stat2 : BYTE);

VAR
  request : RECORD
              plength   : WORD;
              pfunc     : BYTE;
              pnumstats : BYTE;
              statfrom  : BYTE;
              statto    : BYTE;
            END;
  reply : RECORD
            length    : WORD;
            numstats  : BYTE;
            pipestat1 : BYTE;
            pipestat2 : BYTE;
          END;
  reg : REGISTERS;

BEGIN
  WITH reg DO BEGIN
    ah := $E1;
    ds := SEG (request);
    si := OFS (request);
    es := SEG (reply);
    di := OFS (reply);
  END;
  WITH request DO BEGIN
    plength := 6;
    pfunc := 7;
    pnumstats := 2;
    statfrom := stat1;
    statto := stat2;
  END;
  reply.length := 5;
  reply.numstats := 2;

  INTR ($21, reg);
END;

PROCEDURE SendPipeMessage;

VAR
  request : RECORD
              plength   : WORD;
              pfunc     : BYTE;
              pnumstats : BYTE;
              pstation : BYTE;
              pmsg      : STRING;
            END;
  reply : RECORD
            length   : WORD;
            numstats : BYTE;
            rstation : BYTE;
          END;
  reg : REGISTERS;
  i : BYTE;

BEGIN
  WITH reg DO BEGIN
    ah := $E1;
    ds := SEG (request);
    si := OFS (request);
    es := SEG (reply);
    di := OFS (reply);
  END;
  WITH request DO BEGIN
    plength := 5 + length(msg);
    pfunc := 4;
    pnumstats := 1   ;
    pstation := stat2;
    pmsg := msg;
  END;
  reply.length := SIZEOF (reply);

  INTR ($21, reg);
END;


PROCEDURE GetPipeMessage;

VAR
  request : RECORD
              plength : WORD;
              pfunc   : BYTE;
            END;
  reply : RECORD
            length     : WORD;
            sourcestat : BYTE;
            pmsg       : STRING;
          END;
  reg : REGISTERS;

BEGIN
  Msg := '';
  WITH reg DO BEGIN
    ah := $E1;
    ds := SEG (request);
    si := OFS (request);
    es := SEG (reply);
    di := OFS (reply);
  END;
  request.plength := 3;
  request.pfunc := 5;
  reply.length := SIZEOF (reply);

  INTR ($21, reg);

  IF (reg.al = 0) THEN
    msg := reply.pmsg;
END;


FUNCTION OpenSemaphore;

VAR
  regs : REGISTERS;

BEGIN
  regs.ah := $C5;
  regs.al := 00;
  regs.ds := seg(str);
  regs.dx := ofs(str);
  regs.cl := 1;

  INTR($21, regs);

  IF regs.al = 0 THEN
  BEGIN
    OpenSemaphore := regs.bl;
    SemHandleHi := regs.cx;
    SemHandleLo := regs.dx;
  END
  ELSE IF regs.al = $FF THEN
    WRITELN ('ERROR !  Invalid initial value.')
  ELSE IF regs.al = $FE THEN
    WRITELN ('ERROR !  Invalid string length.')
  ELSE IF regs.al = $96 THEN
    WRITELN ('ERROR !  Out of work memory in file server.')
  ELSE
    WRITELN ('ERROR in OpenSamaphore !!!');
END;

FUNCTION ExamineSemaphore;

VAR
  regs : REGISTERS;

BEGIN
  regs.ah := $C5;
  regs.al := 1;
  regs.cx := SemHandleHi;
  regs.dx := SemHandleLo;

  INTR($21, regs);

  IF regs.al = 0 THEN
    ExamineSemaphore := regs.dl
  ELSE IF regs.al = $FF THEN
    WRITELN ('Invalid Semaphore handle.')
  ELSE
    WRITELN ('ERROR in ExamineSemaphore !!!');
END;

PROCEDURE WaitSemaphore;

VAR
  regs : REGISTERS;

BEGIN
  regs.ah := $C5;
  regs.al := 2;
  regs.cx := SemHandleHi;
  regs.dx := SemHandleLo;
  regs.bp := 0;  { Timeout value in 1/18 seconds (0 means no wait) }

  INTR($21, regs);

  IF regs.al = $FF THEN
    WRITELN ('Invalid Semaphore handle.')
  ELSE IF regs.al = $FE THEN
    WRITELN ('Semaphore timeout (did not work)')
  ELSE
    WRITELN ('ERROR in WaitSemaphore !!!');
END;

PROCEDURE SignalSemaphore;

VAR
  regs : REGISTERS;

BEGIN
  regs.ah := $C5;
  regs.al := 3;
  regs.cx := SemHandleHi;
  regs.dx := SemHandleLo;

  INTR($21, regs);

  IF regs.al = $FF THEN
    WRITELN ('Invalid Semaphore handle.')
  ELSE IF regs.al = $01 THEN
    WRITELN ('Semaphore overflow (value too large).')
  ELSE
    WRITELN ('ERROR in SignalSemaphore !!!');
END;

PROCEDURE CloseSemaphore;

VAR
  regs : REGISTERS;

BEGIN
  regs.ah := $C5;
  regs.al := 4;
  regs.cx := SemHandleHi;
  regs.dx := SemHandleLo;

  INTR($21, regs);

  IF regs.al = $FF THEN
    WRITELN ('Invalid Semaphore handle.')
  ELSE
    WRITELN ('ERROR!!!');
END;

{*************************** End Stolen Routines ****************************}

function Socket(OpenClose:byte):word;
  {Programmer's Guide to NetWare Page 442. }
  var NovRegs:registers;
  begin
    with NovRegs do begin
      BX:=OpenClose;
      AL:=$00;
      DX:=$0000;
      MsDos(NovRegs);
      if AL=$00
        then Socket:=DX {Success! Return Assigned Socket}
        else Socket:=AL;{Failure. Returns $FE if Socket Table is full
                                          $FF if Socket is already open}
    end;
  end;  (* func *)


FUNCTION BroadcastMode(Mode:byte) : WORD;
BEGIN

  ASM

    push ss
    push ds
    mov ah, 0DEh
    mov dl, Mode
    INT 21h
    pop ds
    pop ss
    sub ah, ah
    mov @result, ax

  END;

END; {GetBroadcastMode}

function IPX_Installed:boolean;
  var Regs : registers ;
  begin
    Regs.AX := $7A00 ;
    intr($2F,Regs) ;
    IPX_Installed:= (Regs.AL = $FF)
  end;

function Netbios_Installed:Boolean;
  var Regs : registers ;
  begin
    Regs.AH := $35; (* DOS function that checks an interrupt vector *)
    Regs.AL := $5C; (* Interrupt vector to be checked *)
    NetBios_Installed := True;
    msdos(Regs) ;
    if ((Regs.ES = 0) or (Regs.ES = $F000))
      then  NetBios_Installed := False
  end;

function NetShell_Installed:Boolean;
  var Regs : registers ;
      ReplyBuffer : array[1..40] of char ;
  begin
    with Regs do begin
      AH := $EA ;
      AL := 1 ;
      BX := 0 ;
      ES := seg(ReplyBuffer) ;
      DI := ofs(ReplyBuffer) ;
    end ; (* with do begin *)
    msdos(regs) ;
    NetShell_Installed := (Regs.BX = 0)
   end;

END.


procedure Log(station : BYTE; Msg : STRING);
{ By Sid Nash for logging anonomous messages }
  var LogFile:string;
      F:text;
      Year,Month,Day,Hour,Minute,Second : Word;
      WeekDay : DayOfTheWeek;
  begin
    LogFile:='g:\pcinfo\log\slog.txt';
    if (not OpenR(F,LogFile)) then begin
      if not OpenW(F,LogFile) then EXIT;
    end else begin
      {$I-}
      assign(F,LogFile);
      append(F);
      {$I+}
      if IOResult<>0 then EXIT;
    end;
    GetServerDateTime(Year,Month,Day,Hour,Minute,Second,WeekDay);
    writeln(F,'From: ',GetMyName,' ',GetStationAddress,' ',
            'To: ',Net(person.username),GetNetworkAddress(Station),
            ' ',LeadingZero(Month),'/',LeadingZero(Day),'/',Year,' ',
            LeadingZero(Hour),':',LeadingZero(Minute),'.',LeadingZero(Second));
    writeln(F,'"',Msg,'"'); writeln(F);
    close(F);
  end;   (* proc *)
procedure ;
  begin
  end;   (* proc *)




