/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       TEST.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Tirza van Rijn
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1991/4/18
**
** DESCRIPTION: Testfile
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   TEST.C  $
** LOGINFO:     $Log:   I:/TIRZA/CPROG/BEHOLDER/APS/READDUMP/VCS/TEST.C_V  $
**              
**                 Rev 1.0   18 Apr 1991 15:26:54   tirza
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/TIRZA/CPROG/BEHOLDER/APS/READDUMP/VCS/TEST.C_V   1.0   18 Apr 1991 15:26:54   tirza  $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>


#define REC_FRAME       0xF8        /* Marks start of a frame */
#define BYTE            unsigned char

struct rec_hdr {
    unsigned char type;
    short len;
};

/* Compare DP.H _DPBUF for the first 6 items */
static struct frame {
    short Dev;                      /* Logic dev# [0..DPMAXDEV-1]  */
    unsigned long ClockMs;          /* Timestamp in micro seconds  */
    unsigned short Status;          /* Status bits - internal use  */
    unsigned short Size;            /* Packet length in bytes      */
    BYTE *pBuf;                     /* Pointer to packet's content */
    struct frame *pNext;            /* Pointer - internal use      */
    BYTE DestAddr [6];              /* Packet destination address  */
    BYTE SrcAddr [6];               /* Packet source address       */
    BYTE PacketType [2];            /* Protocol type               */
    BYTE Data[1600];                /* Packet data contents        */
};


int ReadByteFromFile (FILE *file, BYTE *b)
{
    return ((fread(b, 1, 1, file) == 1) ? 0 : EOF);
}

int ReadIntFromFile (FILE *file, short *i)
{
    BYTE t1, t2;

    if (ReadByteFromFile(file, &t1) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t2) == EOF)
        return (EOF);
    *i = (t2 << 8) | t1;
    return (0);
}

int ReadLongFromFile (FILE *file, long *l)
{
    BYTE t1, t2, t3, t4;

    if (ReadByteFromFile(file, &t1) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t2) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t3) == EOF)
        return (EOF);
    if (ReadByteFromFile(file, &t4) == EOF)
        return (EOF);
    *l = (t4 << 24) | (t3 << 16) | (t2 << 8) | t1;
    return (0);
}

hexdump (BYTE *Data, unsigned short Length)
{
	int i, j;
	int c;

    for (i=0;i<(int)Length;i++)
	{
		printf ("%02x ", Data[i]);
		if ((i & 15) == 15)
		{
			for (j=i-15;j<=i;j++)
			{
				c = (int) Data[j];
				if (c >= ' ' && c <= '~')
					putchar (c);
				else
					putchar ('.');
			}
            printf("\n");
		}
    }
    for (i=(int)Length & 15;i<16;i++)
        fputs("   ", stdout);
    for (;j<(int)Length;j++)
    {
        c = (int) Data[j];
		if (c >= ' ' && c <= '~')
			putchar (c);
		else
			putchar ('.');
    }
    printf("\n");
}


void main(int argc, char *argv[])
{
    int t = 1;
    int i;
    FILE *dumpfile;
    struct rec_hdr hdr;
    struct frame buf;

    if (argc == 2)
        dumpfile = fopen(argv[1], "r");
    else
        dumpfile = fopen("netcapt.dmp", "r");
    if (dumpfile != NULL)
    {
        while ((ReadByteFromFile(dumpfile, &hdr.type) == 0) &&
               (ReadIntFromFile(dumpfile, &hdr.len) == 0))
        {
            if (hdr.type == REC_FRAME)
            {
                if ((ReadIntFromFile (dumpfile, &buf.Dev) == 0) &&
                    (ReadLongFromFile (dumpfile, &buf.ClockMs) == 0) &&
                    (ReadIntFromFile (dumpfile, &buf.Status) == 0) &&
                    (ReadIntFromFile (dumpfile, &buf.Size) == 0) &&
                    (fread(&buf.pBuf, sizeof(buf.pBuf), 1, dumpfile) == 1) &&
                    (fread(&buf.pNext, sizeof(buf.pNext), 1, dumpfile) == 1) &&
                    (fread(&buf.DestAddr, sizeof(BYTE), 6, dumpfile) == 6) &&
                    (fread(&buf.SrcAddr, sizeof(BYTE), 6, dumpfile) == 6) &&
                    (fread(&buf.PacketType, sizeof(BYTE), 2, dumpfile) == 2) &&
                    (fread(&buf.Data, sizeof(BYTE), (buf.Size-(6+6+2)), dumpfile) == (buf.Size-(6+6+2))))
                {
                    printf("FRAME #%d\n", t++);
                    printf("Frame length = %d\n", hdr.len);
                    printf("Logic device # = %d\n", buf.Dev);
                    printf("Timestamp (in us): %d:%02d:%02d\n", (int)((buf.ClockMs / 1000000L) % 1000),
                            (int)((buf.ClockMs / 1000L) % 1000), (int)(buf.ClockMs % 1000));
                    printf("Status %d\n", buf.Status);
                    printf("Packet length (in bytes) = %d\n", buf.Size);
                    printf("Destination address: %02x:%02x:%02x:%02x:%02x:%02x\n",
                            buf.DestAddr[0], buf.DestAddr[1],
                            buf.DestAddr[2], buf.DestAddr[3],
                            buf.DestAddr[4], buf.DestAddr[5]);
                    printf("Source address: %02x:%02x:%02x:%02x:%02x:%02x\n",
                            buf.SrcAddr[0], buf.SrcAddr[1],
                            buf.SrcAddr[2], buf.SrcAddr[3],
                            buf.SrcAddr[4], buf.SrcAddr[5]);
                    printf("Protocol type: %02x%02x\n", buf.PacketType[0], buf.PacketType[1]);
					printf("Data:\n");
					hexdump(buf.Data, (buf.Size-(6+6+2)));
                    printf("\n\n\n");
                }
            }
            else
				fread(&buf, sizeof(BYTE), (hdr.len-3), dumpfile);
        }
    }
    else
        printf("Can't open dumpfile\n");
    fclose(dumpfile);
}

