/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Functions to select a Type Filter
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPUPREF.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUPREF.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:27:04   etstjan
**              Initial revision.
*************************************************************************/
#include <stdarg.h>                         /* for (,...) */
#include <stdio.h>                          /* for NULL */
#include <power3.h>
#include <dp.h>
#include "dpu.h"                            /* main include file */

#define NROW        0

static int ProcSelectPreFilt(PWWIN *pWin, int action, int element);
static DPTYPEFILT *AddPreFilt(int srow, int scol);
static int ProcSelectPreFiltList(PWWIN *pWin, int action, int element);

static int nTypeFiltList;
static int PreFiltElem = 0;
static int TypeFiltListElem = 0;
static DPTYPEFILT **PreFiltArray;

static DPTYPEFILT *AddPreFilt(int srow, int scol)
{
    if (pw_selectstruct(srow, scol, NROW, 12, "Pre-filter", DpTypeFiltAvailable, NULL, DpuProcSelect, 0, &PreFiltElem) != PWK_ESC)
        return DpTypeFiltAvailable[PreFiltElem];
    else
        return (DPTYPEFILT *)0;
}

static int ProcSelectPreFiltList(PWWIN *pWin, int action, int element)
{
    int i;
    DPTYPEFILT *pPreFilt;

    switch (action)
    {
    case PWA_INIT:
        nTypeFiltList = 0;
        while (PreFiltArray[nTypeFiltList])
            nTypeFiltList++;
        pw_shade(pWin);
        pw_keyinfo(pWin, NULL, "Ins=Add  Del=Delete  Enter=Accept");
        break;
    case PWA_INSERT:
        if (nTypeFiltList < DPMAXTYPEFILT)
        {
            if (pPreFilt = AddPreFilt(pw_winsrow(pWin), pw_winscol(pWin)+pw_winncol(pWin)+2))
            {
                i = 0;
                while ((PreFiltArray[i]) && (PreFiltArray[i] != pPreFilt))
                    i++;
                if (!PreFiltArray[i])
                {
                    for (i=nTypeFiltList; i>element; i--)
                        PreFiltArray[i] = PreFiltArray[i-1];
                    PreFiltArray[element] = pPreFilt;
                    PreFiltArray[++nTypeFiltList] = (DPTYPEFILT *)0;
                }
            }
        }
        break;
    case PWA_DELETE:
        if (nTypeFiltList)
        {
            nTypeFiltList--;
            for (i=element; i<nTypeFiltList; i++)
                PreFiltArray[i] = PreFiltArray[i+1];
            PreFiltArray[nTypeFiltList] = (DPTYPEFILT *)0;
        }
        break;
    case PWA_ENTER:
        element = -1;
        break;
    }
    return element;
}

/************************************************************************
** NAME:        DpuSelectPreFilt
** SYNOPSIS:    void DpuSelectPreFilt(srow, scol, Dev)
**              int srow,scol       Window position
**              int Dev             Network device #
** DESCRIPTION: Let the user select a Type Filter for device
** RETURNS:     void
*************************************************************************/
void DpuSelectPreFilt(srow, scol, Dev)
int srow;
int scol;
int Dev;
{
    if (DpDevActive[0].PktInt != 0)
    {
        PreFiltArray = DpDevActive[0].TypeFiltActive;
        pw_selectstruct(srow, scol, DPMAXTYPEFILT, 12, "Pre-filters", DpDevActive[0].TypeFiltActive, NULL, ProcSelectPreFiltList, 0, &TypeFiltListElem);
    }
    else
        pw_warning("No Network Device drivers present");
}


