{$i-}PROGRAM convert_olx_folders_to_speed_folders;
USES dos;
CONST
  progdesc = 'OLX2SPD - Free DOS utility: Converts folders from OLX to SPEED 1.40 format.';
  author   = 'v1.02: September 14, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
  OLXHeader = '|OLX$SOM|';
  colon = #58;
  QWKField = 25;

TYPE
  stringQWK = STRING[QWKField];
  array6   = ARRAY[1..6] OF char;
  array8   = ARRAY[1..8] OF char;

  OLX_rec=RECORD
    BBSID      : stringQWK;
    conf_numb  : word;
    conf_name  : stringQWK;
    msgnum     : ARRAY[1..7] OF char;
    refernum   : array8;
    private,
    receipt,
    ExHeader   : boolean;
    msgdate    : array8;
    msgtime    : array6;
    whofrom,
    whoto,
    subject    : stringQWK;
    readFlag   : boolean;
    lsubject   : STRING[60]; { these are not in original, but added by me }
    lsboole    : boolean;    { in order to deal with long subject lines   }
  END;                       { lsboole=TRUE if subject line was >25 chars }
(*
  CNF_rec=RECORD
    statusFlag,
    letterA    : char;
    conf_numb  : word;
    conf_name,
    BBSID      : stringQWK;
    msgdate    : array8;
    msgtime    : array6;
    refernum   : array8;
    msglines   : word;
  END;

  IDX_rec=RECORD
    msgoffset  : longint;
    whofrom,
    whoto      : stringQWK;
    msgnum     : array[1..7]  of char;
    subject    : stringQWK;
    SPEEDread,
    PermOrKill : char;
  END;
*)

PROCEDURE showhelp (problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
CONST
  usage    = 'Usage:  OLX2SPD folders(s)_to_convert[.SAV]';
VAR
  message : STRING[79];
BEGIN
  writeln;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      3 : message:='No files found.  First parameter must be a valid file specification.';
      4 : message:='Invalid first line of .IDX file.';
      5 : message:='The current .TMP temporary file already exists.  Rename or delete it.';
      6 : message:='You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message:='Error opening, closing, or renaming a file.  Original may be renamed!'
    ELSE  message:='Undefined error.'
    END;
    writeln (#7,'Error encountered:'); writeln (message); writeln;
  END;
  writeln (usage);
  halt (problem);
END;

PROCEDURE iocheck (iores :byte);
BEGIN
  IF (iores <> 0) THEN showhelp (7);
END;

FUNCTION nameof (fn :STRING):STRING;
BEGIN
  IF (pos ('.', fn) > 0) THEN
    nameof:=copy (fn, 1, (pos ('.', fn)-1))
  ELSE
    nameof:=fn;
END;

FUNCTION getfsize (filename :STRING) :longint;
VAR
  sr : searchrec;
BEGIN
  findfirst (filename, anyfile, sr);
  IF (doserror = 0) THEN
    getfsize:=sr.size
  ELSE
    getfsize:=-1;
END;

PROCEDURE openolx (VAR olxf :text; fname :STRING);
VAR
  olxline   : STRING;
BEGIN
  assign (olxf, fname+'.sav');
  reset (olxf);      iocheck (ioresult);
  REPEAT                               { find the first OLXHeader }
    readln (olxf, olxline);
  UNTIL (eof (olxf) OR (olxline = OLXHeader)) ;
END;

PROCEDURE openidx (VAR idxf :text; fname :STRING; VAR tmsgs :word);
VAR
  nummsgs : STRING;
  valerr  : integer;
BEGIN
  assign (idxf, fname+'.idx');
  reset (idxf);
  IF (ioresult <> 0) THEN BEGIN
    rewrite (idxf);  iocheck (ioresult);
    tmsgs:=0;
    writeln (idxf, '00000');
    flush (idxf);
  END
  ELSE BEGIN
    readln (idxf, nummsgs);
    val (nummsgs, tmsgs, valerr);
    IF ((length (nummsgs) <> 5) OR (valerr <> 0)) THEN
      showhelp (4);
    close (idxf);    iocheck (ioresult);
    append (idxf);   iocheck (ioresult);
  END;
END;

PROCEDURE resetcnf (VAR cnff :text; fname :STRING; VAR fsize :longint);
BEGIN
  fsize:=(getfsize (fname+'.cnf'));
  assign (cnff, fname+'.cnf');
  IF (fsize =-1) THEN BEGIN 
    rewrite (cnff);  iocheck (ioresult);
    fsize:=0;
  END
  ELSE BEGIN
    append (cnff);   iocheck (ioresult);
  END;
END;

PROCEDURE opentmp (VAR tfile :text; fname :STRING);
BEGIN
  assign (tfile, fname+'.tmp');
  append (tfile);
  IF (ioresult = 0) THEN
    showhelp (5)
  ELSE BEGIN 
    rewrite (tfile); iocheck (ioresult);
  END;
END;

FUNCTION leadingzero (w :Word; l :byte) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w :0, s);
  WHILE (Length (s) < l) DO
    s:='0'+s;
  LeadingZero:=s;
END;

FUNCTION yesno (yn :STRING) :boolean;
BEGIN
  IF (yn = 'No') THEN
    yesno:=FALSE
  ELSE
    yesno:=TRUE;
END;

FUNCTION olxdate (datestr :STRING):STRING;
BEGIN
  olxdate:=copy (datestr, 6, 2)+'-'+
    copy (datestr, 9, 2)+'-'+
    copy (datestr, 3, 2);
END;

FUNCTION olxtime (timestr :STRING):STRING;
VAR
  ampm   : char;
  hour   : byte;
  valerr : integer;
  temp   : byte;
BEGIN
  val (copy (timestr, 1, 2), temp, valerr);
  IF (temp > 11)
    THEN ampm:='p'
    ELSE ampm:='a';
  IF (temp > 12) THEN
    temp:=temp MOD 12;
  olxtime:=leadingzero (temp, 2)+colon+copy (timestr, 4, 2)+ampm;
END;

PROCEDURE init_info (VAR olxr :olx_rec);
BEGIN
  WITH olxr DO BEGIN
    fillchar (bbsid[1], sizeof (bbsid), 0);
    conf_numb:=0;
    fillchar (conf_name[1], sizeof (conf_name), 0);
    fillchar (msgnum[1], sizeof (msgnum), 32);
    fillchar (refernum[1], sizeof (refernum), 32);
    private:=FALSE;
    receipt:=FALSE;
    ExHeader:=FALSE;
    fillchar (msgdate[1], sizeof (msgdate), 32);
    fillchar (msgtime[1], sizeof (msgtime), 32);
    fillchar (whofrom[1], QWKField, 32);
    fillchar (whoto[1], QWKField, 32);
    fillchar (subject[1], QWKField, 32);
    readFlag:=FALSE;
    lsubject:='';
    lsboole:=FALSE;
  END;
END;

FUNCTION fillstring (v :STRING) :stringQWK;
VAR
  count : byte;
  s : stringQWK;
BEGIN
  s[0]:=chr (25);
  fillchar (s[1], 25, 32);
  FOR count:=1 TO length (v) DO
    IF (count <= QWKField) THEN
      s[count]:=v[count];
  FillString:=s;
END;

PROCEDURE read_info (VAR olxf :text; VAR olxr :olx_rec);
CONST
  comma=#44;
VAR
  current_line,
  keyword,
  varword,
  tempstr      : STRING; { used to convert date & time strings to arrays }
  count,
  colonpos     : byte;
  valerr       : integer;
BEGIN
  REPEAT
    readln (olxf, current_line);
    colonpos:=pos (colon, current_line);
    IF (colonpos > 1) THEN BEGIN 
      keyword:=copy (current_line, 1, colonpos-1);
      varword:=copy (current_line, colonpos+2, 60-(colonpos+1));
      WITH olxr DO
        IF (keyword = 'BBS') THEN
          BBSID:=varword
        ELSE
          IF (keyword = 'Conference') THEN BEGIN 
            val (copy (varword, 1, (pos (comma, varword)-1)), conf_numb, valerr);
            conf_name:=copy (varword, 
              (pos (comma, varword)+1), length (varword)-pos (comma, varword));
          END
        ELSE
          IF (keyword = 'Number') THEN
            FOR count:=1 TO length (varword) DO
              msgnum[count]:=varword[count]
        ELSE
          IF (keyword = 'Reply-to') THEN
            FOR count:=1 TO length (varword) DO
              refernum[count]:=varword[count]
        ELSE
          IF (keyword = 'Private') THEN
            private:=yesno (varword)
        ELSE
          IF (keyword = 'Receipt') THEN
            receipt:=yesno (varword)
        ELSE
          IF (keyword = 'ExHeader') THEN
            ExHeader:=yesno (varword)
        ELSE
          IF (keyword = 'Date') THEN BEGIN 
            tempstr:=olxdate (copy (varword, 1, (pos (comma, varword)-1)));
            FOR count:=1 TO length (tempstr) DO
              msgdate[count]:=tempstr[count];
            tempstr:=olxtime (copy (varword, 
              (pos (comma, varword)+1), length (varword)-pos (comma, varword)));
            FOR count:=1 TO length (tempstr) DO
              msgtime[count]:=tempstr[count];
          END
        ELSE
          IF (keyword = 'From') THEN
            whofrom:=FillString (varword)
        ELSE
          IF (keyword = 'To') THEN
            whoto:=FillString (varword)
        ELSE
          IF (keyword = 'Subject') THEN BEGIN
            subject:=FillString (varword);
            IF (length (varword) > QWKField) THEN BEGIN
              lsubject:=varword;
              lsboole:=TRUE;
            END
          END
        ELSE
          IF (keyword = 'Flags') THEN
            IF (copy (varword, 1, 4) = 'Read') THEN readFlag:=TRUE
            ELSE readFlag:=FALSE
    END;
  UNTIL (eof (olxf) OR (current_line = '')) ;
END;

PROCEDURE writemsg (VAR olxf, tmpf :text; VAR lines :word);
VAR
  nextline,
  thisline : STRING;
BEGIN
  lines:=0;
  readln (olxf, thisline);
  readln (olxf, nextline);
  WHILE ((NOT eof (olxf)) AND (nextline <> OLXHeader)) DO BEGIN
    writeln (tmpf, thisline);
    inc (lines);
    thisline:=nextline;
    readln (olxf, nextline);
  END;
  IF (eof (olxf)) THEN BEGIN 
    writeln (tmpf, thisline);
    inc (lines);
  END;
END;

PROCEDURE writecnf (VAR cfile, tfile :text; olxr :olx_rec; lines :word);
VAR
  lslen   : byte;
  msgl    : STRING;
  PubPriv : char;
BEGIN
(*
  writeln (?file, receipt);
  writeln (?file, ExHeader);  { I doubt that SPEED uses this OLX stuff }
*)
{ QWK format settings, SPEED seems to have the private ones reversed ... }
{ ' ' = public, unread   - corresponds to (NOT private AND NOT readFlag) }
{ '-' = public, read     - corresponds to (NOT private AND     readFlag) }
{ '+' = private, unread  - corresponds to (    private AND NOT readFlag) }
{ '*' = private, read    - corresponds to (    private AND     readFlag) }

  WITH olxr DO BEGIN
    IF ((NOT private) AND (NOT readFlag)) THEN
      PubPriv:=#32
    ELSE
      IF ((NOT private) AND (readFlag)) THEN
        PubPriv:='-'
    ELSE
      IF ((private) AND (NOT readFlag)) THEN
        PubPriv:='*'  { I have kludged this for SPEED compatibility }
    ELSE
      { IF (private) and (readFlag) THEN }
      PubPriv:='+';   { I have kludged this for SPEED compatibility }

    writeln (cfile, PubPriv+'A');
    writeln (cfile, colon, conf_numb);
    writeln (cfile, colon, conf_name);
    writeln (cfile, colon, BBSID);
    writeln (cfile, msgdate);
    writeln (cfile, msgtime);
    writeln (cfile, refernum);
    IF (lsboole) THEN inc (lines);
    writeln (cfile, lines);

    close (cfile);    iocheck (ioresult);
    append (cfile);   iocheck (ioresult);
    close (tfile);    iocheck (ioresult);
    reset (tfile);    iocheck (ioresult);
    IF (lsboole) THEN BEGIN
      lslen:=length (lsubject);
      lsubject[0]:=chr (60);
      IF (lslen < 60) THEN
        fillchar (lsubject[lslen+1], 60-lslen, #32);
      writeln (cfile, #255, '@SUBJECT:', lsubject, 'N');
    END;
    WHILE (NOT eof (tfile)) DO BEGIN
      readln (tfile, msgl);
      writeln (cfile, msgl);
    END;
  END;
END;

PROCEDURE writeidx (VAR ifile :text; olxr :olx_rec; cnf_filesize :longint);
BEGIN
  WITH olxr DO BEGIN
    writeln (ifile, cnf_filesize);
    writeln (ifile, whofrom);
    writeln (ifile, whoto);
    writeln (ifile, msgnum);
    writeln (ifile, subject);
    writeln (ifile, 'Y ');        { Y = read by SPEED, then permanent/kill }
  END;              { "Read" and "normal" forced for simplicity and safety }
END;

PROCEDURE fixidx (VAR ifile, tfile :text; tmsgs :word);
VAR
  msgl : STRING;
BEGIN
  reset (ifile);    iocheck (ioresult);
  rewrite (tfile);  iocheck (ioresult);
  readln (ifile, msgl);
  writeln (tfile, leadingzero (tmsgs, 5));
  WHILE (NOT eof (ifile)) DO BEGIN
    readln (ifile, msgl);
    writeln (tfile, msgl);
  END;
  close (ifile);    iocheck (ioresult);
  close (tfile);    iocheck (ioresult);
END;

PROCEDURE swapnames (VAR ifile, tfile :text; tname :pathstr);
BEGIN
  rename (ifile, tname+'.swp');  iocheck (ioresult);
  rename (tfile, tname+'.idx');  iocheck (ioresult);
  erase (ifile);                 iocheck (ioresult);
END;

PROCEDURE matchdates (VAR cfile, tfile :text);
VAR
  filedt    : longint;    { file date and time, to match dates     }
BEGIN
  reset (cfile);    iocheck (ioresult);
  reset (tfile);    iocheck (ioresult);
  getftime (cfile, filedt);
  setftime (tfile, filedt);
  close (cfile);    iocheck (ioresult);
  close (tfile);    iocheck (ioresult);
END;

VAR
  olx_file,
  cnf_file,
  idx_file,
  tmp_file  : text;
  info      : OLX_rec;
(*
  cnf       : CNF_rec;
  idx       : IDX_rec;
*)
  fpath     : pathstr;    { source file path,          }
  fdir      : dirstr;     {             directory,     }
  folder    : namestr;    {             name,          }
  fext      : extstr;     {             extension.     }
  dirinfo   : searchrec;  { contains filespec info.    }

  textname,
  fname     : STRING[8];  {             name, again    }

  cnf_size  : longint;
  msglines,               { number of lines in the current message }
  initmsgs,
  totalmsgs,              { total number of messages per folder    }
  numdone   : word;       { numdone is number of files processed   }

BEGIN
  writeln (progdesc);
  writeln (author);
  IF (paramcount <> 1) THEN showhelp (0);
  fpath:=paramstr (1);
  IF (fpath[1] IN ['/', '-']) THEN showhelp (0);
  fsplit (fexpand (fpath), fdir, folder, fext);
  IF (folder = '') THEN showhelp (6);
  
  findfirst (fdir+folder+'.sav', archive, dirinfo);
  IF (doserror <> 0) THEN showhelp (3);
  writeln;
  writeln ('Converting folders from OLX to SPEED in directory: ', fdir);
  numdone:=0;
  
  WHILE (doserror = 0) DO BEGIN 
    fname:=nameof (dirinfo.name);
    textname:=fname;
    textname[0]:=chr (8);
    fillchar (textname[length (fname)+1], 8-length (fname), #46);
    
    write ('Converting folder: ', textname);
    inc (numdone);
    
    openolx (olx_file, fdir+fname);
    openidx (idx_file, fdir+fname, totalmsgs);
    initmsgs:=totalmsgs;
    
    WHILE (NOT eof (olx_file)) DO BEGIN 
      init_info (info);
      read_info (olx_file, info);
      opentmp (tmp_file, fdir+fname);
      writemsg (olx_file, tmp_file, msglines);
      resetcnf (cnf_file, fdir+fname, cnf_size);
      writecnf (cnf_file, tmp_file, info, msglines);
      
      close (cnf_file);  iocheck (ioresult);
      close (tmp_file);  iocheck (ioresult);
      erase (tmp_file);  iocheck (ioresult);
      
      writeidx (idx_file, info, cnf_size);
      inc (totalmsgs);
    END;
    
    close (olx_file);    iocheck (ioresult);
    close (idx_file);    iocheck (ioresult);
    fixidx (idx_file, tmp_file, totalmsgs); { put num of msgs at start of IDX }
    swapnames (idx_file, tmp_file, fdir+fname);

    matchdates (cnf_file, tmp_file);   { tmp_file is actually the .idx file }
    writeln (', added ', totalmsgs-initmsgs :2,
          ' message(s) to ', initmsgs :2,
          ', for a total of ', totalmsgs :2, '.');
    findnext (dirinfo);
  END;
  writeln ('Converted ', numdone, ' folder(s).');
END.

