
#include <stdio.h>
#include "exc.h"
#include "hr_timer.h"

unsigned int maxI = 1000000;

void LoopProc (char *p)
{
  int i;
  for (i=0; i<maxI; i++)
      *p=0;
}

void Exc_13_Continue (void)
{
  /* continue at instruction after *p=0 in above for loop.       */
  /* Generate ASM/LST output to make sure correct offset is used */

  except.EIP += 3;
}

/*---------------------------------------------------------------------*/

int main ()
{
  unsigned int start,t1,t2,dummy;

  InstallExcHandler (NULL,0);
  excHookMain = &Exc_13_Continue;

  SetHiResTimer();

  printf("Timing %u exception 13.. ",maxI);
  start = GetMilliSec();
  LoopProc ((char*)-1);         /* causes exception 13 */
  t1 = GetMilliSec() - start;
  printf("%5u mS\n",t1);

  printf("Timing %u empty loops... ",maxI);
  start = GetMilliSec();
  LoopProc ((char*) &dummy);    /* point to safe location */
  t2 = GetMilliSec() - start;
  printf("%5u mS\n",t2);

  printf("Exception overhead........... %5u S\r\n",1000*(t1-t2)/maxI);
  printf("Exceptions per second........ %5u\r\n",   1000*maxI/t1);
  return 0;
}

