/*
 * File: fxwicon.r
 *  Contents: XIconic, XIconImage, XIconLabel, XMoveIcon, XWindowLabel
 */

#ifdef XIcon

#define RootState IconicState+1


"XIconic(w,s) - iconify/de-iconify a window or return state"

function{0,1} XIconic(argv[argc])
   abstract {
      return string
   }
   body {
      wbp    _w_;
      int warg = 0;
      tended char *tmp;

      OptWindow;

      {
      STDLOCALS(_w_);

#ifndef PresentationManager
      if (ws->iconic == RootState)           /* can't (de)iconify the root */
	 fail;
#else					/* PresentationManager */
      /* doesn't apply to bitmaps */
      if (!stdwin) fail;
#endif					/* PresentationManager */

      if (warg < argc) {
	 if (!cnv:C_string(argv[warg],tmp))        /* convert to check arg */
	    runerr(103,argv[warg]);
	 if (!strcmp(tmp, "icon")) {         /* request to iconify */
#ifndef PresentationManager
	    if (ws->iconic == NormalState)
#ifdef Iconify
	       XIconifyWindow(stddpy, stdwin, wd->screen);
#else					/* Iconify */
	       fail;
#endif					/* Iconify */
#else					/* PresentationManager */
           /* already a window ? */
           if (ws->winState & WS_MIN) fail;
           /* dumb hack - see WM_PAINT in rxwindw.r */
           SETMINPEND(_w_);
           ws->winState = WS_MIN;
           WinSetWindowPos(ws->hwndFrame, 0, 0, 0, 0, 0, SWP_MINIMIZE);
#endif					/* PresentationManager */
	    }
	 else if (!strcmp(tmp, "window")) {  /* request to de-iconify */
#ifndef PresentationManager
	    if (ws->iconic == IconicState)
	       XMapWindow(stddpy, stdwin);
#else					/* PresentationManager */
           /* already a window ? */
           if (ws->winState & WS_NORMAL) fail;
           ws->winState = WS_NORMAL;
           WinSetWindowPos(ws->hwndFrame, 0, 0, 0, 0, 0, SWP_RESTORE);
           } /* End of if - going to window */
         else if (!strcmp(tmp, "fullscreen")) {
           /* already maximized ? */
           if (ws->winState & WS_MAX) fail;
           ws->winState = WS_MAX;
           WinSetWindowPos(ws->hwndFrame, 0, 0, 0, 0, 0, SWP_MAXIMIZE);
 #endif					/* PresentationManager */
	    }
	 else                                /* invalid argument */
	    fail;
         }
#ifndef PresentationManager
      switch (ws->iconic) {
      case RootState:
	 return C_string "root";
      case NormalState:
	 return C_string "window";
      case IconicState:
	 return C_string "icon";
         }
#else					/* PresentationManager */
      return C_string (ws->winState & WS_MAX) ? "fullscreen" :
                      (ws->winState & WS_MIN) ? "icon" : "window";
#endif					/* PresentationManager */
      }
      }
end


#ifndef PresentationManager     /* avoiding inclusion */
/*
 * remap a window ... this time with an iconwin
 */
int remap(w,x,y)
wbp w;
int x,y;
   {
   XSizeHints size_hints;
   XWMHints   *wmhints;
   Window     root;
   unsigned int width, height, bw, depth;
   STDLOCALS(w);

   XGetSizeHints(stddpy, stdwin, &size_hints, XA_WM_NORMAL_HINTS);
   wmhints = XGetWMHints(stddpy, stdwin);
   if (ws->iconwin)
      XDestroyWindow(stddpy, ws->iconwin);
   if (stdwin)
      XDestroyWindow(stddpy, stdwin);

   ws->win = XCreateSimpleWindow(stddpy, DefaultRootWindow(stddpy),
				 ws->posx, ws->posy, ws->width,
				 ws->height, 4, wc->fg->c, wc->bg->c);
   XSetStandardProperties(stddpy, ws->win, ws->windowlabel,
			  ws->iconlabel, 0, 0, 0, &size_hints);
   XSelectInput(stddpy, ws->win, ExposureMask | KeyPressMask |
		ButtonPressMask | ButtonReleaseMask | ButtonMotionMask |
		StructureNotifyMask);

   ws->iconwin = XCreateSimpleWindow(stddpy, DefaultRootWindow(stddpy),
				     ws->iconx, ws->icony, ws->iconw,
				     ws->iconh, 2, wc->fg->c, wc->bg->c);
   XSelectInput(stddpy, ws->iconwin,
		ExposureMask | KeyPressMask | ButtonPressMask);

   wmhints->flags |= IconPositionHint;
   wmhints->icon_x = x;
   wmhints->icon_y = y;
   wmhints->initial_state = ws->iconic;
   wmhints->icon_window = ws->iconwin;
   wmhints->flags |= IconWindowHint;
   XSetWMHints(stddpy, ws->win, wmhints);
   CLREXPOSED(w);
   XMapWindow(stddpy, ws->win);
   if (ws->iconic == NormalState) {
      while (!ISEXPOSED(w))
         if (pollevent() == -1) return -1;
      }
   ws->iconx = x;
   ws->icony = y;
   XSync(stddpy, False);
   XFree((char *)wmhints);
   return 1;
   }
#endif					/* PresentationManager */


"XIconImage(w,x) - set w's icon pixmap"

function{0,1} XIconImage(argv[argc])
   abstract {
      return string
   }
   body {
      wbp    _w_;
      int warg = 0;
      tended char *tmp;
      int    len;
#ifndef PresentationManager
      Pixmap pix;
#else					/* PresentationManager */
      HBITMAP hbm;
#endif					/* PresentationManager */
      int status;

      OptWindow;

      {
      STDLOCALS(_w_);

#ifndef PresentationManager
      if (ws->iconic == RootState)
	 fail;
#endif					/* PresentationManager */
      if (warg < argc) {
	 /* get the preloaded pixmap image */
	 if (is:file(argv[warg]) &&
	     (BlkLoc(argv[warg])->file.status & Fs_Window)) {
#ifndef PresentationManager
	    wbp _x_;
	    strcpy(ws->iconimage, "");
	    _x_ = (wbp)BlkLoc(argv[warg])->file.fd;
	    pix = XCreatePixmap(stddpy, DefaultRootWindow(stddpy),
				_x_->window->width, _x_->window->height,
				DefaultDepth(stddpy,wd->screen));

	    XCopyArea(stddpy, _x_->window->pix, pix, wd->icongc, 0, 0,
		      _x_->window->width, _x_->window->height, 0, 0);
	    if (ws->iconpix) {
	       XSync(stddpy, False);
	       XFreePixmap(stddpy, ws->iconpix);
	       }
	    ws->iconpix = pix;
	    ws->iconw = _x_->window->width;
	    ws->iconh = _x_->window->height;
	    if (!ws->iconx && !ws->icony) {
	       ws->iconx = ws->x;
	       ws->icony = ws->y;
	       }
	    if (remap(_w_,ws->iconx,ws->icony) == -1) runerr(217);
#else					/* PresentationManager */
            wbinding *w2;
            wstate *ws2;
            ULONG size;
            BITMAPINFOHEADER2 bmp;
            PBITMAPINFO2 pbmi;
            PBYTE data;

            /* locate the second window */
            w2 = (wbinding *)BlkLoc(argv[warg])->file.fd;
            ws2 = w2->window;
            /* knock out the previous bitmap */
            GpiDeleteBitmap(ws->hIconBitmap);
            /* knock out the previous filename */
            free(ws->szIconFileName);
            ws->szIconFileName = NULL;
            /* load the bitmap data and create a new bitmap */
            memset(&bmp, 0, sizeof(BITMAPINFOHEADER2));
            bmp.cbFix = sizeof(BITMAPINFOHEADER2);
            GpiQueryBitmapInfoHeader(ws2->hBitmap, &bmp);
            /* make the info table */
            size = sizeof(RGB2) * (1 << (bmp.cPlanes * bmp.cBitCount));
            pbmi = calloc(sizeof(BITMAPINFO2) + size, 1);
            pbmi->cbFix = bmp.cbFix;
            pbmi->cPlanes = bmp.cPlanes;
            pbmi->cBitCount = bmp.cBitCount;
            /* allocate space for the data */
            size = ((bmp.cx * bmp.cPlanes * bmp.cBitCount) + 31) / 32 * 4 * bmp.cy;
            data = calloc(size, 1);
            /* query the data from the bitmap */
            GpiQueryBitmapBits(ws2->hpsBitmap, 0, ws2->bitHeight, data, pbmi);
            /* build the new bitmap */
            ws->hIconBitmap = GpiCreateBitmap(stdbit, &bmp, CBM_INIT, data, pbmi);
            /* free the garbage */
            free(data);
            free(pbmi);
#endif					/* PresentationManager */
            }
	 /* get the pixmap file named by x */
	 else if (is:string(argv[warg])) {
	    int height, width;
	    if (!cnv:C_string(argv[warg],tmp))
	       runerr(103,argv[warg]);
#ifndef PresentationManager
	    strcpy(ws->iconimage, tmp); 
	    if (ws->iconwin == (Window) NULL) makeIcon(_w_,0,0);
	    else {
	       pix = loadimage(_w_,ws->iconimage, &height, &width, 0, &status);
	       if (pix == (Pixmap) NULL)
		  fail;
	       XCopyArea(stddpy, pix, ws->iconwin, wd->icongc,
			 0, 0, width, height, 0, 0);
	       if (ws->iconpix) {
		  XSync(stddpy, False);
		  XFreePixmap(stddpy, ws->iconpix);
		  }
	       ws->iconpix = pix;
	       }
#else					/* PresentationManager */
          /* try to load the bitmap */
          if (hbm = loadimage(_w_, tmp, &height, &width)) {
            GpiDeleteBitmap(ws->hIconBitmap);
            ws->hIconBitmap = hbm;
            /* dup the filename */
            free(ws->szIconFileName);
            ws->szIconFileName = strdup(tmp);
            /* if we are iconic, force a redraw */
            if (ws->winState == WS_MIN) WinInvalidateRect(ws->hwndFrame, NULL, TRUE);
            } /* End of if - could load the bitmap */
          else fail;
#endif					/* PresentationManager */
            }
	 else
	    fail;
         }
#ifndef PresentationManager
      len = strlen(ws->iconimage);
      Protect(tmp = alcstr(ws->iconimage, len), runerr(0));
#else 					/* PresentationManager */
      len = (ws->szIconFileName) ? strlen(ws->szIconFileName) : 0;
      Protect(tmp = alcstr(ws->szIconFileName, len), runerr(0));
#endif					/* PresentationManager */
      return string(len, tmp);
      }
  }
end


"XIconLabel(w,s) - set w's icon label to string s"

function{1} XIconLabel(argv[argc])
   abstract {
      return string
   }
   body {
      wbp    _w_;
      int warg = 0;
      tended char *tmp;
      int    len;
#ifdef PresentationManager
      char buf[MAXLABEL];
#endif					/* PresentationManager */

      OptWindow;

      {
      STDLOCALS(_w_);

#ifndef PresentationManager 
      if (ws->iconic == RootState)
	 fail;
#else
      if (!stdwin) fail;
#endif					/* PresentationManager */
      if (warg < argc) {
	 if (!cnv:C_string(argv[warg],tmp))         /* convert to check arg */
	       runerr(103,argv[warg]);
#ifndef PresentationManager 
	    strcpy(ws->iconlabel, tmp);
	    XSetIconName(stddpy, stdwin, tmp);
	    if (ws->iconic == IconicState && !ws->iconpix) {
	       XClearWindow(stddpy, ws->iconwin);
	       XDrawString(stddpy, ws->iconwin, wd->icongc, 4,
	                   wd->fonts->fsp->max_bounds.ascent + 2,
	                   ws->iconlabel, strlen(ws->iconlabel));
	    }
         }
         len = strlen(ws->iconlabel);
         Protect(tmp = alcstr(ws->iconlabel, len), runerr(0));
#else					/* PresentationManager */
        mystrncpy(buf, tmp, MAXLABEL - 1);
        free(ws->szTitleWhenIcon);
        ws->szTitleWhenIcon = strdup(buf);
        if (ws->winState & WS_MIN)
          WinSetWindowText(ws->hwndFrame, ws->szTitleWhenIcon);
        }
      len = strlen(ws->szTitleWhenIcon);
      Protect(tmp = alcstr(ws->szTitleWhenIcon, len), runerr(0));
#endif					/* PresentationManager */
      return string(len, tmp);
      }  /* subscope */
   }
end


"XMoveIcon(w,x,y) - move icon to x,y"

function{1} XMoveIcon(argv[argc])
   declare {
      int _x_, _y_;
   }
   abstract {
      return file
   }

   body {
      wbp _w_;
      int warg = 0;

      OptWindow;

      if (argc - warg == 0) _x_ = 0;
      else if (!cnv:C_integer(argv[warg], _x_)) runerr(101,argv[warg]);
      if (argc - warg < 2) _y_ = 0;
      else if (!cnv:C_integer(argv[warg+1], _y_)) runerr(101,argv[warg+1]);
#ifndef PresentationManager
      if (_w_->window->iconic == RootState)
	 fail;

      if (_w_->window->iconwin == (Window) NULL)
	 makeIcon(_w_,_x_,_y_);
      if (remap(_w_, _x_, _y_) == -1) runerr(217);
#endif					/* PresentationManager */
      ReturnWindow;
      }
end


"XWindowLabel(w,s) - set w's window label to string s"

function{1} XWindowLabel(argv[argc])
   abstract {
      return string
   }
   body {
      wbp    _w_;
      int    warg = 0;
      tended char *tmp;
      int    len;
#ifdef PresentationManager
      char buf[MAXLABEL];
#endif					/* PresentationManager */

      OptWindow;

      {
      STDLOCALS(_w_);

#ifdef PresentationManager
      if (!stdwin) fail;
#endif					/* PresentationManager */

      if (warg < argc) {
	 if (!cnv:C_string(argv[warg],tmp))       /* convert to check arg */
	    runerr(103,argv[warg]);
#ifndef PresentationManager
	 mystrncpy(ws->windowlabel, tmp, MAXLABEL-1);
	 XStoreName(stddpy, stdwin, tmp);
         }
      len = strlen(ws->windowlabel);
      Protect(tmp = alcstr(ws->windowlabel, len), runerr(0));
#else					/* PresentationManager */
        mystrncpy(buf, tmp, MAXLABEL - 1);
        free(ws->szTitleWhenWindow);
        ws->szTitleWhenWindow = strdup(buf);
        if (!(ws->winState & WS_MIN))
          WinSetWindowText(ws->hwndFrame, ws->szTitleWhenWindow);
        }
      len = strlen(ws->szTitleWhenWindow);
      Protect(tmp = alcstr(ws->szTitleWhenWindow, len), runerr(0));
#endif					/* PresentationManager */
      return string(len, tmp);
      }
      }
end
#else					/* XIcon */
static char x;			/* avoid empty module */
#endif					/* XIcon */
