
/****************************************************************************
*   Function:    int sockwn(int fd, char *ptr, int nbytes)                  *
*   Operation:   to write n bytes to the socket fd                          *
*   Returns:     the number of bytes written, or -1 for error               *
*   Parameters:  fd, socket file descriptor                                 *
*                ptr, address of character array to write                   *
*                nbytes, the actual number of bytes from array to write     *
****************************************************************************/

#include "socko.h"

#include <stdio.h>

#ifdef UNIX
# include <sys/types.h>
# include <sys/time.h>
# include <errno.h>
extern int errno;
#else
# include <tklib.h>
# include <io.h>
# include <sys/nfs_time.h>
# include <tk_errno.h>
#endif

#include <sys/socket.h>

struct timeval wait_time;
fd_set rwfds;

int sockwn(fd, ptr, nbytes)
  register int fd;
  register char *ptr;
  register int nbytes;
{
  int nleft, nwritten;
  nleft = nbytes;

  while (nleft > 0) {
    nwritten = send(fd, ptr, nleft, 0);
    if (nwritten < 0) {
#ifndef SYSV
      if (errno == EWOULDBLOCK) {
#endif

#ifdef SEQ
      if (errno == EWOULDBLOCK) {
#endif
        FD_ZERO(&rwfds);
        FD_SET(fd, &rwfds); 
        wait_time.tv_sec = 25;
        wait_time.tv_usec = 0;
        if ((select(32, (fd_set*) 0, &rwfds, (fd_set *) 0, &wait_time)) < 1)        
          return(-1);
#ifndef SYSV
      } else
        return(-1);
#endif

#ifdef SEQ
      } else
        return(-1);
#endif
    }
    else if (nwritten == 0)
      break;
    else {
      nleft -= nwritten;
      ptr += nwritten;
    }
  }
  return (nbytes - nleft);
}
