{$R-,S-,I-,D-,T-,F-,V-,B-,N-}

unit Extend;

{ This unit allows a program to open more than the standard DOS maximum of 20
  open files at one time.  You must also be sure to set a FILES=XX statement
  in your CONFIG.SYS file.  This program installs a special interrupt handler
  under DOS 2.x and uses some semi-documented features under DOS 3.x.  This
  unit USES the DOS unit and should be used before any other units other than
  the DOS unit.  This code was based upon earlier work by Randy Forgaard, Bela
  Lubkin and Kim Kokkonen.  See EXTEND.DOC for more information.

  Scott Bussinger
  Professional Practice Systems
  110 South 131st Street
  Tacoma, WA  98444
  (206)531-8944
  Compuserve [72247,2671]

  Version 3.0 -- 10/16/1987 -- Reworked as a UNIT for use with Turbo Pascal 4
                               EXTEND.ASM reworked to be compatible with A86 assembler
                               Added support for DOS 3.3
          2.5 --  3/16/1987 -- EXTEND.ASM worked on by Kim Kokkonen and Brian Foley to work
                                 with Turbo Extender and whittle off a few clock cycles
          2.4 -- 12/16/1986 -- Fixed a problem with DUP under DOS 2.x
                               Now allocates the new handle table on heap
                                 under DOS 3.x (compatible with TDebug+)
          2.3 -- 11/18/1986 -- EXTEND now only affects DOS calls made from
                                 same code segment it was installed from (fixes
                                 problems with EXEC and batch files and already
                                 resident TSR programs
          2.2 -- 10/04/1986 -- Fixed problem with EXEC function destroying all
                                 registers including the stack
                               Changed way that original handle number is kept
                               Permit FORCEDUP to change a standard handle
                               Improve some comments
          2.1 -- 10/02/1986 -- Fixed problem of Turbo assuming the registers
                                 valid after the DOS call
          2.0 -- 10/01/1986 -- Initial release of interrupt handler version
          1.5                  Last version of EXTEND.PAS using explicit
                                 calls to extend files. }

interface

uses Dos;

implementation

type HandleArray = array[0..254] of byte;
     HandleArrayPtr = ^HandleArray;

var ExitSave: pointer;                 { Previous exit procedure }
    HandlePtrPtr: ^HandleArrayPtr;     { Pointer to pointer to current table }
    NewHandleTable: HandleArrayPtr;    { Pointer to new table }
    OldInt21: pointer;                 { Save old INT 21 }
    OldHandleTable: HandleArrayPtr;    { Pointer to original table }
    OldNumHandles: byte;               { Original number of handles }


{$L EXTEND }
procedure ExtendInit; external;        { Initialize interrupt handler }
procedure ExtendHandler; external;     { Replacement INT 21 handler }


procedure ExtendHandles;
  { Install the extended handles interrupt.  No files (other than
    standard handles should be open when unit starts up. }
  var Reg: Registers;
  begin
  Reg.AH := $30;
  msdos(Reg);                          { Get DOS version number }
  if Reg.AL = 2
   then
    begin
    GetIntVec($21,OldInt21);           { Install interrupt handler under DOS 2.x }
    SetIntVec($21,@ExtendHandler);
    ExtendInit                         { Initialize the interrupt handler }
    end
   else
    begin                              { Change location of handle table }
    { Allocate space for new handle table on heap }
    new(NewHandleTable);
    { Fill new table with unused entries }
    fillchar(NewHandleTable^,sizeof(HandleArray),$FF);

    OldNumHandles := mem[prefixseg:$0032];        { Get old table length }
    mem[prefixseg:$0032] := sizeof(HandleArray);  { Set new table length }

    HandlePtrPtr := ptr(prefixseg,$0034); { Pointer to pointer to handles }
    { Remember the old handle table location }
    OldHandleTable := HandlePtrPtr^;
    { Copy the current handle table to the new handle table }
    move(OldHandleTable^,NewHandleTable^,OldNumHandles);
    { Point to new handle table on heap }
    HandlePtrPtr^ := NewHandleTable
    end
  end;

{$F+}
procedure UnExtendHandles;
  { Uninstall the extended handles interrupt.  All files (other
    than standard handles) should be closed before unit exits. }
  var Reg: Registers;
  begin
  Reg.AH := $30;
  msdos(Reg);                          { Get DOS version number }
  if Reg.AL = 2
   then
    SetIntVec($21,OldInt21)            { Restore old INT21 handler }
   else
    begin                              { Restore original handle table }
    mem[prefixseg:$0032] := OldNumHandles; { Restore old table length }
    HandlePtrPtr^ := OldHandleTable;   { Restore original handle table }
    { Now copy the current handle table back }
    move(NewHandleTable^,OldHandleTable^,OldNumHandles);
    dispose(NewHandleTable)            { Release the heap space }
    end;
  ExitProc := ExitSave                 { Chain to next exit routine }
  end;
{$F-}

begin
ExitSave := ExitProc;                  { Remember the previous exit routine }
ExitProc := @UnExtendHandles;          { Install our exit routine }
ExtendHandles                          { Install the extended handles }
end.
