/*----------------------------------------
   GEOWIDTH.C -- Geometric Line Widths
                 (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>

char szClass [] = "GeoWidth" ;
char szTitle [] = "GeoWidth: Geometric Line Widths" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     int      y, iWidth  ;
     LOGBRUSH lb ;

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (0, 0, 0) ;
     lb.lbHatch = 0 ;

     for (y = 20, iWidth = 1 ; iWidth <= 20 ; y += 20, iWidth++)
          {
          SelectObject (hdc,
               ExtCreatePen (PS_GEOMETRIC | PS_DASHDOT,
                             iWidth, &lb, 0, NULL)) ;

          MoveToEx (hdc,          20, y, NULL) ;
          LineTo   (hdc, cxArea - 20, y) ;

          DeleteObject (
               SelectObject (hdc,
                    GetStockObject (BLACK_PEN))) ;
          }
     }
