// AtlEditCtl.cpp : Implementation of CAtlEditCtl
#include "stdafx.h"
#include "AtlEdit10.h"
#include "AtlEditCtl.h"

/////////////////////////////////////////////////////////////////////////////
// CAtlEditCtl


HRESULT CAtlEditCtl::OnDraw(ATL_DRAWINFO& di)
{
	USES_CONVERSION;

	HDC hdc = di.hdcDraw;
	HDC hic = di.hicTargetDev;
	RECT& rc = *(RECT*)( di.prcBounds );

	if( hic == NULL )
		hic = AtlCreateTargetDC( hdc, di.ptd );

	if( di.dwDrawAspect != DVASPECT_CONTENT )
		return 0;

	HPEN hFore;
	HBRUSH hBack;
	COLORREF colBack, colFore;

	OleTranslateColor( m_clrBackColor, m_hPalette, &colBack );
	OleTranslateColor( m_clrForeColor, m_hPalette, &colFore );

	hBack = CreateSolidBrush( colBack );
	hFore = CreatePen( PS_SOLID, 2, colFore );

	HGDIOBJ hOldBrush = SelectObject( hdc, hBack );
	HGDIOBJ hOldPen = SelectObject( hdc, hFore );

	FillRect( hdc, &rc, hBack );
	DrawEdge( hdc, &rc, EDGE_SUNKEN, BF_RECT | BF_ADJUST );

	// Draw our text to the control

	if( m_Font != NULL )
	{
		HFONT hFont, hOldFont;
		m_Font->get_hFont( &hFont );
		hOldFont = (HFONT) SelectObject( hdc, hFont );
		
		SetTextColor( hdc, colFore );
		SetBkMode( hdc, TRANSPARENT );

		TextOut( hdc, rc.left, rc.top, OLE2T( m_bstrText ), m_bstrText.Length() );

		if( hOldFont )
			SelectObject( hdc, hOldFont );
	}

	SelectObject( hdc, hOldBrush );
	SelectObject( hdc, hOldPen );

	DeleteObject( reinterpret_cast< HGDIOBJ >( hBack ) );

	if( hic != hdc )
		DeleteDC( hic );

	return S_OK;
}
