{ ATBIOS -- PC Tech Journal AT BIOS Information Display Program  }
{                                                                }
{ Version 1.01                                                   }
{ Last modified 10/14/86                                         }
{ Changes:                                                       }
{       1. Strip non-alphanumeric characters from the            }
{          copyright display.                                    }
{       2. Don't check game adapter bit in equipment flags       }
{          for AT machine type.  It is not used by AT.           }
{       3. Turn on Turbo Pascal I/O redirection.                 }
{                                                                }
{ Copyright (c) 1986, PC Tech Journal                            }
{ Program by: Paul Pierce, Ted Forgeron, Steven Armbrust         }
{                                                                }
{ Displays pertinent information from the BIOS code and data     }
{ areas.                                                         }
{                                                                }
{ This program is written in Turbo Pascal.  However, it can      }
{ be easily ported to any Pascal compiler that allows absolute   }
{ addressing.                                                    }

{$P512}

PROGRAM at_bios_info ;

  CONST
    at_id = $fc ;
    printer_mask = $c000 ;
    game_mask = $1000 ;
    serial_mask = $0e00 ;
    dma_mask = $0100 ;
    drive_num_mask = $00c0 ;
    video_mask = $0030 ;
    ndp_mask = $0002 ;
    drive_mask = $0001 ;
    co40 = $0010 ;
    co80 = $0020 ;
    mono = $0030 ;

  VAR
    i : integer ;
    romdate : ARRAY [1..9] OF char absolute $f000:$fff5 ;
    machine_id : byte absolute $f000:$fffe ;
    copyright : ARRAY [1..80] OF char absolute $f000:$e000 ;
    equip_flag : integer absolute $40:$10 ;
    mem_size : integer absolute $40:$13 ;
    key_buf : ARRAY [1..32] OF char absolute $40:$1e ;
    video_mode : byte absolute $40:$49 ;

  BEGIN
    clrscr ;
    write('ATBIOS -- PC Tech Journal AT BIOS Information ') ;
    writeln('Display') ;
    writeln('Version 1.01, Copyright (c) 1986 PC Tech Journal') ;
    writeln ;
    writeln('ROM BIOS date is                       ',romdate) ;
    IF machine_id = at_id THEN
      writeln('Machine ID is                          AT COMPATIBLE')
    ELSE
      writeln('Machine ID is                          NOT AT') ;
    write('Copyright Statement is                 ') ;
    FOR i := 1 TO 80 DO
      BEGIN
        IF (copyright[i] < ' ') OR (copyright[i] > '~') THEN
          write('.')
        ELSE
          write(copyright[i]) ;
        IF i = 40 THEN
          BEGIN
            writeln ;
            write('                                       ') ;
          END ;
      END ;
    writeln ;
    write('Diskette Drives Installed              ') ;
    IF (equip_flag AND drive_mask) <> 0 THEN
      writeln(((drive_num_mask AND equip_flag) DIV 64)+1)
    ELSE
      writeln('0') ;
    write('80287 Math Coprocessor                 ') ;
    IF (equip_flag AND ndp_mask) <> 0 THEN
      writeln('YES')
    ELSE
      writeln('NO') ;
    write('Initial Video Mode                     ') ;
    CASE (equip_flag AND video_mask) OF
      co40 : writeln('CGA 40x25 B/W text') ;
      co80 : writeln('CGA 80x25 B/W text') ;
      mono : writeln('Monochrome 80x25 text') ;
    END ;
    write('Current Video Mode                     ') ;
    CASE video_mode OF
      00 : writeln('CGA 40x25 B/W text') ;
      01 : writeln('CGA 40x25 16-color text') ;
      02 : writeln('CGA 80x25 B/W text') ;
      03 : writeln('CGA 80x25 16-color text') ;
      04 : writeln('CGA 320x200 4-color graphics') ;
      05 : writeln('CGA 320x200 4-gray graphics') ;
      06 : writeln('CGA 640x200 B/W graphics') ;
      07 : writeln('Monochrome 80x25 text') ;
      08 : writeln('JR 160x200 16-color graphics') ;
      09 : writeln('JR 320x200 16-color graphics') ;
      10 : writeln('EGA 640x200 4/64-color graphics') ;
      13 : writeln('EGA 320x200 16-color graphics') ;
      14 : writeln('EGA 640x200 16-color graphics') ;
      15 : writeln('EGA 640x350 4-color graphics') ;
    END ;
    write('DMA Present                            ') ;
    IF (equip_flag AND dma_mask) <> 0 THEN
      writeln('NO')
    ELSE
      writeln('YES') ;
    writeln('RS-232 Serial Ports                    ',
            (equip_flag AND serial_mask) DIV 512) ;
    IF machine_id <> at_id THEN
      BEGIN
        write('Game Adapter Present                   ') ;
        IF (equip_flag AND game_mask) <> 0 THEN
          writeln('YES')
        ELSE
          writeln('NO') ;
      END ;
    writeln('Parallel Printer Ports                 ',
            abs((equip_flag AND printer_mask) DIV 16384)) ;
    writeln('Memory Size in K Bytes                 ',mem_size) ;
    write('Keyboard Buffer Contents               ') ;
    i := 1 ;
    WHILE i <= 32 DO
      BEGIN
        IF (key_buf[i] < ' ') OR (key_buf > '~') THEN
          write('.')
        ELSE
          write(key_buf[i]) ;
        i := i + 2 ;
      END ;
    writeln ;
  END.
