#include        <stdio.h>       /* printf() */ 
#include        <math.h>        /* sin() */ 
#include        <dos.h>         /* int86() */ 
 
#define XEND    640 
#define YEND    480 
#define VPAGESIZE       ((XEND/8)*YEND) 
 
void SplitScreen( int ); 
void ScreenOrigin( int, int ); 
void SetPixel( int, int, int, int ); 
void SetVideoMode( int ); 
 
union REGS      regs;           /* defined in DOS.H; used by int86() */ 
 
 
main() 
{ 
        int                     i; 
        int                     x,y; 
        long                    lVBufOffset; 
        unsigned char far *     lpVBufByte; 
        unsigned int far *      lpCRT_LEN = (int far *)0x0040004C; 
 
 
        /* select 640 by 480 16-color mode */ 
        SetVideoMode( 0x12 ); 
        printf( "This is 640 by 480 16-color graphics mode." ); 
 
        /* initialize video page 1 */ 
        printf( "\nDrawing grid lines in video page 1 ..." );  
        *lpCRT_LEN = VPAGESIZE;                 /* update ROM BIOS variable */ 
        for( lVBufOffset=VPAGESIZE; lVBufOffset < 0x10000L; lVBufOffset++ ) 
        { 
          lpVBufByte = (unsigned char far *)(0xA0000000L + lVBufOffset); 
          *lpVBufByte = 0;                      /* zero all pixels */ 
        } 
 
        for( x=0; x<XEND; x+=40 )               /* draw vertical lines */ 
          for( y=0; y<150; y++ ) 
            SetPixel( x, y, 1, 2 );     /* video page 1, pixel color 2 */ 
 
        /* split the screen */ 
        SplitScreen( 0 ); 
        ScreenOrigin( 0, YEND ); 
 
        printf( "\nSplitting .. " ); 
 
        for( y=1; y<=150; y++ ) 
          SplitScreen( y ); 
 
 
        /* draw a sine wave and pan from right to left while doing so */ 
        printf( "\nHorizontal Panning ..." ); 
 
        for( i=0; i<3; i++ )            /* do this for 3 screen widths */ 
        { 
          for( x=1; x<=XEND; x++ ) 
          { 
            if( i )             /* erase previously-drawn pixel */ 
            { 
              y = 75 + (int)(75.0 * sin( 0.03*(double)(x+(i-1)*XEND) ) ); 
              if( (x-1) % 40 )                  /* use correct color for .. */ 
                SetPixel( x-1, y, 1, 0 );               /* .. vertical bars */ 
              else 
                SetPixel( x-1, y, 1, 2 ); 
            } 
 
            /* increment the screen origin (pan) */ 
            ScreenOrigin( x, YEND ); 
 
            /* set new pixel */ 
            y = 75 + (int)(75.0 * sin( 0.03*(double)(x+i*XEND) ) ); 
            SetPixel( x-1, y, 1, 7 ); 
          } 
        } 
 
        /* pan vertically, just to show how it looks */ 
        printf( "\nVertical Panning ..." ); 
        for( i=0; i<150; i++ ) 
          ScreenOrigin( 0, YEND+i ); 
 
        for( ; i>=0; --i ) 
          ScreenOrigin( 0, YEND+i ); 
 
        /* undo the split screen */ 
        printf( "\nUnsplitting .." ); 
        for( y=150; y>=0; --y ) 
          SplitScreen( y ); 
 
        ScreenOrigin( 0, 0 ); 
        SplitScreen( 0x3FF ); 
 
        printf( "\nDone." ); 
} 
 
 
void SetVideoMode( mode ) 
int     mode; 
{ 
        /* establish the specified ROM BIOS video mode */ 
        regs.h.ah = 0; 
        regs.h.al = mode; 
        int86( 0x10, &regs, &regs ); 
} 
 
 
void SetPixel( x, y, vpage, value ) 
int     x, y;                   /* pixel x-y coordinates */ 
int     vpage;                  /* ROM BIOS video page */ 
int     value;                  /* pixel value */ 
{ 
        /* setup for ROM BIOS function */ 
        regs.h.ah = 0x0C; 
        regs.h.al = value; 
        regs.h.bh = vpage; 
        regs.x.cx = x; 
        regs.x.dx = y; 
 
        /* use ROM BIOS function to set pixel */ 
        int86( 0x10, &regs, &regs ); 
} 
