// Circle enhancement - Paul Hsieh

// Somewhat faster 32 bit WATCOM C/C++ based circle algorithm.
// The idea is the optimize the divides in Tenie Remmel's
// originally shown algorithm.  In each case, as it runs through
// the loop, we know the each division result either decreases
// in the first case (iy/r), or increases in the second (ix/r)
// from the previous results.  Since the pixels increment one at
// a time, I think its safe to assume that the values dont
// change much, so the while loops should not run too many times
// (usually not at all.)

#include <stdlib.h>
#include <conio.h>

int base;

void plotdot(int a, int b, int c) {
int d = a+b + base;
	if( 0==(d&0xFFFF0000) ) *((char *)(d+0xA0000)) = c;
}

void circle4(int x, int y, int r, int color) {
int a,b,c;
int yd,xd;
int ydd,xdd;
#define ix x
#define iy y

	if( r<1 ) r=1;
	base = ((y*5)*64) + x;

        yd = 64;
        xd = 0;

	ix = 0;
	iy = r*64;

        ydd=iy;
        xdd=ix+r-1;

	do {
		b = (iy+32)>>6;
		a = (ix+32)>>6;
		c = (b*5)*64;
                plotdot(-a, c,color); plotdot( a, c,color);
                plotdot(-a,-c,color); plotdot( a,-c,color);
		c = (a*5)*64;
                plotdot(-b, c,color); plotdot( b, c,color);
                plotdot(-b,-c,color); plotdot( b,-c,color);

                while(ydd>iy) {
                        ydd -= r;
                        yd--;
                }
                ix += yd;

                while(xdd<ix) {
                        xdd += r;
                        xd++;
                }
                iy -= xd;

        } while( b>a );
}

int INT10(int mode);
#pragma aux INT10 = " int 10h " value [eax] parm [eax];

main() {
	INT10(0x13);
        while( !kbhit() ) {
                circle4( rand() % 320, rand() % 200, (rand() % 50) , rand() & 0xff );
	}
	INT10(0x3);
}

