/* Copyright (c) 1990-1997, Alun Jones & Texas Imperial Software */
/* HPTOPS.C - prepares a plot for the conversion to postscript */
#ifdef MSDOS
#include <io.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <ctype.h>

FILE *infd;
static char comlist[672]={0};
float *xcords;
float *ycords;
int numd=0,maxnum=1;
char parms[1000];
char fooble[100];
int lastread=-1;

#define inputleft (!feof(infd))
#define uppercase(x) (x=islower(x)?toupper(x):(x))

void nospace(string)
char *string;
{
  char *outs;
  int i=0,j=0,n=strlen(string);
  outs=(char *)malloc(n+1);
  while (i<n) {
    while (string[i]==' '&&i<n)
      i++;
    while (string[i]!=' '&&i<n) {
      outs[j]=string[i];
      j++;
      i++;
    }
    outs[j]=' ';
    j++;
  }
  outs[j-1]=0;
  printf("%s\n",outs);
  free(outs);
}


void flushdraw()
{
    int i;
    for (i=1;i<numd+1;i++) {
	sprintf(fooble,"%8g %8g ScalePair",xcords[numd-i],ycords[numd-i]);
	nospace(fooble);
    }
    sprintf(fooble,numd>1?"%d SeveralDraws":"DrawOrMove",numd*2);
    nospace(fooble);
}


int insrch(string,scankey)
char *string,*scankey;
{
  char foom[16];
  int chars,match;
  sprintf(foom,"%%[^%s]%%n",scankey);
  match=fscanf(infd,foom,string,&chars);
  if (match>0) string[chars]=0;
  else string[0]=0;
  if (match==EOF) return 0;
  return 1;
}

char known(command)
char *command;
{
  int kindex;
  if (isalpha(command[1])&&isalpha(command[0])) {
    kindex=(command[0]-'A')+26*(command[1]-'A');
    return comlist[kindex];
  }
  else return 0;
}

void hpconvert()
{
  char command[3],LBTerm[2],lastpen=0,Symbol;
  float x,y;
  *LBTerm=3;
  LBTerm[1]=0;
  command[2]=0;
  printf("RunDefinitions\n");
  while (inputleft) {
    fscanf(infd,"%2s",command);
    uppercase(command[0]);
    uppercase(command[1]);
    while (inputleft&&!known(command)) {
      if (isupper(command[0])&&isupper(command[1]))
	fprintf(stderr,"Unknown command: %.2s\n",command);
      /* Commands are recognised from the postscript because they go
	 /?? {  %% HPGL function. */
      command[0]=command[1];
      fscanf(infd,"%c",command+1);
      uppercase(command[1]);
    }
    if (!inputleft) break;
    if (*command=='L' && command[1]=='B') {
      int f,g;
      char foom[7];
      if (numd) flushdraw();
      numd=0;
      if (!insrch(parms,LBTerm)) {
	fprintf(stderr,"End of file reached while scanning the LB string.\n");
	fprintf(stderr,"Possible cause: LB Terminator not properly set by DT command.\n");
	exit(1);
      }
      printf("(");
      for (f=g=0;f<strlen(parms);f++)
	if (parms[f]=='('||parms[f]==')'||parms[f]=='\\'||parms[f]<32) {
	  sprintf(foom,"%%.%ds",f-g);
	  printf(foom,parms+g);
	  g=f;
	  printf("\\");
	  if (parms[f]<32) {
	    g++;
	    printf("%03o",(int)parms[f]);
	  }
	}
      printf("%s",parms+g);
      printf(")%s\n",command);
    } else if (*command=='D' && command[1]=='T') {
      fscanf(infd,"%c",LBTerm);
      if (*LBTerm==';') *LBTerm=3;
    } else if (*command=='S' && command[1]=='M') {
      if (numd) flushdraw();
      numd=0;
      fscanf(infd,"%c",&Symbol);
      if (Symbol<32 || Symbol==';') printf("(;)SM\n");
      else printf("(%c)SM\n",Symbol);
    } else switch ((*command=='P')?command[1]:0) {
    case 'A':
    case 'D':
    case 'R':
    case 'U':
    if (command[1]!=lastpen) {
      if (numd) flushdraw();
      numd=0;
      switch (command[1]) {
      case 'A':
	printf("/Absolute true def ");
	break;
      case 'D':
	printf("/PenState Down def ");
	break;
      case 'R':
	printf("/Absolute false def ");
	break;
      case 'U':
	printf("/PenState Up def ");
      }
      }
      lastpen=command[1];
      while (fscanf(infd,"%f%*[, 	]%f%*[, 	]",&x,&y)==2) {
	numd++;
	if (numd>maxnum) {
	  maxnum+=50;
	  xcords=(float *)realloc(xcords,maxnum*sizeof(float));
	  ycords=(float *)realloc(ycords,maxnum*sizeof(float));
	}
	xcords[numd-1]=x;
	ycords[numd-1]=y;
      }
      break;
    default:
      if (!insrch(parms,";\nA-Za-z")) {
	fprintf(stderr,"End of file while reading command parameters.\n");
	fprintf(stderr,"The command I was reading was a %s\n",command);
	exit(1);
      }
      if (numd) flushdraw();
      lastpen='!';
      numd=0;
      if ((*command=='D'&&command[1]=='F')||(*command=='I'&&command[1]=='N'))
	*LBTerm=3;  /* Commands DF and IN automatically reset LBTerm. */
      if (*parms==';') printf("SemiString %s\n",command);
      else {
	sprintf(fooble,"(%s)%s",parms,command);
	nospace(fooble);
      }
    } 
  }
  printf("SemiString AF\n");
}

void main(argc,argv)
int argc;
char **argv;
{
  FILE *PS;
  time_t seconds;
  char byestring[512];
  int readpast=0,i;
  comlist[('D'-'A')+26*('T'-'A')]=1;
  comlist[('P'-'A')+26*('A'-'A')]=1;
  comlist[('P'-'A')+26*('D'-'A')]=1;
  comlist[('P'-'A')+26*('R'-'A')]=1;
  comlist[('P'-'A')+26*('U'-'A')]=1;
  if (argc<3) {
    fprintf(stderr,"Usage: hptops plot-file HP.PS\n");
    fprintf(stderr,"Where plot-file is the HPGL file, and HP.PS is the most\n");
    fprintf(stderr,"up to date of Alun Jones' DrawHPGL program.\n");
    fprintf(stderr,"Output is produced to stdout, and can be re-directed\n");
    fprintf(stderr,"either to a file, or to a postscript printer.\n");
    exit(1);
  }
  infd=fopen(argv[1],"r");
  PS=fopen(argv[2],"r");
  if (infd==NULL) {
    fprintf(stderr,"Unable to open input file.  No output created.\n");
    perror("Possible reason");
    exit(1);
  }
  if (PS==NULL) {
    fprintf(stderr,"Unable to open file containing DrawHPGL. No output created.\n");
    perror("Possible reason");
    exit(1);
  }
  printf("%%!PS-Adobe-3.0 EPSF-3.0\n");
  printf("%%%%BoundingBox: 15 10 580 830\n");
  printf("%%%%Title: ( %s )\n",argv[1]);
  printf("%%%%Creator: HPtoPS by Alun Jones using DrawHPGL by Alun Jones.\n");
  seconds=time(0);
  printf("%%%%CreationDate: %s\n",asctime(localtime(&seconds)));
  printf("%%%%EndComments\n");
  printf("%%%%%%%%15 10 moveto 15 830 lineto 580 830 lineto 580 10 lineto 15 10 lineto clip newpath\n");
  while (!readpast&&(fscanf(PS,"%[^\n]\n",byestring)!=EOF)) {
    if (byestring[0]!='%') {
      if (!strncmp(byestring,"/DrawHPGL",9))
	readpast=1;
      else {
	if (strlen(byestring)>20 && !strncmp(byestring+4,"{  %% HPGL function",19)) {
	  comlist[(byestring[1]-'A')+26*(byestring[2]-'A')]=1;
	}
	for (i=0;i<strlen(byestring);i++)
	  if (byestring[i]=='%') byestring[i]=0;
	nospace(byestring);
      }
    }
  }
	
  /* Some kind of spooling in here, to determine input and output files.
     The output file will also have the relevant bits of hp.ps written
     to it.  The files are then passed as descriptors infd and outfd. */
  xcords=(float *)malloc(sizeof(float));
  ycords=(float *)malloc(sizeof(float));
  hpconvert();
  /* Some kind of closing and finishing here. Maybe loop for wildcards? */
  exit(0);
}

/* Local Variables: */
/* compile-command: "cc -dos -o hptops.exe hptops.c" */
/* End: */
