{$N-}    {80287 not present}
{$R+}    {Range checking on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}

PROGRAM Signs;
{******************************************************************************
**
**  Robert W. Bloom
**
**  Function:  This program reads input from the terminal and creates signs
**          (horizontal) or banners (vertical) in a number of formats.  Output
**          character fonts are read from a HP LaserJet-compatible 'soft' font file.
**
**  Notes:  Font files must be indexed with FontIndx.Pas before use.
**          See Signs.DOC for more information
**
******************************************************************************}

Uses
  Crt, {Unit found in TURBO.TPL}
  Printer2; {special unit}

{$i const}
VAR
         font_file : FILE OF CHAR;     {the soft font file}
     font_ndx_file : FILE OF CHAR_INDEX_RECORD;  {index to above}
         ndx_array : ARRAY [0..255] OF CHAR_INDEX_RECORD;
  in_file,out_file : TEXT;             {files for input and output}
       avail_width : INTEGER;          {width of output device}
          out_line : OUT_LINE_REC;     {to build output lines}
     gout_1,gout_2 : OUT_GRAPHIC_REC;  {output graphics lines}
          gout_len : INTEGER;          {to build output graphic lines}
          ptr_maps : POINTER;          {pointer to character maps}
          map_size : INTEGER;          {size of the maps}
      space_needed : INTEGER;          {approx width of output?}
       page_offset : INTEGER;          {actual indent}
           bit_cnt : INTEGER;          {counter for graphics output}

{************************* Procedures called *********************************}

PROCEDURE main;                                                   FORWARD;
    PROCEDURE out_sign         (VAR inp_line : S255);             FORWARD;
    PROCEDURE out_banner       (VAR inp_line : S255);             FORWARD;

PROCEDURE parm_menu;                                              FORWARD;
    {PROCEDURE disp_?}
PROCEDURE ask_parm;                                               FORWARD;
    {PROCEDURE ask_?}
PROCEDURE input_menu;                                             FORWARD;

{utilities:}
    PROCEDURE gotorc(R,C : INTEGER);                              FORWARD;
    PROCEDURE sak;                                                FORWARD;
    PROCEDURE alt_inp(VAR alt_str : S14);                         FORWARD;
    PROCEDURE putchr (chrs : S14);                                FORWARD;
    PROCEDURE disp_fs;                                            FORWARD;
    PROCEDURE init_ff (VAR ff,ffi : S14;VAR ok : BOOLEAN);        FORWARD;
    PROCEDURE set_up_maps (VAR inp_line : S255);                  FORWARD;
    PROCEDURE reset_maps (VAR ptr : POINTER);                     FORWARD;

{printer stuff:}
    PROCEDURE avail_space;                                        FORWARD;
    PROCEDURE set_up_prt  (reset_prt : BOOLEAN);                  FORWARD;
    PROCEDURE out_char          (ochar,ichar,action : CHAR);      FORWARD;
       PROCEDURE out_nline;                                       FORWARD;
       PROCEDURE add_gline;                                       FORWARD;
           PROCEDURE out_gl_ids;                                  FORWARD;
           PROCEDURE out_gl_hp;                                   FORWARD;
           PROCEDURE out_gl_ep;                                   FORWARD;


{**************************** Program Start **********************************}

PROCEDURE main;
LABEL finis,restrt;
VAR ans2,ans : CHAR;        {entered char}
  text_input : S255;        {to build line into}
  alt_inp_strng : S14;         {return from alt-char builder}
        done : BOOLEAN;     {flag}
           i : INTEGER;     {loop control}
  output_err : BOOLEAN;     {if can't output correctly}
BEGIN
    done := FALSE;
    text_input := '';
    space_needed := 0;
    parm_menu;
    ask_parm;
    input_menu;
    WHILE NOT done DO BEGIN
restrt:
        ans := READKEY;
        CLREOL;
        CASE ans OF
            ^P : BEGIN            {change parameters}
                     ask_parm;
                     GOTORC(17,41); CLREOL;
                     input_menu;
                     IF sign_type = sign THEN BEGIN    {recalc cause font may}
                         space_needed := given_offset; {have been changed}
                         FOR i := 1 TO LENGTH(text_input) DO
                             space_needed := space_needed +
                                 (ndx_array[ORD(text_input[i])].delta_x * mult_w)
                     END ELSE
                         space_needed := (font_height * mult_h) + given_offset;
                     {end}
                     GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
                     GOTORC(19,25); CLREOL; highvideo; WRITE(text_input)
                 END;
         ^D,^C : done := TRUE;    {done program}
            ^A : BEGIN
                     alt_inp(alt_inp_strng);
                     text_input := text_input + alt_inp_strng;
                     GOTORC(19,25); CLREOL; highvideo; WRITE(text_input)
                 END;
         ^L,^F : BEGIN            {formfeed to printer}
                     GOTORC(24,1);
                     IF output_device = printr THEN BEGIN
                         WRITE(lst,^L);
                         WRITE('Formfeed sent to printer.')
                     END ELSE
                         WRITE('Output is not directed to printer!'^G);
                     {end}
                     sak;
                     GOTORC(24,1); CLREOL;
                     GOTORC(19,25); CLREOL; highvideo; WRITE(text_input)
                 END;
         ^R,^T : BEGIN            {move back to TOF (reverse formfeed)}
                     GOTORC(24,1);
                     IF output_device = printr THEN BEGIN
                         WRITE('Moving print-head back to TOF.');
                         CASE prt_type OF
                             ids : WRITE(lst,CHR(27),'G0$',CHR(27),'H0$');
                           epson : {not available?} ;
                              hp : WRITE(lst,CHR(27),'&a0c0R')
                         END {case}
                     END ELSE
                         WRITE('Output is not directed to printer!'^G);
                     {end}
                     sak;
                     GOTORC(24,1); CLREOL;
                     GOTORC(19,25); CLREOL; highvideo; WRITE(text_input)
                 END;
       ^H,#127 : BEGIN            {backspace once}
                     IF LENGTH(text_input) > 0 THEN BEGIN
                         ans2 := text_input[LENGTH(text_input)];
                         DELETE(text_input,LENGTH(text_input),1);
                         IF sign_type = sign THEN space_needed :=
                             space_needed - (ndx_array[ORD(ans2)].delta_x * mult_w);
                         GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
                         GOTORC(19,25); CLREOL; highvideo; WRITE(text_input)
                     END
                 END;
            ^X : BEGIN            {cancel line, start over}
                     text_input := '';
                     IF sign_type = sign THEN
                         space_needed := given_offset
                     ELSE
                         space_needed := (font_height * mult_h) + given_offset;
                     {end}
                     GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
                     GOTORC(19,25); CLREOL; highvideo
                 END;
            ^M : BEGIN            {go ahead, process input line}
                     output_err := FALSE;
                     IF (LENGTH(text_input) = 0) AND
                         (input_device <> text_file) THEN BEGIN
                         GOTORC(24,1); CLREOL;
                         WRITE('Do you want to quit? (Y/N) -> '^G);
                         ans2 := READKEY;
                         GOTORC(24,1); CLREOL;
                         IF ans2 IN ['y','Y'] THEN
                             GOTO finis
                         ELSE BEGIN
                             GOTORC(19,25); CLREOL;
                             highvideo; WRITE(text_input);
                             GOTO restrt
                         END
                     END;
                     GOTORC(1,65); WRITE('Processing');
                     IF output_device = printr THEN set_up_prt(FALSE);

                     IF input_device = text_file THEN BEGIN
                         FOR i := 1 TO num_copies DO BEGIN
                             WHILE NOT EOF(in_file) DO BEGIN
                                 READLN(in_file,text_input);
                                 IF output_device <> screen THEN BEGIN
                                     GOTORC(19,4); CLREOL; lowvideo;
                                     WRITE('Reading from file -> ');
                                     highvideo; WRITE(text_input)
                                 END;
                                 IF sign_type = sign THEN BEGIN
                                     space_needed := given_offset;
                                     FOR i := 1 TO LENGTH(text_input) DO
                                         space_needed := space_needed +
                                         (ndx_array[ORD(text_input[i])].delta_x * mult_w);
                                     {end}
                                     out_sign(text_input)
                                 END ELSE
                                     out_banner(text_input);
                                 {end if sign}
                             END; {while not eof}
                             IF output_device = printr THEN WRITE(lst,^L);
                             RESET(in_file)
                         END {for each copy wanted}
                     END ELSE
                         IF sign_type = sign THEN
                             out_sign(text_input)
                         ELSE
                             out_banner(text_input);
                         {end if sign}
                     {end if input from file}
                     IF (output_device=screen) THEN BEGIN
                         sak;
                         parm_menu
                     END;
                     text_input := '';
                     IF sign_type = sign THEN
                         space_needed := given_offset
                     ELSE
                         space_needed := (font_height * mult_h) + given_offset;
                     {end}
                     GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
                     input_menu
                 END {process line}
            ELSE BEGIN              {otherwise put entry into input line}
                 text_input := text_input + ans;
                 IF sign_type = sign THEN space_needed :=
                     space_needed + (ndx_array[ORD(ans)].delta_x * mult_w);
                 GOTORC(17,25); CLREOL; highvideo; WRITE(space_needed);
                 GOTORC(19,25); WRITE(text_input)
            END
        END {case}
    END; {while not done}
finis:   {all done, close appropriate files}
    IF output_device = printr THEN set_up_prt(TRUE);
    IF output_device = recd_file THEN CLOSE(out_file);
    IF input_device = text_file THEN CLOSE(in_file);
    CLOSE(font_file)
END; {PROCEDURE main}


PROCEDURE out_banner; {(VAR inp_line : S255)}
VAR chr_num,chr_pos,width_lcv,height_lcv,added,end_line_pos,top_os,bott_os,
    mult_w_lcv,mult_h_lcv,out_cnt,out_cnto : INTEGER;
      i,j : INTEGER;  {for small for loops}
     ptr8 : PTR_CHAR_MAP_8;
    ptr12 : PTR_CHAR_MAP_12;
    ptr18 : PTR_CHAR_MAP_18;
    ptr24 : PTR_CHAR_MAP_24;
    ptr30 : PTR_CHAR_MAP_30;
   chr_byte,chr_bit,test_byte,test_bit : BYTE;
BEGIN
    set_up_maps(inp_line);
    bit_cnt := 0;  {reset for graphic bits}
    IF (output_device <> screen) OR (input_device = keyboard) THEN BEGIN
        GOTORC(1,65); WRITE('Outputting  ')
    END;
    GOTORC(25,1);
    IF output_device <> screen THEN BEGIN
        lowvideo; WRITE('Now outputting character -> '); highvideo
    END;
    CASE map_size OF
         8 : ptr8 := ptr_maps;
        12 : ptr12 := ptr_maps;
        18 : ptr18 := ptr_maps;
        24 : ptr24 := ptr_maps;
        30 : ptr30 := ptr_maps
    END; {case}
    out_char(' ',' ','S'); {start w/blank line}
    out_char(' ',' ','E'); {and output it}
    IF inv_video THEN BEGIN  {if inv_video, add one 'blank' line}
        FOR i := 1 TO ((2+font_height) * mult_h) DO
            out_char(' ',block_char,'A');
        out_char(' ',' ','E'); {and output it}
        out_char(' ',' ','C')  {and clear it}
    END;
    out_cnt := 0;
    FOR chr_pos := 1 TO LENGTH(inp_line) DO BEGIN
        chr_num := ORD(inp_line[chr_pos]);
        IF output_device <> screen THEN WRITE(CHR(chr_num));
        out_cnto := out_cnt;            {where char started for delta_x}
        FOR j := 1 TO (ndx_array[chr_num].left_offset * mult_w) DO BEGIN
            IF inv_video THEN    {if inv_video, add a starting block}
                FOR i := 1 TO mult_h DO out_char(' ',block_char,'A');
            FOR i := 1 TO (font_height * mult_h) DO
                out_char(' ',CHR(chr_num),'A');
            IF inv_video THEN    {if inv_video, add a ending block}
                FOR i := 1 TO mult_h DO out_char(' ',block_char,'A');
            out_char(' ',' ','E'); {add (blank) lines for left_offset}
            out_char(' ',' ','C'); {clear output line}
            out_cnt := out_cnt + 1 {keep track of it}
        END;
        FOR width_lcv := 1 TO ndx_array[chr_num].width DO BEGIN
            IF inv_video THEN    {if inv_video, add a starting block}
                FOR i := 1 TO mult_h DO out_char(' ',block_char,'A');
            bott_os := ((font_height - ndx_array[0].top_offset) -
                (ndx_array[chr_num].height - ndx_array[chr_num].top_offset)) * mult_h;
            FOR i := 1 TO bott_os DO out_char(' ',CHR(chr_num),'A');
            FOR height_lcv := ndx_array[chr_num].height DOWNTO 1 DO BEGIN
                chr_byte := TRUNC(0.99+width_lcv/8);
                CASE map_size OF
                       8 : test_byte := ptr8^.map[height_lcv,chr_byte];
                      12 : test_byte := ptr12^.map[height_lcv,chr_byte];
                      18 : test_byte := ptr18^.map[height_lcv,chr_byte];
                      24 : test_byte := ptr24^.map[height_lcv,chr_byte];
                      30 : test_byte := ptr30^.map[height_lcv,chr_byte]
                END; {case}
                chr_bit := width_lcv MOD 8;
                CASE chr_bit OF
                      1 : test_bit := test_byte AND 128;
                      2 : test_bit := test_byte AND 64;
                      3 : test_bit := test_byte AND 32;
                      4 : test_bit := test_byte AND 16;
                      5 : test_bit := test_byte AND 8;
                      6 : test_bit := test_byte AND 4;
                      7 : test_bit := test_byte AND 2;
                      0 : test_bit := test_byte AND 1
                END; {case}
                FOR mult_h_lcv := 1 TO mult_h DO
                    IF (test_bit = 0) THEN
                        out_char(' ',CHR(chr_num),'A')
                    ELSE
                        out_char(CHR(chr_num),' ','A')
                    {end}
                {for height multiplier}
            END; {for height of char}
            top_os := font_height - ndx_array[chr_num].height - bott_os;
            FOR i := 1 TO top_os * mult_h DO
                out_char(' ',CHR(chr_num),'A'); {fill out char}
            IF inv_video THEN    {if inv_video, add a ending block}
                FOR i := 1 TO mult_h DO out_char(' ',block_char,'A');
            FOR mult_w_lcv := 1 TO mult_w DO
                out_char(' ',' ','E');  {finished building line - output 'em}
            {end for mult_w_lcv}
            out_cnt := out_cnt + mult_w;  {count output lines}
            out_char(' ',' ','C') {clear output line}
        END; {across width of char}
        end_line_pos := out_cnto + (ndx_array[chr_num].delta_x * mult_w);
                                                {calculate end of char}
        IF (chr_pos < LENGTH(inp_line)) AND
          (ndx_array[ORD(inp_line[chr_pos+1])].left_offset < 0) THEN
            end_line_pos := end_line_pos +
              (ndx_array[ORD(inp_line[chr_pos+1])].left_offset * mult_w);
                        {back up if leff_offset < 0 and not eol of inp_line}
        added := end_line_pos - out_cnt; {how much to add}
        FOR j := 1 TO added DO BEGIN
            FOR i := 1 TO (font_height * mult_h) DO
                out_char(' ',block_char,'A');
            IF inv_video THEN    {if inv_video, the border chars}
                FOR i := 1 TO 2*mult_h DO out_char(' ',block_char,'A');
            out_char(' ',' ','E'); {add (blank) lines for delta_x}
            out_char(' ',' ','C'); {clear output line}
            out_cnt := out_cnt + 1
        END;
        CASE map_size OF                   {point to next char map}
             8 : ptr8 := ptr8^.next;
            12 : ptr12 := ptr12^.next;
            18 : ptr18 := ptr18^.next;
            24 : ptr24 := ptr24^.next;
            30 : ptr30 := ptr30^.next
        END {case}
    END; {for each character}
    IF inv_video THEN BEGIN  {if inv_video, add one 'blank' line}
        FOR i := 1 TO ((2+font_height) * mult_h) DO
            out_char(' ',block_char,'A');
        out_char(' ',' ','E'); {and output it}
        out_char(' ',' ','C')  {and clear it}
    END;
    out_char(' ',' ','D'); {end w/blank line}
    reset_maps(ptr_maps) {dispose of maps}
END; {PROCEDURE out_banner}


PROCEDURE out_sign; {(VAR inp_line : S255)}
VAR chr_num,chr_pos,width_lcv,height_lcv,added,end_char_pos,
    mult_w_lcv,mult_h_lcv,out_cnto : INTEGER;
    act_dot_pos : INTEGER; {position within char map}
      i,j : INTEGER;  {for small for loops}
  left_os : INTEGER; {dist from left edge of max cell size to edge of char}
     ptr8 : PTR_CHAR_MAP_8;
    ptr12 : PTR_CHAR_MAP_12;
    ptr18 : PTR_CHAR_MAP_18;
    ptr24 : PTR_CHAR_MAP_24;
    ptr30 : PTR_CHAR_MAP_30;
   chr_byte,chr_bit,test_byte,test_bit : BYTE;
BEGIN
    set_up_maps(inp_line);
    bit_cnt := 0;  {reset for graphic bits}
    IF (output_device <> screen) OR (input_device = keyboard) THEN BEGIN
        GOTORC(1,65); WRITE('Outputting  ')
    END;
    GOTORC(25,1);
    out_char(' ',' ','S'); {start w/blank line}
    out_char(' ',' ','E'); {and output it}
    IF inv_video THEN BEGIN  {if inv_video, start with a solid line}
        FOR i := 1 TO space_needed + mult_w - given_offset DO       {space_needed is only an}
            out_char(' ',block_char,'A');   {approx line length!}
        out_char(' ',' ','E'); {and output it}
        out_char(' ',' ','C')  {and clear it}
    END;
    FOR height_lcv := 1 TO font_height DO BEGIN
        IF output_device <> screen THEN WRITE('Outputting line ',height_lcv:3,chr(13));
        IF inv_video THEN    {if inv_video, add a starting block}
            FOR i := 1 TO mult_w DO out_char(' ',block_char,'A');
        CASE map_size OF
             8 : ptr8 := ptr_maps;
            12 : ptr12 := ptr_maps;
            18 : ptr18 := ptr_maps;
            24 : ptr24 := ptr_maps;
            30 : ptr30 := ptr_maps
        END; {case}
        FOR chr_pos := 1 TO LENGTH(inp_line) DO BEGIN
            chr_num := ORD(inp_line[chr_pos]);
            out_cnto := out_line.len; {where char started for delta_x}
            IF (ndx_array[chr_num].left_offset < 0) AND  {back-up cursor if ok}
              (out_line.len > -1 * ndx_array[chr_num].left_offset * mult_w) THEN
                out_line.len := out_line.len + (ndx_array[chr_num].left_offset * mult_w)
            ELSE
                FOR i := 1 TO (ndx_array[chr_num].left_offset * mult_w) DO
                    out_char(' ',CHR(chr_num),'A');  {left offset}
            {end - add or subtract to out_line for left offset}
            act_dot_pos := height_lcv - (ndx_array[0].top_offset -
              ndx_array[chr_num].top_offset);  {baseline minus char top offset}
            FOR width_lcv := 1 TO ndx_array[chr_num].width DO BEGIN
                IF (act_dot_pos <= 0) OR (act_dot_pos > ndx_array[chr_num].height) THEN
                   FOR i := 1 TO mult_w DO
                       out_char(' ',CHR(chr_num),'A') {space above char}
                ELSE BEGIN
                   chr_byte := TRUNC(0.99+width_lcv/8);
                   CASE map_size OF
                       8 : test_byte := ptr8^.map[act_dot_pos,chr_byte];
                      12 : test_byte := ptr12^.map[act_dot_pos,chr_byte];
                      18 : test_byte := ptr18^.map[act_dot_pos,chr_byte];
                      24 : test_byte := ptr24^.map[act_dot_pos,chr_byte];
                      30 : test_byte := ptr30^.map[act_dot_pos,chr_byte]
                   END; {case}
                   chr_bit := width_lcv MOD 8;
                   CASE chr_bit OF
                      1 : test_bit := test_byte AND 128;
                      2 : test_bit := test_byte AND 64;
                      3 : test_bit := test_byte AND 32;
                      4 : test_bit := test_byte AND 16;
                      5 : test_bit := test_byte AND 8;
                      6 : test_bit := test_byte AND 4;
                      7 : test_bit := test_byte AND 2;
                      0 : test_bit := test_byte AND 1
                   END; {case}
                   FOR mult_w_lcv := 1 TO mult_w DO
                       IF test_bit = 0 THEN
                           out_char(' ',CHR(chr_num),'A')
                       ELSE
                           out_char(CHR(chr_num),' ','A')
                       {end}
                   {end for height multiplier}
                END
            END; {for width of each character}
            end_char_pos := out_cnto + (ndx_array[chr_num].delta_x * mult_w);
            IF (end_char_pos < out_line.len) AND (chr_pos < LENGTH(inp_line))  THEN
                out_line.len := end_char_pos
            ELSE BEGIN
                added := end_char_pos - out_line.len;
                FOR i := 1 TO added DO
                    out_char(' ',block_char,'A');
            END; {subtract or add spaces for delta_x - but not on last char}
            CASE map_size OF                   {point to next char map}
                 8 : ptr8 := ptr8^.next;
                12 : ptr12 := ptr12^.next;
                18 : ptr18 := ptr18^.next;
                24 : ptr24 := ptr24^.next;
                30 : ptr30 := ptr30^.next
            END {case}
        END; {for each character}
        IF inv_video AND ((out_line.chr[out_line.len] <> ' ') OR
          (out_line.ichr[out_line.len] <> block_char)) THEN
            FOR i := 1 TO mult_w DO out_char(' ',block_char,'A');
            {if inv_video and delta_x did not add a space, add a ending block}
        FOR mult_h_lcv := 1 TO mult_h DO
            out_char(' ',' ','E'); {output line(s) }
        out_char(' ',' ','C') {clear output line}
    END; {for height of characters}
    IF inv_video THEN BEGIN {if inv_video, end with a solid line}
        FOR i := 1 TO space_needed + mult_w - given_offset DO       {space_needed is only an}
            out_char(' ',block_char,'A');   {approx line length!}
        out_char(' ',' ','E'); {and output it}
        out_char(' ',' ','C')  {and clear it}
    END;
    out_char(' ',' ','D'); {end w/blank line}
    reset_maps(ptr_maps) {dispose of maps}
END; {PROCEDURE out_sign}

{$i disp}    {display parameters}
{$i ask}     {ask for parameters}
{$i prt}     {printer specific routines}

PROCEDURE parm_menu; {font_f_open : BOOLEAN}
BEGIN
    CLRSCR; highvideo;
    WRITE('Signs'); lowvideo; WRITE(' Version: ',Date);
    GOTORC(1,59); WRITE('Mode:');
    GOTORC(3,1);
    WRITE('------------------------- ');
    highvideo; WRITE('Options and I/O Parameters');
    lowvideo; WRITE(' --------------------------');
    disp_t; disp_b; disp_f; disp_w; disp_h; disp_v;
    disp_a; disp_m; disp_g; disp_q; disp_x; disp_i;
    disp_r; disp_n; disp_o; disp_s; disp_y; disp_p;
    disp_l; disp_c; disp_d; disp_e; disp_fs;
    GOTORC(15,1); lowvideo;
    WRITE('-------------------------------------------------------------------------------');
    avail_space;
    GOTORC(17,41); highvideo;
    TextAttr := TextAttr + Blink;
    WRITE('Enter option letter');
    TextAttr := TextAttr - Blink;
    GOTORC(18,1); lowvideo;
    WRITE('-------------------------------------------------------------------------------');
END; {Procedure parm_menu}


PROCEDURE ask_parm; { (VAR font_f_open : BOOLEAN) }
VAR            ans : CHAR;       {used for single char inut}
   done,out_f_open : BOOLEAN;    {flags}
     old_ff,old_of : STRING[14]; {old filenames upon input or procedure}
BEGIN
    GOTORC(1,65); highvideo; WRITE('Change Parms');
    GOTORC(17,41); CLREOL; WRITE('Enter option letter');
    GOTORC(20,1); CLREOL; GOTORC(21,1); CLREOL;
    GOTORC(22,1); CLREOL; GOTORC(23,1); CLREOL;
    disp_t; disp_b; disp_f; disp_w; disp_h; disp_v;
    disp_a; disp_m; disp_g; disp_q; disp_x; disp_i;
    disp_r; disp_n; disp_o; disp_s; disp_y; disp_p;
    disp_l; disp_c; disp_d; disp_e; disp_fs;
    IF output_device = recd_file THEN
        out_f_open := TRUE
    ELSE
        out_f_open := FALSE;
    old_of := out_fn;
    old_ff := font_fn;
    done := FALSE;
    WHILE NOT done DO BEGIN
        GOTORC(17,41); highvideo;
        TextAttr := TextAttr + Blink;
        WRITE('Enter option letter');
        TextAttr := TextAttr - Blink;
        ans := READKEY;
        GOTORC(17,41); CLREOL;
        GOTORC(20,1); lowvideo;
        CASE ans OF
        'T','t' : ask_t; {change sign type}
        'B','b' : ask_b; {change block/letter type}
        'F','f' : ask_f; {change font filename}
        'W','w' : ask_w; {change width of output graphic characters}
        'H','h' : ask_h; {change height of output graphic characters}
        'V','v' : ask_v; {change inverse video on/off}
        'A','a' : ask_a; {change auto-centering on/off}
        'M','m' : ask_m; {enter a given left margin to use}
        'G','g' : ask_g; {change the maximum width of output line in characters}
        'Q','q' : ask_q; {abort exit}
     ^M,'x','X' : ask_x(done,ff_open,out_f_open,old_ff,old_of);
                         {check if done and if so, return to input}
        'I','i' : ask_i; {change input device}
        'R','r' : ask_r; {change read from input filename}
        'N','n' : ask_n; {change number of copyies desired}
        'O','o' : ask_o; {change output device}
        'S','s' : ask_s; {change output device size}
        'Y','y' : ask_y; {change printer type}
        'P','p' : ask_p; {change printer characters/inch}
        'L','l' : ask_l; {change printer lines/inch}
        'C','c' : ask_c; {change printer color}
        'D','d' : ask_d; {change printer graphic density}
        'E','e' : ask_e  {change output record filename}
        ELSE      BEGIN {not a menu option}
                      GOTORC(24,1); WRITE('Unrecognized code entered ->',ans,'<-'^G);
                      sak
                  END
        END; {case}
        GOTORC(20,1); CLREOL; GOTORC(21,1); CLREOL; GOTORC(22,1); CLREOL;
        GOTORC(23,1); CLREOL; GOTORC(24,1); CLREOL;
        GOTORC(17,41); lowvideo;
        TextAttr := TextAttr + Blink;
        WRITE('Enter option letter');
        TextAttr := TextAttr - Blink
    END; {while not done}
    highvideo
END; {procedure ask_parm}


PROCEDURE input_menu;
BEGIN
    GOTORC(1,65); highvideo; WRITE('Input Text  ');
    GOTORC( 4,1); WRITE(' '); GOTORC( 5,1); WRITE(' '); GOTORC( 6,1); WRITE(' ');
    GOTORC( 7,1); WRITE(' '); GOTORC( 8,1); WRITE(' '); GOTORC( 9,1); WRITE(' ');
    GOTORC(10,1); WRITE(' '); GOTORC(11,1); WRITE(' '); GOTORC(12,1); WRITE(' ');
    GOTORC(13,1); WRITE(' '); GOTORC(14,1); WRITE('      ');
    GOTORC( 4,41); WRITE(' '); GOTORC( 5,41); WRITE(' '); GOTORC( 6,41); WRITE(' ');
    GOTORC( 7,41); WRITE(' '); GOTORC( 8,41); WRITE(' '); GOTORC( 9,41); WRITE(' ');
    GOTORC(10,41); WRITE(' '); GOTORC(11,41); WRITE(' '); GOTORC(12,41); WRITE(' ');
    GOTORC(13,41); WRITE(' '); GOTORC(14,41); WRITE(' ');

    GOTORC(17,1); CLREOL; lowvideo; WRITE(' Output width needed -> ');
    highvideo; WRITE(space_needed);
    GOTORC(19,1); CLREOL;           WRITE('          Input Text -> ');
    GOTORC(20,1); CLREOL;
    GOTORC(21,1); CLREOL;
    WRITE('   ^P'); lowvideo; WRITE(': Change parameters     '); highvideo;
    WRITE('^F,^L'); lowvideo; WRITE(': Send Formfeed to LST    '); highvideo;
    WRITE('^X'); lowvideo; WRITELN(': Restart Input'); highvideo;
    WRITE('^C,^D'); lowvideo; WRITE(': Done, quit to OS      '); highvideo;
    WRITE('^R,^T'); lowvideo; WRITE(': Send Reverse Formfeed   '); highvideo;
    WRITE('^H'); lowvideo; WRITELN(': Backspace'); highvideo;
    WRITE('<ret>'); lowvideo; WRITE(': Process Input         '); highvideo;
    WRITE('   ^A'); lowvideo; WRITE(': Alternate Input         ');
    GOTORC(25,1); CLREOL; GOTORC(19,25);
END;

{$i util}

BEGIN
    main;
    GOTORC(25,1); WRITE('<<< Signs completed >>>')
END.
