{*****************************************************************************
** Communications Client Version 1.0                            May 1, 1991 **
** Copyright 1987,1988,1991 by L. Brett Glass, Systems Consultant           **
******************************************************************************}
program Client; {Client TSR}
uses NetBIOS,NetTools,DOS;

{$M 8192,0,0} {Use 8K of stack, no heap}
{$R-}
{$S-}
{$I-}      {Turn off space- and time-consuming options}
{$V-}

type
  PortNumType = 1..4;

type
  CommRegType = record
    case Boolean of
      TRUE: (dx,cx,bx,ax : Word);
      FALSE: (dl,dh,cl,ch,bl,bh,al,ah : Byte);
    end;

var
  myPermNodeName, remotePortName : NetName;
  biosPortNum : PortNumType;
  commSessionNum : Byte;
  oldInt14 : Pointer;
  clientSendBlock,clientRcvBlock : NCB;
  saveStackSeg : Word;
  saveStackPtr : Word;

const
  ERRORFLAG = $80; {Flag to indicate comm timeout or error}

procedure ValidateParms;
  var
    tempStr : String;
  begin
  if ParamCount <> 2 then
    begin
    Writeln('Usage: CLIENT <Network Name> <Port Number>');
    Writeln(' E.G.: CLIENT MyModem 2');
    Writeln('       Connects COM2: to a remote networked');
    Writeln('        communications port with the name MyModem');
    Halt
    end;
  tempStr := ParamStr(1);
  if (Length(tempStr) = 0) or (Length(tempStr) > 16) then
    begin
    Writeln('Error: Serial port/modem name must be 1 to 16 characters');
    Halt
    end;
  FillChar(remotePortName,SizeOf(remotePortName),' ');
  Move(tempStr[1],remotePortName[1],Length(tempStr));
  tempStr := ParamStr(2);
  if (Length(tempStr) <> 1) or (tempStr[1] < '1') or
    (tempStr[1] > '4') then
    begin
    Writeln('Error: Port number must be 1 through 4');
    Halt
    end;
  biosPortNum := Ord(tempStr[1])-Ord('1'); {BIOS uses 0=COM1, etc.}
  end; {ValidateParms}

procedure Connect;
  begin
  if not NetBIOSPresent then
    begin
    Writeln('Error: NetBIOS not available');
    Halt;
    end;
  if NetToolsGetMyName(myPermNodeName) <> GOOD_RTN then
    begin
    Writeln('Error: Unable to determine adapter status');
    Halt;
    end;
  {Do a call. Set up a session with five-second timeouts.}
  if NetToolsCall(myPermNodeName,remotePortName,10,10,commSessionNum) <> GOOD_RTN then
    begin
    Writeln('Error: Unable to establish session with server');
    Halt;
    end;
  {Initialize NCBs for the conversation}
  clientSendBlock.Init(SEND);
  clientRcvBlock.Init(RECEIVE);
  end; {Connect}

procedure Int14Handler(flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp : Word);
  interrupt;
  {All Int 14 requests are sent off to the server for processing.
   The server takes care of queueing, returning status, etc.
   Note that this code doesn't filter out invalid function codes;
   this allows us to add functionality at the server without
   changing the basic client.}
  var
    commRegs : CommRegType absolute dx;
  begin
  if dx <> biosPortNum then {Chain to old vector}
    asm
    mov sp,bp
    pop bp; pop es; pop ds; pop di; pop si;
    pop dx; pop cx; pop bx; pop ax;
    jmp oldInt14;
    end
  else
    begin
    asm sti end; {Turn on interrupts}
    with clientSendBlock do
      begin
      bufPtr := Addr(commRegs);
      lsn := commSessionNum;
      len := SizeOf(CommRegType);
      if ReturnCode = GOOD_RTN then
        with clientRcvBlock do
          begin
          bufPtr := Addr(commRegs); {Point to block with dx,cx,bx,ax}
          len := SizeOf(commRegs); {Four words long}
          lsn := commSessionNum;
          if (ReturnCode <> GOOD_RTN) or (len <> SizeOf(commRegs)) then
            commRegs.ah := retcode or ERRORFLAG; {Slip in NetBIOS error code}
          end
      else {If send failed}
        commRegs.ah := retcode or ERRORFLAG;
      end
    end {case ah}
  end; {Int14Handler}

procedure DivertInt14;
  begin
  GetIntVec($14,oldInt14);
  SetIntVec($14,Addr(Int14Handler));
  end; {DivertInt14}

begin {Client}
ValidateParms; {Check and parse command line}
Connect;
DivertInt14; {Capture INT 14 so we can provide services}
SwapVectors; {Prepare to go resident}
Keep(0); {Go resident}
end. {Client}
