
#include <iomanip.h>                         // for setprecision(), setwidth()
#include <fstream.h>                         // for device i/o
#include <iostream.h>        // for C++ stuff
#include <dir.h>                             // for findfirst() / findnext(),
                                             // getcwd(), MAXPATH,
                                             // ..and MAXFILE (which is 9)

char inFileName[255];        // for input filename


int done;                    // for the following loop


char name[80],
     tempchar;
float  PIXEL_CLK,
       H_DISP, H_FPORCH, H_SYNC, H_BPORCH, H_SYNC_POL,
       V_DISP, V_FPORCH, V_SYNC, V_BPORCH, V_SYNC_POL,
       INTERLACE_ENABLE,
       microsec,
       temp;

ifstream fin;                // create stream object for input

void setInfo ();     // prototype



int main(int argc, char **argv)
{
   struct ffblk ffblk;                       // for findfirst(), findnext()

   char choice;
   cerr << "\nMonitor Calculator - (C) Copyright 1996  Alexander Eremeef\n"
        << "-- written September 8, 1996 -- for the MGA.MON data file.\n"
        << "-- converts MGA.MON file into microsecond timing data format..\n"
        << "----------------------------------------------------------\n\n";

   int FileFlag=1;       // for later error flag

   if (argc > 1)
   {
     done = findfirst( argv[1], &ffblk, 0 );
     if (!done)
        FileFlag = 0;
   }
   while (FileFlag > 0)
   {
     cerr << "Please enter the name of the file:  \x1B[1;37m";
     cin >> inFileName;
     cerr << "\x1B[0m";

     done = findfirst( inFileName, &ffblk, 0 );

     if (done)
        cerr << "\n\a\x1B[1;36mERROR:  '\x1B[1;37m" << inFileName
             << "\x1B[1;36m'  does not exist!\x1B[1;33m\n\n";
     else
        FileFlag = 0;
   }

   fin.open( ffblk.ff_name );                             // open file
   cerr << "\n\nProcessing file:  " << ffblk.ff_name << "\n\n";

//---------------------------------------------------------------------------
   do
      {
      while (fin.peek() != '[' && fin.good())
         fin.ignore(255,'\n');

      if (!fin.good())
         break;

      setInfo();

      choice = fin.peek();                        // get the answer..
      }
   while (choice != 'n' && choice != 'q' && fin.good());
                                            // quit on 'n', 'q', or EOF
return 0;
}


      void setInfo()                        // constructor, no args
         {
         fin.get(name,80,'\n').get();

         fin.ignore(255,'=');
         fin >> PIXEL_CLK;
         fin.ignore(255,'=');
         fin >> H_DISP;
         fin.ignore(255,'=');
         fin >> H_FPORCH;
         fin.ignore(255,'=');
         fin >> H_SYNC;
         fin.ignore(255,'=');
         fin >> H_BPORCH;
         fin.ignore(255,'=');
         fin >> H_SYNC_POL;
         fin.ignore(255,'=');
         fin >> V_DISP;
         fin.ignore(255,'=');
         fin >> V_FPORCH;
         fin.ignore(255,'=');
         fin >> V_SYNC;
         fin.ignore(255,'=');
         fin >> V_BPORCH;
         fin.ignore(255,'=');
         fin >> V_SYNC_POL;
         fin.ignore(255,'=');
         fin >> INTERLACE_ENABLE;
         fin.ignore(255,'\n');

         temp = H_DISP + H_FPORCH + H_SYNC + H_BPORCH;
         microsec = temp / (PIXEL_CLK * 0.001);

         cout << setiosflags(ios::fixed) << setiosflags(ios::showpoint)
              << setprecision(3)

              << name << endl

              << "Clock      = "
              << setw(9) << setiosflags(ios::right)
              << (PIXEL_CLK * 0.001) << " MHz\n"

              << "Horizontal = "
              << setw(9) << setiosflags(ios::right)
              << (PIXEL_CLK / temp) << " KHz\n"

              << "Vertical   = "
              << setw(9) << setiosflags(ios::right)
              << ((PIXEL_CLK / temp)*1000) / (V_DISP+V_FPORCH+V_SYNC+V_BPORCH)
              << " Hz\n\n"

              << "H_Period   = "
              << setw(9) << setiosflags(ios::right)
              << microsec << " \xE6s" << endl

              << "H_DISP     = "
              << setw(9) << setiosflags(ios::right)
              << microsec / (temp / H_DISP) << " \xE6s"
              << resetiosflags(ios::showpoint)
              << "  ("
              << setw(4) << setiosflags(ios::right)
              << H_DISP << " pixels)\n"
              << setiosflags(ios::showpoint)

              << "H_Blanking = "
              << setw(9) << setiosflags(ios::right)
              << microsec / (temp / (H_FPORCH+H_SYNC+H_BPORCH)) << " \xE6s"
              << resetiosflags(ios::showpoint)
              << "  ("
              << setw(4) << setiosflags(ios::right)
              << H_FPORCH+H_SYNC+H_BPORCH << " pixels)\n"
              << setiosflags(ios::showpoint)

              << "H_FPORCH   = "
              << setw(9) << setiosflags(ios::right)
              << microsec / (temp / H_FPORCH) << " \xE6s" << endl

              << "H_SYNC     = "
              << setw(9) << setiosflags(ios::right)
              << microsec / (temp / H_SYNC) << " \xE6s" << endl

              << "H_BPORCH   = "
              << setw(9) << setiosflags(ios::right)
              << microsec / (temp / H_BPORCH) << " \xE6s" << endl

              << "H_SYNC_POL = "
              << setw(9) << setiosflags(ios::right);

         if (H_SYNC_POL == 0)
            cout << '-';
         else if (H_SYNC_POL == 1)
            cout << '+';
         else
            cout << '?';

         cout << "\n\n"
//-------
              << "V_Period   = "
              << setw(9) << setiosflags(ios::right)
              << microsec * (V_DISP+V_FPORCH+V_SYNC+V_BPORCH) << " \xE6s"
              << endl

              << "V_DISP     = "
              << setw(9) << setiosflags(ios::right)
              << microsec * V_DISP << " \xE6s"
              << resetiosflags(ios::showpoint)
              << "  ("
              << setw(4) << setiosflags(ios::right)
              << V_DISP << " lines)\n"
              << setiosflags(ios::showpoint)

              << "V_Blanking = "
              << setw(9) << setiosflags(ios::right)
              << microsec * (V_FPORCH+V_SYNC+V_BPORCH) << " \xE6s"
              << resetiosflags(ios::showpoint)
              << "  ("
              << setw(4) << setiosflags(ios::right)
              << V_FPORCH+V_SYNC+V_BPORCH << " lines)\n"
              << setiosflags(ios::showpoint)

              << "V_FPORCH   = "
              << setiosflags(ios::showpoint)
              << setw(9) << setiosflags(ios::right)
              << microsec * V_FPORCH << " \xE6s" << endl

              << "V_SYNC     = "
              << setw(9) << setiosflags(ios::right)
              << microsec * V_SYNC << " \xE6s" << endl

              << "V_BPORCH   = "
              << setw(9) << setiosflags(ios::right)
              << microsec * V_BPORCH << " \xE6s" << endl

              << "V_SYNC_POL = "
              << setw(9) << setiosflags(ios::right);

         if (V_SYNC_POL == 0)
            cout << '-';
         else if (V_SYNC_POL == 1)
            cout << '+';
         else
            cout << '?';

         cout << endl
              << "INTERLACE_ENABLE = "
              << setw(3) << setiosflags(ios::right)
              << resetiosflags(ios::showpoint)
              << INTERLACE_ENABLE << endl
              << "-------------------------------------------------------\n\n";
         }

