/* BEGIN MICROSOFT COPYRIGHT ********************************************* */
/* 

     (C) Copyright Microsoft Corp. 1991, 1992, 1993.  All rights reserved.
   
     You have a royalty-free right to use, modify, reproduce and 
     distribute the Sample Files (and/or any modified version) in 
     any way you find useful, provided that you agree that 
     Microsoft has no warranty obligations or liability for any 
     Sample Application Files. 

*/
/* END   MICROSOFT COPYRIGHT ********************************************* */

/* some of the stuff in this file is adapted from Microsoft Developers'
   Sample files.  Modified by David Lai, lai%fastfood@daver.bungi.com */

/* BEGIN DAVID LAI COPYRIGHT ********************************************* */
/*
(C) Copyright David Lai 1993, 1994.  All rights reserved.

The source code is copyright by David Lai, however it is freely
distributable and released for unrestricted use.  Users may copy or modify 
this source code without charge, provided all copyright
notices remain intact in all the source code.  Portions of the source code
copyright by their respective copyright holders and are covered
under different agreements, however the source code used has
specifically been marked distributable royalty-free.

You can do whatever you want with it, even charge money for it, if
you find a sucker willing to pay for it.  This is not shareware, the program
is not crippled in any way, do not send money.  You can e-mail comments
to the electronic mail address below, or fax to the fax number below.

If you add a feature thats useful, or do a new port, you can send
the context diffs to the e-mail address below.  I may include it in
subsequent releases.  Your code must specifically be marked
freely distributable, I will not include code marked otherwise.

THE SOURCE CODE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.

The source code is provided with no support and without any obligation on
the part of David Lai to assist in its use, correction,
modification or enhancement.

DAVID LAI SHALL HAVE NO LIABILITY WITH RESPECT TO THE
INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS SOFTWARE
OR ANY PART THEREOF.

In no event will David Lai be liable for any lost revenue
or profits or other special, indirect and consequential damages, even if
David Lai has been advised of the possibility of such damages.

David Lai
1370 McKendrie St
San Jose, CA 95126
fax: 408-241-4615

lai%fastfood@daver.bungi.com

*/
/* END   DAVID LAI COPYRIGHT ********************************************* */


typedef uint16	WORD;
typedef uint32	DWORD;

/* specific waveform format structure for PCM data */
typedef struct pcmwaveformat_tag {
    WORD    wFormatTag;        /* format type */
    WORD    nChannels;         /* number of channels (i.e. mono, stereo...) */
    DWORD   nSamplesPerSec;    /* sample rate */
    DWORD   nAvgBytesPerSec;   /* for buffer estimation */
    WORD    nBlockAlign;       /* block size of data */
    WORD    wBitsPerSample;
} PCMWAVEFORMAT;

/* flags for wFormatTag field of WAVEFORMAT */
#define WAVE_FORMAT_PCM     1

/* define the mmioFOURCC macro to convert 4 chars to a uint32 , little-endian */
#define mmioFOURCC(a,b,c,d) ( ((uint32)(d) << 24) | ((uint32)(c) << 16) | ((uint32)(b) << 8) | ((uint32)(a)))

/* define the necessary FOURCC constants */

#define cc4_WAVE	mmioFOURCC('W', 'A', 'V', 'E')
#define cc4_LIST	mmioFOURCC('L', 'I', 'S', 'T')
#define cc4_fmt		mmioFOURCC('f', 'm', 't', ' ')
#define cc4_data	mmioFOURCC('d', 'a', 't', 'a')
#define cc4_RIFF	mmioFOURCC('R', 'I', 'F','F')
#define cc4_INFO	mmioFOURCC('I', 'N', 'F','O')
#define cc4_INAM	mmioFOURCC('I', 'N', 'A','M')
#define cc4_ISFT	mmioFOURCC('I', 'S', 'F','T')
#define cc4_ICMT	mmioFOURCC('I', 'C', 'M','T')

/* round up to an even number */

#define EVEN(x) (((x)%2==0)?(x):((x)+1))

extern 
	FILE * wav_write PROTO((signed char *sample_data, struct sample *sample_info,
		uint32 sample_rate, int info_flag)) ;
extern 
	void wav_write_final PROTO((FILE *fw, struct sample *sample_info,
		uint32 sample_rate, int info_flag)) ;

#if 0
$Id: wav.h,v 1.1 1994/03/19 09:21:31 dlai Exp $
$Log: wav.h,v $
 * Revision 1.1  1994/03/19  09:21:31  dlai
 * Initial revision
 *

#endif
