unit xinbta_u;
interface

uses
  betain_u;

function xinbta(p,q,beta,alpha:double;var ifault:integer):double;

implementation

function xinbta(p,q,beta,alpha:double;var ifault:integer):double;

{
c     algorithm as 109 appl statist (1977) vol 26, no 1, pp 111-114.
c
c     (replacing algorithm as 64 appl statist  (1973)
c     vol 22,  no 3.)
c
c     computes inverse of incomplete beta function
c     ratio for given positive values of the arguments
c     p and q, alpha  between zero and one.
c     log of complete beta function, beta, is assumed known.
c
}
var
  index : boolean;
  a,g,h,r,s,t,w,y,yprev,
  pp,qq,
  adj,sq,prev,tx,
  result
   : double;
{
c     define accuracy and initialise.
}
const
     acu = 1.0e-26;
     tol = 1.0e-9;

label
  label7,
  label10,
  label11;
begin
      result := alpha;
      xinbta := result;
{
c     test for admissibility of parameters.
}
      ifault := 1;
      if(p<=0.0) or (q<=0.0) then
        exit;
      ifault := 2;
      if( alpha<0.0) or (alpha>1.0) then
        exit;
      ifault := 0;
      if(abs(alpha)<=tol) or (abs(alpha-1.0)<=tol) then
        exit;
{
c     change tail if necessary
}
      if(alpha>0.5) then
      begin
        a := 1.0 - alpha;
        pp := q;
        qq := p;
        index := true;
      end
      else
      begin
    {1} a := alpha;
        pp := p;
        qq := q;
        index := false;
      end;
{
c     calculate the initial approximation.
}
  {2} r := sqrt(-ln(a*a));
      y := r-(2.30753+0.27061*r) /(1.0+(0.99229+0.04481*r)*r);
      if not ((pp>1.0) and (qq>1.0)) then
      begin
        r := qq + qq;
        t := 1.0/(9.0*qq);
        t := (1.0-t+y*sqrt(t));
        t := r*t*t*t;
        if (t>0.0) then
        begin
          t := (4.0*pp+r-2.0) / t;
          if (t<=1.0) then
            result := exp((ln(a*pp) + beta)/pp)
          else
            result := 1.0-2.0/(t+1.0);
        end
        else
      {3} result := 1.0-exp((ln((1.0-a)*qq)+beta)/qq);
      end
      else
      begin
    {5} r := (y*y-3.0)/6.0;
        s := 1.0 / (pp+pp-1.0);
        t := 1.0/(qq+qq-1.0);
        h := 2.0/(s+t);
        w :=y*sqrt(h+r)/h - (t-s)*(r+5.0/6.0-2.0/(3.0*h));
        result := pp/(pp+qq*exp(w+w));
      end;
{
c     solve for x by a modified newton-rapheson method.
c     using the function betain.
}
  {6} r := 1.0-pp;
      t := 1.0 - qq;
      yprev := 0.0;
      sq := 1.0;
      prev := 1.0;
      if result < 0.0001 then
        result := 0.0001
      else if result > 0.9999 then
        result := 0.9999;
  label7:
      y := betain(result,pp,qq,beta,ifault);
      if(ifault<>0) then
      begin
        ifault := 3;
        exit;
      end;
  {8} y := (y-a)*exp(beta+r*ln(result)+t*ln(1.0-result));
      if(y*yprev<=0.0) then
        prev := sq;
      g := 1.0;
      repeat
    {9} adj := g*y;
        sq := adj*adj;
        if(sq<prev) then
        begin
          tx := result - adj;
          if(tx>=0.0) and (tx<=1.0) then
            goto label11;
        end;
      label10:
        g := g / 3.0;
      until false;
   label11:
      if(prev>acu) and (y*y>acu) then
      begin
        if(abs(tx)<=tol) or (abs(tx-1.0)<=tol) then
          goto label10;
        if (abs((tx-result)/result)>tol) then
        begin
          result := tx;
          yprev := y;
          goto label7;
        end;
      end;
   {12 continue}
      if(index) then
        result := 1.0 - result;
      xinbta := result;
end;

end.
