procedure HIDDENLINE;

{ Make a hidden lines drawing of the object }
var Node:                      word;          { node # }
    Surf:                      word;          { surface # }
    ch:                        char;
    User_abort:                boolean;       { did the user abort? }
{$ifndef BIGMEM}
    Surfmin, Surfmax: surfaces;
      { surface minimum & maximum (Ztran) }
{$endif}
label ABORTTEXT,                              { text-mode abort }
      ABORTGRPH;                              { graphics-mode abort }

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
with ptrd^ do with ptre^ do with ptrf^ do
with ptri^ do with ptrk^ do with ptrn^ do
begin
{$endif}
  perf_start;
  User_abort := TRUE;
  if (Viewchanged) then begin
    menumsg ('Transforming to 2-D...');
    if (checkey) then goto ABORTTEXT;
{ Transform from 3-D to 2-D coordinates }
    setorigin;
    for Node := 1 to Nnodes do
      perspect (Xworld[Node], Yworld[Node], Zworld[Node],
                Xtran[Node],  Ytran[Node],  Ztran[Node]);

    if (checkey) then goto ABORTTEXT;
{ Set plotting limits and normalize transformed coords to screen coords }
    perspect (Xfocal, Yfocal, Zfocal, Xfotran, Yfotran, Zfotran);
    if (not setnormal (Xfotran, Yfotran, XYmax)) then begin
      menumsg ('Warning: Focal point outside data limits.');
      writeln;
      write   ('  Press any key ...');
      ch := readkey;
    { Erase the previous message }
      menumsg ('');
      writeln;
      write ('                          ');
    end;

{ Normalize all the nodes }
    for Node := 1 to Nnodes do
      normalize (Xtran[Node], Ytran[Node], Xfotran, Yfotran, XYmax);

    menumsg ('Sorting surfaces...');
    if (checkey) then goto ABORTTEXT;
    minmax (Surfmin, Surfmax, Nsurf);
    shelsurf (Surfmin, Surfmax, Nsurf);
    Viewchanged := FALSE;
  end; { if Viewchanged }

{$ifdef USE_IFF}
  menumsg ('Plotting...');
{$endif}
  setgmode (Nmatl);
  for Surf := 1 to Nsurf do begin
    if (Nsides = 2) or (Visible (Surf, 1)) then begin
      { First fill the surface in with black }
      fillsurf (Surf, 0, 0);
      { Now draw the border }
      border (Surf, Matl[Surf]);
    end;
    if (grafstat) then goto ABORTGRPH;
  end; { for Surf }
  drawaxes (Xfotran, Yfotran, XYmax);

  perf_stop (3);

{$ifdef USE_IFF}
  menumsg ('Saving IFF...');
  saveiff (Filemask + '.IFF', VGApal);
{$else}
  { Wait for user keypress to continue }
  continue;
{$endif}
  User_abort := FALSE;

  ABORTGRPH:
  exgraphic;
  ABORTTEXT:
  if (User_abort) then
    perf_stop (0);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; {procedure HIDDENLINE }
