	page	,132

; --	absread -- absolute track and sector read
;	Version 1.1  December 30, 1985
;	Glenn F. Roberts
;	calling convention:
;		absread(drive, nsect, sector, &buffer);
;	where:
;		drive = drive no. (A=0, B=1 ...)
;		nsect = number of sectors to read
;		sector = beginning logical sector number
;		buffer = array to hold data
;	returns:
;		0	Normal return, no error
;		1	Write protect violation
;		2	Unknown unit
;		3	Drive not ready
;		4	Unknown command
;		5	CRC error
;		6	Bad drive request structure length
;		7	Seek error
;		8	Unknown media
;		9	Sector not found
;		10	Printer out of paper
;		11	Write fault
;		12	Read fault
;		13	General disk failure

_text	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:_text

	PUBLIC	_absread

_absread PROC	NEAR
	PUSH	BP		; setup stack addressing
	MOV	BP,SP
	PUSH	DI
	PUSH	SI

	MOV	AX,[BP+4]	; AX = drive number
	MOV	CX,[BP+6]	; CX = number of sectors
	MOV	DX,[BP+8]	; DX = starting record
	MOV 	BX,[BP+10]	; DS:BX = buffer address

	INT	025H		; request absolute read
	INC	SP
	INC	SP		; fix the stack

	JC	ERROR		; if error then return code
	XOR	AX,AX		; else show normal return = 0
	JMP	SHORT DONE	; and then exit

ERROR:	MOV	AH,0		; error - zero high byte
	INC	AL		; and increment error no.

DONE:	POP	SI		; restore registers
	POP	DI
	POP	BP
	RET			; and return
_absread ENDP

_text	ENDS
	END
