PAGE	80,132		 
NAME	remdrv

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;
;							    LUBLIN 24-02-1989	;
;   remdrv (v1.03)									;
;								by JW		;
;...............................................................................;



		ASSUME DS:code, SS:code ,CS:code ,ES:code
code		SEGMENT	Para Public 'code'
		ORG	100h

start:		jmp	starter		; jump over data

;.................................................................................

lf		equ	0ah		; line feed
cr		equ	0dh		; carriage return

ZERO		equ	0
TAB		equ	9

DIB_SIZE	equ	21h
FIRST_DIB	equ	26h
FIRST_DA	equ	3ch
NUM_OF_DRV	equ	46h
TOTAL_NUM	equ	47h

;...............................................................................
two		db	2		
dos_dep		dw	0	;0 - if dos 3.xx, 6 - if dos 4.xx or 5.xx
dos_dep2	db	0	;0 - if dos 3.xx, 7 - if dos 4.xx or 5.xx
dos_dep3	dw	0	;0 - if dos 3.xx, 1 - if dos 4.xx or 5.xx

flags		db	0	;1 - device was loaded by Idrv

drv_num		db	0		;current drive number

dos_seg		dw	0		;IMBDOS segment

drv_beg		dw	0		;Start of driver (must be on para boundry)

DIB_offs	dw	0		;Address of ...
DIB_seg		dw	0		; ... driver's DIB

header_offs	dw	0
header_seg	dw	0

last_offs	dw	0		;Address of ...
last_seg	dw	0		; ... DIB to be last

xms_offs 	dw	0
xms_seg	 	dw	0

DA_flag		db	0		;non zero if proper Drive Area found
dev_flag	db	0		;set to 1 if block device
dev_count	db	0

buf		db	10 dup (0)	;area for device driver name
TXT_LEN		equ	$ - buf		

first_dev	db	0
		db	': - '
last_dev	db	0
		db	':    '
PATT_LEN	equ	$ - first_dev

one_dev		db	0
		db	':'
		db	9 dup (' ')
ONLY_ONE	equ	$ - one_dev	

signature 	db	'IdrvCB '
SIG_LEN		equ	$ - signature

;......................................................................................
;...............................................................................

starter:	lea	dx,header
		call	print_msg    
		mov	ah,30h
		int	21h			;Get DOS version number
		lea	dx,err_txt
		cmp	al,3
		jb	pr_txt
check_ver:
		je	get_list		;DOS v3.xx
		cmp	al,5			;ver. above 5 ?
		ja	pr_txt			;yes,jump
		mov	dos_dep,6		;No,change entry length of Open Files Table 
		mov	dos_dep2,7		;Change entry length of Drive Area
		mov	dos_dep3,1		;Change entry length of Disk Info Block
get_list:
		mov	ah,52h
		int	21h			;Get vector for int 25H
		mov	dos_seg,es
		lea	dx,not_PC_Dos
		cmp	word ptr es:52h,'UN'	;NUL device ?
		jne	pr_txt			;No,jump
		les	di,dword ptr es:02ah	;get address of DOS file table
		add	di,dos_dep		;change entry length of OFT if necessary
		cmp	byte ptr es:[di + 05bh],'C'	;Entry for dev. CON ?
		jne	pr_txt
		cmp	word ptr es:[di + 05ch],'NO'	
		je	go_on      
pr_txt:
		jmp	exit		;Jump to print message and qiut
go_on:		
		jmp	ldrv
;...............................................................................
;...............................................................................
;	messages to display
		db	'Program written by Janusz Wojcik',cr,lf
err_txt		db	'IDrv: That version of DOS is not supported!',cr,lf,lf,'$'
not_PC_Dos	db	'IDrv: Not PC DOS ',cr,lf,lf,'$'
unlink_OK	db	cr,lf,'Device Driver uninstalled!',cr,lf,'$'
unlink_err	db	cr,lf,"Can't uninstall device driver!",cr,lf,'$'
unlink_quit	db	cr,lf,"Device driver not uninstalled!",cr,lf,'$'
header		db	'Device Drivers Uninstaller  v1.03',cr,lf
		db	'(C)  1990  by Janusz Wojcik Lublin,Poland.',cr,lf,lf,'$'
intro		db	'This is device ','$'
not_idrv_dev	db	cr,lf,'Not loaded by Idrv !','$'
inquiry		db	cr,lf,'Delete it (y/n) ?','$'
;....................................................................................
;...............................................................................

device_header	struc
next_offs	dw	?
next_seg	dw	?
dev_attr	dw	?
dev_strategy	dw	?
dev_interrupt	dw	?
name_unit	db	8 dup(?)
device_header	ends
;...............................................................................
;...............................................................................
;	the program body
;..............................................................................		
ldrv:  

		mov	es,dos_seg
		mov	si,48h
		les	si,dword ptr es:[si]	;Address of next dev. header
		call	copy_name		;get device driver name
		call	check_type		;check whether character or block device
		call	print_name		;display driver name 
		call	check_icb		;check if Idrv Control Block precedes Device Header
		lea	dx,inquiry
		call	print_msg		;ask if remove device driver
		mov	ah,1
		int	21h			;get char from stdin
		cmp	al,'y'			;remove dev. driver ?
		je	check_attr
		lea	dx,unlink_quit
		jmp	exit_OK

check_attr:		
		mov	ax,es:dev_attr[si]
		test	ah,80h			;Character device ?
		jnz	unlnk_dev		;Yes,jump to unlink device headers

		mov	ax,es
		mov	dx,si
		mov	header_offs,dx
		mov	header_seg,ax

		call	seek_DIB		;Seek DIB pointing to ES:SI
		jc	exit_err
		mov	ax,DIB_offs
		mov	last_offs,ax
		mov	ax,DIB_seg
		mov	last_seg,ax
find_CDS:
		mov	si,es
		mov	dx,bx
		mov	DA_flag,ZERO
		call	seek_DA			;Seek DA poniting to ES:BX
		cmp	DA_flag,ZERO
		jz	exit_err
		mov	dx,header_offs
		mov	ax,header_seg
		
		call	seek_DIB
		jnc	find_CDS
chain_end:
		les	bx,dword ptr last_offs
		mov	si,dos_dep3
		mov	word ptr es:[si + bx + 18h],0ffffh	;Mark DIB as the last DIB
		mov	al,byte ptr es:[bx]
		inc	al
		mov	es,dos_seg
		mov	byte ptr es:NUM_OF_DRV,al		;Set real number of drives
				
unlnk_dev:
		call	unlink_dev		;Link device headers
		lea	dx,unlink_OK
		jmp	exit_OK
exit_err:
		lea	dx,unlink_err
exit_OK:

exit:
		call	print_msg
		mov	ah,4ch		;EXIT
		mov	al,1		;Set return code
		int	21h
;...............................................................................
print_msg:	
		mov	ah,9
		int	21h
		ret
;..............................................................................
; copy_name:
;	copy device driver name from Device Header into local buffer 
; INPUT:
;	ES:SI - address of Device Header for device
;..............................................................................
copy_name:	push	si
		push	es
		push	ds

		mov	ax,es:dev_attr[si]
		test	ah,80h			;Character device ?
		jnz	copy			;Yes,skip
		mov	dev_flag,1		;Signal that block device	
copy:
		
		mov	cx,4
		mov	di,offset buf
		push	es
		pop	ds		;DS = ES	
		add	si,10
		push	cs		
		pop	es		;ES = CS
		cld
		rep	movsw		;copy device name 

quit_copy:
		pop	ds
		pop	es
		pop	si
		ret
;................................................................................
; check_type:
;	check if block device.
;	Prepare for displaying device name if so.
; INPUT:
;	ES:SI - address of Device Header for device
;................................................................................
check_type:
		cmp	dev_flag,1
		jne	quit_check
		push	es
		push	si
		mov	ax,es
		mov	dx,si
		call	seek_DIBs

		inc	first_dev
		add	first_dev,40h
		mov	al,first_dev
		mov	last_dev,al
		mov	al,dev_count
		dec	al
		add	last_dev,al
		pop	si
		pop	es
quit_check:		
		ret
;...............................................................................
; seek_DIBS:
;	find number of the first and the last device 
;	AX:DX - address of Device Header for device
;...............................................................................
seek_DIBs	proc	near

		push	es
		push	si
		mov	es,dos_seg
		les	bx,es:FIRST_DIB			;Get address of first DIB
		mov	si,dos_dep3		
next_DIB_in_chain:	
		cmp	word ptr es:[si + bx + 12h],dx
		jnz	if_last_DIB
		cmp	word ptr es:[si + bx + 14h],ax
		jnz	if_last_DIB
	
		cmp	dev_count,0			;first matched device ?
		jnz	inc_count			;No,jump
		mov	cl,es:[bx] 			;get device number
		mov	first_dev,cl
inc_count:
		inc	dev_count
if_last_DIB:
		cmp	word ptr es:[si + bx + 18h],0ffffh	;The last DIB ?
		jz	seek_DIBS_end				;Yes,jump

		les	bx,dword ptr es:[si + bx + 18h]		;Get addr. of next DIB
		jmp	next_DIB_in_chain
		
seek_DIBs_end:  
		pop	si
		pop	es
		clc
		ret
seek_DIBs	endp
;...............................................................................		
; print_name:
;	display device driver name
;...............................................................................
print_name:
		push	es
		push	si
		lea	dx,intro
		call	print_msg
		mov	cx,TXT_LEN
		mov	dx,offset buf
		cmp	dev_flag,0		;Character device?
		je	call_DOS		;Yes,jump

		cmp	dev_count,1		;More than one device ?
		jnz	not_one_dev		;Yes,jump
		mov	cl,first_dev
		mov	one_dev,cl
		mov	dx,offset one_dev
		mov	cx,ONLY_ONE
		jmp	call_DOS
not_one_dev:		
		mov	dx,offset first_dev
		mov	cx,PATT_LEN
call_DOS:
		mov	ah,40h
		mov	bx,1
		int	21h
		pop	si
		pop	es
		ret
;...............................................................................		
; check_icb:
;	check if Idrv Control Block precedes Device Header
; INPUT:
;	ES:SI - address of Device Header for device
;...............................................................................
check_icb:
		push	es
		push	si
		or	flags,1
		xor	di,di
		mov	ax,es
		dec	ax
		mov	es,ax
		mov	si,offset signature
		mov	cx,SIG_LEN
		repz	cmpsb
		jz	check_icb_end
		and	flags,NOT(1)
		lea	dx,not_idrv_dev
		call	print_msg
check_icb_end:
		pop	si
		pop	es
		ret
page;..........................................................................
; unlink_dev:   							.......
;	remove Device Header from the chain of Device Headers		.......
;..............................................................................


unlink_dev:
		mov	es,dos_seg
		mov	si,48h
		push	es
		les	si,dword ptr es:[si]	;Address of next dev. header
		mov	bx,es:dev_attr[si]
		test	bl,1			;Stdin ?
		jz	dechain			;No,jump

		push	es
		push	si
		call	seek_stdin
		jc	quit_unlink
		mov	es,dos_seg
		mov	es:32h,si		;Change pointer to ...
		mov	es:34h,ax		; ... Stdin
		les	bx,es:02ah		;Get address of DOS file table
		add	bx,dos_dep		;change entry length of OFT if necessary
		mov	es:[bx + 042h],si	;Change address of dev.header ...
		mov	es:[bx + 044h],ax	; ... in Open Files Table
		pop	si
		pop	es
dechain:
		call	free_xms
		mov	ax,es:next_offs[si]
		mov	bx,es:next_seg[si]
		pop	es
		
		cli
		mov	es:48h,ax
		mov	es:4ah,bx		
		sti
		jmp	quit_unlink
	
test_clk:	test	bl,8			;Is it clock device ?
		jz	quit_unlink		;No,jump
		mov	es:2eh,word ptr ZERO
		mov	es:30h,ax
		
quit_unlink:
		ret		
			
;...............................................................................
;  free_xms:
;	frees XMS memory allocated by device driver
;  Input:
;	ES:SI - Device Header
;...............................................................................
free_xms	proc 	near

		push	es
		push	bx
		push	si

		test	flags,1			;ICB found ?
		jz	free_xms_end		;No,jump

		mov	ax,es
		dec	ax
		mov	es,ax
		inc	ax

		cmp	byte ptr es:[si + 7],'X'
		jne	free_xms_end
		cmp	word ptr es:[si + 8],'SM'
		jne	free_xms_end
		mov	dx,es:[si + 0eh]   		;get xms handle to DX
		les	bx,dword ptr es:[si + 0ah]
		cmp	byte ptr es:[bx],0eah		;jmp xxxx:yyyy ?
		jne	free_handle
		cmp	es:[bx + 3],ax			;jump into driver's segment ?
		jne	free_handle
		cli
		mov	word ptr es:[bx],3ebh		;place jmp short there
		mov	word ptr es:[bx + 2],9090h
		mov	byte ptr es:[bx + 4],90h
		sti
free_handle:
		mov	ax,4300h
		int	2fh
		cmp	al,80h
		jne	free_xms_end
		mov	ax,4310h
		int	2fh
		mov	xms_offs,bx
		mov	xms_seg,es
		mov	ah,0ah
		call	dword ptr xms_offs
free_xms_end:
		pop	si
		pop	bx
		pop	es				
		ret

free_xms	endp			
	
;...............................................................................
;  seek_stdin:
;	seek Device Header of previous stdin device
;  OUTPUT:
;	AX:SI - points to Dev. Header of previous STDIN
;	Carry Flag set if not found
;...............................................................................
seek_stdin	proc	near

stdin_next:	les	si,dword ptr es:[si]	;Address of next dev. header
		mov	ax,es
		cmp	ax,-1
		jz	stdin_err_end
		mov	ax,es:dev_attr[si]
		test	al,1
		jz	stdin_next
		mov	ax,es
		clc
		ret

stdin_err_end:
		stc
		ret

seek_stdin	endp
;...............................................................................		
; seek_DIB:
;	seek DIBs pointing at our Device Header and remove them from the
;	chain of DIBS.
; INPUT:
;	AX:DX - address of our Device Header
; OUTPUT:
;	ES:BX - last DIB
;	Carry Flag set if proper DIB not found
;...............................................................................
seek_DIB	proc	near

		mov	es,dos_seg
		les	bx,es:FIRST_DIB			;Get address of first DIB
		mov	si,dos_dep3		
next_DIB:	
		cmp	word ptr es:[si + bx + 12h],dx
		jnz	if_last
		cmp	word ptr es:[si + bx + 14h],ax
		jz	seek_end		      
if_last:
		cmp	word ptr es:[si + bx + 18h],0ffffh	;The last DIB ?
		jz	seek_end2				;Yes,jump


		mov	DIB_offs,bx
		mov	DIB_seg,es
		les	bx,dword ptr es:[si + bx + 18h]		;Get addr. of next DIB
		jmp	next_DIB
		
seek_end:  
		mov	word ptr es:[si + bx + 14h],ZERO
		mov	al,byte ptr es:[bx]			;Get drive number
		mov	drv_num,al
		clc
		ret
seek_end2:		
		stc
		ret		
		
seek_DIB	endp
;...............................................................................;		
;  get_DA_addr:
;	compute address of Drive Area for drive AL
;  INPUT:
;	AL - drive number
;  OUTPUT:									;
;	ES:DI - address of Drive Area for drive AL				;
;...............................................................................;
get_DA_addr	proc	near

		push 	ax
		push	dx

		dec	al
		xor	ah,ah
		mov	dl,51h				;Set DA ...
		add	dl,dos_dep2			; ... size
		mul	dl				;Multiply by DA size
		mov	es,dos_seg
		les	di,dword ptr es:FIRST_DA	;Get addr. of first DA
		add	di,ax				;So now ES:DI points to new DA

		pop	dx
		pop	ax
		ret
		
get_DA_addr	endp

;...............................................................................
; seek_DA:
;	seek Drive Area for drv_num
; On input:
;	SI:DX - DIB address
;...............................................................................
seek_DA		proc	near

		mov	es,dos_seg
		mov	al,drv_num
		xor	ch,ch
		mov	ah,byte ptr es:TOTAL_NUM	;Get total number of drives
check_next_DA:
		inc	al
		cmp	al,ah
		ja	check_end
		call	get_DA_addr			;Get address of DA to ES:DI
		cmp	word ptr es:[di + 45h],dx	;DA not used ?
		jnz	check_next_DA			;Yes,jump
		cmp	word ptr es:[di + 47h],si	;DA
		jnz	check_next_DA

		inc	DA_flag
		mov	word ptr es:[di + 43h],ZERO	;mark DA as not used 
		push	ax
		add	al,40h
		mov	byte ptr es:[di],al
		pop	ax
		mov	byte ptr es:[di + 3],ZERO
		jmp	check_next_DA
		ret
		
check_end:	
		stc					;Signal error
		ret		
		
seek_DA		endp


code		ENDS
		END	start


