;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
; Only loads DOS programs!!!
; Command line for a spawned program overwrites command line of original
;   So if needed, better copy the original prior to spawning!!!
;
; Loader.asm
;
; Function: Load a task prior to execution
;   Handle Check DOS exe header
;   Handle Check Proprietary exe header
;   Handle Load program
;   Handle Allocate memory for program as it is loaded
;   Handle Allocate BSS space and zero it
;   Handle Allocate a page for command line and initializing it

	;MASM MODE
	.386p

include  segs.asi 
include  os.asi 
include  page.asi 
include  sys.mac 
include  tss.asi 
include  errors.asi 
include	 boot.mac 
include  boot.ase 
include  page.ase 
include  pageall.ase 
include  descript.ase 
include  pageall.asi 
include  loader.asi 
;
; Offsets into DOS exe file
;
EXEHEAD = 0
EXEPARS = 8
;
	PUBLIC	loader, init_load_file

seg386data	SEGMENT	
startofusermem dd 0
cmdlineofs dd	0
fileofs	dd	0
fileseg	dw	0
seg386data	ENDS	

seg386	SEGMENT	
;
; Init the load file address
;
init_load_file	PROC	
	mov	eax,gs			; User seg in ax
	push	ds			; Get system data seg
	push	DS386			;
	pop	ds			;
	mov	[fileseg],ax		; Save segment
	mov	[fileofs],ebx		; and offset
	mov	[cmdlineofs],esi	; and command line
	pop	ds
	ret
init_load_file	ENDP	
;
; Copy the command line to new process space
;
CopyCommandLine	PROC	
	mov	ebx,[cmdlineofs]
	or	ebx,ebx
	jz	short ccl_nocopy
	ZA	edi
	push	esi
	push	edi
	mov	esi,[fileofs]
	push	ds
	push	es
	push	ds
	pop	es
	mov	ds,[fileseg]
	sub	ecx,ecx
ccl_loop:
	cmp	BYTE PTR [esi],0
	jz	ccl_fnamedone
	cmp	BYTE PTR [esi],' '
	jz	ccl_fnamedone
	inc	ecx
	movsb
	jmp	ccl_loop
ccl_fnamedone:
	mov	BYTE PTR es:[edi],' '
	inc	edi
	mov	esi,ebx
ccl_loop2:
	movsb
	inc	ecx
	cmp	ecx,4095
	jnc	short ccl_fin
	cmp	BYTE PTR [esi-1],0
	jnz	short ccl_loop2
ccl_fin:
	mov	BYTE PTR es:[edi],0
	pop	es
	pop	ds
	pop	edi
	pop	esi
ccl_nocopy:
	ret
CopyCommandLine	ENDP	
;
; Routine to load data from a disk file
;
loader	PROC	
	ENTER	4,0
	mov	DWORD PTR [ebp-4],0
	or	ax,ax			; Copying from another task?
	jz	diskload
	mov	esi,edi			; Yes, esi gets dest page
	call	DescriptorAddress	; Get descriptor address
	call	GetDescriptorBase	; Load the task base address
	ZA	edi
	mov	edi,[edi + TSS.rrCR3]	; Get page dir
	ZA	edi
	mov	edi,[edi+4]		; Load 4MB entry up
	and	edi,NOT (PG_SIZE - 1)	; Clear extraneous bits
	ZA	edi			; Make linear
	add	edi,4*USER_PROGRAM_OFFSET
	push	edi			; Save source
	xchg	esi,edi			; xchg source & dest
	cld
copyloop:
	test	DWORD PTR [esi],PG_PRESENT ; Have we hit end?
	jz	donecopy		; Yes, quit

	movsd				; Move one entry
	jmp	copyloop		; Continue
donecopy:
	mov	edi,[edi-4]		; Get command line page
	and	edi,NOT (PG_SIZE - 1)
	call	CopyCommandLine		; Copy to it
	mov	eax,edi
	pop	edi			; Get source page
	mov	edi,[edi]		; Get first entry
	and	edi,NOT (PG_SIZE - 1)	; Clear extraneous bits
	ZA	edi			; Make linear
	sub	ecx,ecx			; Data seg offset = 0
	sub	eax,eax			; Code seg offset = 0
	mov	edx,[edi + HEADER.CODESTART]	; Get start address
	clc
	LEAVE
	ret
	
	
diskload:
	movzx	ebx,[dosdata]		; Get data seg where filename resides
	assume	ds:nothing,es:dgroup
	push	ds                      ;
	mov	ax,DS386                ; Get system data seg
	mov	ds,ax                   ;
	LDS	ebx,FWORD PTR [fileofs] ; Get file pointer

	mov	dl,FIA_READ             ; Open file for read access
	os	FI_OPEN                 ;
	pop	ds                      ;
	assume	ds:dgroup
	jc	openerr                 ; Branch if not found

	mov	ebx,eax			; Get handle
	push	ebx                     ;

	ALLOCEXT			; Allocating extended memory
	call    PageAlloc
	jc	nomemory
	push	eax			; Save physical
	ZA	eax			; Reference to this DS
	mov	[startofusermem],eax	; Save for later
	pop	ebx			; Restore physical
	mov	edx,eax			; This is where we read to in a bit
	sub	eax,eax			; First entry
	or	ebx,PG_USERMODE OR PG_WRITEABLE ; Make it writeable
	call	PageTableEnterAddress	; Enter the address
	add	edi,4			; Move to next entry
	mov	ecx,40h                 ;
	pop	ebx			; Get handle
	push	ebx
	os	FI_READ                 ;
	jc	readerr                 ; Error if not read

	mov	eax,[startofusermem]
	cmp	WORD PTR [eax + EXEHEAD],"ZM" ; Else make sure is EXE file header
	jne	checknoexe              ;

	movzx	ecx,WORD PTR [eax + EXEPARS]  ; Find out how many paragraphs to skip
	shl	ecx,4			;
	sub	ecx,40h			;
	jz	short readfile			; None, branch
	mov	edx,[startofusermem]	; Else read in that many bytes
	pop	ebx			;
	push	ebx			; Handle
	os	FI_READ			; Read the rest of the header
	jc	readerr			;
readfile:
	mov	edx,[startofusermem]	; Get first page
readlp:
	mov	ecx,PG_SIZE		; Read in a page
	pop	ebx			;
	push	ebx			; Handle in BX
	os	FI_READ			;
	jc	readerr			; Read fail

	add	DWORD PTR [ebp - 4],ecx	; Inc count read
	cmp	ecx,PG_SIZE		; See if read a whole page
	jc	short readall		; No, read it all
	ALLOCEXT			; Otherwise alloc next page
	call	PageAlloc		;
	jc	nomemory		; Quit if no memory
	mov	ebx,eax			; Else ebx = physical page
	sub	eax,eax			; eax = entry 0
	push	ebx			; Save page address
	or	ebx,PG_USERMODE OR PG_WRITEABLE	; Make writeable
	call	PageTableEnterAddress	; Enter the address
	add	edi,4			; Bump to next entry
	pop	edx			; Get address to read
	ZA	edx			; as an offset to DS
	jmp	readlp
readall:
	pop	ebx
	os	FI_CLOSE		; Close the file
	jc	closerr			;

	mov	esi,[startofusermem]
	cmp	[esi+ HEADER.IDENT],H_IDENT	; Verify signature
	jne	badformerr2		;

	bt	[esi + HEADER.FLAGS],HFLAG_INITBSS; See if has a BSS initted
	jc	short hasbss			; Yes, get out
       	test	[esi + HEADER.BSSSIZE],-1	; See if any BSS
	je	short nobss			; No, get out

needanother:
	mov	eax,[esi + HEADER.BSSSIZE]	; Get the image size
	add	eax,[esi + HEADER.BSSBASE]
	sub	eax,USER_PROGRAM_OFFSET * PG_SIZE

	cmp	eax,[ebp -4]			; See if allocated enough
	jbe	short zerobss			; Yes, just blank it out
	
	ALLOCEXT			; Otherwise alloc next page
	call	PageAlloc		;
	jc	nomemory		; Quit if no memory
	mov	ebx,eax			; Else ebx = physical page
	sub	eax,eax			; eax = entry 0
	push	ebx			; Save physical address
	or	ebx,PG_USERMODE OR PG_WRITEABLE	; Make writeable
	call	PageTableEnterAddress	; Enter the address
	add	edi,4			; Bump to next entry
	xchg	[esp],edi		; Get virtual address
	mov	ecx,PG_SIZE/4		; Zero it out
	sub	eax,eax
	ZA	edi
	rep	stosd
	pop	edi			; Restore page table offset
	add	WORD PTR [ebp-4],PG_SIZE
	jmp	needanother
; Zeroing out first page

zerobss:
	push	edi
	mov	edi,[esi + HEADER.BSSBASE]	; Get the bss offset
	mov	ecx,edi				; Get start of next page
	add	ecx,PG_SIZE-1			;
	and	ecx,NOT (PG_SIZE-1)			;
	sub	ecx,edi				
	sub	al,al
	add	edi,[startofusermem]	; Get the base
	rep	stosb
	pop	edi
nobss:
hasbss:
	ALLOCEXT
	call	PageAlloc
	jc	nomemory
	mov	ebx,eax
	sub	eax,eax
	push	edi
	push	ebx
	or	ebx,PG_USERMODE OR PG_WRITEABLE
	call	PageTableEnterAddress
	pop	edi
	call	CopyCommandLine
	pop	edi
	add	edi,[zero]
	and	edi,PG_SIZE - 1
	shl	edi,PG_SHIFTSIZE-2
	mov	[esi + HEADER.ARGS],edi
	mov	edx,[esi + HEADER.CODESTART]
	sub	eax,eax				; Code seg offset =0
	sub	ecx,ecx				; Data seg offset = 0
	LEAVE
	ret
nomemory:
	pop	edx
	pop	ebx
	stc
	mov	al,ERR_NOMEM
	LEAVE
	ret
checknoexe:
	cmp	[DWORD PTR eax + HEADER.IDENT],H_IDENT ; IF not Just our header
	jne	short badformerr	; we have a bad format
	sub	edx,edx			; 
	os	FI_POSITION		; Else reposition back at the start
	jmp	readfile		; And do a normal read

openerr:
	stc
	mov	al,ERR_FILENOTFOUND
	LEAVE
	ret
closerr:
	stc
	mov	al,ERR_CLOSE
	LEAVE
	ret
readerr:
	pop	ebx			; Clear Stack
	stc
	mov	al, ERR_READ
	LEAVE
	ret
badformerr:
	pop	ebx			; Clear stack
badformerr2:
	stc
	mov	al, ERR_BADFORMAT
	LEAVE
	ret
loader	ENDP	
seg386	ENDS	
END