PROGRAM Comm_TTY;                                                               {-This is the comment column }
                                                                                { which will be used to tell }
{         Comm_TTY.PAS Ver. 2.00 - Demo for Comm_TP4.PAS TPU Routines         } { what the program is doing  }
{                             (c) Copyright, 1989                             } { where its not self-evident }
{                              Kevin R. Bulgrien                              } {                            }
{                                October, 1989                                } { Yes, it is wider than 80   }
{                                                                             } { columns so you will need   }
{ See the accompanying file COMM_TP4.DOC for specific information regarding   } { to use compressed print to }
{ the distribution policies and usage information for this source code file.  } { print it out.              }
{                                                                             } {                            }
{ Written by:  Kevin R. Bulgrien           Version 1.00 completed 10/24/89    } { I hope you don't complain  }
{                                                                             } { too much, because I think  }
{ Contact at:  LeTourneau University       LeTourneau University BBS          } { the code documentation is  }
{              Microcomputer Services      2400/1200/300 Baud                 } { much easier to read when   }
{              P.O. Box 7001               (214) 237-2742                     } { it is not intermingled     }
{              Longview, TX  75607                                            } { with the code.             }
{                                                                             } {                            }
                                                                                { No code extends beyond the }
USES DOS, CRT, Comm_TP4;                                                        { 80th column, so it can be  }
                                                                                { deleted easily enough.     }
TYPE                                                                            {                            }
  ComSettingsRecord = RECORD                                                    {-A structure to hold port   }
                       Baud : BYTE;                                             { communications settings.   }
                       Parity : BYTE;                                           {                            }
                       Stop : BYTE;                                             {                            }
                       Bits : BYTE;                                             {                            }
                     END;                                                       {                            }
                                                                                {                            }
  ComSettingsType = ARRAY [1..2] OF ComSettingsRecord;                          {                            }
                                                                                {                            }
VAR                                                                             {                            }
  ComSettings : ComSettingsType;                                                {-Current port settings      }
  Select, PortNumber : BYTE;                                                    {-Port number currently set  }
  InkeyVar : CHAR;                                                              {                            }
                                                                                {                            }
{ A crude but effective procedure to allow the user to change settings of a serial port in use. PortNumber & }
{ ComSettings determine how the port is currently set up. As the parameters are changed, ComSettings is also }
{ updated.  Once again, keep in mind that the object of this program is not to provide a glamorous terminal  }
{ program.  Rather it serves as an example for those wanting to use serial routines in their own programs.   }
                                                                                {                            }
PROCEDURE SetupPort (Com : BYTE);                                               {                            }
VAR                                                                             {                            }
  ResetPort : BOOLEAN;                                                          {-TRUE when settings changed }
BEGIN                                                                           {                            }
  WRITELN;                                                                      {                            }
  ResetPort := FALSE;                                                           {                            }
  WRITELN ('COM', Com, ' Setup', #10);                                          {-Select a baud rate         }
  WRITELN ('0)  110           5)  2400');                                       {                            }
  WRITELN ('1)  150           6)  4800');                                       {-Note that defaults are     }
  WRITELN ('2)  300           7)  9600');                                       { allowed if you press <CR>  }
  WRITELN ('3)  600           8) 19200');                                       { at any of the prompts. The }
  WRITELN ('4) 1200           9) 38400', #10);                                  { port is not reset unless   }
  WRITE ('Select a baud rate [', ComSettings [Com] . Baud, ']: ');              { the defaults are changed.  }
  REPEAT                                                                        {                            }
    InkeyVar := READKEY;                                                        {                            }
  UNTIL (InkeyVar IN ['0'..'9', #13]);                                          {                            }
  WRITELN (InkeyVar, #10);                                                      {                            }
  IF (InkeyVar <> #13)                                                          {                            }
    THEN BEGIN                                                                  {                            }
           ComSettings [Com] . Baud := ORD (InkeyVar) - 48;                     {                            }
           ResetPort := TRUE;                                                   {                            }
         END;                                                                   {                            }
  WRITE ('Select number of data bits [', ComSettings [Com] . Bits, ']: ');      {-Select number of data bits }
  REPEAT                                                                        {                            }
    InkeyVar := READKEY;                                                        {                            }
  UNTIL (InkeyVar IN ['5'..'8', #13]);                                          {                            }
  WRITELN (InkeyVar, #10);                                                      {                            }
  IF (InkeyVar <> #13)                                                          {                            }
    THEN BEGIN                                                                  {                            }
           ComSettings [Com] . Bits := ORD(InkeyVar) - 48;                      {                            }
           ResetPort := TRUE;                                                   {                            }
         END;                                                                   {                            }
  WRITELN ('0) None           2) None');                                        {-Select a parity setting    }
  WRITELN ('1) Odd            3) Even', #10);                                   {                            }
  WRITE ('Select a parity type [', ComSettings [Com] . Parity, ']: ');          {                            }
  REPEAT                                                                        {                            }
    InkeyVar := READKEY;                                                        {                            }
  UNTIL (InkeyVar IN ['0'..'3', #13]);                                          {                            }
  WRITELN (InkeyVar, #10);                                                      {                            }
  IF (InkeyVar <> #13)                                                          {                            }
    THEN BEGIN                                                                  {                            }
           ComSettings [Com] . Parity := ORD(InkeyVar) - 48;                    {                            }
           ResetPort := TRUE;                                                   {                            }
         END;                                                                   {                            }
  WRITE ('Select number of stop bits [', ComSettings [Com] . Stop, ']: ');      {-Select number of stop bits }
  REPEAT                                                                        {                            }
    InkeyVar := READKEY;                                                        {                            }
  UNTIL (InkeyVar IN ['1'..'2', #13]);                                          {                            }
  WRITELN (InkeyVar, #10);                                                      {                            }
  IF (InkeyVar <> #13)                                                          {                            }
    THEN BEGIN                                                                  {                            }
           ComSettings [Com] . Stop := ORD(InkeyVar) - 48;                      {                            }
           ResetPort := TRUE;                                                   {                            }
         END;                                                                   {                            }
  IF ResetPort                                                                  {-If the settings changed,   }
    THEN SetupCOMPort (Com, ComSettings [Com] . Baud,                           { reset the port             }
                            ComSettings [Com] . Bits,                           {                            }
                            ComSettings [Com] . Parity,                         {                            }
                            ComSettings [Com] . Stop);                          {                            }
END;                                                                            {                            }
                                                                                {                            }
{ This provides a simple terminal emulation that might be used to prove that Comm_TP4 really works, and that }
{ it is not hard to use.  I got to playing, and perhaps it got a bit more complex than necessary... but then }
{ again, who said it had to be quick and dirty.  The LocalEcho parameter determines if characters typed on   }
{ the keyboard should be echoed to the screen.                                                               }
                                                                                {                            }
PROCEDURE TTY (LocalEcho : BOOLEAN);                                            {                            }
VAR                                                                             {                            }
  ExitTTY,                                                                      {-TRUE when ready to quit    }
  DataReady,                                                                    {-TRUE if buffer not empty   }
  ShowHelp : BOOLEAN;                                                           {-TRUE if need help screen   }
  OldCarrier : ARRAY [1..2] OF BOOLEAN;                                         {-Helps detect carrier change}
  Buffer : CHAR;                                                                {-A character buffer         }
  Loop : BYTE;                                                                  {                            }
BEGIN                                                                           {                            }
  FOR Loop := 1 TO MaxPorts DO                                                  {-Force Carrier status to be }
    OldCarrier [Loop] := NOT CD [Loop];                                         { displayed the first time   }
  DataReady := FALSE;                                                           {                            }
  ShowHelp := TRUE;                                                             {-Show help screen on start  }
  ExitTTY := FALSE;                                                             {                            }
  Buffer := #0;                                                                 {                            }
  CLRSCR;                                                                       {                            }
  REPEAT                                                                        {-Terminal emulation starts  }
    IF ShowHelp                                                                 {-Print the help screen if   }
      THEN                                                                      { it has been requested.     }
        BEGIN                                                                   {                            }
          WRITELN (#13, #10, 'Terminal emulator commands', #10);                {-Brief summary of command   }
          WRITELN ('<Alt C>  Switch Port to be used');                          { keys that can be used      }
          WRITELN ('<Alt E>  Toggle Local Echo On/Off');                        {                            }
          WRITELN ('<Alt H>  Help With Commands');                              {                            }
          WRITELN ('<Alt P>  Change Port Parameters');                          {                            }
          WRITELN ('<Alt X>  Exit');                                            {                            }
          ShowHelp := FALSE;                                                    {                            }
        END;                                                                    {                            }
    DisableInts;                                                                {                            }
    DataReady := (InTail [PortNumber] <> InHead [PortNumber]);                  {-If data has been received, }
    EnableInts;                                                                 { print one character        }
    IF DataReady                                                                {                            }
      THEN                                                                      {                            }
        BEGIN                                                                   { CHR(12) is interpreted as  }
          DisableInts;                                                          { a FormFeed, and so clears  }
          Buffer := CHR(InBuffer [PortNumber, InHead [PortNumber]]);            { the screen                 }
          InHead [PortNumber] := (InHead [PortNumber] + 1) MOD (MaxInSize + 1); {                            }
          EnableInts;                                                           { Input buffer is updated    }
          CASE Buffer OF                                                        {                            }
            #12 : CLRSCR;                                                       {                            }
            ELSE  WRITE (Buffer);                                               {                            }
          END;                                                                  {                            }
        END;                                                                    {                            }
    IF (OldCarrier [PortNumber] <> CD [PortNumber])                             {-If a change in carrier     }
      THEN                                                                      { detect occurs, notify the  }
        BEGIN                                                                   { user of the new status     }
          WRITELN;                                                              {                            }
          IF CD [PortNumber]                                                    {                            }
            THEN WRITELN ('CARRIER DETECTED (COM', PortNumber, ')')             {                            }
            ELSE WRITELN ('NO CARRIER (COM', PortNumber, ')');                  {                            }
          OldCarrier [PortNumber] := CD [PortNumber];                           {                            }
        END;                                                                    {-If a key has been pressed, }
    IF KEYPRESSED                                                               { process it                 }
      THEN                                                                      {                            }
        BEGIN                                                                   {                            }
          Buffer := READKEY;                                                    {                            }
          IF (Buffer = #00) AND KEYPRESSED                                      {-Extended key codes require }
            THEN                                                                { another read               }
              BEGIN                                                             {                            }
                Buffer := READKEY;                                              {                            }
                CASE Buffer OF                                                  {                            }
                  #46 : REPEAT                                                  {-<ALT C> lets you select a  }
                          PortNumber := (PortNumber + 1) MOD (MaxPorts + 1);    { different port if you have }
                          PortNumber := ORD (PortNumber = 0) + PortNumber;      { installed more that one.   }
                          WRITE (#13,#10, 'COM', COMNmbr [PortNumber]);         {                            }
                          IF NOT IntInstalled [PortNumber]                      { It notifies you of the new }
                            THEN                                                { COM number & any ports it  }
                              BEGIN                                             { saw were uninstalled.      }
                                WRITE (' not installed');                       {                            }
                              END;                                              {                            }
                          WRITELN;                                              {                            }
                        UNTIL (IntInstalled [PortNumber]);                      {                            }
                  #18 : LocalEcho := NOT LocalEcho;                             {-<ALT E> toggles Local Echo }
                  #35 : ShowHelp := TRUE;                                       {-<ALT H> shows help screen  }
                  #25 : SetupPort (PortNumber);                                 {-<ALT P> allows port setup  }
                  #45 : ExitTTY := TRUE;                                        {-<ALT X> exits the program  }
                  ELSE  IWriteCOM (PortNumber, CHR(27) + Buffer);               {-Other extended key codes   }
                END;                                                            { are sent to the port       }
              END                                                               {                            }
            ELSE                                                                {                            }
              BEGIN                                                             {-Normal key codes are sent  }
                 CASE Buffer OF                                                 { or translated and sent     }
                   #12 : BEGIN                                                  {                            }
                           IWriteCOM (PortNumber, Buffer);                      {-FormFeed clears screen if  }
                           IF LocalEcho THEN CLRSCR;                            { local echo is on           }
                         END;                                                   {                            }
                   #13 : BEGIN                                                  {-A carriage return also     }
                           IWriteCOM (PortNumber, Buffer); { + CHR(10)); }      { sends a line feed          }
                           IF LocalEcho THEN WRITELN;                           {                            }
                         END;                                                   {                            }
                   ELSE  BEGIN                                                  {-All other characters are   }
                           IWriteCOM (PortNumber, Buffer);                      { sent as typed              }
                           IF LocalEcho THEN WRITE (Buffer);                    {                            }
                         END;                                                   {                            }
                 END;                                                           {                            }
              END;                                                              {                            }
        END;                                                                    {                            }
  UNTIL ExitTTY;                                                                {-Continue emulation until   }
END;                                                                            { <ALT X> is pressed.        }
                                                                                {                            }
BEGIN                                                                           {                            }
  Select := 0;                                                                  {-Default no port selected.  }
  REPEAT                                                                        {                            }
    CLRSCR;                                                                     {                            }
    WRITELN ('COMM_TTY Terminal Emulator', #10);                                {                            }
    WRITELN ('The following ports are usable:', #10);                           {                            }
    FOR PortNumber := 1 TO MaxPorts DO                                          {-List all of the ports that }
      BEGIN                                                                     { the Comm_TP4 TPU is set up }
        WRITE ('Port #', PortNumber, ':  COM', COMNmbr [PortNumber], ', IRQ');  { to handle.                 }
        WRITE (IRQNmbr [PortNumber], ', 2400 baud, 8N1, ');                     {                            }
        IF NOT IntInstalled [PortNumber]                                        {-For simplicity, we will    }
          THEN WRITE ('Not ');                                                  { only allow the port to be  }
        WRITE ('Installed');                                                    { set up to specific baud    }
        IF Select = PortNumber                                                  { rates, bits, parity, and   }
          THEN WRITE (', Selected');                                            { stop bits after the TTY    }
        CLREOL;                                                                 { emulation is started.      }
        WRITELN;                                                                {                            }
        ComSettings [PortNumber] . Baud := ORD (B2400);                         { This is a very simple set- }
        ComSettings [PortNumber] . Bits := 8;                                   { up routine, but it does    }
        ComSettings [PortNumber] . Parity := ORD (None);                        { easily allow the user to   }
        ComSettings [PortNumber] . Stop := 1;                                   { tell the program how his   }
      END;                                                                      { machine is configured.  A  }
    WRITELN (#10, 'You may change the baud, bits, parity, and stop bits ');     { program should not lock in }
    WRITELN ('from within the terminal emulation.', #10);                       { what ports can be used.    }
    WRITELN ('A port must be installed & selected in order to begin.', #10);    {                            }
    WRITE ('<Esc>, B)egin, or (1-', MaxPorts, ') to ');                         {                            }
    WRITE ('(un)install or select port: ');                                     {                            }
    REPEAT                                                                      {                            }
      InkeyVar := READKEY;                                                      {                            }
    UNTIL (InkeyVar IN [#27, 'b', 'B', '1'..CHR(Maxports+48)]);                 {                            }
    WRITE (InkeyVar, ' ');                                                      {                            }
    IF InkeyVar IN ['1'..CHR(MaxPorts+48)]                                      {-Update port status         }
      THEN                                                                      {                            }
        BEGIN                                                                   {                            }
          PortNumber := ORD (InkeyVar) -48;                                     {                            }
          IF IntInstalled [PortNumber]                                          {-If the port has already    }
            THEN                                                                { been installed, we want to }
              BEGIN                                                             { select it, or uninstall it.}
                WRITE ('S)elect, U)ninstall? ');                                {                            }
                REPEAT                                                          {                            }
                  InkeyVar := READKEY;                                          {                            }
                UNTIL InkeyVar IN ['s', 'S', 'u', 'U'];                         {                            }
                WRITE (InkeyVar);                                               {                            }
                CASE InkeyVar OF                                                {                            }
                  's', 'S' : Select := PortNumber;                              {-Select the port            }
                  'u', 'U' : BEGIN                                              {-Uninstall the port by      }
                               Select := ORD (Select <> PortNumber) * Select;   { removing the interrupt     }
                               RemoveInt (PortNumber);                          { handler and deselecting it }
                             END;                                               { if it was selected.        }
                END;                                                            {                            }
              END                                                               {                            }
            ELSE                                                                {-If the port has not been   }
              BEGIN                                                             { installed yet, install it  }
                SetupCOMPort (PortNumber,                                       { by setting up the port     }
                              ComSettings [PortNumber] . Baud,                  { protocol and installing    }
                              ComSettings [PortNumber] . Bits,                  { the interrupt handler.     }
                              ComSettings [PortNumber] . Parity,                {                            }
                              ComSettings [PortNumber] . Stop);                 {                            }
                InstallInt (PortNumber);                                        {                            }
              END;                                                              {                            }
        END;                                                                    {                            }
  UNTIL (InkeyVar = #27) OR ((InkeyVar IN ['b', 'B']) AND (Select > 0));        {-Stay in setup loop until   }
  IF (InkeyVar <> #27)                                                          { <Esc> was hit or B)egin    }
    THEN                                                                        { was chosen and a port was  }
      BEGIN                                                                     { selected.                  }
        PortNumber := Select;                                                   {                            }
        TTY (FALSE);                                                            {-TTY with local echo off on }
      END;                                                                      { selected port now begins.  }
                                                                                {                            }
  { IMPORTANT:  RemoveIntOnExit is always called when the program terminates! } {-RemoveIntOnExit invoked by }
                                                                                { Turbo.  Don't quit without }
END.                                                                            { removing interrupts!       }
