{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Generic1.pas   [x] Protected mode

  Polymorphic elements. This is a demonstration of how tGenericElement
  allows you to place any data inside an element.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFELEM;


var Element1, Element2 : pGenericElement;
    Data : string;


begin
     { All of EFLIB's data structures uses polymorphic elements,
       that is, elements that descend from tElement. Hence, you
       always know how to control elements, independent on which
       ADT you are using. }

     Data := 'SOMETHING HERE';
     New ( Element1, Initialize (@Data, SizeOf(Data)) );
     New ( Element2, Duplicate (Element1) );

     { tGenericElement is a specialization of tElement that
       enables you to store *any* data inside an element. This
       is the default element for all data structures. However,
       you may want to replace tGenericElement with a even more
       specialized element - e.g. for integers, strings or objects. }

     { Display the two elements }
     Write ('"', String(Element1^.Data(0)^), '" should be equal to "');
     WriteLn (String(Element2^.Data(0)^), '"');

     Element1^.Free; Element2^.Free;
end.