{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Olist2.pas        [x] Protected mode

  Example of tOrderList - the ordered list. An ordered list
  maintains its element in sorted order. This program demonstrates
  the superior performance in "active sorting".

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFLIST, EFBASIC;


const NumberOfElements = 100;

var A, B : tOrderedList;
    Timer : tTimer;
    Index, Number : word;


{ Stores some elements to an arbitrary ADT instance. }
procedure Build (A : pList);
begin
     for Index := 1 to NumberOfElements do begin
         Number := Succ(Random(High(Number)));
         A^.Store (Number); { Add element }
     end;
end;

procedure TestCommonSorting;
begin
     with A do begin

          Initialize (SizeOf(Number));

          { Make sure that the structure is empty }
          Clear;

          Write ('  Common sorting (tList)        : ');

          Timer.Initialize;

          { Build structure without sorting it }
          Build (@A);

          { Sort structure with QuickSort algorithm
            (default algorithm). }
          Sort (AscendingOrder);

          WriteLn (Timer.ElapsedMS:0:0, ' [ms]');

          Timer.Intercept;
     end;
end;


procedure TestActiveSorting;
begin
     with B do begin

          Initialize (SizeOf(Number));

          { Make sure that the structure is empty }
          Clear;

          Write ('  Active sorting (tOrderedList) : ');

          Timer.Initialize;

          { Active sorting during insertion of new elements }
          Build (@B);

          WriteLn (Timer.ElapsedMS:0:0, ' [ms]');

          Timer.Intercept;
     end;
end;


begin

     { EFLIB supplies two ways of sorting doubly linked lists:

        1) common sorting algorithms after the list is built:
           available in all lists.
        2) active sorting where each new element is placed in
           sorted order: supplied by the tOrderedList descendant.

       The common sorting can be performed with various sorting algorithms,
       you can even write your own sorting algorithms by inheriting from
       tSortPlug and using the method AssignSortPlug that is available
       for all (linear) ADT's.

       Active sorting is a bit different. You then must create an
       ordered list (tOrderedList) instead of a tList. This list
       automatically sorts elements when they are inserted. The
       performance is better than insertion sort (or equal to).

       There are two ways of sorting tOrderedList: (i) binary
       search or (ii) linear search. When you insert an element
       into a tOrderedList using (i), tOrderedList searchs for
       the insertion point using a fast binary search. This is
       the default method. (ii) works the same way, but uses
       a linear search. (ii) could be faster if your elements
       are (almost) in sorted order. }

       RandSeed := 0; { Control random seed }

       WriteLn ('* tOrderedList vs. tList - sorting performance comparison *');

       TestCommonSorting;
       TestActiveSorting;

end.