{*******************************************************************************
*   Unit name: MCMENU10 interface
*      Author: Martin CEKAL
*        Date: February 2, 1993
*     Version: 1.1
*     Purpose: put, delete and handle with windows(menu) and status line
********************************************************************************}
Unit MCMENU10;

interface

uses dos;

type
  { type Win - window(menu) definition }
  pnt = record                    { other windows's parametres }
    xr,yb:integer;                { right-down corner }
    pos:1..16;                    { actual position in list }
    p,q:array[1..16] of byte;     { scan codes of hot keys }
    p_menu:pointer;               { pointer to saved screen }
    xms_ok:boolean;               { screen succesfully in XMS }
    handle:word;                  { handle for XMS }
  end;

  Point  = ^pnt;                   { pointer to other window's parametres }
  PtrWin = ^Win;                   { pointer to window }
  aWin = array[1..12] of PtrWin;   {array of Win}

  { array of lines (items) }
  it = record
     case u:boolean of                   { used/unused item }
       true:(text:string[50];            { text of item (left justified) }
             enable:boolean;             { enable/disable item }
       case k:1..5 of                    { type of item }
         2:(yes:boolean);                { switch Yes/No }
         3:(n,i:byte;                    { n:number of items; i:position in list }
           a:array[1..8] of string[5]);  { swith among "a" items }
         4:(v,min,max:real;              { edit of number "v"; min,max:range }
           lv,d:shortint);               { lv:lenght; d:decimals }
         5:(s:string[50];ls:shortint));  { edit of string "s"; ls:lenght }
  end; 

  { main body of Win }
  Win = record
    x,y:integer;            { left up corner of window }
    ni:1..16;               { number of lines (items) }
    vert:boolean;           { orientation =true:vertical }
    titl:string[50];        { title of window }
    hlp:PtrWin;             { pointer to help window }
    pt:Point;               { pointer to other parametres of window }
    its:array[1..16] of it; { array of lines (items) }
  end;

  fWin = file of Win;              {file of Win}

  xms = record                {XMS info structure}
    xms_ok,in_conv:boolean;   {xms_ok: XMS succesfully used;
                              in_conv: flag if the win is in conventional memory}
    handle:word;              {unique handler}
    pw:ptrwin;                {pointer to window}
  end;
  pxms=^xms;                  {pointer to XMS info structure}

  { full name of file }
  fname = record
    s:string[50]; {define name of file}
    p:pathstr;    {path}
    d:dirstr;     {directory}
    n:namestr;    {name}
    e:extstr;     {.extension}
    chg:boolean;  {change name(s) }
    io:boolean;   {I/O O.K.}
  end;

  { array of items }
  stl = record
     case u:boolean of                 { used/unused item }
       true:(ltext,rtext:string[10];   { text of item (ltext-hotkey) }
             code:word;                { code of key(s) }
             enable:boolean);          { enable/disable item }
  end;

  { main body of StatLine }
  StLine = record
    ni:1..5;                 { number of lines (items) }
    pt:pointer;              { pointer to other saved screen }
    its:array[1..5] of stl;  { array of items }
  end;

var
  init_mouse:byte;

{*******************************************************************************
*        Name: RegWin
*  Parametres: MyWin:Win
*              PWin:PtrWin      pointer to window
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Load variable MyWin:Win to the heap
********************************************************************************}
procedure RegWin(MyWin:Win; var PWin:PtrWin);

{*******************************************************************************
*        Name: UnregWin
*  Parametres: PWin:PtrWin      pointer to window
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Free the heap
********************************************************************************}
procedure UnregWin(PWin:PtrWin);

{*******************************************************************************
*        Name: RegWinXMS
*  Parametres: MyWin:Win
*              px:pxms      pointer to XMS info structure
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Load variable MyWin:Win to the XMS heap
********************************************************************************}
procedure RegWinXMS(MyWin:Win;var px:pxms);

{*******************************************************************************
*        Name: UnregWinXMS
*  Parametres: px:pxms      pointer to XMS info structure
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Free the XMS heap
********************************************************************************}
procedure UnRegWinXMS(px:pxms);

{*******************************************************************************
*        Name: UseWinXMS
*  Parametres: px:pxms      pointer to XMS info structure
*              pwn:PtrWin   pointer to window
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Prepares win for usage (moves it from and to XMS)
********************************************************************************}
procedure UseWinXMS(var px:pxms; var pwn:ptrwin);

{*******************************************************************************
*        Name: NewPalete
*  Parametres: desktop,bground,frame,text,dtext,hotkey:byte
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set new colors and redraw backgound
********************************************************************************}
procedure NewPalete(desktop,bground,frame,text,dtext,hotkey:byte);

{*******************************************************************************
*        Name: PutWin
*  Parametres: MyWin:Win   definition of window(menu)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert window(menu) to desktop
********************************************************************************}
procedure PutWin(var MyWin:Win);

{*******************************************************************************
*        Name: DelWin
*  Parametres: MyWin:Win   definition of window(menu)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Remove window(menu) from desktop
********************************************************************************}
procedure DelWin(MyWin:Win);

{*******************************************************************************
*        Name: HandleWin
*  Parametres: MyWin:Win   definition of window(menu)
*              Code:byte   position in menu (Esc=0)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Handle with window(menu)
********************************************************************************}
procedure HandleWin(var MyWin:Win;var code:byte);

{*******************************************************************************
*        Name: SaveWin
*  Parametres: fn:fname    name of file
*              n:integer   number of records Win
*              fdat:aWin   array of Win
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Save definitions of window(menu) to file
********************************************************************************}
procedure SaveWin(var fn:fname;n:integer;var fdat:aWin);

{*******************************************************************************
*        Name: LoadWin
*  Parametres: fn:fname    name of file
*              n:integer   number of records Win
*              fdat:aWin   array of Win
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Load definitions of window(menu) to array fdat
********************************************************************************}
procedure LoadWin(var fn:fname;n:integer;var fdat:aWin);

{*******************************************************************************
*        Name: HandlelStLine
*  Parametres: MyStLine:StLine   definition of status line
*              code:word;        code of key;
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Handle with status line
********************************************************************************}
procedure HandleStLine(MyStLine:StLine;var code:word);

{*******************************************************************************
*        Name: DelStLine
*  Parametres: MyStLine:StLine   definition of status line
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Delete status line from desktop
********************************************************************************}
procedure DelStLine(MyStLine:StLine);

{*******************************************************************************
*        Name: PutStLine
*  Parametres: MyStLine:StLine   definition of status line
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert status line to desktop
********************************************************************************}
procedure PutStLine(var MyStLine:StLine);

{*******************************************************************************
*        Name: HandleAll
*  Parametres: MyWin:Win       definition of window(menu)
*              Code:byte       position in menu (Esc=0)
*              MyStLine:StLine definition of sttus line
*              Codest:word     status line code
*        Date: December 20, 1992
*     Version: 1.0
*     Purpose: Handle with all (window+status line)
********************************************************************************}
procedure HandleAll(var MyWin:Win;var code:byte;
                    var MyStLine:StLine;var codest:word);

{*******************************************************************************
*        Name: PrtScreen
*  Parametres: MinX,MaxX,MinY,MaxY:integer  upper left and lower right
*                                           corner of printed window
*              lq:boolean quality of print lq=true  - letter quiality
*                                          lq=false - draft
*        Date: January 10, 1993
*     Version: 1.0
*     Purpose: Print part of screen in graphic mode
********************************************************************************}
procedure  PrtScreen(MinX,MaxX,MinY,MaxY:integer;lq:boolean);

{*******************************************************************************
*   Unit name: MCMENU10 implementation
*      Author: Martin CEKAL
*        Date: February 2, 1993
*     Version: 1.1
*     Purpose: put, delete and handle with windows(menu) and status line
********************************************************************************}
implementation

uses crt,printer,graph,mcmice10,mcxms10;

type
  { color palette }
  palete = record
    desktop,bground,frame,    { colors of desktop, back ground, frame, }
    text,dtext,hotkey:byte;   { text, disabled text and hotkeys }
  end;

  {information about files in directory}
  afile = record
    ni:byte;                          {number of files in directory}
    first:byte;                       {first file to fill}
    fil:array[1..100] of string[30];  {array of files in directory}
  end;

const
  y = true;
  n = false;
  fh = 16;     htitl = 30;
  hofs = 20;   vofs = 10;
  { dafault paltte for monochrome monitor }
  pal_mono:palete=(desktop:1;bground:10;frame:1;text:1;dtext:3;hotkey:15);
  { dafault paltte for color monitor }
  pal_co:palete=(desktop:1;bground:7;frame:0;text:0;dtext:8;hotkey:4);

  {error message-out of range}
  Out:win=(x:200;y:100;ni:3;vert:y;titl:'ERROR';hlp:nil;pt:nil;
     its:((u:y;text:'Out of valid range   ';enable:y;k:1),
          (u:y;text:'Valid range is: ';enable:y;k:1),
          (u:y;text:'';enable:y;k:1),
          (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),
          (u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));

  {load file}
  LoadSet:win=(x:50;y:50;ni:3;vert:y;titl:'';hlp:nil;pt:nil;
         its:((u:y;text:'~Change path';enable:y;k:1),
              (u:y;text:'~Previous';enable:y;k:1),
              (u:y;text:'~Next';enable:y;k:1),
              (u:y;text:'N~ew file';enable:y;k:1),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));

  {change directory or extension}
  ChgDir:win=(x:200;y:105;ni:2;vert:y;titl:'';hlp:nil;pt:nil;
        its:((u:y;text:'~Directory';enable:y;k:5;s:'';ls:30),
             (u:y;text:'~Extension';enable:y;k:5;s:'';ls:4),
             (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),
             (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));

  {help for I/O operations}
  HLoadSet:win=(x:100;y:70;ni:7;vert:y;titl:'Help';hlp:nil;pt:nil;
         its:((u:y;text:'This menu supports I/O operations';enable:y;k:1),
              (u:y;text:'';enable:y;k:1),
              (u:y;text:'"Change path" enable to change path and extension';enable:y;k:1),
              (u:y;text:'"Previos" moves in the list of files back';enable:y;k:1),
              (u:y;text:'"Next" moves in the list of files forward';enable:y;k:1),
              (u:y;text:'"New" enable to enter new name of output file';enable:y;k:1),
              (u:y;text:'Press Enter on file to/from you want read/write';enable:y;k:1),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));


  {information about I/O operation}
  scioe:win=(x:300;y:70;ni:1;vert:y;titl:'';hlp:nil;pt:nil;
         its:((u:y;text:'';enable:y;k:1),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));

  {input of new filename}
  NewFile:win=(x:200;y:105;ni:1;vert:y;titl:'';hlp:nil;pt:nil;
         its:((u:y;text:'New file';enable:y;k:5;s:'';ls:12),
             (u:y;text:'~Extension';enable:y;k:5;s:'';ls:4),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n),
              (u:n),(u:n),(u:n),(u:n),(u:n),(u:n),(u:n)));

var
  pal:palete;

{*******************************************************************************
*        Name: MyOrd:longint
*  Parametres: MyStr:string
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: returns lenght of showed string (without ~ )
********************************************************************************}
function MyOrd(MyStr:string):longint;
var i,j:integer;
begin
  j:=0;
  for i:=1 to ord(MyStr[0]) do begin
    if MyStr[i] <> '~' then inc(j);
  end;
  MyOrd:=j;
end;

{*******************************************************************************
*        Name: RegWin
*  Parametres: MyWin:Win
*              PWin:PtrWin      pointer to window
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Load variable MyWin:Win to the heap
********************************************************************************}
procedure RegWin(MyWin:Win; var PWin:PtrWin);
begin
  new(PWin);
  PWin^:=MyWin;
end; {*** end RegWin ***}

{*******************************************************************************
*        Name: UnregWin
*  Parametres: PWin:PtrWin      pointer to window
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Free the heap
********************************************************************************}
procedure UnregWin(PWin:PtrWin);
begin
  dispose(PWin);
end; {*** end UnregWin ***}

{*******************************************************************************
*        Name: RegWinXMS
*  Parametres: MyWin:Win
*              px:pxms      pointer to XMS info structure
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Load variable MyWin:Win to the XMS heap
********************************************************************************}
procedure RegWinXMS(MyWin:Win;var px:pxms);
var p:pointer;
begin
  new(px);
  with px^ do begin
    getxms(handle,sizeof(MyWin),xms_ok);
    if xms_ok then begin
      awakepointer(handle,p,xmswritemode);
      move(MyWin,p^,sizeof(MyWin));
      sleeppointer(handle);
    end
    else RegWin(MyWin,pw);
    in_conv:=false;
  end;
end; {*** end RegWinXMS ***}

{*******************************************************************************
*        Name: UnregWinXMS
*  Parametres: px:pxms      pointer to XMS info structure
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Free the XMS heap
********************************************************************************}
procedure UnRegWinXMS(px:pxms);
begin
  if px^.xms_ok then freexms(px^.handle);
end; {*** end UnRegWinXMS ***}

{*******************************************************************************
*        Name: UseWinXMS
*  Parametres: px:pxms      pointer to XMS info structure
*              pwn:PtrWin   pointer to window
*        Date: February 2, 1993
*     Version: 1.0
*     Purpose: Prepares win for usage (moves it from and to XMS)
********************************************************************************}
procedure UseWinXMS(var px:pxms; var pwn:ptrwin);
var p:pointer;
begin
  if px=nil then exit;
  with px^ do begin
    if xms_ok then begin
      awakepointer(handle,p,xmsreadwritemode);
      if in_conv then  move(pw^,p^,sizeof(pw^))
      else move(p^,pw^,sizeof(pw^));
      in_conv:=not in_conv;
      sleeppointer(handle);
    end;
    pwn:=pw;
  end;
end; {*** end UseWinXMS ***}

{*******************************************************************************
*        Name: NewPalete
*  Parametres: desktop,bground,frame,text,dtext,hotkey:byte
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Set new colors and redraw backgound
********************************************************************************}
procedure NewPalete(desktop,bground,frame,text,dtext,hotkey:byte);
begin
  pal.desktop:=desktop;
  pal.bground:=bground;
  pal.frame:=frame;
  pal.text:=text;
  pal.dtext:=dtext;
  pal.hotkey:=hotkey;
  setbkcolor(desktop);
end; {*** end NewPalete ***}

{*******************************************************************************
*        Name: DelWin
*  Parametres: MyWin:Win   definition of window(menu)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Remove window(menu) from desktop
********************************************************************************}
procedure Delwin(MyWin:Win);
begin
  with MyWin do begin
    setviewport(0,0,getmaxx,getmaxy,clipon);
    if pt^.xms_ok then awakepointer(pt^.handle,pt^.p_menu,xmsreadmode);
    putimage(x,y,pt^.p_menu^,0);
    if pt^.xms_ok then begin
      sleeppointer(pt^.handle);
      freeXMS(pt^.handle);
    end
    else freemem(pt^.p_menu,imagesize(x,y,pt^.xr,pt^.yb));
  end;
end; {*** end DelWin ***}

{*******************************************************************************
*        Name: MyReadKey:word
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Returns scan code, for extended codes returns code+1000
********************************************************************************}
function MyReadKey:word;
var c:word;
begin
  c:=ord(readkey);
  if c=0 then c:=ord(readkey)+1000;
  MyReadKey:=c;
end;

{*******************************************************************************
*        Name: InsText
*  Parametres: MyWin:Win    definition of window(menu)
*              inv:boolean  true-inverse colors; false-default colors
*              all:boolean  true-whole line; false-right side of line
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert menu items
********************************************************************************}
procedure InsText(MyWin:Win;inv,all:boolean);
var
  cb,ct,cdt,ch:word;
  xp,yp,i:integer;
  vals:string;
begin
  if inv then begin
    cb:=pal.text;          ct:=pal.bground;
    cdt:=pal.bground;      ch:=pal.bground;
   end
   else begin
     cb:=pal.bground;      ct:=pal.text;
     cdt:=pal.dtext;       ch:=pal.hotkey;
   end;
   with MyWin do begin
    if vert then begin
      xp:=x+hofs;
      yp:=y+fh*pt^.pos+vofs;
    end
    else begin
      xp:=hofs;
      for i:=1 to (pt^.pos-1) do xp:=xp+MyOrd(its[i].text)*8+hofs;
      yp:=y+fh+vofs;
    end;
    if titl <> '' then yp:=yp+htitl;
    if all then begin
      settextjustify(0,0);
      setcolor(cdt);
      if its[pt^.pos].enable then setcolor(ct);
      for i:=1 to ord(its[pt^.pos].text[0]) do begin
        if its[pt^.pos].text[i] <> '~' then begin
          outtextxy(xp,yp,its[pt^.pos].text[i]);
          xp:=xp+8;
        end
        else begin
          if its[pt^.pos].enable then setcolor(ch);
          inc(i);
          if i <= ord(its[pt^.pos].text[0]) then outtextxy(xp,yp,its[pt^.pos].text[i]);
          xp:=xp+8;
          if its[pt^.pos].enable then begin
            setcolor(ct);
            pt^.p[pt^.pos]:=ord(its[pt^.pos].text[i]);
            pt^.q[pt^.pos]:=pt^.p[pt^.pos];
            if (pt^.p[pt^.pos] >= 65) and (pt^.p[pt^.pos] <= 90) then pt^.q[pt^.pos]:=pt^.p[pt^.pos]+32;
            if (pt^.p[pt^.pos] >= 97) and (pt^.p[pt^.pos] <= 122) then pt^.q[pt^.pos]:=pt^.p[pt^.pos]-32;
          end;
        end;
      end;
    end;
    if its[pt^.pos].enable then setcolor(ct)
    else setcolor(cdt);
    if vert then begin
      settextjustify(2,0);
      xp:=pt^.xr-hofs;
      case its[pt^.pos].k of
        2: if its[pt^.pos].yes then outtextxy(xp,yp,'Yes')
           else outtextxy(xp,yp,'No');
        3: outtextxy(xp,yp,its[pt^.pos].a[its[pt^.pos].i]);
        4: begin
             str(its[pt^.pos].v:0:its[pt^.pos].d,vals);
             outtextxy(xp,yp,vals);
           end;
        5: outtextxy(xp,yp,its[pt^.pos].s);
      end;
    end;
  end;
end; {*** end InsText ***}

{*******************************************************************************
*        Name: HandleBar
*  Parametres: MyWin:Win    definition of window(menu)
*              put:boolean  true-insert bar; false-remove bar
*              all:boolean  true-whole bar; false-right part of bar (edit)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert and remove bar
********************************************************************************}
procedure HandleBar(MyWin:Win; put,all:boolean);
const
  hofs1=2;
var
  xl,yt,xr,yb,i:integer;
begin
  with MyWin do begin
    if put then begin
      setfillstyle(1,pal.text);
      setcolor(pal.bground);
    end
    else begin
      setfillstyle(1,pal.bground);
      setcolor(pal.text);
    end;
    if vert then begin
      xr:=pt^.xr-hofs+hofs1;
      yt:=y+fh*pt^.pos-2;
      if all then begin
        xr:=pt^.xr-hofs+hofs1;
        xl:=x+hofs-hofs1;
      end
      else begin
        if its[pt^.pos].k = 4 then xl:=its[pt^.pos].lv*8;
        if its[pt^.pos].k = 5 then xl:=its[pt^.pos].ls*8;
        xr:=pt^.xr-hofs+8;
        xl:=xr-xl-8;
      end;
    end
    else begin
      xr:= x+2;
      for i:=1 to pt^.pos do xr:=xr+MyOrd(its[i].text)*8+hofs;
      xl:=xr-4-MyOrd(its[pt^.pos].text)*8;
      yt:=y+fh-2;
     end;
    if titl <> '' then yt:=yt+htitl;
    bar(xl,yt,xr,yt+14);
    InsText(MyWin,put,all);
  end;
end; {*** end HandleBar ***}

{*******************************************************************************
*        Name: Edit         (includes others functions and procedures)
*  Parametres: MyWin:Win    definition of window(menu)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Edit of values and strings
********************************************************************************}
procedure Edit(var MyWin:Win);

{*******************************************************************************
*        Name: CrsrPut
*  Parametres: pcx,pcy:integer     position of cursor
*              is:boolean          =true insert mode
*              put:boolean         =true insert cursor
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Inserts and deletes cursor
********************************************************************************}
procedure CrsrPut(pcx,pcy,cpos:integer;vals:string;is,put:boolean);
begin
  pcx:=pcx-(cpos-1)*8;
  if put then setcolor(pal.bground)
  else setcolor(pal.text);
  if is then begin
    outtextxy(pcx,pcy+1,'_');
    outtextxy(pcx,pcy+2,'_');
  end
  else begin
    if put then setfillstyle(1,pal.bground)
    else setfillstyle(1,pal.text);
    bar(pcx-9,pcy-10,pcx-1,pcy);
    if put then setcolor(pal.text)
    else setcolor(pal.bground);
    if cpos <> 0 then outtextxy(pcx,pcy,vals[ord(vals[0])-cpos+1]);
  end;
end; {*** end CrsrPut ****}

{*******************************************************************************
*        Name: CrsrMove
*  Parametres: pcx,pcy:integer     position of cursor
*              is:boolean          =true insert mode
*              right:boolean       =true move to right
*              lv:integer          lenght of string
*              j:integer           position of cursor in the string
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Moves cursor right and left
********************************************************************************}
procedure CrsrMove(pcx,pcy,lv:integer;var cpos:integer;vals:string;is,right:boolean);
begin
  CrsrPut(pcx,pcy,cpos,vals,is,false);
  if right then begin
    dec(cpos);
    if cpos=-1 then cpos:=0;
  end
  else begin
    inc(cpos);
    if cpos > lv then dec(cpos);
  end;
  CrsrPut(pcx,pcy,cpos,vals,is,true);
end; {*** end CrsrMove ***}

{*******************************************************************************
*        Name: tovalue:real
*  Parametres: MyWin:Win           definition of window(menu)
*              vals:string         string to changing
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Changes string to real value
********************************************************************************}
function tovalue(MyWin:Win;vals:string):real;
var
  vv:real;
  cd:integer;
  OutRange:Win;
  outst,st:string;

begin
  OutRange:=Out;
  with MyWin.its[MyWin.pt^.pos] do begin
    if k<>4 then exit;
    val(vals,vv,cd);
    if cd=0 then begin
      if (vv >=  min) and (vv <= max) then tovalue:=vv
      else begin
        tovalue:=v;
        str(min:0:d,outst);
        str(max:0:d,st);
        outst:=outst+' - '+st;
        Outrange.its[3].text:=outst;
        putwin(outrange);
        repeat until keypressed;
        cd:=myreadkey;
        delwin(outrange);
      end;
    end;
  end;
end; {*** end tovalue ***}

{*******************************************************************************
*        Name: towin
*  Parametres: xp,yp               position of text
*              ovals:string        old string for delete
*              vals:string         new string for output
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Deletes old and puts new text to window(menu)
********************************************************************************}
procedure towin(xp,yp:integer;var ovals,vals:string);
var
  vv:real;
  cd:integer;
  vals1:string;

begin
  settextjustify(2,0);
  setcolor(pal.text);
  outtextxy(xp,yp,ovals);
  setcolor(pal.bground);
  with MyWin.its[MyWin.pt^.pos] do begin
    if k=4 then begin
      val(vals,vv,cd);
      if cd=0 then str(vv:lv:d,vals1);
      if (vals='') or (vals='-') then cd:=0;
      if (ord(vals1[0]) > lv) or (ord(vals[0]) > lv)  then vals:=ovals;
      if cd <> 0 then vals:=ovals;
    end
    else if ord(vals[0]) > ls then vals:=ovals;
  end;
  outtextxy(xp,yp,vals);
end; {*** end towin ***}

{*** begin Edit ***}
var
key:word;
ovals,vals:string;
yp,xp,xpc,cpos,ii:integer;
ex,iins:boolean;
label 1;

begin
  cpos:=0;
  iins:=true;
  with MyWin do begin
    yp:=y+fh*pt^.pos+vofs;
    if titl <> '' then yp:=yp+htitl;
    xp:=pt^.xr-hofs;
  end;
  HandleBar(MyWin,false,true);
  HandleBar(MyWin,true,false);
  with MyWin.its[MyWin.pt^.pos] do begin
    if k=4 then str(v:0:d,ovals)
    else ovals:=s;
  end;
1:repeat until keypressed;
  key:=MyReadKey;
  case key of
    1059:begin
      if MyWin.hlp <> nil then begin
        PutWin(MyWin.hlp^);
        repeat until keypressed;
        key:=MyReadKey;
        DelWin(MyWin.hlp^);
      end;
      goto 1;
    end;
    13,27: begin
      HandleBar(MyWin,false,false);
      exit;
    end;
    1082:begin
      iins:=not iins;
      CrsrPut(xp,yp,cpos,ovals,iins,true);
      vals:=ovals;
    end;
    1077,1075:begin
      CrsrPut(xp,yp,cpos,ovals,iins,true);
      vals:=ovals;
    end;
    else begin
      with MyWin.its[MyWin.pt^.pos] do begin
        if key < 1000 then vals:=chr(key);
        towin(xp,yp,ovals,vals);
        CrsrPut(xp,yp,cpos,vals,iins,true);
      end;
    end;
  end;
  ex:=false;
  repeat
    repeat until keypressed;
    key:=MyReadKey;
    with MyWin.its[MyWin.pt^.pos] do begin
      case key of
        1059:begin
          if MyWin.hlp <> nil then begin
            PutWin(MyWin.hlp^);
            repeat until keypressed;
            key:=MyReadKey;
            DelWin(MyWin.hlp^);
          end;
        end;
        13: begin
          if k=4 then v:=tovalue(MyWin,vals)
          else s:=vals;
          ex:=true;
        end;
        27:ex:=true;
        8:begin
          ovals:=vals;
          if ord(vals[0]) > 0 then begin
            for ii:=ord(vals[0])-cpos to ord(vals[0])-1 do
              vals[ii]:=vals[ii+1];
            vals[0]:=chr(ord(vals[0])-1);
            towin(xp,yp,ovals,vals);
          end;
        end;
        1083:begin
          ovals:=vals;
          if (ord(vals[0]) > 0) and (cpos > 0) then begin
            for ii:=ord(vals[0])-cpos+1 to ord(vals[0])-1 do
              vals[ii]:=vals[ii+1];
            vals[0]:=chr(ord(vals[0])-1);
            towin(xp,yp,ovals,vals);
            if ovals <> vals then CrsrMove(xp,yp,ord(vals[0]),cpos,vals,iins,true);
          end;
        end;
        1082:begin
          CrsrPut(xp,yp,cpos,vals,iins,false);
          iins:=not iins;
          CrsrPut(xp,yp,cpos,vals,iins,true);
        end;
        1075:CrsrMove(xp,yp,ord(vals[0]),cpos,vals,iins,false);
        1077:CrsrMove(xp,yp,ord(vals[0]),cpos,vals,iins,true);
        else begin
          if key<1000 then begin
            ovals:=vals;
            if cpos=0 then vals:=ovals+chr(key)
            else if (ord(ovals[0])-cpos)=0 then begin
              if iins then vals:=chr(key)+ovals
              else vals[1]:=chr(key);
            end
            else begin
              if iins then begin
                vals:='';
                for ii:=1 to  ord(ovals[0]) do begin
                  if ii=(ord(ovals[0])-cpos) then vals:=vals+ovals[ii]+chr(key)
                  else vals:=vals+ovals[ii];
                end;
              end
              else vals[ord(vals[0])-cpos+1]:=chr(key);
            end;
            towin(xp,yp,ovals,vals);
            if (not iins) and (ovals <> vals) then
               CrsrMove(xp,yp,ord(vals[0]),cpos,vals,iins,true)
            else CrsrPut(xp,yp,cpos,ovals,iins,true);
          end;
        end;
      end;
    end;
  until ex;
  HandleBar(MyWin,false,false);
end; {*** end Edit ***}

{*******************************************************************************
*        Name: HandleMenu
*  Parametres: MyWin:Win   definition of window(menu)
*              Code:byte   position in menu (Esc=0)
*              event:byte  number of event
*              key:word    value of pressed key
*        Date: December 20, 1992
*     Version: 1.0
*     Purpose: Handle with menu
********************************************************************************}
procedure HandleMenu(var MyWin:Win; var code:byte;event:byte;key:word);
var
  go:boolean;
  j:integer;

begin
  go:=false;
  with MyWin do begin
    case event of
      1,2,8:begin
        if event=1 then begin
          for j:=1 to ni do begin
            if (key=pt^.p[j]) or (key=pt^.q[j]) then begin
              HandleBar(MyWin,false,true);
              pt^.pos:=j;
              HandleBar(MyWin,true,true);
              j:=ni;
              go:=true;
            end;
          end;
        end;
        if ((event=8) or (event=2)) and (its[pt^.pos].enable) then go:=true;
        if go then begin
          case its[pt^.pos].k of
            1:begin
              code:=pt^.pos;
              HandleBar(MyWin,false,true);
            end;
            2:begin
              its[pt^.pos].yes:=not its[pt^.pos].yes;
              HandleBar(MyWin,true,true);
            end;
            3:begin
              inc(its[pt^.pos].i);
              if its[pt^.pos].i > its[pt^.pos].n then its[pt^.pos].i:=1;
              HandleBar(MyWin,true,true);
            end;
            4,5:Edit(MyWin);
          end;
        end;
      end;
      4:begin
        if vert then begin
          HandleBar(MyWin,false,true);
          inc(pt^.pos);
          if its[pt^.pos].text='-' then inc(pt^.pos);
          if pt^.pos > ni then pt^.pos:=1;
          HandleBar(MyWin,true,true);
        end;
      end;
      5:begin
        if vert then begin
          HandleBar(MyWin,false,true);
          dec(pt^.pos);
          if its[pt^.pos].text='-' then dec(pt^.pos);
          if pt^.pos < 1 then pt^.pos:=ni;
          HandleBar(MyWin,true,true);
        end;
      end;
      6:begin
        if not vert then begin
          HandleBar(MyWin,false,true);
          inc(pt^.pos);
          if pt^.pos > ni then pt^.pos:=1;
          HandleBar(MyWin,true,true);
        end;
      end;
      7:begin
        if not vert then begin
          HandleBar(MyWin,false,true);
          dec(pt^.pos);
          if pt^.pos < 1 then pt^.pos:=ni;
          HandleBar(MyWin,true,true);
        end;
      end;
      3,9: code:=0;
      10:begin
        if MyWin.hlp <> nil then begin
          PutWin(MyWin.hlp^);
          repeat until keypressed;
          key:=MyReadKey;
          DelWin(MyWin.hlp^);
        end;
      end;
    end;
  end;
end; {*** end HandleMenu ***}

{*******************************************************************************
*        Name: HandleWin
*  Parametres: MyWin:Win   definition of window(menu)
*              Code:byte   position in menu (Esc=0)
*        Date: December 20, 1992
*     Version: 1.1
*     Purpose: Handle with window(menu)
********************************************************************************}
procedure HandleWin(var MyWin:Win;var code:byte);
const
  m_step=10;
var
  event:0..10;
  xm,ym,xmn,ymn:integer;
  key:word;

begin
  HandleBar(MyWin,y,y);
  event:=0;
  xmn:=0;  ymn:=0;
  code:=100;
  getmmotion(xm,ym);
  repeat
    if keypressed then begin
      key:=MyReadKey;
      case key of
        1080: event:=4;
        1072: event:=5;
        1077: event:=6;
        1075: event:=7;
        1059: event:=10;
          13: event:=8;
          27: event:=9;
        else  event:=1;
      end;
    end
    else begin
      if pressedbutton(1) then begin
        event:=2;   repeat until not pressedbutton(1);
      end  else if pressedbutton(2) then begin
        event:=3;   repeat until not pressedbutton(2);
      end  else begin
        getmmotion(xm,ym);
        xmn:=xmn+xm;
        ymn:=ymn+ym;
        if ymn > m_step then event:=4;
        if ymn < -m_step then event:=5;
        if xmn > m_step then event:=6;
        if xmn < -m_step then event:=7;
        if (event >=4) and (event <= 7) then begin
          xmn:=0;
          ymn:=0;
        end;
      end;
    end;
  until event <> 0;
  HandleMenu(MyWin,code,event,key);
end; {*** end HandleWin ***}

{*******************************************************************************
*        Name: PutWin
*  Parametres: MyWin:Win   definition of window(menu)
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert window(menu) to desktop
********************************************************************************}
procedure PutWin(var MyWin:Win);
var
  w,w_max,xr,h,yb,i,j:integer;
  pi:pointer;
  cl,han:word;
  ok:boolean;

begin
  cl:= getcolor;
  with MyWin do begin
    if vert then begin
      w_max:=ord(titl[0]);
      for i:=1 to ni do begin                  { Fix position and size }
        w:=MyOrd(its[i].text);                 { Horizontal }
        case its[i].k of
          2: w:=w+6;
          3: w:=w+8;
          4: w:=w+its[i].lv+3;
          5: w:=w+its[i].ls+3;
        end;
        if w > w_max then w_max:=w;
        w:=w_max*8+2*hofs;
      end;
    end
    else begin
      w_max:=0;
      for i:=1 to ni do w_max:=w_max+MyOrd(its[i].text);
      w:=w_max*8+(ni+1)*hofs;
    end;
    xr:=x+w;
    if xr+4 > getmaxx then begin
      xr:=getmaxx-5;
      x:=xr-w;
    end;
    if vert then begin
      if titl ='' then h:=0                    { Vertical }
      else h:=htitl;
      h:=h+ni*fh+2*vofs+4;
    end
    else h:=fh+2*vofs+4;
    yb:=y+h;
    if yb+4 > getmaxy then begin
      yb:=getmaxy-5;
      y:=yb-h;
    end;
    setviewport(0,0,getmaxx,getmaxy,clipon);   { Frame and title }
    getxms(han,imagesize(x,y,xr,yb),ok);
    if ok then awakepointer(han,pi,xmswritemode)
    else getmem(pi,imagesize(x,y,xr,yb));
    getimage(x,y,xr,yb,pi^);
    if ok then sleeppointer(han);
    setviewport(x,y,xr,yb,clipon);
    clearviewport;
    setfillstyle(1,pal.bground);
    bar(0,0,w,h);
    setcolor(pal.frame);
    rectangle(8,8,w-8,h-8);
    rectangle(10,10,w-10,h-10);
    if titl <> '' then begin
      line(10,htitl+vofs,w-10,htitl+vofs);
      settextjustify(1,0);
      outtextxy(round(w/2),htitl,titl);
    end;
    setviewport(0,0,getmaxx,getmaxy,clipon);
    new(pt);                                   { Save parametres of window }
    pt^.xr:=xr;      pt^.yb:=yb;     pt^.p_menu:=pi;
    pt^.xms_ok:=ok;  pt^.handle:=han;
    for j:= 1 to ni do begin                   { write items }
      pt^.pos:=j;
      if its[j].text='-' then begin
        setcolor(pal.frame);
        h:=y+vofs+j*fh-4;
        if titl <> '' then h:=h+htitl;
        line(x+10,h,x+w-10,h);
      end
      else InsText(MyWin,false,true);
    end;
    pt^.pos:=1;
  end;
  setcolor(cl);           { Set color back }
end; {*** end PutWin ***}

{*******************************************************************************
*        Name: ioer
*  Parametres: fil:string      string to output
*              io:boolean      I/O O.K. - io=true
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Put the echo about I/O operation
********************************************************************************}
procedure ioer(fil:string;var io:boolean);
var
  tcioe:win;
  temp:string;

begin
  io:=false;
  tcioe:=scioe;
  case ioresult of
    0: begin
      temp:='OK';
      io:=true;
    end;
    100:temp:='Disk read error';
    101:temp:='Disk write error';
    102:temp:='File not assigned';
    103:temp:='File not open';
    104:temp:='File not open for input';
    105:temp:='File not open for output';
    106:temp:='Invalid numeric format';
    159,160:temp:='Printer fault';
  end;
  tcioe.its[1].text:=fil+' : '+temp;
  PutWin(tcioe);
  delay(1000);
  DelWin(tcioe);
end; {*** end ioer ***}

{*******************************************************************************
*        Name: FilWin
*  Parametres: MyWin:Win       definition of window(menu)
*              iofiles:afile   information about files
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Fills MyWin with names of files
********************************************************************************}
procedure FilWin(var MyWin:Win;var iofiles:afile);
var
   i,max,pos,dif:integer;

begin
  if iofiles.first < 1 then iofiles.first:=1;
  max:=iofiles.first+11;
  if max > iofiles.ni then max:=iofiles.ni;
  dif:=max-iofiles.first;
  MyWin.ni:=dif+1+4;
  if iofiles.first = 1 then MyWin.its[2].enable:=false
  else MyWin.its[2].enable:=true;
  if max = iofiles.ni then MyWin.its[3].enable:=false
  else MyWin.its[3].enable:=true;
  pos:=4;
  for i:=iofiles.first to max do begin
    inc(pos);
    MyWin.its[pos].k:=1;
    MyWin.its[pos].enable:=true;
    MyWin.its[pos].text:=iofiles.fil[i];
  end;
end; {*** end FilWin ***}

{*******************************************************************************
*        Name: DirFil
*  Parametres: MyWin:Win       definition of window(menu)
*              iofiles:afile   information about files
*              fn:fname        name of file
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Fills iofiles with names of files
********************************************************************************}
procedure dirfil(var MyWin:win;var iofiles:afile;fn:fname);
var s:searchrec;

begin
  iofiles.ni:=0;
  findfirst(fn.d+'*'+fn.e,$3f,s);
  while doserror = 0 do begin
    inc(iofiles.ni);
    iofiles.fil[iofiles.ni]:=fn.d+s.name;
    findnext(s);
  end;
  iofiles.first:=1;
  FilWin(MyWin,iofiles);
end; {*** end dirfil ***}

{*******************************************************************************
*        Name: ChFil
*  Parametres: MyWin:Win       definition of window(menu)
*              fn:fname        name of file
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Changes directory and extension and chooses file for I/O
********************************************************************************}
procedure chfil(var MyWin:Win; var fn:fname);
var codel,codeg:byte;
    ex:boolean;
    iofiles:afile;
    pTWin,pChgDir:PtrWin;

begin
  RegWin(ChgDir,pChgDir);
  RegWin(HLoadSet,pChgDir^.hlp);
  dirfil(MyWin,iofiles,fn);
  PutWin(MyWin);
  ex:=false;
  fn.io:=true;
  repeat
    HandleWin(MyWin,codel);
    case codel of
      1:begin
        pChgDir^.its[1].s:=fn.d;
        pChgDir^.its[2].s:=fn.e;
        PutWin(pChgDir^);
        repeat
          HandleWin(pChgDir^,codeg);
        until codeg=0;
        DelWin(pChgDir^);
        DelWin(MyWin);
        if pChgDir^.its[1].s[length(pChgDir^.its[1].s)]<>'\'
          then pChgDir^.its[1].s:=pChgDir^.its[1].s+'\';
        fn.d:=pChgDir^.its[1].s;
        if length(pChgDir^.its[2].s)=3 then
          pChgDir^.its[2].s:='.'+pChgDir^.its[2].s;
        fn.e:=pChgDir^.its[2].s;
        dirfil(MyWin,iofiles,fn);
        PutWin(MyWin);
      end;
      2:begin
        iofiles.first:=iofiles.first-12;
        DelWin(MyWin);
        FilWin(MyWin,iofiles);
        PutWin(MyWin);
      end;
      3:begin
        iofiles.first:=iofiles.first+12;
        DelWin(MyWin);
        FilWin(MyWin,iofiles);
        PutWin(MyWin);
      end;
      4:begin
        RegWin(NewFile,pTwin);
        PutWin(pTWin^);
        repeat
          HandleWin(pTWin^,codeg);
        until codeg=0;
        DelWin(pTWin^);
        fn.p:=fn.d+pTWin^.its[1].s;
        fsplit(fn.p,fn.d,fn.n,fn.e);
        ex:=true;
      end;
      0:begin
        fn.io:=false;
        ex:=true;
      end;
      else if codel <= MyWin.ni then begin
        fsplit(MyWin.its[codel].text,fn.d,fn.n,fn.e);
        ex:=true;
      end;
    end;
  until ex;
  DelWin(MyWin);
  fn.p:=fn.d+fn.n+fn.e;
  fn.s:=fn.p;
  UnregWin(pChgDir);
  UnregWin(pChgDir^.hlp);
end; {*** end chfil ***}

{*******************************************************************************
*        Name: SaveWin
*  Parametres: fn:fname    name of file
*              n:integer   number of records Win
*              fdat:aWin   array of Win
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Save definitions of window(menu) to file
********************************************************************************}
procedure SaveWin(var fn:fname;n:integer;var fdat:aWin);
var i:integer;
    fil:string[50];
    tdata:fWin;
    tLoadSet:Win;

begin
  tLoadSet:=LoadSet;
  RegWin(HLoadSet,tLoadSet.hlp);
  tLoadSet.titl:='Save Setup';
  tLoadSet.its[4].enable:=true;
  fn.p:=fexpand(fn.s);
  fsplit(fn.p,fn.d,fn.n,fn.e);
  fn.io:=true;
  if fn.chg then chfil(tLoadSet,fn);
  if fn.io then begin
    {$I-}
    assign(tdata,fn.p);
    rewrite(tdata);
    for i:=1 to n do write(tdata,fdat[i]^);
    close(tdata);
    {$I+}
    fil:='Writting '+fn.p;
    ioer(fil,fn.io);
  end;
  UnregWin(tLoadSet.hlp);
end; {*** end SaveWin ***}

{*******************************************************************************
*        Name: LoadWin
*  Parametres: fn:fname    name of file
*              n:integer   number of records Win
*              fdat:aWin   array of Win
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Load definitions of window(menu) to array fdat
********************************************************************************}
procedure LoadWin(var fn:fname;n:integer;var fdat:aWin);
var i:integer;
    fil:string[50];
    tdata:fWin;
    tempWin,tLoadSet:Win;

begin
  tLoadSet:=LoadSet;
  RegWin(HLoadSet,tLoadSet.hlp);
  tLoadSet.titl:='Load Setup';
  tLoadSet.its[4].enable:=false;
  fn.p:=fexpand(fn.s);
  fsplit(fn.p,fn.d,fn.n,fn.e);
  fn.io:=true;
  if fn.chg then chfil(tLoadSet,fn);
  if fn.io then begin
    {$I-}
    assign(tdata,fn.p);
    reset(tdata);
    for i:=1 to n do begin
      read(tdata,tempWin);
      RegWin(tempWin,fdat[i]);
    end;
    close(tdata);
    {$I+}
    fil:='Reading '+fn.p;
    ioer(fil,fn.io);
  end;
  UnregWin(tLoadSet.hlp);
end; {*** end LoadWin ***}

{*******************************************************************************
*        Name: HandlelStLine
*  Parametres: MyStLine:StLine   definition of status line
*              code:word;        code of key;
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Handle with status line
********************************************************************************}
procedure HandleStLine(MyStLine:StLine;var code:word);
var cKey:word;
    i:integer;
begin
  code:=0;
  if keypressed then begin
    cKey:=MyReadKey;
    with MyStLine do begin
      for i:=1 to ni do
        if (its[i].code=cKey) and its[i].enable then code:=its[i].code;
    end;
  end;
end; {*** end HandleStLine ***}

{*******************************************************************************
*        Name: DelStLine
*  Parametres: MyStLine:StLine   definition of status line
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Delete status line from desktop
********************************************************************************}
procedure DelStLine(MyStLine:StLine);
begin
  with MyStLine do begin
    setviewport(0,0,getmaxx,getmaxy,clipon);
    putimage(0,getmaxy-12,pt^,0);
    freemem(pt,imagesize(0,getmaxy-12,getmaxx,getmaxy));
  end;
end; {*** end DelStLine ***}

{*******************************************************************************
*        Name: PutStLine
*  Parametres: MyStLine:StLine   definition of status line
*        Date: June 26, 1992
*     Version: 1.0
*     Purpose: Insert status line to desktop
********************************************************************************}
procedure PutStLine(var MyStLine:StLine);

var
  cl,maxx,maxy,ps,i:integer;

begin
  cl:= getcolor;
  maxx:=getmaxx;
  maxy:=getmaxy;
  with MyStLine do begin
    setviewport(0,0,maxx,maxy,clipon);
    getmem(pt,imagesize(0,maxy-12,maxx,maxy));
    getimage(0,maxy-12,maxx,maxy,pt^);
    setviewport(0,maxy-12,maxx,maxy,clipoff);
    clearviewport;
    setfillstyle(1,pal.bground);
    bar(0,0,maxx,maxy);
    settextjustify(0,0);
    ps:=-10;
    for i:=1 to ni do begin
      ps:=ps+25;
      if its[i].enable then  setcolor(pal.text) else setcolor(pal.dtext);
      outtextxy(ps,10,its[i].ltext);
      ps:=ps+length(its[i].ltext)*8+8;
      if its[i].enable then  setcolor(pal.hotkey)   else setcolor(pal.dtext);
      outtextxy(ps,10,its[i].rtext);
      ps:=ps+length(its[i].rtext)*8;
    end;
  end;
  setviewport(0,0,getmaxx,getmaxy,clipon);
  setcolor(cl);           { Set color back }
end; {*** end PutStLine ***}


{*******************************************************************************
*        Name: HandleAll
*  Parametres: MyWin:Win       definition of window(menu)
*              Code:byte       position in menu (Esc=0)
*              MyStLine:StLine definition of sttus line
*              Codest:word     status line code
*        Date: December 20, 1992
*     Version: 1.0
*     Purpose: Handle with all (window+status line)
********************************************************************************}
procedure HandleAll(var MyWin:Win;var code:byte;
                    var MyStLine:StLine;var codest:word);
const
  m_step=10;
var
  event:0..10;
  xm,ym,xmn,ymn,i:integer;
  key:word;

begin
  HandleBar(MyWin,y,y);
  event:=0;
  xmn:=0;  ymn:=0;
  code:=100;
  codest:=0;
  getmmotion(xm,ym);
  repeat
    if keypressed then begin
      key:=MyReadKey;
      case key of
        1080: event:=4;
        1072: event:=5;
        1077: event:=6;
        1075: event:=7;
        1059: event:=10;
          13: event:=8;
          27: event:=9;
        else  event:=1;
      end;
      with MyStLine do begin
        for i:=1 to ni do
          if (its[i].code=key) and its[i].enable then begin
            codest:=its[i].code;
            exit;
          end;
      end;
    end
    else begin
      if pressedbutton(1) then begin
        event:=2;   repeat until not pressedbutton(1);
      end  else if pressedbutton(2) then begin
        event:=3;   repeat until not pressedbutton(2);
      end  else begin
        getmmotion(xm,ym);
        xmn:=xmn+xm;
        ymn:=ymn+ym;
        if ymn > m_step then event:=4;
        if ymn < -m_step then event:=5;
        if xmn > m_step then event:=6;
        if xmn < -m_step then event:=7;
        if (event >=4) and (event <= 7) then begin
          xmn:=0;
          ymn:=0;
        end;
      end;
    end;
  until event <> 0;
  HandleMenu(MyWin,code,event,key);
end; {*** end HandleAll ***}

{*******************************************************************************
*        Name: PrtScreen
*  Parametres: MinX,MaxX,MinY,MaxY:integer  upper left and lower right
*                                           corner of printed window
*              lq:boolean quality of print lq=true  - letter quiality
*                                          lq=false - draft
*        Date: January 10, 1993
*     Version: 1.0
*     Purpose: Print part of screen in graphic mode
********************************************************************************}
procedure  PrtScreen(MinX,MaxX,MinY,MaxY:integer;lq:boolean);

var
   i,j,k : word;
   n : byte;
   x1, x2 : char;
begin
   x1 := Chr((MaxX-MinX+1) mod 256);
   x2 := Chr((MaxX-MinX+1) div 256);
   {$I-}
   for j := MinY div 8 to MaxY div 8 do begin
     write(Lst,Chr(13));
     write(Lst,Chr(27),'J',Chr(24));             { LineFeed 24/216" }
     write(Lst,'     ');                         { Start offset }
     if lq then write(Lst,Chr(27),'L',x1, x2)    {'L' - LQ }
     else write(Lst,Chr(27),'Y',x1, x2);         {'Y' - Draft }
     for i := MinX to MaxX do begin
       n := 0;
       for k := 0 to 7 do
         if GetPixel(i, 8*j+k) > 0 then n:=n Or ($80 shr k);
       write(Lst,Chr(n));
     end;
   end;
   write(Lst,Chr(13));
   {$I+}
   ioer('Printing: ',lq);
end;


{ Main body of unit }
var
  GrD,GrM:integer;

Begin
  DetectGraph(GrD,GrM);
  if (GrD=5) or (GrD=7) then pal:=pal_mono
  else pal:=pal_co;
  initmouse(init_mouse);
End. {*** unit MCMENU10 ***}
