(*****************************************************************************

  Program: Editor demonstration.

  Purpose:
    This program demonstrates the editor unit.

  Features:
    Allows the user to try the editor procedures with a variety of data types.

  Limitations:
    None.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Edit_demonstration_Program( Input, Output );

  Uses
    CRT,
    Editor;

  Var
   { These variables hold the data to be operated on. }
    Data1: String;
    Data2: Real;
    Data3: Integer;
    Data4: Boolean;
    Data5: LongInt;

  Begin
    WriteLn( 'Editor demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the abilities of the Editor unit.  To escape a field' );
    WriteLn( 'Simply press Enter or Escape.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    ClrScr;

    WriteLn( 'Editing a text string.' );
    Data1 := 'This is a test string for the editor procedure.';
    Edit_String( 2, 1, Data1 );
    GotoXY( 1, 3 );
    WriteLn( 'Result > ', Data1 );

    WriteLn( 'Setting a real number.' );
    Data2 := 1/3;
    Set_Real(  5, 1, Data2 );
    GotoXY( 1, 6 );
    WriteLn( 'Result > ', Data2 );

    WriteLn( 'Editing a real number.' );
    Data2 := 1/6;
    Edit_Real( 8, 1, Data2 );
    GotoXY( 1, 9 );
    WriteLn( 'Result > ', Data2 );

    WriteLn( 'Toggling an integer.' );
    Data3 := 57;
    Toggle_Integer( 11, 1, Data3 );
    GotoXY( 1, 12 );
    WriteLn( 'Result > ', Data3 );

    WriteLn( 'Editing an integer.' );
    Data3 := 105;
    Edit_Integer( 14, 1, Data3 );
    GotoXY( 1, 15 );
    WriteLn( 'Result > ', Data3 );

    WriteLn( 'Changing a Boolean value.' );
    Data4 := True;
    Change_Boolean( 17, 1, Data4 );
    GotoXY( 1, 18 );
    WriteLn( 'Result > ', Data4 );

    WriteLn( 'Getting a long integer.' );
    Data5 := 0;
    Get_Long_Integer( 20, 1, Data5 );
    GotoXY( 1, 21 );
    WriteLn( 'Result > ', Data5 );

    WriteLn( 'Editing a long integer.' );
    Data5 := 102305934;
    Edit_Long_Integer( 23, 1, Data5 );
    GotoXY( 1, 24 );
    WriteLn( 'Result > ', Data5 );

  End.

