(*****************************************************************************

  Program: File demonstration.

  Purpose:
    This program demonstrates the abilities of the FileMem unit.

  Features:
    The FileMem unit is a unit that allows file space to be allocated and
      used like memory.  One immediate advantage is that data structures
      far larger than memory size can be created and used easily.
    FileMem ( Version 2 ) also used system memory as a temporary storage
      space to increase performance.  The amount of system memory it uses
      is not definite, FileMem is very willing to give up some of it's memory
      space when asked.

  What it does:
    This program allocates random data strings and stores them in FileMem.
    Then it deallocates some of the records and dumps out a listing.
    Then it reallocates the records and dumps out a listing.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal version 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2.

*****************************************************************************)

Program File_Demonstration( Input, Output );

 {$DEFINE NoDebug} { Used for testing and debugging program}

  Uses
    DOS,
    CRT,
    FileMem;

  Const
   { The amount of records to allocate. }
    Amount = 1000;

  Type
   { This structure hold a single data allocation. }
    Data_Record_Type = Record
                         Size: Byte;
                         Pointer: Pointer_Type;
                       End;
   { This structure hold the multiple data allocations. }
    Data_Type = Packed array[ 1 .. Amount ] of Data_Record_Type;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Create char.
    This function returns a randomly generated
    character.

*************************************************)

  Function Create_Char: Char;
    Var
      Character: Char;
    Begin
      Repeat
        Character := CHR( Random( 120 ) );
      Until ( Character in [ 'A'..'Z', 'a'..'z' ] );
      Create_Char := Character;
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Create string.
    This function returns a string of random
    length of randomly generated characters.

*************************************************)

  Function Create_String: String;
    Var
      Counter: Byte;
      Hold_String: String;
    Begin
      Hold_String := '';
      For Counter := 1 to Random( 255 ) do
        Hold_String := Hold_String + Create_Char;
      Create_String := Hold_String;
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Fill data.
    This procedure fills the data structure with
    the randomly generated data.

*************************************************)

  Procedure Fill_Data( Var Data: Data_Type; Amount: Integer );
    Var
      Counter: Integer;
      My_String: String;
    Begin
      For Counter := 1 to Amount do
        With Data[ Counter ] do
          Begin
            Write( ( Amount - Counter ):6 );
            My_String := Create_String;
            Size := Succ( Length( My_String ) );
            Pointer := New_Pointer( Size );
            Put_Data( Pointer, My_String, Size );
          End;
      WriteLn;
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write data.
    This procedure writes out the randomly
    generated data.

*************************************************)

  Procedure Write_Data( Var Data: Data_Type; Amount: Integer );
    Var
      Counter: Integer;
      My_String: String;
    Begin
      For Counter := 1 to Amount do
        With Data[ Counter ] do
          Begin
            Get_Data( Pointer, My_String, Size );
            WriteLn( '>', My_String );
          End;
    End;

{-----------------------------------------------------------------------------}

(*************************************************

  Main program.
    Allocate the data.
    Write the data.
    Deallocate some of the records.
    Dump the listing.
    Reallocate the deallocated records.
    Dump the listing.

*************************************************)

  Var
    Counter,
    New_Amount: Integer;
    My_String: String;
    Data: Data_Type;
  Begin
    WriteLn( 'FileMem demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates and tests the effectiveness of the FileMem unit' );
    WriteLn( 'Basically all it does is allocate ', Amount, ' number of random length' );
    WriteLn( 'strings filled with random data.  Then the information is dumped on screen' );
    WriteLn( 'to test the effectivness of the rapid access code.  Finally a number of' );
    WriteLn( 'records are deallocated to test the effectiveness of the record management' );
    WriteLn( 'system.  A listing of the deallocated list is displayed then the same number' );
    WriteLn( 'records are reallocated.  Another listing of the leftover allocations is' );
    WriteLn( 'displayed and the program ends.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    Randomize;

{   Switch_to_memory_listings;  }

    WriteLn( 'Allocating ', Amount, ' string records.' );
    Fill_Data( Data, Amount );

    Write_Data( Data, Amount );

   {$IFDEF Debug}
    New_Amount := Amount;
   {$ELSE}
    New_Amount := Random( Amount );
   {$ENDIF}

    WriteLn( 'Deallocating ', New_Amount, ' string records.' );
    For Counter := 1 to New_Amount do
      With Data[ Counter ] do
        Begin
          Write( ( New_Amount - Counter ):6 );
          If not Dispose_Pointer( Pointer )
            then
              Begin
                WriteLn;
                WriteLn( 'Error in disposing pointer' );
                WriteLn( 'Press Enter to continue' );
                ReadLn;
                WriteLn;
              End;
        End;
    WriteLn;

    WriteLn( 'Reallocating ', New_Amount, ' string records.' );
    Fill_Data( Data, New_Amount );

   {$IFDEF Debug}
    Dump_Deallocated_Listings( Output );
   {$ENDIF}

  End.

