{$F+} { Compiler Directive: Generate far calls: On } { Do Not Change! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  FillCode
    Version 1.0

    This unit implements primative rasper graphic routines for building
      graphical displays.

    Purpose:
      When building complex graphical objects, especially with multiple
      overlapping vertices, such as with complex polygons, graphical pixel
      filling can get quite complicated.  Most of the time it's not to the
      systems advantage to build the display on the screen.  This system
      takes over that task and piles the necessary data in a special data
      structure until the results are ready to be dumped onscreen as a
      unified whole rather than as indivual parts.

    How it works:
      This system interlinks with draw and is an interal part of the draw
        grapical system.
      This system builds a hash table of linked lists to represent the various
        parts of the pixel elements of the complex polygon.
      Steps to completing the process.
        First the list must be cleared.
        Then with numerous calls to the filled pixel routines, the drawing is
          completed in the data structure.
        Finally, the drawing is transfered to the graphical rasper display.

    Features:
      Use of dynamic data structures to build structure.
      Use of sorting mechanisms to increase pixel thouralput.
      The color of the display is determined by draw.

  Copyright 1991, All rights reserved.
    P. R. Renaud

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit FillCode;

  Interface

    Uses
      Draw;

(***********************************************************

  Procedure: Swap.

    This procedure swaps the values of the two given
    integers.

***********************************************************)

    Procedure Swap( Var Value_1, Value_2: Integer );

(***********************************************************

  Procedure: Clear List.

    This procedure clears the Y coordinate list and the
    work area list.

***********************************************************)

    Procedure Clear_List;

(***********************************************************

  Procedure: Clear Y Coordinate List.

    This procedure clears only the Y coordinate list.

***********************************************************)

    Procedure Clear_Y_Coordinate_List;

(***********************************************************

  Procedure: Filled Pixel.

    This procedure enters the given pixel into the data
    structure at the given coordinates as part of the
    outline.  This routine produces immediate results if
    possible.

***********************************************************)

    Procedure Filled_Pixel( X, Y: Integer );

(***********************************************************

  Procedure: Filled Line.

    This procedure enters the line of pixels into the data
    structure at the given coordinates as part of the
    outline.  This routine produces immediate results if
    possible.

***********************************************************)

    Procedure Filled_Line( X1, Y1, X2, Y2: Integer );


(***********************************************************

  Procedure: Filled Pixel Job.

    This procedure enters the given pixel into the data
    structure at the given coordinates as part of the
    outline.  This routine waits for the completion of the
    job before data is displayed.

***********************************************************)

    Procedure Filled_Pixel_Job( X, Y: Integer );

(***********************************************************

  Procedure: Filled Line Job.

    This procedure enters the line of pixels into the data
    structure at the given coordinates as part of the
    outline.  This routine waits for the completing of the
    job before data is displayed.

***********************************************************)

    Procedure Filled_Line_Job( X1, Y1, X2, Y2: Integer );

(***********************************************************

  Procedure: Draw List.

    This procedure is designed to be called after the
    complete structure is finished to display the data on
    the screen.

***********************************************************)

    Procedure Draw_List;

{----------------------------------------------------------------------------}

  Implementation

    Type
     { This pointer points to the single line element. }
      List_Pointer = ^List_Record;
     { This is the single line element structure. }
      List_Record = Record
                      Start,
                      Finish: Integer;
                      Next: List_Pointer;
                    End;
     { This structure holds the table of line elements. }
      List_Array = array[ Y_Range ] of List_Pointer;
     { This structure holds the data of the row values. }
      Row_Type = Record
                   Amount: 0 .. 1000;
                   Data: array[ 1 .. 1000 ] of Integer;
                 End;
     { This holds the alternate structure of the integers. }
      Filling_Type = array[ Y_Range ] of Integer;
     { This variable holds the various data structures. }
      Work_Area_Type = Record
                         List: List_Array;
                         Case Byte of
                          0: ( Row: Row_Type );
                          1: ( Filling_List: Filling_Type );
                       End;
     { This defines a procedure variable type for various procedures. }
      Do_Pixel_Type = Procedure( X, Y: Integer );

    Var
     { Allocates the work area. }
      Work_Area: Work_Area_Type;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Swap.
    As previously defined.

*************************************************)

    Procedure Swap( Var Value_1, Value_2: Integer );
     {$IfDef Ver60 }
      Assembler;
      Asm
        Push Ds
        LEs Di, Value_1
        LDs Si, Value_2
        Mov Ax, [ Es: Di ]
        XChg Ax, [ Ds: Si ]
        Mov [ Es: Di ], Ax
        Pop Ds
      End;
     {$else}
      Var
        Temporary: Integer;
      Begin
        Temporary := Value_1;
        Value_1 := Value_2;
        Value_2 := Temporary;
      End;
     {$EndIf}

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear Y Coordinate List.
    As previously defined.

*************************************************)

    Procedure Clear_Y_Coordinate_List;
      Var
        Index: Word;
      Begin
        With Work_Area do
          For Index := 0 to Y_Limit do
            Filling_List[ Index ] := -1;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear List.
    As previously defined.

*************************************************)

    Procedure Clear_List;
      Var
        Counter: Word;
      Begin
        Clear_Y_Coordinate_List;
        For Counter := 0 to Y_Limit do
          Work_Area.List[ Counter ] := Nil;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Add to List.
    This procedure adds the given coordinates to
    the linked list at the appropiate Y
    coordinate.

*************************************************)

    Procedure Add_To_List( Y, X1, X2: Integer );
      Var
        New_Pointer: List_Pointer;
      Begin
        If ( ( Y < 0 ) or ( Y > Y_Limit ) )
          then
            Exit;
        New( New_Pointer );
        With New_Pointer^ do
          Begin
            Next := Work_Area.List[ Y ];
            Start := X1;
            Finish := X2;
          End;
        Work_Area.List[ Y ] := New_Pointer;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear Row.
    This procedure clears the row structure by
    simple changing the amount of values in the
    structure to zero.  This indicates the
    structure is empty.

*************************************************)

    Procedure Clear_Row;
      Begin
        Work_Area.Row.Amount := 0;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Add Row.
    This procedure puts the two given numbers in
    the row structure.

*************************************************)

    Procedure Add_Row( Num1, Num2: Integer );
      Begin
        With Work_Area.Row do
          Begin
            Inc( Amount );
            Data[ Amount ] := Num1;
            Inc( Amount );
            Data[ Amount ] := Num2;
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Quick Sort.
    This procedure sorts the row structure.  This
    is because the data isn't stored in order.

*************************************************)

    Procedure QSort( Low, High: Word );
      Var
        Examine,
        New_Low,
        New_High: Integer;
      Begin
        With Work_Area.Row do
          Begin
            New_Low := Low;
            New_High := High;
            Examine := Data[ ( ( Low + High ) div 2 ) ];
            Repeat
              While ( Data[ New_Low ] < Examine ) do
                Inc( New_Low );
              While ( Examine < Data[ New_High ] ) do
                Dec( New_High );
              If ( New_Low <= New_High )
                then
                  Begin
                    Swap( Data[ New_Low ], Data[ New_High ] );
                    Inc( New_Low );
                    Dec( New_High );
                  End;
            Until ( New_Low > New_High );
            If ( Low < New_High )
              then
                QSort( Low, New_High );
            If ( New_Low < High )
              then
                QSort( New_Low, High );
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw Row.
    This procedure draws the given row structure
    on the screen.  Usually there isn't much
    data for any particular row.

*************************************************)

    Procedure Draw_Row( Y: Integer );
      Var
        Point: Byte;
      Begin
        With Work_Area.Row do
          Begin
            QSort( 1, Amount );
            Point := 1;
            While ( Point < Amount ) do
              Begin
                Fill_Line( Data[ Point ], Data[ Succ( Point ) ], Y, Filling_Color );
                Inc( Point, 2 );
              End;
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw List.
    As previously defined.

*************************************************)

    Procedure Draw_List;
      Var
        Holder,
        Pointer: List_Pointer;
        Counter: Word;
      Begin
        For Counter := 0 to Y_Limit do
          If ( Work_Area.List[ Counter ] <> Nil )
            then
              Begin
                Clear_Row;
                Pointer := Work_Area.List[ Counter ];
                While ( Pointer <> Nil ) do
                  Begin
                    Add_Row( Pointer^.Start, Pointer^.Finish );
                    Holder := Pointer;
                    Pointer := Holder^.Next;
                    Dispose( Holder );
                  End;
                Draw_Row( Counter );
              End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Filled Pixel.
    As previously defined.

*************************************************)

    Procedure Filled_Pixel( X, Y: Integer );
      Begin
        If ( X < 0 )
          then
            X := 0;
        With Work_Area do
          If ( ( 0 <= Y ) And ( Y <= Y_Limit ) )
            then
              If ( Filling_List[ Y ] = -1 )
                then
                  Filling_List[ Y ] := X
                else
                  If ( Filling_List[ Y ] <> X )
                    then
                      Begin
                        Fill_Line( Filling_List[ Y ], X, Y, Filling_Color );
                        Filling_List[ Y ] := -1;
                      End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Filled Pixel Job.
    As previously defined.

*************************************************)

    Procedure Filled_Pixel_Job( X, Y: Integer );
      Begin
        If ( X < 0 )
          then
            X := 0;
        With Work_Area do
          If ( ( 0 <= Y ) And ( Y <= Y_Limit ) )
            then
              If ( Filling_List[ Y ] = -1 )
                then
                  Filling_List[ Y ] := X
                else
                  Begin
                    Add_To_List( Y, Filling_List[ Y ], X );
                    Filling_List[ Y ] := -1;
                  End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Line Forward.
    This procedure draws the line in the forward
    fashion.  That is, the Coordinates are
    increasing.

*************************************************)

    Procedure Line_Forward( X, Y, A, B: Integer; Plot: Do_Pixel_Type );
      Var
        I,
        T,
        D: Integer;
      Begin
        If ( A > B )
          then
            Begin
              T := ( B - A );
              D := B - A div 2;
              Plot( X, Y );
              For I := 0 to Pred( A ) do
                Begin
                  Inc( X );
                  If ( D < 0 )
                    then
                      D := ( D + B )
                    else
                      Begin
                        Inc( Y );
                        D := ( D + T );
                        Plot( X, Y );
                      End;
                End;
            End
          else
            Begin
              T := ( A - B );
              D := A - B div 2;
              For I := 0 to B do
                Begin
                  Plot( X, Y );
                  Inc( Y );
                  If ( D < 0 )
                    then
                      D := ( D + A )
                    else
                      Begin
                        Inc( X );
                        D := ( D + T )
                      End;
                End;
            End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Line Backward.
    This procedure draws the line in the backwards
    fashion.  This routine is called when the
    coordinates are decreasing.

*************************************************)

    Procedure Line_Backward( X, Y, A, B: Integer; Plot: Do_Pixel_Type );
      Var
        I,
        T,
        D: Integer;
      Begin
        If ( A > B )
          then
            Begin
              T := ( B - A );
              D := B - A div 2;
              Plot( X, Y );
              For I := 0 to Pred( A ) do
                Begin
                  Inc( X );
                  If ( D < 0 )
                    then
                      D := ( D + B )
                    else
                      Begin
                        Dec( Y );
                        D := ( D + T );
                        Plot( X, Y );
                      End;
                End;
            End
          else
            Begin
              T := ( A - B );
              D := A - B div 2;
              For I := 0 to B do
                Begin
                  Plot( X, Y );
                  Dec( Y );
                  If ( D < 0 )
                    then
                      D := ( D + A )
                    else
                      Begin
                        Inc( X );
                        D := ( D + T )
                      End;
                End;
            End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Filled Line.
    As previously defined.

*************************************************)

    Procedure Filled_Line( X1, Y1, X2, Y2: Integer );
      Var
        A,
        B: Integer;
      Begin
        A := ( X2 - X1 );
        B := ( Y2 - Y1 );
        If ( A > 0 )
          then
            If ( B > 0 )
              then
                Line_Forward( X1, Y1, A, B, Filled_Pixel )
              else
                Line_Backward( X1, Y1, A, -B, Filled_Pixel )
          else
            If ( B > 0 )
              then
                Line_Backward( X2, Y2, -A, B, Filled_Pixel )
              else
                Line_Forward( X2, Y2, -A, -B, Filled_Pixel );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Filled Line Job.
    As previously defined.

*************************************************)

    Procedure Filled_Line_Job( X1, Y1, X2, Y2: Integer );
      Var
        A,
        B: Integer;
      Begin
        A := ( X2 - X1 );
        B := ( Y2 - Y1 );
        If ( A > 0 )
          then
            If ( B > 0 )
              then
                Line_Forward( X1, Y1, A, B, Filled_Pixel_Job )
              else
                Line_Backward( X1, Y1, A, -B, Filled_Pixel_Job )
          else
            If ( B > 0 )
              then
                Line_Backward( X2, Y2, -A, B, Filled_Pixel_Job )
              else
                Line_Forward( X2, Y2, -A, -B, Filled_Pixel_Job );
      End;

{-----------------------------------------------------------------------------}

  End.
