(*****************************************************************************

  Program:  String utility demonstration.

  Purpose:
    This program demonstrates the abilities of the string utility unit.

  Features:
    Displays the abilities of the string utility unit to convert numbers into
      words.
    Demonstrates the ability of the unit to convert date and time into words.
    Demonstrates the ability of the unit to perform mathematical function on
      strings of numbers without converting them into binary numbers.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program String_Demonstration( Input, Output );

  Uses
    CRT,
   {$IFNDEF OS2}
    String_Utilities;
   {$ELSE}
    String_U;
   {$ENDIF}

  Var
    Numbers1,
    Numbers2,
    Numbers3,
    Date_String,
    Time_String,
    Number_String: String;
    Number: LongInt;

  Begin
    WriteLn( 'String unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the ability of the String unit. First a simple number' );
    WriteLn( 'is converted into a string and displayed on the screen.  Next, you''ll see the' );
    WriteLn( 'date and time polled and returned as readable strings.  Finally, you''ll see' );
    WriteLn( 'the results of several mathematical problems worked out in string format.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    DirectVideo := True;

    Number := 189458596;
    Number_String := Write_Out_Number( Number );
    WriteLn( Number, ' converts to ', Number_String );
    WriteLn;
    Get_Date( Date_String );
    Get_Time( Time_String );
    WriteLn( 'Time: ', Time_String );
    WriteLn( 'Date: ', Date_String );
    Numbers1 := '987654321';
    Numbers2 := '123456789';
    Numbers3 := Add_Integer_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' + ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Subtract_Integer_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' - ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Multiply_Integer_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' * ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Divide_Integer_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' / ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Mod_Integer_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' Mod ', Numbers2, ' = ', Numbers3 );
    Numbers1 := '98765.4321';
    Numbers2 := '123.456789';
    Numbers3 := Add_Real_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' + ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Subtract_Real_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' - ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Multiply_Real_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' * ', Numbers2, ' = ', Numbers3 );
    Numbers3 := Divide_Real_String( Numbers1, Numbers2 );
    WriteLn( Numbers1, ' / ', Numbers2, ' = ', Numbers3 );
    WriteLn;
    WriteLn( 'Press enter to continue.' );
    ReadLn;

  End.

