{----------------------------------------------------------------------------}

   {$F+} { Do not remove! }

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get file name default.
    This procedure prompts the user for the name
    of a file.

*************************************************)

    Procedure Get_File_Name_Default( Var Data: String );
      Begin
        ClrScr;
        TextAttr := Message_HighLight;
        Write( Screen, 'Please enter the file name: ' );
        TextAttr := Message_Normal;
        ReadLn( Keys, Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Map keys.
    This procedure maps the screen location to the
    keys so that clicking on the screen works like
    pressing a number.

*************************************************)

    Procedure Map_Keys( Adjust_Amount: Byte; Var Value: Char );
      Begin
        Case Adjust_Amount of
          0: Value := '0';
          1: Value := '1';
          2: Value := '2';
          3: Value := '3';
          4: Value := '4';
          5: Value := '5';
          6: Value := '6';
          7: Value := '7';
          8: Value := '8';
          9: Value := '9';
        End; { Case }
        Delay( 200 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get search data default.
    This procedure prompts the user for the search
    data, then presents a simple menu to adjust
    the options.

*************************************************)

    Procedure Get_Search_Data_Default( Var Data: String );
      Var
        Width: Byte;
        Value: Char;
        Temporary: String;
      Begin
        ClrScr;
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Separator( 'Search', Width );
        WriteLn( Screen );
        WriteLn( Screen, 'Please enter the search string.' );
        WriteLn( Screen, 'You may use the character [ ~ ] as a wild card.' );
        WriteLn( Screen );
        TextAttr := Message_HighLight;
        Write( Screen, 'Search data: ' );
        TextAttr := Message_Normal;
        ReadLn( Keys, Data );
        Substitute( Data, '~', WildCard );
        WriteLn( Screen );
        WriteLn( Screen, Center( ' Options ', Width, '=' ) );
        WriteLn( Screen );
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Please press appropriate number.' );
        Repeat
          Cursor_Row := 13;
          GotoXY( 1, Succ( Cursor_Row ) );
          Case Search_Selected_Text of
            True: Temporary := 'Selected text';
            False: Temporary := 'Global';
          End; { Case }
          TextAttr := Message_HighLight;
          Write( Screen, ' 1 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Search limits', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Start_Search_At_Cursor of
            True: Temporary := 'At cursor';
            False: Temporary := 'At beginning';
          End; { Case }
          Write( Screen, ' 2 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Start the search', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Only_Whole_Words of
            True: Temporary := 'Complete words only';
            False: Temporary := 'Words and word fragments';
          End; { Case }
          Write( Screen, ' 3 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Limit search to', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Case_Sensitive of
            True: Temporary := 'Consider case';
            False: Temporary := 'Ignore case';
          End; { Case }
          Write( Screen, ' 4 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Letters', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Write( Screen, ' 5 ' );
          TextAttr := Message_Normal;
          WriteLn( Screen, 'Start operation. ' );
          TextAttr := Message_HighLight;
          Write( Screen, ' 6 ' );
          TextAttr := Message_Normal;
          WriteLn( Screen, 'Cancel operation. ' );
          Repeat
            Get_Command( Value, Command );
          Until ( Command in [ Press_Numbers, Press_Escape, Pointer_Down ] );
          If ( Command = Pointer_Down )
            then
              Map_Keys( Adjust_Amount, Value );
          Case Value of
            '1': Search_Selected_Text := not Search_Selected_Text;
            '2': Start_Search_At_Cursor := not  Start_Search_At_Cursor;
            '3': Search_Only_Whole_Words := not Search_Only_Whole_Words;
            '4': Search_Case_Sensitive := not Search_Case_Sensitive;
            else ;
          End; { Case }
        Until ( ( Value in [ '5', '6' ] ) or ( Command = Press_Escape ) );
        If ( ( Value = '6' ) or ( Command = Press_Escape ) )
          then
            Data := '';
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get search and replace data default.
    This procedure prompts the user for the search
    and replace data, then presents a simple menu
    to adjust the options.

*************************************************)

    Procedure Get_Search_And_Replace_Data_Default( Var Data1, Data2: String );
      Var
        Width: Byte;
        Value: Char;
        Temporary: String;
      Begin
        ClrScr;
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        Separator( 'Search and Replace', Width );
        WriteLn( Screen, 'Please enter the search string.' );
        WriteLn( Screen, 'You may use the character [ ~ ] as a wild card.' );
        TextAttr := Message_HighLight;
        Write( Screen, 'Search data: ' );
        TextAttr := Message_Normal;
        ReadLn( Keys, Data1 );
        Substitute( Data1, '~', WildCard );
        WriteLn( Screen, 'Please enter the replacement string.' );
        TextAttr := Message_HighLight;
        Write( Screen, 'Replace data: ' );
        TextAttr := Message_Normal;
        ReadLn( Keys, Data2 );
        WriteLn( Screen, Center( ' Options ', Width, '=' ) );
        WriteLn( Screen );
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Please press appropriate number.' );
        Repeat
          Cursor_Row := 12;
          GotoXY( 1, Succ( Cursor_Row ) );
          Case Search_Selected_Text of
            True: Temporary := 'Selected text';
            False: Temporary := 'Global';
          End; { Case }
          TextAttr := Message_HighLight;
          Write( Screen, ' 1 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Search limits', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Start_Search_At_Cursor of
            True: Temporary := 'At cursor';
            False: Temporary := 'At beginning';
          End; { Case }
          Write( Screen, ' 2 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Start the search', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Only_Whole_Words of
            True: Temporary := 'Complete words only';
            False: Temporary := 'Words and word fragments';
          End; { Case }
          Write( Screen, ' 3 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Limit search to', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Case_Sensitive of
            True: Temporary := 'Consider case';
            False: Temporary := 'Ignore case';
          End; { Case }
          Write( Screen, ' 4 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Letters', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Change_All of
            True: Temporary := 'To end of text';
            False: Temporary := 'To first occurrence';
          End; { Case }
          Write( Screen, ' 5 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Search and Replace range', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Case Search_Prompt_On_Replace of
            True: Temporary := 'Yes';
            False: Temporary := 'No';
          End; { Case }
          Write( Screen, ' 6 ' );
          TextAttr := Message_Normal;
          Write( Screen, Push_To( 'Confirm replace operation', Temporary, 43, '.' ) );
          TextAttr := Message_HighLight;
          WriteLn( Screen, Temporary );
          Write( Screen, ' 7 ' );
          TextAttr := Message_Normal;
          WriteLn( Screen, '- Start operation. ' );
          TextAttr := Message_HighLight;
          Write( Screen, ' 8 ' );
          TextAttr := Message_Normal;
          WriteLn( Screen, '- Cancel operation. ' );
          WriteLn( Screen );
          Repeat
            Get_Command( Value, Command );
          Until ( Command in [ Press_Numbers, Press_Escape, Pointer_Down ] );
          If ( Command = Pointer_Down )
            then
              Map_Keys( Adjust_Amount, Value );
          Case Value of
            '1': Search_Selected_Text := not Search_Selected_Text;
            '2': Start_Search_At_Cursor := not Start_Search_At_Cursor;
            '3': Search_Only_Whole_Words := not Search_Only_Whole_Words;
            '4': Search_Case_Sensitive := not Search_Case_Sensitive;
            '5': Search_Change_All := not Search_Change_All;
            '6': Search_Prompt_On_Replace := not Search_Prompt_On_Replace;
          End; { Case }
        Until ( ( Value in [ '7', '8' ] ) or ( Command = Press_Escape ) );
        If ( ( Value = '8' ) or ( Command = Press_Escape ) )
          then
            Data1 := '';
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write search failure default.
    This procedure flags the user when the search
    failed.

*************************************************)

    Procedure Write_Search_Failure_Default;
      Begin
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Warning: Search Failure! ' );
        WriteLn( Screen );
        Pause_For_Key;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Confirm changes default.
    This procedure displays the success of the
    changes and how many items were successfully
    altered.

*************************************************)

    Procedure Confirm_Changes_Default( Amount: Word );
      Begin
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Changes completed. ' );
        TextAttr := Message_Normal;
        WriteLn( Screen );
        Write( Screen, Amount:5 );
        TextAttr := Message_HighLight;
        WriteLn( Screen, ' items were altered. ' );
        WriteLn( Screen );
        Pause_For_Key;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get confirmation of change default.
    This function allows the user to confirm the
    changes to the text.  There are three possible
    results, 'Y' meaning yes, 'N' meaning no and
    'E' meaning escape or abandon.

*************************************************)

    Function Get_Confirmation_Of_Change_Default: Char;
      Begin
        GotoXY( 1, 1 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Do you wish to change this? ' );
        Get_Confirmation_Of_Change_Default := Get_Answer;
      End;

{----------------------------------------------------------------------------}

   Type
     A_Display_Type = Array[ 'A' .. 'Z' ] of Char;
     B_Display_Type = Array[ '0' .. '9' ] of Char;

   Const
    { These structures hold the data for the character menu. }
     Hold1: A_Display_Type = #131#132#133#160#134#142#143#136#137#138#130#144#140#139#141#161#147#148#149#162#153#150#129+
                             #151#163#154;
     Hold2: B_Display_Type = #155#152#145#146#166#167#164#165#128#135;
     Hold3: A_Display_Type = #168#173#156#157#158#159#171#172#127#174#175#224#225#226#227#228#229#230#231#232#233#234#235+
                             #326#237#238;
     Hold4: B_Display_Type = #253#239#240#241#242#243#246#247#248#251;

(*************************************************

  Function: Character menu default.
    Invoked by control P, this procedure allows
    the user to input the extended characters
    into the the text file by picking them from
    a menu.

*************************************************)

    Function Character_Menu_Default( Var Character: Char ): Boolean;
      Var
        Answer: Char;
        Width,
        Command: Byte;

      Procedure Initialize;
        Begin
          ClrScr;
          Character := ' ';
          Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
          Separator( 'Character input menu', Width );
          TextAttr := Message_HighLight;
          WriteLn( Screen, 'Press the appropriate key to select the character' );
          WriteLn( Screen );
        End;

      Procedure Write_It( Menu_Character, Display_Character: Char );
        Begin
          TextAttr := Message_HighLight;
          Write( Screen, Menu_Character );
          TextAttr := Message_Normal;
          Write( Screen, '[ ', Display_Character, ' ]   ' );
        End;

      Procedure Display_A_Line( Start, Finish: Char; Data: A_Display_Type );
        Var
          Character: Char;
        Begin
          Write( Screen, '   ' );
          For Character := Start to Finish do
            Write_It( Character, Data[ Character ] );
          WriteLn( Screen );
          WriteLn( Screen );
        End;

      Procedure Display_B_Line( Start, Finish: Char; Data: B_Display_Type );
        Var
          Character: Char;
        Begin
          Write( Screen, '   ' );
          For Character := Start to Finish do
            Write_It( Character, Data[ Character ] );
          WriteLn( Screen );
          WriteLn( Screen );
        End;

      Procedure Display_Exit;
        Begin
          Write( Screen, 'Press ' );
          TextAttr := Message_HighLight;
          Write( Screen, 'Enter' );
          TextAttr := Message_Normal;
          WriteLn( Screen, ' for next menu' );
          WriteLn( Screen );
          Write( Screen, 'Press ' );
          TextAttr := Message_HighLight;
          Write( Screen, 'Escape' );
          TextAttr := Message_Normal;
          Write( Screen, ' to exit' );
        End;

      Procedure Get_Choice( Data1: A_Display_Type; Data2: B_Display_Type );
        Begin
          Repeat
            Get_Command( Answer, Command );
            Case Command of
              Press_Lower_Letters: Character := Data1[ UpCase( Answer ) ];
              Press_Capital_Letters: Character := Data1[ Answer ];
              Press_Numbers: Character := Data2[ Answer ];
              Press_Escape: ;
              Press_Enter: Character := 'N';
              else Character := ' ';
            End; { Case }
          Until ( ( Character <> ' ' ) or ( Command = Press_Escape ) );
        End;

      Procedure Menu_A;
        Begin
          Initialize;
          Display_A_Line( 'A', 'G', Hold1 );
          Display_A_Line( 'H', 'L', Hold1 );
          Display_A_Line( 'M', 'P', Hold1 );
          Display_A_Line( 'Q', 'U', Hold1 );
          Display_A_Line( 'V', 'Z', Hold1 );
          Display_B_Line( '0', '4', Hold2 );
          Display_B_Line( '5', '9', Hold2 );
          Display_Exit;
          Get_Choice( Hold1, Hold2 );
        End;

      Procedure Menu_B;
        Begin
          Initialize;
          Display_A_Line( 'A', 'G', Hold3 );
          Display_A_Line( 'H', 'N', Hold3 );
          Display_A_Line( 'O', 'U', Hold3 );
          Display_A_Line( 'V', 'Z', Hold3 );
          Display_B_Line( '0', '4', Hold4 );
          Display_B_Line( '5', '9', Hold4 );
          Display_Exit;
          Get_Choice( Hold3, Hold4 );
        End;

      Begin
        Repeat
          Menu_A;
          If ( Character = 'N' )
            then
              Menu_B;
        Until ( Character <> 'N' );
        Character_Menu_Default := ( Command <> Press_Escape );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write error default.
    This procedure writes a warning message when
    something has gone wrong.  It's intended for
    non critical errors.

*************************************************)

    Procedure Write_Error_Default( Code: Word );
      Begin
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, 'Warning!  Operation failed.' );
        WriteLn( Screen, 'Error code: ', Code );
        WriteLn( Screen );
        Pause_For_Key;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write wait default.
    This procedure is called to display a wait
    message on screen.

*************************************************)

    Procedure Write_Wait_Default;
      Begin
        GotoXY( 1, 1 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Please Wait ' );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Write complete default.
    This procedure is called to display an
    operation completed message on screen.

*************************************************)

    Procedure Write_Complete_Default;
      Begin
        GotoXY( 1, 3 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Operation completed ' );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display read status default.
    This procedure is called to display the read
    status on the screen

*************************************************)

    Procedure Display_Read_Status_Default( Where: LongInt );
      Begin
        GotoXY( 1, 2 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Reading line: ' );
        TextAttr := Message_Normal;
        Write( Screen, Where:5 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display where status default.
    This procedure is called to display the
    current line status on the screen

*************************************************)

    Procedure Display_Where_Status_Default( Where: LongInt );
      Begin
        GotoXY( 1, 2 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Scanning line: ' );
        TextAttr := Message_Normal;
        Write( Screen, Where:5 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display write status default.
    This procedure is called to display the write
    status on the screen

*************************************************)

    Procedure Display_Write_Status_Default( Where, Limit: LongInt );
      Begin
        GotoXY( 1, 2 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Writing line: ' );
        TextAttr := Message_Normal;
        Write( Screen, Where:5 );
        TextAttr := Message_HighLight;
        Write( Screen, ' out of ' );
        TextAttr := Message_Normal;
        Write( Screen, Limit:5 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display where default.
    This procedure is called to display the
    current text information on the screen

*************************************************)

    Procedure Display_Information_Default( Var All: All_Type );
      Begin
        GotoXY( 1, 1 );
        TextAttr := Message_HighLight;
        Write( Screen, 'Row: ' );
        TextAttr := Message_Normal;
        Write( Screen, All.Data.Cursor.Row, ' ' );
        TextAttr := Message_HighLight;
        Write( Screen, 'Column: ' );
        TextAttr := Message_Normal;
        Write( Screen, All.Data.Cursor.Column, ' ' );
        Repeat
        Until Data_Ready;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get new line default.
    This procedure is designed to accept a line
    number between 1 and Limit as a place to
    directly place the cursor.

*************************************************)

    Procedure Get_New_Line_Default( Var New_Line: LongInt; Limit: LongInt );
      Begin
        Repeat
          ClrScr;
          TextAttr := Message_HighLight;
          Write( Screen, 'Please enter the new line number: ( range: ' );
          TextAttr := Message_Normal;
          Write( Screen, '1 ' );
          TextAttr := Message_HighLight;
          Write( Screen, 'to ' );
          TextAttr := Message_Normal;
          Write( Screen, Limit, ' ' );
          TextAttr := Message_HighLight;
          Write( Screen, ') ' );
          TextAttr := Message_Normal;
          {$I-}
          ReadLn( Keys, New_Line );
          {$I+}
        Until ( ( IoResult = 0 ) and ( New_Line >= 1 ) and ( New_Line <= Limit ) );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Function key default.
    This procedure is designed to intercept the
    command when the function key is pressed and
    allow other functions to be substituted or
    additional commands to be entered.

*************************************************)

    Procedure Function_Key_Default( Var Command: Byte; Var Character: Char ); {$IFDEF VER60} Far; {$ENDIF}
      Begin
        Case Command of
          Press_F1: Command := Press_Help;
        End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Escape operation default.
    This routine takes over and allow the user to
    escape the operation by changing Continue to
    false.

*************************************************)

    Procedure Escape_Operation_Default( Var Continue: Boolean );
      Begin
        TextAttr := Message_HighLight;
        Write( Screen, ' Escaping operation.' );
        Continue := False;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Help default.
    This procedure is designed to display the
    default help screen.

*************************************************)

    Procedure Help_Default;
      Var
        Width: Byte;

      { This procedure writes a line with a single command. }
      Procedure Write_Single( Front, Back: String );
        Begin
          TextAttr := Message_Normal;
          Write( Screen, Push_To( Front, Back, 37, '.' ) );
          TextAttr := Message_HighLight;
          Write( Screen, Back );
          TextAttr := Message_Normal;
        End;

      { This procedure writes a line with a double command. }
      Procedure Write_Double( Front, Middle, Back: String );
        Begin
          TextAttr := Message_Normal;
          Write( Screen, Push_To( Front, Middle + '  ' + Back, 37, '.' ) );
          TextAttr := Message_HighLight;
          Write( Screen, Middle );
          TextAttr := Message_Normal;
          Write( Screen, ', ' );
          TextAttr := Message_HighLight;
          Write( Screen, Back );
          TextAttr := Message_Normal;
        End;

      Begin
        Width := Pred( Right_Of_Window^ - Left_Of_Window^ );
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( 'Help screen', Width, ' ' ) );
        Separator( 'Basic cursor movement', Width );
        Write_Double( 'Left', '^S', #27 );
        Write( Screen, '   ' );
        Write_Double( 'Right', '^D', #26 );
        WriteLn( Screen );
        Write_Double( 'Up', '^E', #24 );
        Write( Screen, '   ' );
        Write_Double( 'Down', '^X', #25 );
        WriteLn( Screen );
        Write_Double( 'Word Left', '^A', '^'#27 );
        Write( Screen, '   ' );
        Write_Double( 'Word Right', '^F', '^'#26 );
        WriteLn( Screen );
        Write_Double( 'Start of line', '^QS', '[home]' );
        Write( Screen, '   ' );
        Write_Double( 'End of line', '^QD', '[end]' );
        WriteLn( Screen );
        Write_Single( 'Tab left', '[shift][tab]' );
        Write( Screen, '   ' );
        Write_Double( 'Tab right', '^I', '[tab]' );
        WriteLn( Screen );
        Write_Single( 'Scroll up', '^W' );
        Write( Screen, '   ' );
        Write_Single( 'Scroll down', '^Z' );
        WriteLn( Screen );
        Write_Double( 'Page up', '^R', '[pg up]' );
        Write( Screen, '   ' );
        Write_Double( 'Page down', '^C', '[pg dn]' );
        WriteLn( Screen );
        Write_Double( 'Top of screen', '^QE', '^[home]' );
        Write( Screen, '   ' );
        Write_Double( 'Bottom of screen', '^QX', '^[end]' );
        WriteLn( Screen );
        Write_Double( 'Top of file', '^QR', '^[pg up]' );
        Write( Screen, '   ' );
        Write_Double( 'Bottom of file', '^QC', '^[pg dn]' );
        WriteLn( Screen );
        Write_Single( 'Top of block', '^QB' );
        Write( Screen, '   ' );
        Write_Single( 'Bottom of block', '^QK' );
        WriteLn( Screen );
        Write_Single( 'Goto line number', '^JN' );
        WriteLn( Screen );
        Separator( 'Insert and Delete keys', Width );
        Write_Double( 'Delete character', '^G', '[del]' );
        Write( Screen, '   ' );
        Write_Single( 'Delete line', '^Y' );
        WriteLn( Screen );
        Write_Double( 'Backspace', '^H', '[backspace]' );
        Write( Screen, '   ' );
        Write_Single( 'Delete to end', '^QY' );
        WriteLn( Screen );
        Write_Single( 'Delete word right', '^T' );
        Write( Screen, '   ' );
        Write_Single( 'Restore line', '^JL' );
        WriteLn( Screen );
        Write_Double( 'Toggle Insert', '^V', '[ins]' );
        Write( Screen, '   ' );
        Write_Single( 'Insert line', '^N' );
        WriteLn( Screen );
        WriteLn( Screen );
        Pause_For_Key;
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( 'Help screen', Width, ' ' ) );
        Separator( 'Block commands', Width );
        Write_Single( 'Mark block start', '^KB' );
        Write( Screen, '   ' );
        Write_Single( 'Mark block finish', '^KK' );
        WriteLn( Screen );
        Write_Single( 'Read block', '^KR' );
        Write( Screen, '   ' );
        Write_Single( 'Write block', '^KW' );
        WriteLn( Screen );
        Write_Double( 'Delete block', '^KY', '^[del]' );
        Write( Screen, '   ' );
        Write_Single( 'Print block', '^KP' );
        WriteLn( Screen );
        Write_Single( 'Mark single word', '^KT' );
        Write( Screen, '   ' );
        Write_Single( 'Hide block', '^KH' );
        WriteLn( Screen );
        Write_Single( 'Copy block', '^KC' );
        Write( Screen, '   ' );
        Write_Single( 'Move block', '^KV' );
        WriteLn( Screen );
        Separator( 'Search commands', Width );
        Write_Single( 'Find string', '^QF' );
        Write( Screen, '   ' );
        Write_Single( 'Find and replace', '^QA' );
        WriteLn( Screen );
        Write_Single( 'Repeat search', '^L' );
        WriteLn( Screen );
        WriteLn( Screen );
        Pause_For_Key;
        ClrScr;
        TextAttr := Message_HighLight;
        WriteLn( Screen, Center( 'Help screen', Width, ' ' ) );
        Separator( 'Other commands', Width );
        Write_Single( 'Set Left margin', '^OL' );
        Write( Screen, '   ' );
        Write_Single( 'Set Right margin', '^OR' );
        WriteLn( Screen );
        Write_Single( 'Center text', '^OC' );
        Write( Screen, '   ' );
        Write_Double( 'Reformat paragraph', '^B', '^JO' );
        WriteLn( Screen );
        Write_Single( 'Reform entire text', '^JQ' );
        Write( Screen, '   ' );
        Write_Single( 'Reform block', '^JK' );
        WriteLn( Screen );
        Write_Single( 'Toggle auto reform', '^OW' );
        Write( Screen, '   ' );
        Write_Single( 'Display info', '^J[space]' );
        WriteLn( Screen );
        Write_Single( 'Print text', '^JP' );
        Write( Screen, '   ' );
        Write_Double( 'Help', '^JH', '[f1]' );
        WriteLn( Screen );
        WriteLn( Screen );
        Write_Single( 'Escape from editor', '[esc]' );
        WriteLn( Screen );
        WriteLn( Screen );
        Pause_For_Key;
      End;
