{

Video State Restorer

Rev. 1.00

(c) Copyright 1993, Michael Gallias

Target: Real, Protected

Remark: Uses 1kb of Code and 1 Text Page of Heap, Usually 4kb.
        Must be the First Unit in the Uses Clause to Work Correctly.

}

{$F+}

Unit VidState;

Interface

Const
  KeepVideoData  = True;

Implementation

Var
  OldExit,
  SSave          :Pointer;
  Page,
  Mode           :Byte;
  BufStart,
  BufSize        :Word;
  VideoSegment   :Word;
  CursorPosition :Word;
  CursorSize     :Word;

Procedure SaveScreen;

Var
  Q       :^Byte;
  P       :^Word;

Begin
  P:=Ptr(Seg0040,$4c);          {Buffer Size}
  BufSize:=P^;

  Asm
    mov   ah, 0fh
    int   10h
    mov   Mode, al
    mov   Page, bh
  End;

  If (BufSize>16384) Or (MaxAvail<BufSize) Or (Not KeepVideoData) Then
    SSave:=Nil
  Else
  Begin
    If Mode = 7 Then
      VideoSegment:=SegB000
    Else
      VideoSegment:=SegB800;

    P:=Ptr(Seg0040,$4e);        {Start Address Of Buffer}
    BufStart:=P^;

    P:=Ptr(VideoSegment,BufStart);
    GetMem(SSave,BufSize);
    Move(P^,SSave^,BufSize);
    Asm
      mov    ah, 3
      mov    bh, Page
      int    10h
      mov    CursorSize, cx
      mov    CursorPosition, dx
    End;
  End;
End;

Procedure RestoreScreen;

Var
  P     :Pointer;

Begin
  ExitProc:=OldExit;

  Asm
    xor   ah, ah
    mov   al, Mode
    int   10h
    mov   ah, 5
    mov   al, Page
    int   10h
  End;

  If SSave<>Nil Then
  Begin
    P:=Ptr(VideoSegment,BufStart);
    Move(SSave^,P^,BufSize);
    FreeMem(SSave,BufSize);
    Asm
      mov  ah, 1
      mov  cx, CursorSize
      int  10h
      mov  ah, 2
      mov  bh, Page
      mov  dx, CursorPosition
      int  10h
    End;
  End;
End;

Begin
  SaveScreen;
  OldExit:=ExitProc;
  ExitProc:=@RestoreScreen;
End.
